function [pnflow_header_file, outfolder]= pnflow_write_function(image_name, pnflow_base_file, ...
    new_pnextract_filename, new_folder_name, contact_angle, iftension)
% Christopher Zahasky
% Imperial College
% 5/1/2019

% This function writes the pnextract input data file give

%% Begin function
% open base pnextract file, read input, and write to a new file
fid = fopen(pnflow_base_file);
Af = textscan(fid,'%s','Delimiter','\n');
fclose(fid);

% Find relevant locations
% preallocate
out_row = 0;
ca_row = 0;
ift_row = 0;
net_row =  0;
% Search file
for i=1:length(Af{1,1})
    % Look for row with output title
    tf = strncmpi(Af{1,1}(i,1), 'TITLE', 5);
    if tf == 1
        out_row = i+1;
    end
    
    % Look for row with contact angle def
    tf = strncmpi(Af{1,1}(i,1), 'INIT_CONT_ANG',12);
    if tf == 1
        ca_row = i+1;
    end
    
    % Look for row fluid def
    tf = strncmpi(Af{1,1}(i,1), 'FLUID',5);
    if tf == 1
        ift_row = i+4;
    end
    
    % Look for row with network name
    tf = strncmpi(Af{1,1}(i,1), 'NETWORK', 7);
    if tf == 1
        net_row = i+1;
    end
end


% Change output title
outfolder = [new_folder_name, '_network_results'];
Af{1,1}(out_row,1)={outfolder};

% Change network input in text
% ca_string = num2str(ca_test(iteration_number));
ca_string = num2str(contact_angle);
Af{1,1}(ca_row,1)={['1  ', ca_string, ' ', ca_string, '  0.2   3.0   rand   0.0']};

% Change network input in text
ift_string = num2str(iftension);
Af{1,1}(ift_row,1)={['     ', ift_string, '        1.0          1.0        1.2           1000.0      1000.0   1000.0']};

% Change network input in text
Af{1,1}(net_row,1)={['F ', image_name]};


pnflow_header_file = ['pnflow_',new_pnextract_filename, '.dat'];
% write to file
fileID = fopen([new_folder_name, '\', pnflow_header_file],'w');
for i=1:length(Af{1,1})
    fprintf(fileID,'%s\n', char(Af{1,1}(i,1)));
end
fclose(fileID);