function [pnextract_header_file]= pnextract_write_function(image_name, pnextract_base_file, ...
    new_pnextract_filename, new_folder_name, MSS, image_dim, voxel_size)
% Christopher Zahasky
% Imperial College
% 5/1/2019

%% Change medial surface settings (clipROutx, clipROutyz, midRFrac, 
% RMedSurfNoise, lenNf, vmvRadRelNf, nRSmoothing, RCorsf, RCors)
% Typical settings from SA
% clipROx = 0.05;
% clipROz = 0.05;
% midRFrac = 0.7;
% RMedSurfNoise = 0.1;
% lenNf = 0.6;
% vmvRadRelNf = 1;
% nRSmoothing = 1.5;
% RCorsf = 0.15;
% RCors = 1;
% MSS = [clipROx, clipROz, midRFrac, RMedSurfNoise, lenNf, vmvRadRelNf, ...
%     nRSmoothing, RCorsf, RCors];

%% Begin function
% open base pnextract file, read input, and write to a new file
fid = fopen(pnextract_base_file);
A = textscan(fid,'%s','Delimiter','\n');
fclose(fid);

% Find relevant locations in pnextract input file
% preallocate
size_row = 0;
vsize_row = 0;
file_row = 0;
mss_row = 0;
% Search file
for i=1:length(A{1,1})
    % Look for row with image dimensions
    tf = strncmpi(A{1,1}(i,1), 'DimSize',7);
    if tf == 1
        size_row = i;
    end
    
    % Look for row with voxel dimensions
    tf = strncmpi(A{1,1}(i,1), 'ElementSpacing',12);
    if tf == 1
        vsize_row = i;
    end
    
    % Look for row with file name
    tf = strncmpi(A{1,1}(i,1), 'ElementDataFile',15);
    if tf == 1
        file_row = i;
    end
    % Look for row with file name
    tf = strncmpi(A{1,1}(i,1), 'medialSurfaceSettings',20);
    if tf == 1
        mss_row = i;
    end
end
% If medial surface settings was omitted from base file then add it to the
% last line of file
if mss_row == 0
    mss_row = length(A{1,1})+1;
end

% Change dimsize
A{1,1}(size_row,1)={['DimSize =        ', num2str(image_dim(1)), '  ', ...
    num2str(image_dim(2)), '  ',num2str(image_dim(3))]};

if length(voxel_size) == 1
    % Change dimsize
    A{1,1}(vsize_row,1)={['ElementSpacing = ', num2str(voxel_size), '  ', ...
        num2str(voxel_size), '  ',num2str(voxel_size)]};
elseif length(voxel_size) == 3
    A{1,1}(vsize_row,1)={['ElementSpacing = ', num2str(voxel_size(1)), '  ', ...
        num2str(voxel_size(2)), '  ',num2str(voxel_size(3))]};
end

% Change filename in text
A{1,1}(file_row,1)={['ElementDataFile = ', image_name, '.raw']};

% Apply medial surface extraction settings
mss_string = sprintf('%0.2f  ', MSS);
A{1,1}(mss_row,1)={['medialSurfaceSettings: = ', mss_string]};

pnextract_header_file = ['pnextract_',new_pnextract_filename, '.mhd'];
% write to file
fileID = fopen([new_folder_name, '\', pnextract_header_file],'w');
for i=1:length(A{1,1})
    fprintf(fileID,'%s\n', char(A{1,1}(i,1)));
end
fclose(fileID);
