function [pc_data, porosity, permeability, rel_perm_data]= ...
    pnflow_output_extraction_function(outfolder)
% Christopher Zahasky
% Imperial College
% 5/1/2019

% This function extracts pc, porosity, and perm data from model output

% Extract PC data
C1 = importdata([outfolder, '_cycle1_drain.csv']);
pc_data = C1.data(:,1:2);
rel_perm_data = [C1.data(:,1), C1.data(:, 3:4)];
% Extract porosity and permeability data
% open base pnextract file, read input, and write to a new file
fid = fopen([outfolder, '_out.prt']);
Aout = textscan(fid,'%s','Delimiter','\n');
fclose(fid);
% Find relevant porosity and permability data
% preallocate
tf = 0;
tk = 0;
text_row = 1;
% Search file
while tk == 0 
    % Look for row with porosity
    tf = strncmpi(Aout{1,1}(text_row,1), 'Net porosity', 12);
    if tf == 1
        aa = Aout{1,1}(text_row,1);
        porosity = str2double(aa{1}(15:end));
    end
    
    tk = strncmpi(Aout{1,1}(text_row,1), 'Absolute permeability (mD)', 26);
    if tk == 1
        aa = Aout{1,1}(text_row,1);
        permeability = str2double(aa{1}(28:end));
    end
    
    text_row = text_row+1;
end