% homogeneous_vs_heter_profile_comparison
% Christopher Zahasky
% 04/01/2019, updated for repository 09/16/2019
clear all
close all
set(0,'DefaultAxesFontSize',17, 'defaultlinelinewidth', 2,...
    'DefaultAxesTitleFontWeight', 'normal')
% This script is to plot figure 3 from paper titled 'Pore network model 
% predictions of Darcy-scale multiphase flow heterogeneity validated with 
% multiscale experimental observations'

% Load core 1 data
load('formated_exp_sim_saturation_data_var_rel_perm_pc_end_tube_hom_dummys')

% transparcey setting
alpha_factor = 0.8;

%% Core 1 plot
% Start plotting
figure('Position', [167         126        1602         852])

% plot Core 1 subdomain-vs grid cell saturation data
subplot(2,3,1)
hold on

core_length_true = 7.32;
normZ = gridZho./core_length_true;
[X,Y,Z] = meshgrid(gridXho, gridYho, gridZho);
z_array = round(Z(:).*100);

% color palette in paper requires downloading and using 'cbrewer' function
% on the Matlab File Exchange
% colormaps without colorbrewer
ccb = winter(max(z_array));
ccp = cool(max(z_array));
ccr = autumn(max(z_array));


for i = 1:length(z_array)
    cc_zb(i,:) = ccb(z_array(i), :);
    cc_zp(i,:) = ccp(z_array(i), :);
    cc_zr(i,:) = ccr(z_array(i), :);
end

% Extract fw = 0.95 data
current_exp_sat = hom_exp_sat_matrix(:,:,:,1);
current_sim_sat = hom_sim_sat_matrix(:,:,:,1);

f1 = scatter(current_exp_sat(:), current_sim_sat(:), 15, cc_zb, 'filled');
f1.MarkerFaceAlpha = 1;

% Extract fw = 0 data
current_exp_sat = hom_exp_sat_matrix(:,:,:,2);
current_sim_sat = hom_sim_sat_matrix(:,:,:,2);

f1 = scatter(current_exp_sat(:), current_sim_sat(:), 15, cc_zr, 'filled');
f1.MarkerFaceAlpha = 1;

% identity line
plot([1 0], [1 0], '-k', 'linewidth', 1, 'HandleVisibility', 'off')
xlabel('MicroCT water saturation')
xticks(0:0.2:1)
ylabel('CMG water saturation')
axis([0 1 0 1])
box on
legend('f_w = 0.95', 'f_w = 0', 'Location','northwest', 'Fontsize', 14)
legend boxoff

% plot slice average data
subplot(2, 3,[2 3])
hold on

% Plot Core 1 slice average saturation comparison
% FF water 0.95
% Plot grey uncertainty bounds
patch([gridZho'; flipud(gridZho')], ...
    [hom_plus_prof(:,1); flipud(hom_minus_prof(:,1))],  [0.9 0.9 0.9], 'EdgeColor','none', ...
    'HandleVisibility', 'off');
alpha(alpha_factor)
% slice average lines
sat_profile = squeeze(nanmean(nanmean(hom_exp_sat_matrix(:,:,:,1))));
plot(gridZho, sat_profile, ':', 'color', cc_zb(100,:))
sat_profile = squeeze(nanmean(nanmean(hom_sim_sat_matrix(:,:,:,1))));
plot(gridZho, sat_profile, '-', 'color', cc_zb(100,:))

% FF water 0
% Plot grey uncertainty bounds
patch([gridZho'; flipud(gridZho')], ...
    [hom_plus_prof(:,2); flipud(hom_minus_prof(:,2))],  [0.9 0.9 0.9], 'EdgeColor','none', ...
    'HandleVisibility', 'off');
alpha(alpha_factor)
% slice average lines
sat_profile = squeeze(nanmean(nanmean(hom_exp_sat_matrix(:,:,:,2))));
plot(gridZho, sat_profile, ':', 'color', cc_zr(100,:))
sat_profile = squeeze(nanmean(nanmean(hom_sim_sat_matrix(:,:,:,2))));
plot(gridZho, sat_profile, '-', 'color', cc_zr(100,:))

% dashed lines to mark unscanned section of core
plot([gridZho(1) gridZho(1)], [0 1], '--k', 'linewidth', 1, 'HandleVisibility', 'off')
plot([gridZho(end) gridZho(end)], [0 1], '--k', 'linewidth', 1, 'HandleVisibility', 'off')

% format plot
xlabel('Distance from inlet [cm]')
ylabel('Water saturation')
axis([0 core_length_true 0 1])
title('Bentheimer Core 1')
box on
legend('Exp f_w = 0.95', 'Sim f_w = 0.95', 'Exp f_w = 0', 'Sim f_w = 0', 'Location','eastoutside', 'Fontsize', 14)
legend boxoff
set(gca, 'Position',[0.41 0.583 0.47 0.34]);
clear exp_sat_matrix

%% Core 2 plot
% plot Core 2 subdomain-vs grid cell saturation data
subplot(2,3,4)
hold on

% define grid cell centers
core_length_true = 6.47;
normZ = gridZhet./core_length_true;
[X,Y,Z] = meshgrid(gridXhet,gridYhet,gridZhet);
z_array = round(Z(:).*100);

% color palette in paper requires downloading and using 'cbrewer' function
% on the Matlab File Exchange
% colormaps without colorbrewer
ccb = winter(max(z_array));
ccp = cool(max(z_array));
ccr = autumn(max(z_array));

clear cc_zb cc_zp cc_zr
for i = 1:length(z_array)
    cc_zb(i,:) = ccb(z_array(i), :);
    cc_zp(i,:) = ccp(z_array(i), :);
    cc_zr(i,:) = ccr(z_array(i), :);
end

% Extract and plot fw = 0.95 data
current_exp_sat = het_exp_sat_matrix(:,:,:,1);
current_sim_sat = het_sim_sat_matrix(:,:,:,1);

f1 = scatter(current_exp_sat(:), current_sim_sat(:), 15, cc_zb, 'filled');
f1.MarkerFaceAlpha = 1;

% Extract and plot fw = 0.5 data
current_exp_sat = het_exp_sat_matrix(:,:,:,2);
current_sim_sat = het_sim_sat_matrix(:,:,:,2);

f1 = scatter(current_exp_sat(:), current_sim_sat(:), 15, cc_zp, 'filled');
f1.MarkerFaceAlpha = 1;

% Extract and plot fw = 0 data
current_exp_sat = het_exp_sat_matrix(:,:,:,3);
current_sim_sat = het_sim_sat_matrix(:,:,:,3);

f1 = scatter(current_exp_sat(:), current_sim_sat(:), 15, cc_zr, 'filled');
f1.MarkerFaceAlpha = 1;

% identity line
plot([1 0], [1 0], '-k', 'linewidth', 1, 'HandleVisibility', 'off')
xlabel('MicroCT water saturation')
ylabel('CMG water saturation')
xticks(0:0.2:1)
axis([0 1 0 1])
box on
legend('f_w = 0.95', 'f_w = 0.5', 'f_w = 0', 'Location','northwest', 'Fontsize', 14)
legend boxoff

% plot core 2 slice average data
subplot(2, 3,[5 6])
hold on

% plot uncertainity bounds
% FF water 0.95
patch([gridZhet'; flipud(gridZhet')], ...
    [het_plus_prof(:,1); flipud(het_minus_prof(:,1))],  [0.9 0.9 0.9], 'EdgeColor','none', ...
    'HandleVisibility', 'off');
alpha(alpha_factor)
% slice average lines
sat_profile = squeeze(nanmean(nanmean(het_exp_sat_matrix(:,:,:,1))));
plot(gridZhet, sat_profile, ':', 'color', cc_zb(100,:))
sat_profile = squeeze(nanmean(nanmean(het_sim_sat_matrix(:,:,:,1))));
plot(gridZhet, sat_profile, '-', 'color', cc_zb(100,:))

% FF water 0.50
patch([gridZhet'; flipud(gridZhet')], ...
    [het_plus_prof(:,2); flipud(het_minus_prof(:,2))],  [0.9 0.9 0.9], 'EdgeColor','none', ...
    'HandleVisibility', 'off');
alpha(alpha_factor)
% slice average lines
sat_profile = squeeze(nanmean(nanmean(het_exp_sat_matrix(:,:,:,2))));
plot(gridZhet, sat_profile, ':', 'color', cc_zp(100,:))
sat_profile = squeeze(nanmean(nanmean(het_sim_sat_matrix(:,:,:,2))));
plot(gridZhet, sat_profile, '-', 'color', cc_zp(100,:))

% FF water 0
patch([gridZhet'; flipud(gridZhet')], ...
    [het_plus_prof(:,3); flipud(het_minus_prof(:,3))],  [0.9 0.9 0.9], 'EdgeColor','none', ...
    'HandleVisibility', 'off');
alpha(alpha_factor)
% slice average lines
sat_profile = squeeze(nanmean(nanmean(het_exp_sat_matrix(:,:,:,3))));
plot(gridZhet, sat_profile, ':', 'color', cc_zr(100,:))
sat_profile = squeeze(nanmean(nanmean(het_sim_sat_matrix(:,:,:,3))));
plot(gridZhet, sat_profile, '-', 'color', cc_zr(100,:))

% dashed lines to mark unscanned section of core
plot([gridZhet(1) gridZhet(1)], [0 1], '--k', 'linewidth', 1, 'HandleVisibility', 'off')
plot([gridZhet(end) gridZhet(end)], [0 1], '--k', 'linewidth', 1, 'HandleVisibility', 'off')

% Plot comparison with model with constant relative permeaiblity in every
% grid cell
load('formated_exp_sim_saturation_data_hom_bent_rel_perm_pc_end_tube_hom_dummys')
sat_profile = squeeze(nanmean(nanmean(het_sim_sat_matrix(:,:,:,1))));
plot(gridZhet, sat_profile, '-', 'color', cc_zb(100,:), 'linewidth', 1, 'HandleVisibility', 'off')
sat_profile = squeeze(nanmean(nanmean(het_sim_sat_matrix(:,:,:,2))));
plot(gridZhet, sat_profile, '-', 'color', cc_zp(100,:), 'linewidth', 1, 'HandleVisibility', 'off')
sat_profile = squeeze(nanmean(nanmean(het_sim_sat_matrix(:,:,:,3))));
plot(gridZhet, sat_profile, '-', 'color', cc_zr(100,:), 'linewidth', 1, 'HandleVisibility', 'off')

% format plot
xlabel('Distance from the inlet [cm]')
ylabel('Water saturation')
axis([0 core_length_true 0 1])
title('Bentheimer Core 2')
box on
legend('Exp f_w = 0.95', 'Sim f_w = 0.95', 'Exp f_w = 0.50', ...
    'Sim f_w = 0.50', 'Exp f_w = 0', 'Sim f_w = 0', 'Location','eastoutside', 'Fontsize', 14)
legend boxoff
set(gca, 'Position',[0.41 0.11 0.4177 0.34]);

