/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.script.SV;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;

public class Draw
extends MeshCollection {
    DrawMesh[] dmeshes = new DrawMesh[4];
    private DrawMesh thisMesh;
    private P3[] ptList;
    private V3 offset = new V3();
    private int nPoints;
    private int diameter;
    private float width;
    private float newScale;
    private float length;
    private boolean isCurve;
    private boolean isArc;
    private boolean isArrow;
    private boolean isLine;
    private boolean isVector;
    private boolean isCircle;
    private boolean isPerpendicular;
    private boolean isCylinder;
    private boolean isVertices;
    private boolean isPlane;
    private boolean isReversed;
    private boolean isRotated45;
    private boolean isCrossed;
    private boolean isValid;
    private boolean noHead;
    private boolean isBarb;
    private int indicatedModelIndex = -1;
    private int[] modelInfo;
    private boolean makePoints;
    private P4 plane;
    private BS bsAllModels;
    private Lst<Object> polygon;
    private Lst<Object[]> vData;
    private String intersectID;
    private P3[] boundBox;
    private Lst<P3[]> lineData;
    private static final int PT_COORD = 1;
    private static final int PT_IDENTIFIER = 2;
    private static final int PT_BITSET = 3;
    private static final int PT_MODEL_INDEX = 4;
    private static final int PT_MODEL_BASED_POINTS = 5;
    MeshSurface slabData;
    private final V3 vAB = new V3();
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final P3i ptXY = new P3i();

    public Draw() {
        this.htObjects = new Hashtable();
    }

    @Override
    public void allocMesh(String string, Mesh mesh) {
        int n = this.meshCount++;
        this.dmeshes = (DrawMesh[])AU.ensureLength(this.dmeshes, this.meshCount * 2);
        this.meshes = this.dmeshes;
        this.dmeshes[n] = mesh == null ? new DrawMesh(this.vwr, string, this.colix, n) : (DrawMesh)mesh;
        this.thisMesh = this.dmeshes[n];
        this.currentMesh = this.dmeshes[n];
        this.currentMesh.color = this.color;
        this.currentMesh.index = n;
        if (string != null && string != "+PREVIOUS_MESH+" && this.htObjects != null) {
            this.htObjects.put(string.toUpperCase(), this.currentMesh);
        }
    }

    private void setPropertySuper(String string, Object object, BS bS) {
        this.currentMesh = this.thisMesh;
        this.setPropMC(string, object, bS);
        this.thisMesh = (DrawMesh)this.currentMesh;
    }

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "draw";
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        if ("init" == string) {
            this.initDraw();
            this.setPropertySuper("init", object, bS);
            return;
        }
        if ("length" == string) {
            this.length = ((Float)object).floatValue();
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            return;
        }
        if ("intersect" == string) {
            if (object instanceof String) {
                this.intersectID = (String)object;
            } else {
                this.boundBox = (P3[])object;
            }
            return;
        }
        if ("slab" == string) {
            int n = this.getIndexFromName((String)object);
            if (n < 0) {
                return;
            }
            Mesh mesh = this.meshes[n];
            if (mesh.checkByteCount != 1) {
                return;
            }
            MeshSurface meshSurface = new MeshSurface();
            meshSurface.vs = mesh.vs;
            meshSurface.vvs = new float[mesh.vc];
            meshSurface.vc = mesh.vc;
            meshSurface.pis = mesh.pis;
            meshSurface.pc = mesh.pc;
            meshSurface.dataOnly = true;
            this.slabData = meshSurface;
        }
        if ("lineData" == string) {
            this.lineData = new Lst();
            if (this.indicatedModelIndex < 0) {
                this.indicatedModelIndex = this.vwr.am.cmi;
            }
            float[] fArray = (float[])object;
            int n = fArray.length / 6;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                this.lineData.addLast(new P3[]{P3.new3(fArray[n2++], fArray[n2++], fArray[n2++]), P3.new3(fArray[n2++], fArray[n2++], fArray[n2++])});
            }
            return;
        }
        if ("modelIndex" == string) {
            this.indicatedModelIndex = (Integer)object;
            if (this.indicatedModelIndex < 0 || this.indicatedModelIndex >= this.vwr.ms.mc) {
                return;
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = 4;
            this.modelInfo = new int[]{this.indicatedModelIndex, 0};
            objectArray[1] = this.modelInfo;
            this.vData.addLast(objectArray);
            return;
        }
        if ("planedef" == string) {
            this.plane = (P4)object;
            if (this.intersectID != null || this.boundBox != null || this.slabData != null) {
                return;
            }
            if (this.isCircle || this.isArc) {
                this.isPlane = true;
            }
            this.vData.addLast(new Object[]{1, P3.new3(Float.NaN, Float.NaN, Float.NaN)});
            return;
        }
        if ("perp" == string) {
            this.isPerpendicular = true;
            return;
        }
        if ("cylinder" == string) {
            this.isCylinder = true;
            return;
        }
        if ("plane" == string) {
            this.isPlane = true;
            return;
        }
        if ("curve" == string) {
            this.isCurve = true;
            return;
        }
        if ("arrow" == string) {
            this.isArrow = true;
            return;
        }
        if ("line" == string) {
            this.isLine = true;
            this.isCurve = true;
            return;
        }
        if ("arc" == string) {
            this.isCurve = true;
            this.isArc = true;
            if (this.isArrow) {
                this.isArrow = false;
                this.isVector = true;
            }
            return;
        }
        if ("circle" == string) {
            this.isCircle = true;
            return;
        }
        if ("vector" == string) {
            this.isArrow = true;
            this.isVector = true;
            return;
        }
        if ("vertices" == string) {
            this.isVertices = true;
            return;
        }
        if ("reverse" == string) {
            this.isReversed = true;
            return;
        }
        if ("nohead" == string) {
            this.noHead = true;
            return;
        }
        if ("isbarb" == string) {
            this.isBarb = true;
            return;
        }
        if ("rotate45" == string) {
            this.isRotated45 = true;
            return;
        }
        if ("crossed" == string) {
            this.isCrossed = true;
            return;
        }
        if ("points" == string) {
            this.newScale = ((Integer)object).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 1.0f;
            }
            return;
        }
        if ("scale" == string) {
            this.newScale = ((Integer)object).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 0.01f;
            }
            if (this.thisMesh != null) {
                this.scale(this.thisMesh, this.newScale);
                this.thisMesh.initialize(1073741964, null, null);
            }
            return;
        }
        if ("diameter" == string) {
            this.diameter = ((Float)object).intValue();
            return;
        }
        if ("width" == string) {
            this.width = ((Float)object).floatValue();
            return;
        }
        if ("identifier" == string) {
            String string2 = (String)object;
            int n = this.getIndexFromName(string2);
            if (n >= 0) {
                this.vData.addLast(new Object[]{2, new int[]{n, this.isReversed ? 1 : 0, this.isVertices ? 1 : 0}});
                this.isVertices = false;
                this.isReversed = false;
            } else {
                Logger.error("draw identifier " + object + " not found");
                this.isValid = false;
            }
            return;
        }
        if ("polygon" == string) {
            this.polygon = (Lst)object;
            if (this.polygon == null) {
                this.polygon = new Lst();
            }
            return;
        }
        if ("coord" == string) {
            this.vData.addLast(new Object[]{1, object});
            if (this.indicatedModelIndex >= 0) {
                this.modelInfo[1] = this.modelInfo[1] + 1;
            }
            return;
        }
        if ("offset" == string) {
            this.offset = V3.newV((P3)object);
            if (this.thisMesh != null) {
                this.thisMesh.offset(this.offset);
            }
            return;
        }
        if ("atomSet" == string) {
            BS bS2 = (BS)object;
            if (bS2.isEmpty()) {
                return;
            }
            this.vData.addLast(new Object[]{3, bS2});
            if (this.isCircle && this.diameter == 0 && this.width == 0.0f) {
                this.width = this.vwr.ms.calcRotationRadiusBs(bS2) * 2.0f;
            }
            return;
        }
        if ("coords" == string) {
            this.addPoints(1, object);
            return;
        }
        if ("modelBasedPoints" == string) {
            this.addPoints(5, object);
            return;
        }
        if ("set" == string) {
            if (this.thisMesh == null) {
                this.allocMesh(null, null);
                this.thisMesh.colix = this.colix;
                this.thisMesh.color = this.color;
            }
            boolean bl = this.thisMesh.isValid = this.isValid ? this.setDrawing((int[])object) : false;
            if (this.thisMesh.isValid) {
                if (this.thisMesh.vc > 2 && this.length != Float.MAX_VALUE && this.newScale == 1.0f) {
                    this.newScale = this.length;
                }
                this.scale(this.thisMesh, this.newScale);
                this.thisMesh.initialize(1073741964, null, null);
                Draw.setAxes(this.thisMesh);
                this.thisMesh.title = this.title;
                this.thisMesh.visible = true;
            }
            this.nPoints = -1;
            this.vData = null;
            this.lineData = null;
            return;
        }
        if (string == "deleteModelAtoms") {
            this.deleteModels(((int[])((Object[])object)[2])[0]);
            return;
        }
        this.setPropertySuper(string, object, bS);
    }

    private void addPoints(int n, Object object) {
        boolean bl;
        Lst lst = (Lst)object;
        Integer n2 = n;
        boolean bl2 = bl = n == 5;
        if (bl) {
            this.vData.addLast(new Object[]{n2, lst});
        }
        int n3 = lst.size();
        block4: for (int i = 0; i < n3; ++i) {
            P3 p3;
            SV sV = (SV)lst.get(i);
            switch (sV.tok) {
                case 10: {
                    if (!bl && ((BS)sV.value).isEmpty()) continue block4;
                    p3 = this.vwr.ms.getAtomSetCenter((BS)sV.value);
                    break;
                }
                case 8: {
                    if (bl) continue block4;
                }
                default: {
                    p3 = SV.ptValue(sV);
                }
            }
            if (bl) {
                lst.set(i, SV.getVariable(p3));
                continue;
            }
            this.vData.addLast(new Object[]{n2, p3});
        }
    }

    private void deleteModels(int n) {
        int n2 = this.meshCount;
        while (--n2 >= 0) {
            boolean bl;
            DrawMesh drawMesh = this.dmeshes[n2];
            if (drawMesh == null) continue;
            boolean bl2 = bl = drawMesh.modelIndex == n;
            if (drawMesh.modelFlags != null) {
                drawMesh.deleteAtoms(n);
                bl = drawMesh.modelFlags.length() == 0;
                if (!bl) continue;
            }
            if (bl) {
                --this.meshCount;
                this.deleteMeshElement(n2);
                continue;
            }
            if (this.meshes[n2].modelIndex <= n) continue;
            --this.meshes[n2].modelIndex;
        }
        this.resetObjects();
    }

    private void deleteMeshElement(int n) {
        if (this.meshes[n] == this.currentMesh) {
            this.thisMesh = null;
            this.currentMesh = null;
        }
        this.dmeshes = (DrawMesh[])AU.deleteElements(this.meshes, n, 1);
        this.meshes = this.dmeshes;
    }

    private void initDraw() {
        this.boundBox = null;
        this.bsAllModels = null;
        this.colix = (short)5;
        this.color = -1;
        this.diameter = 0;
        this.explicitID = false;
        this.indicatedModelIndex = -1;
        this.intersectID = null;
        this.isLine = false;
        this.isCylinder = false;
        this.isCircle = false;
        this.isPlane = false;
        this.isArrow = false;
        this.isArc = false;
        this.isCurve = false;
        this.isBarb = false;
        this.noHead = false;
        this.isCrossed = false;
        this.isRotated45 = false;
        this.isReversed = false;
        this.isFixed = false;
        this.isVector = false;
        this.isVertices = false;
        this.isPerpendicular = false;
        this.isValid = true;
        this.length = Float.MAX_VALUE;
        this.lineData = null;
        this.newScale = 0.0f;
        this.offset = null;
        this.plane = null;
        this.polygon = null;
        this.slabData = null;
        this.vData = new Lst();
        this.width = 0.0f;
        this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
    }

    @Override
    public boolean getPropertyData(String string, Object[] objectArray) {
        Object object;
        if (string == "keys") {
            objectArray[1] = object = objectArray[1] instanceof Lst ? (Lst)objectArray[1] : new Lst();
            ((Lst)object).addLast("getSpinAxis");
        }
        if (string == "getCenter") {
            object = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            int n2 = (Integer)objectArray[2];
            objectArray[2] = this.getSpinCenter((String)object, n, n2);
            return objectArray[2] != null;
        }
        if (string == "getSpinAxis") {
            object = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            objectArray[2] = this.getSpinAxis((String)object, n);
            return objectArray[2] != null;
        }
        return this.getPropDataMC(string, objectArray);
    }

    @Override
    public Object getProperty(String string, int n) {
        DrawMesh drawMesh = this.thisMesh;
        if (n >= 0 && (n >= this.meshCount || (drawMesh = (DrawMesh)this.meshes[n]) == null)) {
            return null;
        }
        if (string == "command") {
            return this.getCommand(drawMesh);
        }
        if (string == "type") {
            return drawMesh == null ? EnumDrawType.NONE.id : drawMesh.drawType.id;
        }
        return this.getPropMC(string);
    }

    private T3 getSpinCenter(String string, int n, int n2) {
        DrawMesh drawMesh;
        String string2;
        int n3 = string.indexOf("[");
        if (n3 > 0) {
            string2 = string.substring(0, n3);
            int n4 = string.lastIndexOf("]");
            if (n4 < n3) {
                n4 = string.length();
            }
            try {
                n = Integer.parseInt(string.substring(n3 + 1, n4));
            }
            catch (Exception exception) {}
        } else {
            string2 = string;
        }
        if ((drawMesh = (DrawMesh)this.getMesh(string2)) == null || drawMesh.vs == null) {
            return null;
        }
        if (n == Integer.MAX_VALUE) {
            return P3.new3(drawMesh.index + 1, this.meshCount, drawMesh.vc);
        }
        if (n != Integer.MIN_VALUE) {
            n = drawMesh.getVertexIndexFromNumber(n);
        }
        return n >= 0 ? drawMesh.vs[n] : (drawMesh.ptCenters == null || n2 < 0 || n2 >= drawMesh.ptCenters.length ? drawMesh.ptCenter : drawMesh.ptCenters[n2]);
    }

    private V3 getSpinAxis(String string, int n) {
        DrawMesh drawMesh = (DrawMesh)this.getMesh(string);
        return drawMesh == null || drawMesh.vs == null ? null : (drawMesh.ptCenters == null || n < 0 ? drawMesh.axis : drawMesh.axes[n]);
    }

    private boolean setDrawing(int[] nArray) {
        Object object;
        if (this.thisMesh == null) {
            this.allocMesh(null, null);
        }
        this.thisMesh.clear("draw");
        this.thisMesh.diameter = this.diameter;
        this.thisMesh.width = this.width;
        if (this.intersectID != null || this.boundBox != null) {
            if (this.boundBox != null) {
                if (this.plane == null) {
                    // empty if block
                }
            } else if (this.plane != null && this.intersectID != null) {
                Lst lst = new Lst();
                object = new Object[]{this.intersectID, this.plane, lst, null};
                this.vwr.shm.getShapePropertyData(24, "intersectPlane", (Object[])object);
                if (lst.size() > 0) {
                    this.indicatedModelIndex = (Integer)object[3];
                    this.lineData = lst;
                }
            }
        } else if (this.slabData != null && this.plane != null) {
            this.slabData.getMeshSlicer().getIntersection(0.0f, this.plane, null, null, null, null, null, false, true, 134217750, false);
            this.polygon = new Lst();
            this.polygon.addLast(this.slabData.vs);
            this.polygon.addLast(this.slabData.pis);
        }
        if (this.polygon == null && (this.lineData == null ? this.vData.size() == 0 == (nArray == null) : this.lineData.size() == 0) || !this.isArrow && nArray != null) {
            return false;
        }
        int n = this.vwr.ms.mc;
        if (this.polygon != null || this.lineData != null || this.indicatedModelIndex < 0 && (this.isFixed || this.isArrow || this.isCurve || this.isCircle || this.isCylinder || n == 1)) {
            this.thisMesh.modelIndex = this.lineData == null ? this.vwr.am.cmi : this.indicatedModelIndex;
            boolean bl = this.thisMesh.isFixed = this.isFixed || this.lineData == null && this.thisMesh.modelIndex < 0 && n > 1;
            if (this.isFixed && n > 1) {
                this.thisMesh.modelIndex = -1;
            } else if (this.lineData == null && this.thisMesh.modelIndex < 0) {
                this.thisMesh.modelIndex = 0;
            }
            this.thisMesh.ptCenters = null;
            this.thisMesh.modelFlags = null;
            this.thisMesh.drawTypes = null;
            this.thisMesh.drawVertexCounts = null;
            this.thisMesh.connectedAtoms = nArray;
            if (this.polygon != null) {
                if (this.polygon.size() == 0) {
                    return false;
                }
                this.thisMesh.isTriangleSet = true;
                this.thisMesh.vs = (P3[])this.polygon.get(0);
                this.thisMesh.pis = (int[][])this.polygon.get(1);
                this.thisMesh.drawVertexCount = this.thisMesh.vc = this.thisMesh.vs.length;
                this.thisMesh.pc = this.thisMesh.pis == null ? -1 : this.thisMesh.pis.length;
                for (int i = 0; i < this.thisMesh.pc; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (this.thisMesh.pis[i][j] < this.thisMesh.vc) continue;
                        return false;
                    }
                }
                this.thisMesh.drawType = EnumDrawType.POLYGON;
                this.thisMesh.checkByteCount = 1;
            } else if (this.lineData != null) {
                this.thisMesh.lineData = this.lineData;
            } else {
                this.thisMesh.setPolygonCount(1);
                if (this.setPoints(-1, -1)) {
                    this.setPoints(-1, this.nPoints);
                }
                this.setPolygon(0);
            }
        } else {
            this.thisMesh.modelIndex = -1;
            this.thisMesh.setPolygonCount(n);
            this.thisMesh.ptCenters = new P3[n];
            this.thisMesh.modelFlags = new BS();
            this.thisMesh.drawTypes = new EnumDrawType[n];
            this.thisMesh.drawVertexCounts = new int[n];
            this.thisMesh.vc = 0;
            if (this.indicatedModelIndex >= 0) {
                this.setPoints(-1, 0);
                this.thisMesh.drawType = EnumDrawType.MULTIPLE;
                this.thisMesh.drawVertexCount = -1;
                this.thisMesh.modelFlags.set(this.indicatedModelIndex);
                this.indicatedModelIndex = -1;
            } else {
                object = this.vwr.getVisibleFramesBitSet();
                for (int i = 0; i < n; ++i) {
                    if (((BS)object).get(i) && this.setPoints(i, -1)) {
                        this.setPoints(i, this.nPoints);
                        this.setPolygon(i);
                        this.thisMesh.setCenter(i);
                        this.thisMesh.drawTypes[i] = this.thisMesh.drawType;
                        this.thisMesh.drawVertexCounts[i] = this.thisMesh.drawVertexCount;
                        this.thisMesh.drawType = EnumDrawType.MULTIPLE;
                        this.thisMesh.drawVertexCount = -1;
                        this.thisMesh.modelFlags.set(i);
                        continue;
                    }
                    this.thisMesh.drawTypes[i] = EnumDrawType.NONE;
                    this.thisMesh.pis[i] = new int[0];
                }
            }
        }
        this.thisMesh.isVector = this.isVector;
        this.thisMesh.noHead = this.noHead;
        this.thisMesh.isBarb = this.isBarb;
        this.thisMesh.width = this.thisMesh.drawType == EnumDrawType.CYLINDER || this.thisMesh.drawType == EnumDrawType.CIRCULARPLANE ? -Math.abs(this.width) : this.width;
        this.thisMesh.setCenter(-1);
        if (this.offset != null) {
            this.thisMesh.offset(this.offset);
        }
        if (this.thisMesh.thisID == null) {
            this.thisMesh.thisID = this.thisMesh.drawType.name + ++this.nUnnamed;
            this.htObjects.put(this.thisMesh.thisID, this.thisMesh);
        }
        this.clean();
        return true;
    }

    @Override
    protected void clean() {
        int n = this.meshCount;
        while (--n >= 0) {
            if (this.meshes[n] != null && (this.meshes[n].vc != 0 || this.meshes[n].connectedAtoms != null || this.meshes[n].lineData != null)) continue;
            this.deleteMeshI(n);
        }
    }

    private void addPoint(T3 t3, int n) {
        if (this.makePoints) {
            if (t3 == null || n >= 0 && !this.bsAllModels.get(n)) {
                return;
            }
            this.ptList[this.nPoints] = P3.newP(t3);
            if (t3.z == Float.MAX_VALUE || t3.z == -3.4028235E38f) {
                this.thisMesh.haveXyPoints = true;
            }
        } else if (n >= 0) {
            this.bsAllModels.set(n);
        }
        ++this.nPoints;
    }

    private boolean setPoints(int n, int n2) {
        boolean bl = this.makePoints = n2 >= 0;
        if (this.makePoints) {
            this.ptList = new P3[Math.max(5, n2)];
            if (this.bsAllModels == null) {
                this.bsAllModels = this.vwr.getVisibleFramesBitSet();
            }
        }
        this.nPoints = 0;
        int n3 = this.vData.size();
        int n4 = 0;
        BS bS = n < 0 ? null : this.vwr.getModelUndeletedAtomsBitSet(n);
        block7: for (int i = 0; i < n3; ++i) {
            Object[] objectArray = (Object[])this.vData.get(i);
            switch ((Integer)objectArray[0]) {
                case 4: {
                    int n5;
                    int[] nArray = (int[])objectArray[1];
                    n4 = nArray[0];
                    this.nPoints = nArray[1];
                    int n6 = Math.max(this.nPoints, 3);
                    int n7 = this.thisMesh.vc;
                    if (this.nPoints <= 0) continue block7;
                    this.thisMesh.pis[n4] = new int[n6];
                    int[] nArray2 = this.thisMesh.pis[n4];
                    for (n5 = 0; n5 < this.nPoints; ++n5) {
                        objectArray = (Object[])this.vData.get(++i);
                        nArray2[n5] = this.thisMesh.addV((P3)objectArray[1], false);
                    }
                    for (n5 = this.nPoints; n5 < 3; ++n5) {
                        nArray2[n5] = n7 + this.nPoints - 1;
                    }
                    this.thisMesh.drawTypes[n4] = EnumDrawType.getType(this.nPoints);
                    this.thisMesh.drawVertexCounts[n4] = this.nPoints;
                    this.thisMesh.modelFlags.set(n4);
                    continue block7;
                }
                case 1: {
                    this.addPoint((P3)objectArray[1], this.makePoints ? n : -1);
                    continue block7;
                }
                case 3: {
                    BS bS2 = BSUtil.copy((BS)objectArray[1]);
                    if (bS != null) {
                        bS2.and(bS);
                    }
                    if (bS2.length() <= 0) continue block7;
                    this.addPoint(this.vwr.ms.getAtomSetCenter(bS2), this.makePoints ? n : -1);
                    continue block7;
                }
                case 2: {
                    boolean bl2;
                    int[] nArray2 = (int[])objectArray[1];
                    DrawMesh drawMesh = this.dmeshes[nArray2[0]];
                    boolean bl3 = nArray2[1] == 1;
                    boolean bl4 = bl2 = nArray2[2] == 1;
                    if (drawMesh.modelIndex > 0 && drawMesh.modelIndex != n) {
                        return false;
                    }
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BS();
                    }
                    if (this.isPlane && !this.isCircle || this.isPerpendicular || bl2) {
                        if (bl3) {
                            if (n < 0 || n >= drawMesh.pc) {
                                int n8 = drawMesh.drawVertexCount;
                                while (--n8 >= 0) {
                                    this.addPoint(drawMesh.vs[n8], n);
                                }
                                continue block7;
                            }
                            if (drawMesh.pis[n] == null) continue block7;
                            int n9 = drawMesh.drawVertexCounts[n];
                            while (--n9 >= 0) {
                                this.addPoint(drawMesh.vs[drawMesh.pis[n][n9]], n);
                            }
                            continue block7;
                        }
                        if (n < 0 || n >= drawMesh.pc) {
                            for (int j = 0; j < drawMesh.drawVertexCount; ++j) {
                                this.addPoint(drawMesh.vs[j], n);
                            }
                            continue block7;
                        }
                        if (drawMesh.pis[n] == null) continue block7;
                        for (int j = 0; j < drawMesh.drawVertexCounts[n]; ++j) {
                            this.addPoint(drawMesh.vs[drawMesh.pis[n][j]], n);
                        }
                        continue block7;
                    }
                    if (n < 0 || drawMesh.ptCenters == null || drawMesh.ptCenters[n] == null) {
                        this.addPoint(drawMesh.ptCenter, n);
                        continue block7;
                    }
                    this.addPoint(drawMesh.ptCenters[n], n);
                    continue block7;
                }
                case 5: {
                    BS bS2;
                    Lst lst = (Lst)objectArray[1];
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BS();
                    }
                    for (int j = 0; j < lst.size(); ++j) {
                        if (n >= 0 && j != n) continue;
                        Object e = lst.get(j);
                        this.bsAllModels.set(j);
                        if (e instanceof P3) {
                            this.addPoint((P3)e, j);
                            continue;
                        }
                        if (e instanceof BS) {
                            bS2 = (BS)e;
                            if (bS != null) {
                                bS2.and(bS);
                            }
                            if (bS2.length() <= 0) continue;
                            this.addPoint(this.vwr.ms.getAtomSetCenter(bS2), j);
                            continue;
                        }
                        if (!(e instanceof SV)) continue;
                        this.addPoint(SV.ptValue((SV)e), j);
                    }
                    continue block7;
                }
            }
        }
        if (this.makePoints && this.isCrossed && this.nPoints == 4) {
            P3 p3 = this.ptList[1];
            this.ptList[1] = this.ptList[2];
            this.ptList[2] = p3;
        }
        return this.nPoints > 0;
    }

    private void setPolygon(int n) {
        int n2;
        T3 t3;
        int n3 = this.nPoints;
        EnumDrawType enumDrawType = EnumDrawType.POINT;
        if (this.isArc) {
            if (n3 >= 2) {
                enumDrawType = EnumDrawType.ARC;
            } else {
                this.isArc = false;
                this.isVector = false;
                this.isCurve = false;
                this.isArrow = true;
            }
        }
        if (this.isCircle) {
            this.length = 0.0f;
            if (n3 == 2) {
                this.isPlane = true;
            }
            if (!this.isPlane) {
                enumDrawType = EnumDrawType.CIRCLE;
            }
            if (this.width == 0.0f) {
                this.width = 1.0f;
            }
        } else if ((this.isCurve || this.isArrow) && n3 >= 2 && !this.isArc) {
            EnumDrawType enumDrawType2 = this.isLine ? EnumDrawType.LINE_SEGMENT : (enumDrawType = this.isCurve ? EnumDrawType.CURVE : EnumDrawType.ARROW);
        }
        if (this.isVector && !this.isArc) {
            if (n3 > 2) {
                n3 = 2;
            } else if (this.plane == null && n3 != 2) {
                this.isVector = false;
            }
        }
        if (this.thisMesh.haveXyPoints) {
            this.isPerpendicular = false;
            if (n3 == 3 && this.isPlane) {
                this.isPlane = false;
            }
            this.length = Float.MAX_VALUE;
            if (this.isVector) {
                this.thisMesh.diameter = 0;
            }
        } else if (n3 == 2 && this.isVector) {
            this.ptList[1].add(this.ptList[0]);
        }
        float f = 0.0f;
        if (this.isArc || this.plane != null && this.isCircle) {
            if (this.plane != null) {
                f = Measure.distanceToPlane(this.plane, this.ptList[0]);
                t3 = V3.new3(-this.plane.x, -this.plane.y, -this.plane.z);
                t3.normalize();
                if (f < 0.0f) {
                    t3.scale(-1.0f);
                }
                if (this.isCircle) {
                    t3.scale(0.005f);
                    this.ptList[0].sub(t3);
                    t3.scale(2.0f);
                }
                t3.add(this.ptList[0]);
                this.ptList[1] = P3.newP(t3);
                EnumDrawType enumDrawType3 = this.isArrow ? EnumDrawType.ARROW : (enumDrawType = this.isArc ? EnumDrawType.ARC : EnumDrawType.CIRCULARPLANE);
            }
            if (this.isArc) {
                f = Math.abs(f);
                if (n3 <= 3) {
                    if (n3 == 3) {
                        this.ptList[3] = P3.newP(this.ptList[2]);
                        this.ptList[2] = Draw.randomPoint();
                    } else {
                        if (n3 == 2) {
                            this.ptList[2] = Draw.randomPoint();
                        }
                        this.ptList[3] = P3.new3(0.0f, 360.0f, 0.0f);
                    }
                }
                if (this.plane != null) {
                    this.ptList[3].z *= f;
                }
                n3 = 4;
            }
            this.plane = null;
        } else if (enumDrawType == EnumDrawType.POINT) {
            P3 p3 = new P3();
            V3 v3 = new V3();
            if (n3 == 2 && this.plane != null) {
                this.ptList[1] = P3.newP(this.ptList[0]);
                V3 v32 = new V3();
                Measure.getPlaneProjection(this.ptList[1], this.plane, this.ptList[1], v32);
                n3 = -2;
                if (this.isArrow) {
                    enumDrawType = EnumDrawType.ARROW;
                }
                this.plane = null;
            }
            if (n3 == 3 && this.isPlane && !this.isPerpendicular) {
                t3 = P3.newP(this.ptList[1]);
                t3.sub(this.ptList[0]);
                t3.scale(0.5f);
                this.ptList[3] = P3.newP(this.ptList[2]);
                this.ptList[2].add(t3);
                this.ptList[3].sub(t3);
                n3 = 4;
            } else if (n3 >= 3 && !this.isPlane && this.isPerpendicular) {
                Measure.calcNormalizedNormal(this.ptList[0], this.ptList[1], this.ptList[2], v3, this.vAB);
                p3 = new P3();
                Measure.calcAveragePointN(this.ptList, n3, p3);
                f = this.length == Float.MAX_VALUE ? this.ptList[0].distance(p3) : this.length;
                v3.scale(f);
                this.ptList[0].setT(p3);
                this.ptList[1].add2(p3, v3);
                n3 = 2;
            } else if (n3 == 2 && this.isPerpendicular) {
                Measure.calcAveragePoint(this.ptList[0], this.ptList[1], p3);
                float f2 = f = this.length == Float.MAX_VALUE ? this.ptList[0].distance(p3) : this.length;
                if (this.isPlane && this.length != Float.MAX_VALUE) {
                    f /= 2.0f;
                }
                if (this.isPlane && this.isRotated45) {
                    f *= 1.4142f;
                }
                Measure.getNormalToLine(this.ptList[0], this.ptList[1], v3);
                v3.scale(f);
                if (this.isPlane) {
                    this.ptList[2] = P3.newP(p3);
                    this.ptList[2].sub(v3);
                    t3 = P3.newP(p3);
                    t3.add(v3);
                    Measure.calcNormalizedNormal(this.ptList[0], this.ptList[1], this.ptList[2], v3, this.vAB);
                    v3.scale(f);
                    this.ptList[3] = P3.newP(p3);
                    this.ptList[3].add(v3);
                    this.ptList[1].sub2(p3, v3);
                    this.ptList[0].setT(t3);
                    if (this.isRotated45) {
                        Measure.calcAveragePoint(this.ptList[0], this.ptList[1], this.ptList[0]);
                        Measure.calcAveragePoint(this.ptList[1], this.ptList[2], this.ptList[1]);
                        Measure.calcAveragePoint(this.ptList[2], this.ptList[3], this.ptList[2]);
                        Measure.calcAveragePoint(this.ptList[3], (P3)t3, this.ptList[3]);
                    }
                    n3 = 4;
                } else {
                    this.ptList[0].sub2(p3, v3);
                    this.ptList[1].add2(p3, v3);
                }
                if (this.isArrow && n3 != -2) {
                    this.isArrow = false;
                }
            } else if (n3 == 2 && this.length != Float.MAX_VALUE) {
                Measure.calcAveragePoint(this.ptList[0], this.ptList[1], p3);
                v3.sub2(this.ptList[1], p3);
                v3.scale(0.5f / v3.length() * (this.length == 0.0f ? 0.01f : this.length));
                if (this.length == 0.0f) {
                    p3.setT(this.ptList[0]);
                }
                this.ptList[0].sub2(p3, v3);
                this.ptList[1].add2(p3, v3);
            }
            if (n3 > 4) {
                n3 = 4;
            }
            switch (n3) {
                case -2: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    enumDrawType = this.isArc ? EnumDrawType.ARC : (this.isPlane && this.isCircle ? EnumDrawType.CIRCULARPLANE : (this.isCylinder ? EnumDrawType.CYLINDER : EnumDrawType.LINE));
                    break;
                }
                default: {
                    enumDrawType = this.thisMesh.connectedAtoms == null ? EnumDrawType.PLANE : EnumDrawType.ARROW;
                }
            }
        }
        this.thisMesh.drawType = enumDrawType;
        this.thisMesh.drawVertexCount = n3;
        if (n3 == 0) {
            return;
        }
        int n4 = this.thisMesh.vc;
        for (n2 = 0; n2 < n3; ++n2) {
            this.thisMesh.addV(this.ptList[n2], false);
        }
        n2 = n3 < 3 ? 3 : n3;
        this.thisMesh.setPolygonCount(n + 1);
        this.thisMesh.pis[n] = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.thisMesh.pis[n][i] = n4 + (i < n3 ? i : n3 - 1);
        }
    }

    private void scale(Mesh mesh, float f) {
        DrawMesh drawMesh = (DrawMesh)mesh;
        if (f == 0.0f || drawMesh.vc == 0 && drawMesh.connectedAtoms == null || drawMesh.scale == f) {
            return;
        }
        float f2 = f / drawMesh.scale;
        drawMesh.scale = f;
        drawMesh.isScaleSet = true;
        if (drawMesh.isRenderScalable()) {
            return;
        }
        V3 v3 = new V3();
        int n = -1;
        int n2 = 0;
        try {
            int n3 = drawMesh.pc;
            while (--n3 >= 0) {
                T3 t3;
                T3 t32 = drawMesh.isVector ? drawMesh.vs[0] : (t3 = drawMesh.ptCenters == null ? drawMesh.ptCenter : drawMesh.ptCenters[n3]);
                if (t3 == null) {
                    return;
                }
                if (drawMesh.pis[n3] == null) continue;
                n = -1;
                int n4 = drawMesh.pis[n3].length;
                while (--n4 >= 0) {
                    n2 = drawMesh.pis[n3][n4];
                    if (n2 == n) continue;
                    n = n2;
                    v3.sub2(drawMesh.vs[n2], t3);
                    v3.scale(f2);
                    v3.add(t3);
                    drawMesh.vs[n2].setT(v3);
                }
            }
        }
        catch (Exception exception) {
            Logger.info("Error executing DRAW command: " + exception);
            drawMesh.isValid = false;
        }
    }

    private static final void setAxes(DrawMesh drawMesh) {
        drawMesh.axis = V3.new3(0.0f, 0.0f, 0.0f);
        drawMesh.axes = new V3[drawMesh.pc > 0 ? drawMesh.pc : 1];
        if (drawMesh.vs == null) {
            return;
        }
        int n = 0;
        int n2 = drawMesh.pc;
        while (--n2 >= 0) {
            int[] nArray = drawMesh.pis[n2];
            drawMesh.axes[n2] = new V3();
            if (nArray != null && nArray.length != 0) {
                if (drawMesh.drawVertexCount == 2 || drawMesh.drawVertexCount < 0 && drawMesh.drawVertexCounts[n2] == 2) {
                    drawMesh.axes[n2].sub2(drawMesh.vs[nArray[0]], drawMesh.vs[nArray[1]]);
                    ++n;
                } else {
                    Measure.calcNormalizedNormal(drawMesh.vs[nArray[0]], drawMesh.vs[nArray[1]], drawMesh.vs[nArray[2]], drawMesh.axes[n2], drawMesh.vAB);
                    ++n;
                }
            }
            drawMesh.axis.add(drawMesh.axes[n2]);
        }
        if (n == 0) {
            return;
        }
        drawMesh.axis.scale(1.0f / (float)n);
    }

    @Override
    public void setModelVisibilityFlags(BS bS) {
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh == null) continue;
            int n = drawMesh.visibilityFlags = drawMesh.isValid && drawMesh.visible ? this.vf : 0;
            if (drawMesh.modelIndex >= 0 && !bS.get(drawMesh.modelIndex) || drawMesh.modelFlags != null && !BSUtil.haveCommon(bS, drawMesh.modelFlags)) {
                drawMesh.visibilityFlags = 0;
                continue;
            }
            if (drawMesh.modelFlags == null) continue;
            drawMesh.bsMeshesVisible.clearAll();
            drawMesh.bsMeshesVisible.or(drawMesh.modelFlags);
            drawMesh.bsMeshesVisible.and(bS);
        }
    }

    @Override
    public Map<String, Object> checkObjectClicked(int n, int n2, int n3, BS bS, boolean bl) {
        boolean bl2;
        boolean bl3 = this.vwr.getPickingMode() == 4;
        boolean bl4 = bl2 = this.vwr.getPickingMode() == 5;
        if (!bl3 && !bl && !bl2 || C.isColixTranslucent(this.colix)) {
            return null;
        }
        if (!this.findPickedObject(n, n2, false, bS)) {
            return null;
        }
        T3 t3 = this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][this.pickedVertex]];
        int n4 = this.pickedMesh.modelIndex;
        BS bS2 = ((DrawMesh)this.pickedMesh).modelFlags;
        if (n4 < 0 && BSUtil.cardinalityOf(bS2) == 1) {
            n4 = bS2.nextSetBit(0);
        }
        Map<String, Object> map = null;
        if (n3 != 0) {
            map = this.getPickedPoint(t3, n4);
        }
        if (bl && !bl3) {
            if (n3 != 0) {
                this.setStatusPicked(-2, t3, map);
            }
            return this.getPickedPoint(t3, n4);
        }
        if (n3 == 0 || this.pickedMesh.pis[this.pickedModel][0] == this.pickedMesh.pis[this.pickedModel][1]) {
            return map;
        }
        boolean bl5 = this.vwr.isBound(n3, 42);
        if (this.pickedVertex == 0) {
            this.vwr.startSpinningAxis(this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][1]], this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][0]], bl5);
        } else {
            this.vwr.startSpinningAxis(this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][0]], this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][1]], bl5);
        }
        return this.getPickedPoint(null, 0);
    }

    @Override
    public boolean checkObjectHovered(int n, int n2, BS bS) {
        String string;
        if (!this.vwr.getDrawHover()) {
            return false;
        }
        if (C.isColixTranslucent(this.colix)) {
            return false;
        }
        if (!this.findPickedObject(n, n2, false, bS)) {
            return false;
        }
        if (this.vwr.gdata.antialiasEnabled) {
            n <<= 1;
            n2 <<= 1;
        }
        String string2 = string = this.pickedMesh.title == null ? this.pickedMesh.thisID : this.pickedMesh.title[0];
        if (string.length() > 1 && string.charAt(0) == '>') {
            string = string.substring(1);
        }
        this.vwr.hoverOnPt(n, n2, string, this.pickedMesh.thisID, this.pickedPt);
        return true;
    }

    @Override
    public synchronized boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BS bS) {
        if (this.vwr.getPickingMode() != 4) {
            return false;
        }
        boolean bl = this.vwr.isBound(n5, 8);
        boolean bl2 = this.vwr.isBound(n5, 9);
        if (!bl && !bl2) {
            return false;
        }
        if (n == Integer.MIN_VALUE) {
            return this.findPickedObject(n3, n4, true, bS);
        }
        if (n == Integer.MAX_VALUE) {
            this.pickedMesh = null;
            return false;
        }
        if (this.pickedMesh == null) {
            return false;
        }
        DrawMesh drawMesh = (DrawMesh)this.pickedMesh;
        this.move2D(drawMesh, drawMesh.pis[this.pickedModel], this.pickedVertex, n3, n4, bl);
        this.thisMesh = drawMesh;
        return true;
    }

    private void move2D(DrawMesh drawMesh, int[] nArray, int n, int n2, int n3, boolean bl) {
        int n4;
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (this.vwr.gdata.isAntialiased()) {
            n2 <<= 1;
            n3 <<= 1;
        }
        P3 p3 = new P3();
        int n5 = nArray[n];
        P3 p32 = P3.newP(drawMesh.altVertices == null ? drawMesh.vs[n5] : (P3)drawMesh.altVertices[n5]);
        P3 p33 = new P3();
        V3 v3 = new V3();
        this.vwr.tm.transformPt3f(p32, p3);
        p3.x = n2;
        p3.y = n3;
        this.vwr.tm.unTransformPoint(p3, p33);
        v3.sub2(p33, p32);
        if (drawMesh.isTriangleSet) {
            n = n5;
        }
        int n6 = !bl ? n + 1 : (drawMesh.isTriangleSet ? drawMesh.vs.length : nArray.length);
        BS bS = new BS();
        int n7 = n4 = bl ? 0 : n;
        while (n4 < n6) {
            if (bl || n4 == n) {
                int n8;
                int n9 = n8 = drawMesh.isTriangleSet ? n4 : nArray[n4];
                if (!bS.get(n8)) {
                    bS.set(n8);
                    drawMesh.vs[n8].add(v3);
                }
            }
            ++n4;
        }
        if (drawMesh.altVertices != null) {
            drawMesh.recalcAltVertices = true;
        }
        drawMesh.setCenters();
    }

    private boolean findPickedObject(int n, int n2, boolean bl, BS bS) {
        int n3 = 100;
        if (this.vwr.gdata.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n3 <<= 1;
        }
        this.pickedModel = 0;
        this.pickedVertex = 0;
        this.pickedMesh = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int n4;
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.visibilityFlags == 0) continue;
            int n5 = n4 = drawMesh.isTriangleSet ? drawMesh.pc : (drawMesh.modelFlags == null ? 1 : this.vwr.ms.mc);
            while (--n5 >= 0) {
                int n6;
                if (drawMesh.modelFlags != null && !drawMesh.modelFlags.get(n5) || drawMesh.pis == null || !drawMesh.isTriangleSet && (n5 >= drawMesh.pis.length || drawMesh.pis[n5] == null)) continue;
                int n7 = n6 = drawMesh.isTriangleSet ? 3 : drawMesh.pis[n5].length;
                while (--n6 >= 0) {
                    try {
                        int n8 = drawMesh.pis[n5][n6];
                        T3 t3 = drawMesh.altVertices == null ? drawMesh.vs[n8] : (P3)drawMesh.altVertices[n8];
                        int n9 = this.coordinateInRange(n, n2, t3, n3, this.ptXY);
                        if (n9 < 0) continue;
                        this.pickedMesh = drawMesh;
                        n3 = n9;
                        this.pickedModel = n5;
                        this.pickedVertex = n6;
                        this.pickedPt = t3;
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
            }
        }
        return this.pickedMesh != null;
    }

    private String getCommand(Mesh mesh) {
        if (mesh != null) {
            return this.getCommand2(mesh, mesh.modelIndex);
        }
        SB sB = new SB();
        String string = this.explicitID && this.previousMeshID != null && PT.isWild(this.previousMeshID) ? this.previousMeshID : null;
        Lst<Mesh> lst = this.getMeshList(string, false);
        int n = lst.size();
        while (--n >= 0) {
            Mesh mesh2 = (Mesh)lst.get(n);
            sB.append(this.getCommand2(mesh2, mesh2.modelIndex));
        }
        return sB.toString();
    }

    private String getCommand2(Mesh mesh, int n) {
        Object object;
        int n2;
        DrawMesh drawMesh = (DrawMesh)mesh;
        if (!drawMesh.isValid || drawMesh.drawType == EnumDrawType.NONE && drawMesh.lineData == null && drawMesh.drawVertexCount == 0 && drawMesh.drawVertexCounts == null) {
            return "";
        }
        SB sB = new SB();
        int n3 = this.vwr.ms.mc;
        if (!drawMesh.isFixed && n >= 0 && n3 > 1) {
            Draw.appendCmd(sB, "frame " + this.vwr.getModelNumberDotted(n));
        }
        sB.append("  draw ID ").append(PT.esc(drawMesh.thisID));
        if (drawMesh.isFixed) {
            sB.append(" fixed");
        }
        if (n < 0) {
            n = 0;
        }
        if (drawMesh.noHead) {
            sB.append(" noHead");
        } else if (drawMesh.isBarb) {
            sB.append(" barb");
        }
        if (drawMesh.scale != 1.0f && drawMesh.isScaleSet && (drawMesh.haveXyPoints || drawMesh.connectedAtoms != null || drawMesh.drawType == EnumDrawType.CIRCLE || drawMesh.drawType == EnumDrawType.ARC)) {
            sB.append(" scale ").appendF(drawMesh.scale);
        }
        if (drawMesh.width != 0.0f) {
            sB.append(" diameter ").appendF(drawMesh.drawType == EnumDrawType.CYLINDER ? Math.abs(drawMesh.width) : (drawMesh.drawType == EnumDrawType.CIRCULARPLANE ? Math.abs(drawMesh.width * drawMesh.scale) : drawMesh.width));
        } else if (drawMesh.diameter > 0) {
            sB.append(" diameter ").appendI(drawMesh.diameter);
        }
        if (drawMesh.lineData != null) {
            sB.append("  lineData [");
            n2 = drawMesh.lineData.size();
            int n4 = 0;
            while (n4 < n2) {
                object = (P3[])drawMesh.lineData.get(n4);
                String string = Escape.eP(object[0]);
                sB.append(string.substring(1, string.length() - 1));
                sB.append(",");
                string = Escape.eP(object[1]);
                sB.append(string.substring(1, string.length() - 1));
                if (++n4 >= n2) continue;
                sB.append(", ");
            }
            sB.append("]");
        } else {
            n2 = drawMesh.drawVertexCount > 0 || drawMesh.drawVertexCounts == null ? drawMesh.drawVertexCount : drawMesh.drawVertexCounts[n >= 0 ? n : 0];
            switch (drawMesh.drawTypes == null || drawMesh.drawTypes[n] == null ? drawMesh.drawType : drawMesh.drawTypes[n]) {
                case NONE: 
                case MULTIPLE: {
                    break;
                }
                case POLYGON: {
                    sB.append(" POLYGON ").appendI(n2);
                    break;
                }
                case PLANE: {
                    if (n2 != 4) break;
                    sB.append(" PLANE");
                    break;
                }
                case LINE_SEGMENT: {
                    sB.append(" LINE");
                    break;
                }
                case ARC: {
                    sB.append(drawMesh.isVector ? " ARROW ARC" : " ARC");
                    break;
                }
                case ARROW: {
                    sB.append(drawMesh.isVector ? " VECTOR" : " ARROW");
                    if (drawMesh.connectedAtoms == null) break;
                    sB.append(" connect ").append(Escape.eAI(drawMesh.connectedAtoms));
                    break;
                }
                case CIRCLE: {
                    sB.append(" CIRCLE");
                    break;
                }
                case CURVE: {
                    sB.append(" CURVE");
                    break;
                }
                case CIRCULARPLANE: 
                case CYLINDER: {
                    sB.append(" CYLINDER");
                    break;
                }
                case POINT: {
                    n2 = 1;
                    break;
                }
                case LINE: {
                    n2 = 2;
                }
            }
            if (drawMesh.modelIndex < 0 && !drawMesh.isFixed) {
                for (int i = 0; i < n3; ++i) {
                    if (!Draw.isPolygonDisplayable(drawMesh, i)) continue;
                    if (n2 == 0) {
                        n2 = drawMesh.drawVertexCounts[i];
                    }
                    sB.append(" [ " + i);
                    object = Draw.getVertexList(drawMesh, i, n2);
                    if (((String)object).indexOf("NaN") >= 0) {
                        return "";
                    }
                    sB.append((String)object);
                    sB.append(" ] ");
                }
            } else if (drawMesh.drawType == EnumDrawType.POLYGON) {
                int n5;
                for (n5 = 0; n5 < drawMesh.vc; ++n5) {
                    sB.append(" ").append(Escape.eP(drawMesh.vs[n5]));
                }
                sB.append(" ").appendI(drawMesh.pc);
                for (n5 = 0; n5 < drawMesh.pc; ++n5) {
                    if (drawMesh.pis[n5] == null) {
                        sB.append(" [0 0 0 0]");
                        continue;
                    }
                    sB.append(" ").append(Escape.eAI(drawMesh.pis[n5]));
                }
            } else {
                String string = Draw.getVertexList(drawMesh, n, n2);
                if (string.indexOf("NaN") >= 0) {
                    return "";
                }
                sB.append(string);
            }
        }
        if (drawMesh.mat4 != null) {
            V3 v3 = new V3();
            drawMesh.mat4.getTranslation(v3);
            sB.append(" offset ").append(Escape.eP(v3));
        }
        if (drawMesh.title != null) {
            String string = "";
            for (int i = 0; i < drawMesh.title.length; ++i) {
                string = string + "|" + drawMesh.title[i];
            }
            sB.append(PT.esc(string.substring(1)));
        }
        sB.append(";\n");
        Draw.appendCmd(sB, drawMesh.getState("draw"));
        Draw.appendCmd(sB, Draw.getColorCommandUnk("draw", drawMesh.colix, this.translucentAllowed));
        return sB.toString();
    }

    public static boolean isPolygonDisplayable(Mesh mesh, int n) {
        return n < mesh.pis.length && mesh.pis[n] != null && mesh.pis[n].length > 0;
    }

    private static String getVertexList(DrawMesh drawMesh, int n, int n2) {
        String string = "";
        try {
            if (n >= drawMesh.pis.length) {
                n = 0;
            }
            boolean bl = drawMesh.isVector && drawMesh.drawType != EnumDrawType.ARC;
            for (int i = 0; i < n2; ++i) {
                T3 t3 = drawMesh.vs[drawMesh.pis[n][i]];
                if (t3.z == Float.MAX_VALUE || t3.z == -3.4028235E38f) {
                    string = string + (i == 0 ? " " : " ,") + "[" + (int)t3.x + " " + (int)t3.y + (t3.z < 0.0f ? " %]" : "]");
                    continue;
                }
                if (bl && i == 1) {
                    P3 p3 = P3.newP(t3);
                    p3.sub(drawMesh.vs[drawMesh.pis[n][0]]);
                    string = string + " " + Escape.eP(p3);
                    continue;
                }
                string = string + " " + Escape.eP(t3);
            }
        }
        catch (Exception exception) {
            Logger.error("Unexpected error in Draw.getVertexList");
        }
        return string;
    }

    @Override
    public Lst<Map<String, Object>> getShapeDetail() {
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        for (int i = 0; i < this.meshCount; ++i) {
            int n;
            Lst<Serializable> lst2;
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.vc == 0) continue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("visible", drawMesh.visible ? Boolean.TRUE : Boolean.FALSE);
            hashtable.put("fixed", drawMesh.ptCenters == null ? Boolean.TRUE : Boolean.FALSE);
            hashtable.put("ID", drawMesh.thisID == null ? "<noid>" : drawMesh.thisID);
            hashtable.put("drawType", drawMesh.drawType.name);
            if (drawMesh.diameter > 0) {
                hashtable.put("diameter", drawMesh.diameter);
            }
            if (drawMesh.width != 0.0f) {
                hashtable.put("width", Float.valueOf(drawMesh.width));
            }
            hashtable.put("scale", Float.valueOf(drawMesh.scale));
            if (drawMesh.drawType == EnumDrawType.MULTIPLE) {
                lst2 = new Lst<Serializable>();
                n = this.vwr.ms.mc;
                for (int j = 0; j < n; ++j) {
                    if (drawMesh.ptCenters[j] == null) continue;
                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                    hashtable2.put("modelIndex", j);
                    hashtable2.put("command", this.getCommand2(drawMesh, j));
                    hashtable2.put("center", drawMesh.ptCenters[j]);
                    int n2 = drawMesh.drawVertexCounts[j];
                    hashtable2.put("vertexCount", n2);
                    if (n2 > 1) {
                        hashtable2.put("axis", drawMesh.axes[j]);
                    }
                    Lst<T3> lst3 = new Lst<T3>();
                    for (int k = 0; k < n2; ++k) {
                        lst3.addLast(drawMesh.vs[drawMesh.pis[j][k]]);
                    }
                    hashtable2.put("vertices", lst3);
                    if (drawMesh.drawTypes[j] == EnumDrawType.LINE) {
                        float f = drawMesh.vs[drawMesh.pis[j][0]].distance(drawMesh.vs[drawMesh.pis[j][1]]);
                        hashtable2.put("length_Ang", Float.valueOf(f));
                    }
                    lst2.addLast(hashtable2);
                }
                hashtable.put("models", lst2);
            } else {
                hashtable.put("command", this.getCommand(drawMesh));
                hashtable.put("center", drawMesh.ptCenter);
                if (drawMesh.drawVertexCount > 1) {
                    hashtable.put("axis", drawMesh.axis);
                }
                lst2 = new Lst();
                for (n = 0; n < drawMesh.vc; ++n) {
                    lst2.addLast(drawMesh.vs[n]);
                }
                hashtable.put("vertices", lst2);
                if (drawMesh.drawType == EnumDrawType.LINE) {
                    hashtable.put("length_Ang", Float.valueOf(drawMesh.vs[0].distance(drawMesh.vs[1])));
                }
            }
            lst.addLast((Map<String, Object>)hashtable);
        }
        return lst;
    }

    @Override
    public String getShapeState() {
        SB sB = new SB();
        sB.append("\n");
        Draw.appendCmd(sB, this.myType + " delete");
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.vc == 0 && drawMesh.lineData == null) continue;
            sB.append(this.getCommand2(drawMesh, drawMesh.modelIndex));
            if (drawMesh.visible) continue;
            sB.append(" " + this.myType + " ID " + PT.esc(drawMesh.thisID) + " off;\n");
        }
        return sB.toString();
    }

    public static P3 randomPoint() {
        return P3.new3((float)Math.random(), (float)Math.random(), (float)Math.random());
    }

    public static enum EnumDrawType {
        MULTIPLE(-1, "multiple"),
        NONE(0, "none"),
        POINT(1, "point"),
        LINE(2, "line"),
        PLANE(4, "plane"),
        CYLINDER(14, "cylinder"),
        ARROW(15, "arrow"),
        CIRCLE(16, "circle"),
        CURVE(17, "curve"),
        CIRCULARPLANE(18, "circularPlane"),
        ARC(19, "arc"),
        LINE_SEGMENT(20, "lineSegment"),
        POLYGON(21, "polygon");

        final int id;
        final String name;

        private EnumDrawType(int n2, String string2) {
            this.id = n2;
            this.name = string2;
        }

        public static EnumDrawType getType(int n) {
            switch (n) {
                case 1: {
                    return POINT;
                }
                case 2: {
                    return LINE;
                }
                case 4: {
                    return PLANE;
                }
            }
            return NONE;
        }
    }
}

