/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.CU;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class Ras3DReader
extends PolygonFileReader {
    private String pmeshError;
    private String type;
    private boolean asQuads;
    private int nPolygons;
    Map<String, Integer> htVertices;

    Ras3DReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PR(surfaceGenerator, bufferedReader);
    }

    protected void init2PR(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PFR(surfaceGenerator, bufferedReader);
        String string = (String)((Object[])surfaceGenerator.getReaderData())[0];
        if (string == null) {
            return;
        }
        this.type = "ras3d";
        this.setHeader();
    }

    protected void setHeader() {
        this.jvxlFileHeaderBuffer.append(this.type + " file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    @Override
    void getSurfaceData() throws Exception {
        if (this.readVerticesAndPolygons()) {
            Logger.info((String)(this.type + " file contains " + this.nVertices + " vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles"));
        } else {
            Logger.error((String)(this.params.fileName + ": " + (this.pmeshError == null ? "Error reading pmesh data " : this.pmeshError)));
        }
    }

    protected boolean readVerticesAndPolygons() {
        block3: {
            try {
                if (this.readVertices()) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (this.pmeshError != null) break block3;
                this.pmeshError = this.type + " ERROR: " + exception;
            }
        }
        return false;
    }

    private boolean readVertices() throws Exception {
        this.htVertices = new Hashtable<String, Integer>();
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n = 0;
        int n2 = 0;
        if (this.rd().indexOf("DSSR") >= 0) {
            this.asQuads = true;
        }
        while (this.rd() != null) {
            while (!this.line.equals("1")) {
                this.rd();
            }
            this.rd();
            String[] stringArray = this.getTokens();
            nArray[0] = this.getPoint(stringArray, 0);
            nArray[1] = this.getPoint(stringArray, 3);
            nArray[2] = this.getPoint(stringArray, 6);
            ++this.nTriangles;
            n = CU.colorTriadToFFRGB((float)this.parseFloatStr(stringArray[9]), (float)this.parseFloatStr(stringArray[10]), (float)this.parseFloatStr(stringArray[11]));
            if (this.asQuads) {
                if (this.nTriangles % 2 == 1) {
                    int[] nArray3 = nArray2;
                    nArray2 = nArray;
                    nArray = nArray3;
                    int n3 = n2;
                    n2 = n;
                    n = n3;
                    continue;
                }
                this.addTriangleCheck(nArray[0], nArray[1], nArray[2], 6, 0, false, n);
                this.addTriangleCheck(nArray2[0], nArray2[1], nArray2[2], 3, 0, false, n2);
            } else {
                this.addTriangleCheck(nArray[0], nArray[1], nArray[2], 7, 0, false, n);
            }
            ++this.nPolygons;
        }
        return true;
    }

    private int getPoint(String[] stringArray, int n) {
        String string = stringArray[n] + ";" + stringArray[n + 1] + ";" + stringArray[n + 2];
        Integer n2 = this.htVertices.get(string);
        if (n2 == null) {
            this.addVertexCopy((T3)P3.new3((float)this.parseFloatStr(stringArray[n]), (float)this.parseFloatStr(stringArray[n + 1]), (float)this.parseFloatStr(stringArray[n + 2])), 0.0f, this.nVertices, false);
            n2 = this.nVertices++;
            this.htVertices.put(string, n2);
        }
        return n2;
    }
}

