/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;

public class XmlCmlReader
extends XmlReader {
    private String scalarDictRef;
    private String scalarDictValue;
    private String scalarTitle;
    private String cellParameterType;
    private boolean checkedSerial;
    private boolean isSerial;
    private int moleculeNesting = 0;
    private int latticeVectorPtr = 0;
    private boolean embeddedCrystal = false;
    private Properties atomIdNames;
    protected String[] tokens = new String[16];
    private int aaLen;
    private Atom[] atomArray = new Atom[100];
    private int bondCount;
    private Bond[] bondArray = new Bond[100];
    private int tokenCount;
    private int moduleNestingLevel = 0;
    private boolean haveMolecule = false;
    private String localSpaceGroupName;
    protected boolean processing = true;
    protected int state = 0;
    private int atomIndex0;
    private Lst<String[]> joinList;
    private Map<Atom, String> mapRtoA;
    private BS deleteAtoms;
    protected String moleculeID;
    protected Map<String, Object> htModelAtomMap;
    protected static final int START = 0;
    protected static final int CML = 1;
    protected static final int CRYSTAL = 2;
    protected static final int CRYSTAL_SCALAR = 3;
    protected static final int CRYSTAL_SYMMETRY = 4;
    protected static final int CRYSTAL_SYMMETRY_TRANSFORM3 = 5;
    protected static final int MOLECULE = 6;
    protected static final int MOLECULE_ATOM_ARRAY = 7;
    protected static final int MOLECULE_ATOM = 8;
    protected static final int MOLECULE_ATOM_SCALAR = 9;
    protected static final int MOLECULE_BOND_ARRAY = 10;
    protected static final int MOLECULE_BOND = 11;
    protected static final int MOLECULE_FORMULA = 12;
    protected static final int MOLECULE_ATOM_BUILTIN = 13;
    protected static final int MOLECULE_BOND_BUILTIN = 14;
    protected static final int MODULE = 15;
    protected static final int SYMMETRY = 17;
    protected static final int LATTICE_VECTOR = 18;
    protected static final int ASSOCIATION = 19;
    private static final String[] unitCellParamTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};

    @Override
    public void processStartElement(String string, String string2) {
        if (!this.processing) {
            return;
        }
        this.processStart2(string);
    }

    protected void processStart2(String string) {
        string = string.toLowerCase();
        switch (this.state) {
            case 0: {
                if (string.equals("molecule")) {
                    this.moleculeID = (String)this.atts.get("id");
                    this.state = 6;
                    this.haveMolecule = true;
                    if (this.moleculeNesting == 0) {
                        this.createNewAtomSet();
                    }
                    ++this.moleculeNesting;
                    break;
                }
                if (string.equals("crystal")) {
                    this.state = 2;
                    break;
                }
                if (string.equals("symmetry")) {
                    this.state = 17;
                    String string2 = (String)this.atts.get("spacegroup");
                    if (string2 != null) {
                        this.localSpaceGroupName = string2;
                        break;
                    }
                    this.localSpaceGroupName = "P1";
                    this.parent.clearUnitCell();
                    break;
                }
                if (string.equals("module")) {
                    ++this.moduleNestingLevel;
                    break;
                }
                if (!string.equals("latticevector")) break;
                this.state = 18;
                this.setKeepChars(true);
                break;
            }
            case 2: {
                String string3;
                this.checkedSerial = true;
                this.isSerial = false;
                if (string.equals("scalar")) {
                    this.state = 3;
                    this.setKeepChars(true);
                    this.scalarTitle = (String)this.atts.get("title");
                    this.getDictRefValue();
                    break;
                }
                if (string.equals("symmetry")) {
                    this.state = 4;
                    String string4 = (String)this.atts.get("spacegroup");
                    if (string4 == null) break;
                    this.localSpaceGroupName = string4;
                    for (int i = 0; i < this.localSpaceGroupName.length(); ++i) {
                        if (this.localSpaceGroupName.charAt(i) != '_') continue;
                        this.localSpaceGroupName = this.localSpaceGroupName.substring(0, i) + this.localSpaceGroupName.substring(i-- + 1);
                    }
                    break;
                }
                if (!string.equals("cellparameter") || (string3 = (String)this.atts.get("parametertype")) == null) break;
                this.cellParameterType = string3;
                this.setKeepChars(true);
                break;
            }
            case 18: {
                this.setKeepChars(true);
                break;
            }
            case 3: 
            case 4: 
            case 17: {
                if (!string.equals("transform3")) break;
                this.state = 5;
                this.setKeepChars(true);
                break;
            }
            case 5: 
            case 6: {
                if (string.equals("fragmentlist")) {
                    this.joinList = new Lst();
                    this.mapRtoA = new Hashtable<Atom, String>();
                    if (this.deleteAtoms != null) break;
                    this.deleteAtoms = new BS();
                    break;
                }
                if (string.equals("crystal")) {
                    this.state = 2;
                    this.embeddedCrystal = true;
                    break;
                }
                if (string.equals("molecule")) {
                    this.state = 6;
                    ++this.moleculeNesting;
                    break;
                }
                if (string.equals("join")) {
                    int n = -1;
                    this.tokenCount = 0;
                    String string5 = (String)this.atts.get("atomrefs2");
                    if (string5 == null) break;
                    this.breakOutTokens(string5);
                    string5 = (String)this.atts.get("order");
                    if (string5 != null) {
                        n = this.parseBondToken(string5);
                    }
                    if (this.tokenCount != 2 || n <= 0) break;
                    this.joinList.addLast(new String[]{this.tokens[0], this.tokens[1], "" + n});
                    break;
                }
                if (string.equals("bondarray")) {
                    int n;
                    this.state = 10;
                    this.bondCount = 0;
                    String string6 = (String)this.atts.get("order");
                    if (string6 != null) {
                        this.breakOutBondTokens(string6);
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.bondArray[n].order = this.parseBondToken(this.tokens[n]);
                        }
                    }
                    if ((string6 = (String)this.atts.get("atomref1")) != null) {
                        this.breakOutBondTokens(string6);
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.bondArray[n].atomIndex1 = this.getAtomIndex(this.tokens[n]);
                        }
                    }
                    if ((string6 = (String)this.atts.get("atomref2")) == null) break;
                    this.breakOutBondTokens(string6);
                    n = this.tokenCount;
                    while (--n >= 0) {
                        this.bondArray[n].atomIndex2 = this.getAtomIndex(this.tokens[n]);
                    }
                    break;
                }
                if (string.equals("atomarray")) {
                    int n;
                    this.state = 7;
                    this.aaLen = 0;
                    boolean bl = false;
                    String string7 = (String)this.atts.get("atomid");
                    if (string7 != null) {
                        this.breakOutAtomTokens(string7);
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.atomArray[n].atomName = this.tokens[n];
                        }
                    }
                    if ((string7 = (String)this.atts.get("x3")) != null) {
                        bl = true;
                        this.breakOutAtomTokens(string7);
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.atomArray[n].x = this.parseFloatStr(this.tokens[n]);
                        }
                    }
                    if ((string7 = (String)this.atts.get("y3")) != null) {
                        this.breakOutAtomTokens(string7);
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.atomArray[n].y = this.parseFloatStr(this.tokens[n]);
                        }
                    }
                    if ((string7 = (String)this.atts.get("z3")) != null) {
                        this.breakOutAtomTokens(string7);
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.atomArray[n].z = this.parseFloatStr(this.tokens[n]);
                        }
                    }
                    if ((string7 = (String)this.atts.get("x2")) != null) {
                        this.breakOutAtomTokens(string7);
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.atomArray[n].x = this.parseFloatStr(this.tokens[n]);
                        }
                    }
                    if ((string7 = (String)this.atts.get("y2")) != null) {
                        this.breakOutAtomTokens(string7);
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.atomArray[n].y = this.parseFloatStr(this.tokens[n]);
                        }
                    }
                    if ((string7 = (String)this.atts.get("elementtype")) != null) {
                        this.breakOutAtomTokens(string7);
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.atomArray[n].elementSymbol = this.tokens[n];
                        }
                    }
                    n = this.aaLen;
                    while (--n >= 0) {
                        Atom atom = this.atomArray[n];
                        if (!bl) {
                            atom.z = 0.0f;
                        }
                        this.addAtom(atom);
                    }
                    break;
                }
                if (string.equals("formula")) {
                    this.state = 12;
                    break;
                }
                if (!string.equals("association")) break;
                this.state = 19;
                break;
            }
            case 10: {
                if (!string.equals("bond")) break;
                this.state = 11;
                int n = -1;
                this.tokenCount = 0;
                String string8 = (String)this.atts.get("atomrefs2");
                if (string8 != null) {
                    this.breakOutTokens(string8);
                }
                if ((string8 = (String)this.atts.get("order")) != null) {
                    n = this.parseBondToken(string8);
                }
                if (this.tokenCount != 2 || n <= 0) break;
                this.addNewBond(this.tokens[0], this.tokens[1], n);
                break;
            }
            case 7: {
                if (!string.equals("atom")) break;
                this.state = 8;
                this.atom = new Atom();
                this.parent.setFractionalCoordinates(false);
                String string9 = (String)this.atts.get("id");
                String string10 = (String)this.atts.get("name");
                this.atom.atomName = string10 != null ? string10 : ((string10 = (String)this.atts.get("title")) != null ? string10 : ((string10 = (String)this.atts.get("label")) != null ? string10 : string9));
                if (!this.checkedSerial) {
                    this.isSerial = string9 != null && string9.length() > 1 && string9.startsWith("a") && PT.parseInt(string9.substring(1)) != Integer.MIN_VALUE;
                    this.checkedSerial = true;
                }
                if (this.isSerial) {
                    this.atom.atomSerial = PT.parseInt(string9.substring(1));
                }
                if ((string10 = (String)this.atts.get("xfract")) != null && (this.parent.iHaveUnitCell || !this.atts.containsKey("x3"))) {
                    this.parent.setFractionalCoordinates(true);
                    this.atom.set(this.parseFloatStr(string10), this.parseFloatStr((String)this.atts.get("yfract")), this.parseFloatStr((String)this.atts.get("zfract")));
                } else {
                    string10 = (String)this.atts.get("x3");
                    if (string10 != null) {
                        this.atom.set(this.parseFloatStr(string10), this.parseFloatStr((String)this.atts.get("y3")), this.parseFloatStr((String)this.atts.get("z3")));
                    } else {
                        string10 = (String)this.atts.get("x2");
                        if (string10 != null) {
                            this.atom.set(this.parseFloatStr(string10), this.parseFloatStr((String)this.atts.get("y2")), 0.0f);
                        }
                    }
                }
                string10 = (String)this.atts.get("elementtype");
                if (string10 != null) {
                    String string11 = string10;
                    string10 = (String)this.atts.get("isotope");
                    if (string10 != null) {
                        this.atom.elementNumber = (short)((this.parseIntStr(string10) << 7) + JmolAdapter.getElementNumber(string11));
                    }
                    this.atom.elementSymbol = string11;
                }
                if ((string10 = (String)this.atts.get("formalcharge")) == null) break;
                this.atom.formalCharge = this.parseIntStr(string10);
                break;
            }
            case 11: {
                String string12 = (String)this.atts.get("builtin");
                if (string12 == null) break;
                this.setKeepChars(true);
                this.state = 14;
                this.scalarDictValue = string12;
                break;
            }
            case 8: {
                if (string.equals("scalar")) {
                    this.state = 9;
                    this.setKeepChars(true);
                    this.scalarTitle = (String)this.atts.get("title");
                    this.getDictRefValue();
                    break;
                }
                String string13 = (String)this.atts.get("builtin");
                if (string13 == null) break;
                this.setKeepChars(true);
                this.state = 13;
                this.scalarDictValue = string13;
                break;
            }
            case 9: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
        }
    }

    private int getAtomIndex(String string) {
        return this.asc.getAtomIndex(this.isSerial ? string.substring(1) : string);
    }

    @Override
    void processEndElement(String string) {
        if (!this.processing) {
            return;
        }
        this.processEnd2(string);
    }

    public void processEnd2(String string) {
        string = string.toLowerCase();
        switch (this.state) {
            case 0: {
                if (!string.equals("module") || --this.moduleNestingLevel != 0) break;
                if (this.parent.iHaveUnitCell) {
                    this.applySymmetryAndSetTrajectory();
                }
                this.setAtomNames();
                break;
            }
            case 19: {
                if (!string.equals("association")) break;
                this.state = 6;
                break;
            }
            case 2: {
                if (string.equals("crystal")) {
                    if (this.embeddedCrystal) {
                        this.state = 6;
                        this.embeddedCrystal = false;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                if (!string.equals("cellparameter") || !this.keepChars) break;
                String[] stringArray = PT.getTokens(this.chars.toString());
                this.setKeepChars(false);
                if (stringArray.length == 3 && this.cellParameterType != null) {
                    if (this.cellParameterType.equals("length")) {
                        for (int i = 0; i < 3; ++i) {
                            this.parent.setUnitCellItem(i, this.parseFloatStr(stringArray[i]));
                        }
                        break;
                    }
                    if (this.cellParameterType.equals("angle")) {
                        for (int i = 0; i < 3; ++i) {
                            this.parent.setUnitCellItem(i + 3, this.parseFloatStr(stringArray[i]));
                        }
                        break;
                    }
                }
                Logger.error("bad cellParameter information: parameterType=" + this.cellParameterType + " data=" + this.chars);
                this.parent.setFractionalCoordinates(false);
                break;
            }
            case 3: {
                if (string.equals("scalar")) {
                    this.state = 2;
                    if (this.scalarTitle != null) {
                        this.checkUnitCellItem(unitCellParamTags, this.scalarTitle);
                    } else if (this.scalarDictRef != null) {
                        this.checkUnitCellItem(JmolAdapter.cellParamNames, this.scalarDictValue.startsWith("_") ? this.scalarDictValue : "_" + this.scalarDictValue);
                    }
                }
                this.setKeepChars(false);
                this.scalarTitle = null;
                this.scalarDictRef = null;
                break;
            }
            case 5: {
                if (!string.equals("transform3")) break;
                this.setKeepChars(false);
                this.state = 4;
                break;
            }
            case 18: {
                float[] fArray = XmlCmlReader.getTokensFloat(this.chars.toString(), null, 3);
                this.parent.addPrimitiveLatticeVector(this.latticeVectorPtr, fArray, 0);
                this.latticeVectorPtr = (this.latticeVectorPtr + 1) % 3;
                this.setKeepChars(false);
                this.state = 0;
                break;
            }
            case 4: 
            case 17: {
                if (string.equals("symmetry")) {
                    int n = this.state = this.state == 4 ? 2 : 0;
                }
                if (this.moduleNestingLevel != 0 || !this.parent.iHaveUnitCell || this.embeddedCrystal) break;
                this.applySymmetryAndSetTrajectory();
                break;
            }
            case 6: {
                if (string.equals("fragmentlist")) {
                    int n = this.joinList.size();
                    while (--n >= 0) {
                        String[] stringArray = (String[])this.joinList.get(n);
                        Atom atom = this.asc.getAtomFromName(this.fixSerialName(stringArray[0]));
                        Atom atom2 = this.asc.getAtomFromName(this.fixSerialName(stringArray[1]));
                        if (atom == null || atom2 == null) continue;
                        this.deleteAtoms.set(atom.index);
                        this.deleteAtoms.set(atom2.index);
                        this.addNewBond(this.mapRtoA.get(atom), this.mapRtoA.get(atom2), this.parseIntStr(stringArray[2]));
                    }
                    this.joinList = null;
                    this.mapRtoA = null;
                }
                if (!string.equals("molecule")) break;
                if (--this.moleculeNesting == 0) {
                    this.applySymmetryAndSetTrajectory();
                    this.setAtomNames();
                    this.state = 0;
                    break;
                }
                this.state = 6;
                break;
            }
            case 10: {
                if (!string.equals("bondarray")) break;
                this.state = 6;
                for (int i = 0; i < this.bondCount; ++i) {
                    this.addBond(this.bondArray[i]);
                }
                this.parent.applySymmetryToBonds = true;
                break;
            }
            case 7: {
                if (!string.equals("atomarray")) break;
                this.state = 6;
                for (int i = 0; i < this.aaLen; ++i) {
                    this.addAtom(this.atomArray[i]);
                }
                break;
            }
            case 11: {
                if (!string.equals("bond")) break;
                this.state = 10;
                break;
            }
            case 8: {
                if (!string.equals("atom")) break;
                this.state = 7;
                this.addAtom(this.atom);
                this.atom = null;
                break;
            }
            case 9: {
                if (string.equals("scalar")) {
                    this.state = 8;
                    if ("jmol:charge".equals(this.scalarDictRef)) {
                        this.atom.partialCharge = this.parseFloatStr(this.chars.toString());
                    } else if (this.scalarDictRef != null && "_atom_site_label".equals(this.scalarDictValue)) {
                        if (this.atomIdNames == null) {
                            this.atomIdNames = new Properties();
                        }
                        this.atomIdNames.put(this.atom.atomName, this.chars.toString());
                    }
                }
                this.setKeepChars(false);
                this.scalarTitle = null;
                this.scalarDictRef = null;
                break;
            }
            case 13: {
                this.state = 8;
                if (this.scalarDictValue.equals("x3")) {
                    this.atom.x = this.parseFloatStr(this.chars.toString());
                } else if (this.scalarDictValue.equals("y3")) {
                    this.atom.y = this.parseFloatStr(this.chars.toString());
                } else if (this.scalarDictValue.equals("z3")) {
                    this.atom.z = this.parseFloatStr(this.chars.toString());
                } else if (this.scalarDictValue.equals("elementType")) {
                    this.atom.elementSymbol = this.chars.toString();
                }
                this.setKeepChars(false);
                break;
            }
            case 14: {
                int n;
                this.state = 11;
                if (this.scalarDictValue.equals("atomRef")) {
                    if (this.tokenCount == 0) {
                        this.tokens = new String[2];
                    }
                    if (this.tokenCount < 2) {
                        this.tokens[this.tokenCount++] = this.chars.toString();
                    }
                } else if (this.scalarDictValue.equals("order") && (n = this.parseBondToken(this.chars.toString())) > 0 && this.tokenCount == 2) {
                    this.addNewBond(this.tokens[0], this.tokens[1], n);
                }
                this.setKeepChars(false);
                break;
            }
            case 12: {
                this.state = 6;
            }
        }
    }

    private void addBond(Bond bond) {
        Atom atom = this.asc.atoms[bond.atomIndex1];
        Atom atom2 = this.asc.atoms[bond.atomIndex2];
        if (this.joinList != null && !this.checkBondToR(atom.atomName, atom2.atomName)) {
            this.asc.addBond(bond);
        }
    }

    private boolean checkBondToR(String string, String string2) {
        Atom atom = this.asc.getAtomFromName(string);
        Atom atom2 = this.asc.getAtomFromName(string2);
        if (atom == null || atom2 == null) {
            return true;
        }
        if ("R".equals(atom.elementSymbol)) {
            this.mapRtoA.put(atom, atom2.atomName);
            return true;
        }
        if ("R".equals(atom2.elementSymbol)) {
            this.mapRtoA.put(atom2, atom.atomName);
            return true;
        }
        return false;
    }

    private void setAtomNames() {
        if (this.atomIdNames == null) {
            return;
        }
        Atom[] atomArray = this.asc.atoms;
        for (int i = this.atomIndex0; i < this.asc.ac; ++i) {
            String string = this.atomIdNames.getProperty(atomArray[i].atomName);
            if (string == null) continue;
            atomArray[i].atomName = string;
        }
        this.atomIdNames = null;
        this.atomIndex0 = this.asc.ac;
    }

    private void addNewBond(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return;
        }
        this.parent.applySymmetryToBonds = true;
        string = this.fixSerialName(string);
        string2 = this.fixSerialName(string2);
        if (this.joinList == null || !this.checkBondToR(string, string2)) {
            this.asc.addNewBondFromNames(string, string2, n);
        }
    }

    private String fixSerialName(String string) {
        return this.isSerial ? string.substring(1) : string;
    }

    private void getDictRefValue() {
        this.scalarDictRef = (String)this.atts.get("dictref");
        if (this.scalarDictRef != null) {
            int n = this.scalarDictRef.indexOf(":");
            this.scalarDictValue = this.scalarDictRef.substring(n + 1);
        }
    }

    private void checkUnitCellItem(String[] stringArray, String string) {
        int n = stringArray.length;
        while (--n >= 0) {
            if (!string.equals(stringArray[n])) continue;
            this.parent.setUnitCellItem(n, this.parseFloatStr(this.chars.toString()));
            return;
        }
    }

    private void addAtom(Atom atom) {
        if (atom.elementSymbol == null && atom.elementNumber < 0 || Float.isNaN(atom.z)) {
            return;
        }
        this.parent.setAtomCoord(atom);
        if (this.htModelAtomMap != null) {
            this.htModelAtomMap.put(this.moleculeID + atom.atomName, atom);
        }
        if (this.isSerial) {
            this.asc.addAtomWithMappedSerialNumber(atom);
        } else {
            this.asc.addAtomWithMappedName(atom);
        }
    }

    private int parseBondToken(String string) {
        float f = this.parseFloatStr(string);
        if (Float.isNaN(f) && string.length() >= 1) {
            string = string.toUpperCase();
            switch (string.charAt(0)) {
                case 'S': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'T': {
                    return 3;
                }
                case 'A': {
                    return 515;
                }
                case 'P': {
                    return 66;
                }
            }
            return this.parseIntStr(string);
        }
        if ((double)f == 1.5) {
            return 515;
        }
        if (f == 2.0f) {
            return 2;
        }
        if (f == 3.0f) {
            return 3;
        }
        return 1;
    }

    private void breakOutTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.tokenCount = stringTokenizer.countTokens();
        if (this.tokenCount > this.tokens.length) {
            this.tokens = new String[this.tokenCount];
        }
        for (int i = 0; i < this.tokenCount; ++i) {
            try {
                this.tokens[i] = stringTokenizer.nextToken();
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.tokens[i] = null;
            }
        }
    }

    void breakOutAtomTokens(String string) {
        this.breakOutTokens(string);
        this.checkAtomArrayLength(this.tokenCount);
    }

    void checkAtomArrayLength(int n) {
        if (this.aaLen == 0) {
            if (n > this.atomArray.length) {
                this.atomArray = new Atom[n];
            }
            int n2 = n;
            while (--n2 >= 0) {
                this.atomArray[n2] = new Atom();
            }
            this.aaLen = n;
        } else if (n != this.aaLen) {
            throw new IndexOutOfBoundsException("bad atom attribute length");
        }
    }

    void breakOutBondTokens(String string) {
        this.breakOutTokens(string);
        this.checkBondArrayLength(this.tokenCount);
    }

    void checkBondArrayLength(int n) {
        if (this.bondCount == 0) {
            if (n > this.bondArray.length) {
                this.bondArray = new Bond[n];
            }
            int n2 = n;
            while (--n2 >= 0) {
                this.bondArray[n2] = new Bond(-1, -1, 1);
            }
            this.bondCount = n;
        } else if (n != this.bondCount) {
            throw new IndexOutOfBoundsException("bad bond attribute length");
        }
    }

    private void createNewAtomSet() {
        String string;
        String string2;
        this.asc.newAtomSet();
        if (this.htModelAtomMap != null) {
            this.htModelAtomMap.put("" + this.asc.iSet, this.moleculeID);
        }
        String string3 = string2 = (string = (String)this.atts.get("title")) != null || (string = (String)this.atts.get("id")) != null ? string : null;
        if (string2 != null) {
            this.asc.setAtomSetName(string2);
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() {
        if (this.moduleNestingLevel > 0 || !this.haveMolecule || this.localSpaceGroupName == null) {
            return;
        }
        this.parent.setSpaceGroupName(this.localSpaceGroupName);
        this.parent.iHaveSymmetryOperators = this.iHaveSymmetryOperators;
        this.parent.applySymmetryAndSetTrajectory();
    }

    @Override
    public void endDocument() {
        if (this.deleteAtoms != null) {
            BS bS = this.asc.bsAtoms == null ? (this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac)) : this.asc.bsAtoms;
            bS.andNot(this.deleteAtoms);
        }
    }
}

