/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public abstract class SpartanInputReader
extends BasisFunctionReader {
    protected int modelAtomCount;
    protected String bondData = "";
    protected String constraints = "";

    protected String readInputRecords() throws Exception {
        String[] stringArray;
        int n = this.asc.ac;
        String string = this.readInputHeader();
        while (this.rd() != null && ((stringArray = this.getTokens()).length != 2 || this.parseIntStr(stringArray[0]) == Integer.MIN_VALUE || this.parseIntStr(stringArray[1]) < 0)) {
        }
        if (this.line == null) {
            return null;
        }
        this.readInputAtoms();
        this.discardLinesUntilContains("ATOMLABELS");
        if (this.line != null) {
            this.readAtomNames();
        }
        if (this.modelAtomCount > 1) {
            this.discardLinesUntilContains("HESSIAN");
            if (this.line != null) {
                this.readBonds(n);
            }
            if (this.line != null && this.line.indexOf("BEGINCONSTRAINTS") >= 0) {
                this.readConstraints();
            }
        }
        while (this.line != null && this.line.indexOf("END ") < 0 && this.line.indexOf("MOLSTATE") < 0) {
            this.rd();
        }
        if (this.line != null && this.line.indexOf("MOLSTATE") >= 0) {
            this.readTransform();
        }
        return string;
    }

    private void readConstraints() throws Exception {
        this.constraints = "";
        while (this.rd() != null && this.line.indexOf("END") < 0) {
            this.constraints = this.constraints + (this.constraints == "" ? "" : "\n") + this.line;
        }
        this.rd();
        if (this.constraints.length() == 0) {
            return;
        }
        this.asc.setCurrentModelInfo("constraints", this.constraints);
        this.asc.setAtomSetModelProperty(".PATH", "EnergyProfile");
        this.asc.setAtomSetModelProperty("Constraint", this.constraints);
    }

    private void readTransform() throws Exception {
        this.rd();
        String[] stringArray = PT.getTokens(this.rd() + " " + this.rd());
        this.setTransform(this.parseFloatStr(stringArray[0]), this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[4]), this.parseFloatStr(stringArray[5]), this.parseFloatStr(stringArray[6]), this.parseFloatStr(stringArray[8]), this.parseFloatStr(stringArray[9]), this.parseFloatStr(stringArray[10]));
    }

    private String readInputHeader() throws Exception {
        while (this.rd() != null && !this.line.startsWith(" ")) {
        }
        this.rd();
        return this.line.substring(0, (this.line + ";").indexOf(";")).trim();
    }

    private void readInputAtoms() throws Exception {
        this.modelAtomCount = 0;
        while (this.rd() != null && !this.line.startsWith("ENDCART")) {
            String[] stringArray = this.getTokens();
            this.addAtomXYZSymName(stringArray, 1, SpartanInputReader.getElementSymbol(this.parseIntStr(stringArray[0])), null);
            ++this.modelAtomCount;
        }
        if (this.debugging) {
            Logger.debug(this.asc.ac + " atoms read");
        }
    }

    private void readAtomNames() throws Exception {
        int n = this.asc.ac - this.modelAtomCount;
        for (int i = 0; i < this.modelAtomCount; ++i) {
            String string;
            this.line = this.rd().trim();
            this.asc.atoms[n + i].atomName = string = this.line.substring(1, this.line.length() - 1);
        }
    }

    private void readBonds(int n) throws Exception {
        int n2 = this.modelAtomCount;
        this.bondData = "";
        while (this.rd() != null && !this.line.startsWith("ENDHESS")) {
            String[] stringArray = this.getTokens();
            this.bondData = this.bondData + this.line + " ";
            if (n2 == 0) {
                int n3 = this.parseIntStr(stringArray[0]) - 1 + n;
                int n4 = this.parseIntStr(stringArray[1]) - 1 + n;
                int n5 = this.parseIntStr(stringArray[2]);
                if (n5 <= 0) continue;
                this.asc.addBond(new Bond(n3, n4, n5 < 4 ? n5 : (n5 == 5 ? 515 : 1)));
                continue;
            }
            n2 -= stringArray.length;
        }
        this.rd();
        if (this.debugging) {
            Logger.debug(this.asc.bondCount + " bonds read");
        }
    }
}

