/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import smile.sort.SortUtils;

public class IntHeapSelect {
    private int k;
    private int n;
    private boolean sorted;
    private int[] heap;

    public IntHeapSelect(int n) {
        this(new int[n]);
    }

    public IntHeapSelect(int[] nArray) {
        this.heap = nArray;
        this.k = nArray.length;
        this.n = 0;
        this.sorted = false;
    }

    public void add(int n) {
        this.sorted = false;
        if (this.n < this.k) {
            this.heap[this.n++] = n;
            if (this.n == this.k) {
                IntHeapSelect.heapify(this.heap);
            }
        } else {
            ++this.n;
            if (n < this.heap[0]) {
                this.heap[0] = n;
                SortUtils.siftDown(this.heap, 0, this.k - 1);
            }
        }
    }

    public int peek() {
        return this.heap[0];
    }

    public int get(int n) {
        if (n > Math.min(this.k, this.n) - 1) {
            throw new IllegalArgumentException("HeapSelect i is greater than the number of data received so far.");
        }
        if (n == this.k - 1) {
            return this.heap[0];
        }
        if (!this.sorted) {
            IntHeapSelect.sort(this.heap, Math.min(this.k, this.n));
            this.sorted = true;
        }
        return this.heap[this.k - 1 - n];
    }

    public void sort() {
        if (!this.sorted) {
            IntHeapSelect.sort(this.heap, Math.min(this.k, this.n));
            this.sorted = true;
        }
    }

    private static void heapify(int[] nArray) {
        int n = nArray.length;
        for (int i = n / 2 - 1; i >= 0; --i) {
            SortUtils.siftDown(nArray, i, n - 1);
        }
    }

    private static void sort(int[] nArray, int n) {
        int n2 = 1;
        do {
            n2 *= 3;
        } while (++n2 <= n);
        do {
            for (int i = n2 /= 3; i < n; ++i) {
                int n3 = nArray[i];
                int n4 = i;
                while (nArray[n4 - n2] < n3) {
                    nArray[n4] = nArray[n4 - n2];
                    if ((n4 -= n2) >= n2) continue;
                }
                nArray[n4] = n3;
            }
        } while (n2 > 1);
    }
}

