/*
 * Decompiled with CFR 0.152.
 */
package smile.math.random;

import smile.math.random.RandomNumberGenerator;

public class MersenneTwister
implements RandomNumberGenerator {
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MAGIC = new int[]{0, -1727483681};
    private static final int MAGIC_FACTOR1 = 1812433253;
    private static final int MAGIC_MASK1 = -1658038656;
    private static final int MAGIC_MASK2 = -272236544;
    private static final int MAGIC_SEED = 19650218;
    private transient int[] mt = new int[624];
    private transient int mti;

    public MersenneTwister() {
        this(19650218);
    }

    public MersenneTwister(int n) {
        this.setSeed(n);
    }

    public MersenneTwister(long l) {
        this.setSeed(l);
    }

    @Override
    public void setSeed(long l) {
        this.setSeed((int)(l % 899999963L));
    }

    public void setSeed(int n) {
        this.mt[0] = n;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            ++this.mti;
        }
    }

    @Override
    public int next(int n) {
        return this.nextInt() >>> 32 - n;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextInt() >>> 1) / 2.147483647E9;
    }

    @Override
    public void nextDoubles(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.nextDouble();
        }
    }

    @Override
    public int nextInt() {
        int n;
        if (this.mti >= 624) {
            int n2;
            for (n2 = 0; n2 < 227; ++n2) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ MAGIC[n & 1];
            }
            while (n2 < 623) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ MAGIC[n & 1];
                ++n2;
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ MAGIC[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return n;
    }

    @Override
    public int nextInt(int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((n3 = this.next(31)) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    @Override
    public long nextLong() {
        long l = this.nextInt();
        return l << 32 | (long)this.nextInt();
    }
}

