/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.io.Serializable;
import java.lang.reflect.Method;
import smile.math.Math;
import smile.math.matrix.ATA;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Factory;
import smile.math.matrix.Lanczos;
import smile.math.matrix.SVD;
import smile.stat.distribution.GaussianDistribution;

public interface Matrix
extends Serializable {
    public static DenseMatrix newInstance(double[][] dArray) {
        return Factory.matrix(dArray);
    }

    public static DenseMatrix newInstance(double[] dArray) {
        return Factory.matrix(dArray);
    }

    public static DenseMatrix newInstance(int n, int n2, double d) {
        return Factory.matrix(n, n2, d);
    }

    public static DenseMatrix zeros(int n, int n2) {
        return Factory.matrix(n, n2);
    }

    public static DenseMatrix ones(int n, int n2) {
        return Factory.matrix(n, n2, 1.0);
    }

    public static DenseMatrix eye(int n) {
        DenseMatrix denseMatrix = Factory.matrix(n, n);
        for (int i = 0; i < n; ++i) {
            denseMatrix.set(i, i, 1.0);
        }
        return denseMatrix;
    }

    public static DenseMatrix eye(int n, int n2) {
        DenseMatrix denseMatrix = Factory.matrix(n, n2);
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            denseMatrix.set(i, i, 1.0);
        }
        return denseMatrix;
    }

    public static DenseMatrix diag(double[] dArray) {
        int n = dArray.length;
        DenseMatrix denseMatrix = Factory.matrix(n, n);
        for (int i = 0; i < n; ++i) {
            denseMatrix.set(i, i, dArray[i]);
        }
        return denseMatrix;
    }

    public static DenseMatrix randn(int n, int n2) {
        return Matrix.randn(n, n2, 0.0, 1.0);
    }

    public static DenseMatrix randn(int n, int n2, double d, double d2) {
        DenseMatrix denseMatrix = Matrix.zeros(n, n2);
        GaussianDistribution gaussianDistribution = new GaussianDistribution(d, d2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix.set(j, i, gaussianDistribution.rand());
            }
        }
        return denseMatrix;
    }

    default public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = bl ? this.nrows() : Math.min(7, this.nrows());
        int n2 = bl ? this.ncols() : Math.min(7, this.ncols());
        String string = n2 < this.ncols() ? "...\n" : "\n";
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append(String.format("%8.4f  ", this.get(i, j)));
            }
            stringBuilder.append(string);
        }
        if (n < this.nrows()) {
            stringBuilder.append("  ...\n");
        }
        return stringBuilder.toString();
    }

    default public boolean isSymmetric() {
        return false;
    }

    default public void setSymmetric(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public int nrows();

    public int ncols();

    public Matrix transpose();

    public double get(int var1, int var2);

    default public double apply(int n, int n2) {
        return this.get(n, n2);
    }

    default public double[] diag() {
        int n = Math.min(this.nrows(), this.ncols());
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.get(i, i);
        }
        return dArray;
    }

    default public double trace() {
        int n = Math.min(this.nrows(), this.ncols());
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.get(i, i);
        }
        return d;
    }

    public Matrix ata();

    public Matrix aat();

    public double[] ax(double[] var1, double[] var2);

    public double[] axpy(double[] var1, double[] var2);

    public double[] axpy(double[] var1, double[] var2, double var3);

    public double[] atx(double[] var1, double[] var2);

    public double[] atxpy(double[] var1, double[] var2);

    public double[] atxpy(double[] var1, double[] var2, double var3);

    default public EVD eigen(int n) {
        return this.eigen(n, 1.0E-8, 10 * this.nrows());
    }

    default public EVD eigen(int n, double d, int n2) {
        try {
            Class<?> clazz = Class.forName("smile.netlib.ARPACK");
            Method method = clazz.getMethod("eigen", Matrix.class, Integer.TYPE, String.class, Double.TYPE, Integer.TYPE);
            return (EVD)method.invoke(null, this, n, "LA", d, n2);
        }
        catch (Exception exception) {
            if (!(exception instanceof ClassNotFoundException)) {
                System.out.println("Matrix.eigen(" + n + ", " + d + ", " + n2 + "):" + exception);
            }
            return Lanczos.eigen(this, n, d, n2);
        }
    }

    default public SVD svd(int n) {
        return this.svd(n, 1.0E-8, 10 * this.nrows());
    }

    default public SVD svd(int n, double d, int n2) {
        int n3;
        int n4;
        ATA aTA = new ATA(this);
        EVD eVD = Lanczos.eigen(aTA, n, d, n2);
        double[] dArray = eVD.getEigenValues();
        for (n4 = 0; n4 < dArray.length; ++n4) {
            dArray[n4] = Math.sqrt(dArray[n4]);
        }
        n4 = this.nrows();
        if (n4 >= (n3 = this.ncols())) {
            DenseMatrix denseMatrix = eVD.getEigenVectors();
            double[] dArray2 = new double[n4];
            double[] dArray3 = new double[n3];
            DenseMatrix denseMatrix2 = Matrix.zeros(n4, dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                int n5;
                for (n5 = 0; n5 < n3; ++n5) {
                    dArray3[n5] = denseMatrix.get(n5, i);
                }
                this.ax(dArray3, dArray2);
                for (n5 = 0; n5 < n4; ++n5) {
                    denseMatrix2.set(n5, i, dArray2[n5] / dArray[i]);
                }
            }
            return new SVD(denseMatrix2, denseMatrix, dArray);
        }
        DenseMatrix denseMatrix = eVD.getEigenVectors();
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n4];
        DenseMatrix denseMatrix3 = Matrix.zeros(n3, dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                dArray5[n6] = denseMatrix.get(n6, i);
            }
            this.atx(dArray5, dArray4);
            for (n6 = 0; n6 < n3; ++n6) {
                denseMatrix3.set(n6, i, dArray4[n6] / dArray[i]);
            }
        }
        return new SVD(denseMatrix, denseMatrix3, dArray);
    }
}

