/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.io.Serializable;
import smile.math.Math;

public class Complex
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double re;
    private final double im;

    public Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public String toString() {
        if (this.im == 0.0) {
            return String.format("%.4f", this.re);
        }
        if (this.re == 0.0) {
            return String.format("%.4fi", this.im);
        }
        if (this.im < 0.0) {
            return String.format("%.4f - %.4fi", this.re, -this.im);
        }
        return String.format("%.4f + %.4fi", this.re, this.im);
    }

    public boolean equals(Object object) {
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            if (this.re == complex.re && this.im == complex.im) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 47 * n + (int)(Double.doubleToLongBits(this.re) ^ Double.doubleToLongBits(this.re) >>> 32);
        n = 47 * n + (int)(Double.doubleToLongBits(this.im) ^ Double.doubleToLongBits(this.im) >>> 32);
        return n;
    }

    public double abs() {
        return Math.hypot(this.re, this.im);
    }

    public double phase() {
        return Math.atan2(this.im, this.re);
    }

    public Complex plus(Complex complex) {
        Complex complex2 = this;
        double d = complex2.re + complex.re;
        double d2 = complex2.im + complex.im;
        return new Complex(d, d2);
    }

    public Complex minus(Complex complex) {
        Complex complex2 = this;
        double d = complex2.re - complex.re;
        double d2 = complex2.im - complex.im;
        return new Complex(d, d2);
    }

    public Complex times(Complex complex) {
        Complex complex2 = this;
        double d = complex2.re * complex.re - complex2.im * complex.im;
        double d2 = complex2.re * complex.im + complex2.im * complex.re;
        return new Complex(d, d2);
    }

    public Complex times(double d) {
        return new Complex(d * this.re, d * this.im);
    }

    public Complex div(Complex complex) {
        double d;
        double d2;
        if (Math.abs(complex.re) > Math.abs(complex.im)) {
            double d3 = complex.im / complex.re;
            double d4 = complex.re + d3 * complex.im;
            d2 = (this.re + d3 * this.im) / d4;
            d = (this.im - d3 * this.re) / d4;
        } else {
            double d5 = complex.re / complex.im;
            double d6 = complex.im + d5 * complex.re;
            d2 = (d5 * this.re + this.im) / d6;
            d = (d5 * this.im - this.re) / d6;
        }
        return new Complex(d2, d);
    }

    public Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    public Complex reciprocal() {
        double d = this.re * this.re + this.im * this.im;
        return new Complex(this.re / d, -this.im / d);
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public Complex exp() {
        return new Complex(Math.exp(this.re) * Math.cos(this.im), Math.exp(this.re) * Math.sin(this.im));
    }

    public Complex sin() {
        return new Complex(Math.sin(this.re) * Math.cosh(this.im), Math.cos(this.re) * Math.sinh(this.im));
    }

    public Complex cos() {
        return new Complex(Math.cos(this.re) * Math.cosh(this.im), -Math.sin(this.re) * Math.sinh(this.im));
    }

    public Complex tan() {
        return this.sin().div(this.cos());
    }
}

