/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.V3d;

class Slice {
    final P4d leftPlane = new P4d();
    final P4d middle = new P4d();
    final P4d rightPlane = new P4d();
    double angleXY;
    double anglefromZ;
    double position;
    double thickness;
    final P3d boundBoxNegCorner = new P3d();
    final P3d boundBoxPosCorner = new P3d();
    final P3d boundBoxCenter = new P3d();
    double diagonal;

    Slice() {
    }

    static void makePlane(double length, double angleXY, double anglefromZ, P4d result) {
        result.set4(Math.cos(angleXY) * Math.sin(anglefromZ), Math.sin(angleXY) * Math.sin(anglefromZ), Math.cos(anglefromZ), -length);
    }

    void setSlice(double angleXY, double anglefromZ, double position, double thickness, P3d boundBoxCenter, V3d boundBoxVec, boolean useMolecular) {
        double fix;
        if (angleXY >= 0.0 && angleXY < Math.PI) {
            this.angleXY = angleXY;
        } else {
            fix = Math.floor(angleXY / Math.PI);
            this.angleXY = angleXY - fix * Math.PI;
        }
        if (anglefromZ >= 0.0 && anglefromZ < Math.PI) {
            this.anglefromZ = anglefromZ;
        } else {
            fix = Math.floor(anglefromZ / Math.PI);
            this.anglefromZ = anglefromZ - fix * Math.PI;
        }
        this.position = position;
        this.thickness = thickness;
        this.boundBoxCenter.setT(boundBoxCenter);
        this.boundBoxNegCorner.sub2(boundBoxCenter, boundBoxVec);
        this.boundBoxPosCorner.add2(boundBoxCenter, boundBoxVec);
        this.diagonal = this.boundBoxPosCorner.distance(this.boundBoxNegCorner);
        Slice.makePlane(position, angleXY, anglefromZ, this.middle);
        if (!useMolecular) {
            P3d pt = P3d.new3(this.middle.x, this.middle.y, this.middle.z);
            pt.scaleAdd2(-this.middle.w, pt, boundBoxCenter);
            MeasureD.getPlaneThroughPoint(pt, V3d.new3(this.middle.x, this.middle.y, this.middle.z), this.middle);
        }
        this.leftPlane.set4(this.middle.x, this.middle.y, this.middle.z, this.middle.w);
        this.leftPlane.w += thickness / 2.0;
        this.rightPlane.set4(this.middle.x, this.middle.y, this.middle.z, this.middle.w);
        this.rightPlane.w -= thickness / 2.0;
        System.out.println(thickness + " left:" + this.leftPlane + " right:" + this.rightPlane);
    }

    Slice getSlice() {
        return this;
    }

    P4d getMiddle() {
        return this.middle;
    }
}

