/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.so;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.BondAngleSet;
import com.actelion.research.chem.conf.BondLengthSet;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.VDWRadii;
import com.actelion.research.util.DoubleFormat;
import java.util.ArrayList;
import org.openmolecules.chem.conf.so.ConformationRule;

public class DistanceRule
extends ConformationRule {
    private static final double VDW_TOLERANCE = 0.85;
    private static final int PRIORITY_ONE_BOND = 10;
    private static final int PRIORITY_TWO_BONDS = 5;
    private static final int PRIORITY_THREE_BONDS = 3;
    private double[] mDistance;
    private int[] mNotList;
    private int mPriority;

    public DistanceRule() {
        super(null);
    }

    public DistanceRule(int[] nArray, int[] nArray2, double d, int n) {
        super(nArray);
        this.mDistance = new double[1];
        this.mDistance[0] = d;
        this.mNotList = nArray2;
        this.mPriority = n;
    }

    public DistanceRule(int[] nArray, double d, double d2, int n) {
        super(nArray);
        this.mDistance = new double[2];
        this.mDistance[0] = d;
        this.mDistance[1] = d2;
        this.mPriority = n;
    }

    public DistanceRule(int[] nArray, int[] nArray2, double d, double d2, int n) {
        super(nArray);
        this.mDistance = new double[2];
        this.mDistance[0] = d;
        this.mDistance[1] = d2;
        this.mNotList = nArray2;
        this.mPriority = n;
    }

    @Override
    public int getRuleType() {
        return 0;
    }

    public boolean isFixedDistance() {
        return this.mDistance.length == 1;
    }

    public static void calculateRules(ArrayList<ConformationRule> arrayList, StereoMolecule stereoMolecule) {
        double d;
        double d2;
        double d3;
        int n;
        int n2;
        int n3;
        int n4;
        BondLengthSet bondLengthSet = new BondLengthSet(stereoMolecule);
        BondAngleSet bondAngleSet = new BondAngleSet(stereoMolecule, bondLengthSet);
        DistanceRule[][] distanceRuleArray = new DistanceRule[stereoMolecule.getAllAtoms()][];
        for (n4 = 1; n4 < stereoMolecule.getAllAtoms(); ++n4) {
            distanceRuleArray[n4] = new DistanceRule[n4];
        }
        for (n4 = 0; n4 < stereoMolecule.getAllBonds(); ++n4) {
            int[] nArray = DistanceRule.combineAtoms(stereoMolecule.getBondAtom(0, n4), stereoMolecule.getBondAtom(1, n4));
            DistanceRule.setFixedDistance(distanceRuleArray, nArray, nArray, bondLengthSet.getLength(n4), 10);
        }
        for (n4 = 0; n4 < stereoMolecule.getAtoms(); ++n4) {
            for (int i = 1; i < stereoMolecule.getAllConnAtoms(n4); ++i) {
                int n5 = stereoMolecule.getConnAtom(n4, i);
                int n6 = stereoMolecule.getConnBond(n4, i);
                double d4 = bondLengthSet.getLength(n6);
                for (n3 = 0; n3 < i; ++n3) {
                    n2 = stereoMolecule.getConnAtom(n4, n3);
                    n = stereoMolecule.getConnBond(n4, n3);
                    d3 = bondAngleSet.getConnAngle(n4, i, n3);
                    d2 = bondLengthSet.getLength(n);
                    d = Math.sqrt(d4 * d4 + d2 * d2 - 2.0 * d4 * d2 * Math.cos(d3));
                    int[] nArray = new int[]{n4};
                    DistanceRule.setFixedDistance(distanceRuleArray, DistanceRule.combineAtoms(n5, n2), nArray, d, 5);
                }
            }
        }
        for (n4 = 0; n4 < stereoMolecule.getAllBonds(); ++n4) {
            int n7;
            Object object;
            if (stereoMolecule.isAromaticBond(n4) || stereoMolecule.isRingBond(n4) && stereoMolecule.getBondRingSize(n4) <= 5) continue;
            int[] nArray = new int[2];
            for (int i = 0; i < 2; ++i) {
                nArray[i] = stereoMolecule.getBondAtom(i, n4);
            }
            if (stereoMolecule.getAllConnAtoms(nArray[0]) <= 1 || stereoMolecule.getAllConnAtoms(nArray[1]) <= 1) continue;
            if (stereoMolecule.getBondOrder(n4) == 3) {
                double d5 = bondLengthSet.getLength(n4);
                object = new int[2];
                block7: for (int i = 0; i < 2; ++i) {
                    for (n3 = 0; n3 < stereoMolecule.getAllConnAtoms(nArray[i]); ++n3) {
                        n2 = stereoMolecule.getConnBond(nArray[i], n3);
                        if (n2 == n4) continue;
                        d5 += (double)bondLengthSet.getLength(n2);
                        object[i] = stereoMolecule.getConnAtom(nArray[i], n3);
                        continue block7;
                    }
                }
                int[] nArray2 = new int[]{nArray[0], nArray[1]};
                DistanceRule.setFixedDistance(distanceRuleArray, DistanceRule.combineAtoms(object[0], object[1]), nArray2, d5, 3);
                continue;
            }
            if (stereoMolecule.getBondOrder(n4) == 2 && stereoMolecule.getAtomPi(nArray[0]) == 1 && stereoMolecule.getAtomPi(nArray[1]) == 1 && stereoMolecule.getBondParity(n4) != 3) {
                int n8;
                int[][] nArrayArray = new int[2][];
                int[][] nArrayArray2 = new int[2][];
                object = new double[2][];
                for (n8 = 0; n8 < 2; ++n8) {
                    nArrayArray[n8] = new int[stereoMolecule.getAllConnAtoms(nArray[n8]) - 1];
                    nArrayArray2[n8] = new int[stereoMolecule.getAllConnAtoms(nArray[n8]) - 1];
                    object[n8] = (int)new double[stereoMolecule.getAllConnAtoms(nArray[n8]) - 1];
                    n3 = -1;
                    for (n2 = 0; n2 < stereoMolecule.getAllConnAtoms(nArray[n8]); ++n2) {
                        if (stereoMolecule.getConnAtom(nArray[n8], n2) != nArray[1 - n8]) continue;
                        n3 = n2;
                        break;
                    }
                    n2 = 0;
                    for (n = 0; n < stereoMolecule.getAllConnAtoms(nArray[n8]); ++n) {
                        if (n == n3) continue;
                        nArrayArray[n8][n2] = stereoMolecule.getConnAtom(nArray[n8], n);
                        nArrayArray2[n8][n2] = stereoMolecule.getConnBond(nArray[n8], n);
                        object[n8][n2] = bondAngleSet.getConnAngle(nArray[n8], n3, n);
                        ++n2;
                    }
                }
                for (n8 = 0; n8 < nArrayArray[0].length; ++n8) {
                    for (n3 = 0; n3 < nArrayArray[1].length; ++n3) {
                        int n9 = n2 = stereoMolecule.getBondParity(n4) == 1 ? 1 : 0;
                        if (nArrayArray[0].length == 2 && nArrayArray[0][n8] > nArrayArray[0][1 - n8]) {
                            int n10 = n2 = n2 == 0 ? 1 : 0;
                        }
                        if (nArrayArray[1].length == 2 && nArrayArray[1][n3] > nArrayArray[1][1 - n3]) {
                            n2 = n2 == 0 ? 1 : 0;
                        }
                        DistanceRule.setDoubleBondDistance(nArrayArray[0][n8], nArrayArray[1][n3], nArrayArray2[0][n8], nArrayArray2[1][n3], (double)object[0][n8], (double)object[1][n3], n4, n2 != 0, bondLengthSet, distanceRuleArray, stereoMolecule);
                    }
                }
                continue;
            }
            if (stereoMolecule.getBondOrder(n4) == 0) continue;
            int[] nArray3 = new int[2];
            block14: for (n7 = 0; n7 < 2; ++n7) {
                for (int i = 0; i < stereoMolecule.getAllConnAtoms(nArray[n7]); ++i) {
                    if (stereoMolecule.getConnAtom(nArray[n7], i) != nArray[1 - n7]) continue;
                    nArray3[n7] = i;
                    continue block14;
                }
            }
            for (n7 = 0; n7 < stereoMolecule.getAllConnAtoms(nArray[0]); ++n7) {
                if (n7 == nArray3[0]) continue;
                for (int i = 0; i < stereoMolecule.getAllConnAtoms(nArray[1]); ++i) {
                    if (i == nArray3[1]) continue;
                    if (stereoMolecule.getAtomPi(nArray[0]) == 0 && stereoMolecule.getAtomPi(nArray[1]) == 0) {
                        DistanceRule.setSingleBondConnAtomDistance(stereoMolecule.getConnAtom(nArray[0], n7), stereoMolecule.getConnAtom(nArray[1], i), stereoMolecule.getConnBond(nArray[0], n7), stereoMolecule.getConnBond(nArray[1], i), bondAngleSet.getConnAngle(nArray[0], nArray3[0], n7), bondAngleSet.getConnAngle(nArray[1], nArray3[1], i), n4, bondLengthSet, distanceRuleArray, stereoMolecule);
                        continue;
                    }
                    DistanceRule.setAnyBondConnAtomDistance(stereoMolecule.getConnAtom(nArray[0], n7), stereoMolecule.getConnAtom(nArray[1], i), stereoMolecule.getConnBond(nArray[0], n7), stereoMolecule.getConnBond(nArray[1], i), bondAngleSet.getConnAngle(nArray[0], nArray3[0], n7), bondAngleSet.getConnAngle(nArray[1], nArray3[1], i), n4, bondLengthSet, distanceRuleArray, stereoMolecule);
                }
            }
        }
        for (n4 = 0; n4 < stereoMolecule.getAtoms(); ++n4) {
            if (stereoMolecule.getAtomPi(n4) != 2 || stereoMolecule.getConnAtoms(n4) != 2 || stereoMolecule.getConnBondOrder(n4, 0) != 2 || stereoMolecule.getConnBondOrder(n4, 1) != 2) continue;
            int n11 = stereoMolecule.getConnAtom(n4, 0);
            int n12 = stereoMolecule.getConnAtom(n4, 1);
            for (int i = 0; i < stereoMolecule.getAllConnAtoms(n11); ++i) {
                int n13 = stereoMolecule.getConnAtom(n11, i);
                if (n13 == n4) continue;
                for (int j = 0; j < stereoMolecule.getAllConnAtoms(n12); ++j) {
                    n3 = stereoMolecule.getConnAtom(n12, j);
                    if (n3 == n4) continue;
                    double d6 = bondAngleSet.getAngle(n11, n4, n13);
                    d3 = bondAngleSet.getAngle(n12, n4, n3);
                    d2 = bondLengthSet.getLength(stereoMolecule.getConnBond(n11, i));
                    d = bondLengthSet.getLength(stereoMolecule.getConnBond(n12, j));
                    double d7 = (double)(bondLengthSet.getLength(stereoMolecule.getConnBond(n4, 0)) + bondLengthSet.getLength(stereoMolecule.getConnBond(n4, 1))) - d2 * Math.cos(d6) - d * Math.cos(d3);
                    double d8 = d2 * Math.sin(d6);
                    double d9 = d * Math.sin(d3);
                    int[] nArray = new int[]{n11, n12};
                    DistanceRule.setFixedDistance(distanceRuleArray, DistanceRule.combineAtoms(n13, n3), nArray, Math.sqrt(d7 * d7 + d8 * d8 + d9 * d9), 3);
                }
            }
        }
        for (n4 = 0; n4 < stereoMolecule.getAllAtoms(); ++n4) {
            DistanceRule.calculateLongDistanceRules(distanceRuleArray, n4, stereoMolecule, bondLengthSet);
        }
        DistanceRule.calculateDisconnectedDistanceRules(distanceRuleArray, stereoMolecule);
        for (n4 = 1; n4 < stereoMolecule.getAllAtoms(); ++n4) {
            for (int i = 0; i < n4; ++i) {
                if (distanceRuleArray[n4][i].mDistance == null) continue;
                arrayList.add(distanceRuleArray[n4][i]);
            }
        }
    }

    private static void calculateLongDistanceRules(DistanceRule[][] distanceRuleArray, int n, StereoMolecule stereoMolecule, BondLengthSet bondLengthSet) {
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        int[] nArray2 = new int[stereoMolecule.getAllAtoms()];
        double[] dArray = new double[stereoMolecule.getAllAtoms()];
        nArray2[0] = n;
        int n2 = 0;
        for (int i = 0; i <= n2; ++i) {
            int n3 = nArray2[i];
            for (int j = 0; j < stereoMolecule.getAllConnAtoms(n3); ++j) {
                int n4 = stereoMolecule.getConnAtom(n3, j);
                if (nArray[n4] != 0 || n4 == n) continue;
                nArray2[++n2] = n4;
                nArray[n4] = nArray[n3] + 1;
                if (nArray[n4] == 2) {
                    dArray[n4] = n4 < n ? distanceRuleArray[n][n4].mDistance[0] : distanceRuleArray[n4][n].mDistance[0];
                    continue;
                }
                if (nArray[n4] <= 2) continue;
                dArray[n4] = dArray[n3] + (double)bondLengthSet.getLength(stereoMolecule.getConnBond(n3, j));
                if (n4 >= n || distanceRuleArray[n][n4] != null) continue;
                if (nArray[n4] == 3) {
                    distanceRuleArray[n][n4] = new DistanceRule();
                    continue;
                }
                int[] nArray3 = new int[]{nArray2[1], n3};
                distanceRuleArray[n][n4] = new DistanceRule(DistanceRule.combineAtoms(n, n4), nArray3, DistanceRule.getVDWRadius(n, stereoMolecule) + DistanceRule.getVDWRadius(n4, stereoMolecule), dArray[n4], 0);
                distanceRuleArray[n][n4].mDistance[0] = distanceRuleArray[n][n4].mDistance[0] * 0.85;
            }
        }
    }

    private static void calculateDisconnectedDistanceRules(DistanceRule[][] distanceRuleArray, StereoMolecule stereoMolecule) {
        for (int i = 1; i < stereoMolecule.getAllAtoms(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (distanceRuleArray[i][j] != null) continue;
                distanceRuleArray[i][j] = new DistanceRule(DistanceRule.combineAtoms(i, j), DistanceRule.getVDWRadius(i, stereoMolecule) + DistanceRule.getVDWRadius(j, stereoMolecule), Double.MAX_VALUE, -1);
            }
        }
    }

    private static double getVDWRadius(int n, StereoMolecule stereoMolecule) {
        int n2 = stereoMolecule.getAtomicNo(n);
        return n2 < VDWRadii.VDW_RADIUS.length ? (double)VDWRadii.VDW_RADIUS[n2] : 2.0;
    }

    private static void setDoubleBondDistance(int n, int n2, int n3, int n4, double d, double d2, int n5, boolean bl, BondLengthSet bondLengthSet, DistanceRule[][] distanceRuleArray, StereoMolecule stereoMolecule) {
        double d3 = (double)bondLengthSet.getLength(n5) - (double)bondLengthSet.getLength(n3) * Math.cos(d) - (double)bondLengthSet.getLength(n4) * Math.cos(d2);
        double d4 = (double)bondLengthSet.getLength(n3) * Math.sin(d);
        d4 = bl ? (d4 += (double)bondLengthSet.getLength(n4) * Math.sin(d2)) : (d4 -= (double)bondLengthSet.getLength(n4) * Math.sin(d2));
        int[] nArray = new int[]{stereoMolecule.getBondAtom(0, n5), stereoMolecule.getBondAtom(1, n5)};
        DistanceRule.setFixedDistance(distanceRuleArray, DistanceRule.combineAtoms(n, n2), nArray, Math.sqrt(d3 * d3 + d4 * d4), 3);
    }

    private static void setSingleBondConnAtomDistance(int n, int n2, int n3, int n4, double d, double d2, int n5, BondLengthSet bondLengthSet, DistanceRule[][] distanceRuleArray, StereoMolecule stereoMolecule) {
        int n6;
        if (n == n2) {
            return;
        }
        int[] nArray = DistanceRule.combineAtoms(n, n2);
        if (distanceRuleArray[nArray[0]][nArray[1]] != null && distanceRuleArray[nArray[0]][nArray[1]].isFixedDistance()) {
            return;
        }
        double d3 = 0.866;
        double d4 = 0.5;
        if (stereoMolecule.isRingBond(n5) && (n6 = stereoMolecule.getBondRingSize(n5)) < 6) {
            d3 = 0.0;
            d4 = 1.0;
        }
        double d5 = (double)bondLengthSet.getLength(n5) - (double)bondLengthSet.getLength(n3) * Math.cos(d) - (double)bondLengthSet.getLength(n4) * Math.cos(d2);
        double d6 = (double)bondLengthSet.getLength(n3) * Math.sin(d);
        double d7 = (double)bondLengthSet.getLength(n4) * Math.sin(d2);
        double d8 = d6 + d7;
        double d9 = d6 - d7 * d4;
        double d10 = d7 * d3;
        double d11 = Math.sqrt(d5 * d5 + d9 * d9 + d10 * d10);
        double d12 = Math.sqrt(d5 * d5 + d8 * d8);
        int[] nArray2 = new int[]{stereoMolecule.getBondAtom(0, n5), stereoMolecule.getBondAtom(1, n5)};
        DistanceRule distanceRule = distanceRuleArray[nArray[0]][nArray[1]];
        if (distanceRule == null) {
            distanceRuleArray[nArray[0]][nArray[1]] = new DistanceRule(nArray, nArray2, d11, d12, 3);
        } else {
            distanceRule.mDistance[0] = Math.min(distanceRule.mDistance[0], d11);
            distanceRule.mDistance[1] = Math.min(distanceRule.mDistance[1], d12);
        }
    }

    private static void setAnyBondConnAtomDistance(int n, int n2, int n3, int n4, double d, double d2, int n5, BondLengthSet bondLengthSet, DistanceRule[][] distanceRuleArray, StereoMolecule stereoMolecule) {
        if (n == n2) {
            return;
        }
        int[] nArray = DistanceRule.combineAtoms(n, n2);
        if (distanceRuleArray[nArray[0]][nArray[1]] != null && distanceRuleArray[nArray[0]][nArray[1]].isFixedDistance()) {
            return;
        }
        double d3 = (double)bondLengthSet.getLength(n5) - (double)bondLengthSet.getLength(n3) * Math.cos(d) - (double)bondLengthSet.getLength(n4) * Math.cos(d2);
        double d4 = (double)bondLengthSet.getLength(n3) * Math.sin(d);
        double d5 = (double)bondLengthSet.getLength(n4) * Math.sin(d2);
        double d6 = d4 + d5;
        double d7 = d4 - d5;
        double d8 = Math.sqrt(d3 * d3 + d7 * d7);
        double d9 = Math.sqrt(d3 * d3 + d6 * d6);
        int[] nArray2 = new int[]{stereoMolecule.getBondAtom(0, n5), stereoMolecule.getBondAtom(1, n5)};
        DistanceRule distanceRule = distanceRuleArray[nArray[0]][nArray[1]];
        if (distanceRule == null) {
            distanceRuleArray[nArray[0]][nArray[1]] = new DistanceRule(nArray, nArray2, d8, d9, 3);
        } else {
            distanceRule.mDistance[0] = Math.min(distanceRule.mDistance[0], d8);
            distanceRule.mDistance[1] = Math.min(distanceRule.mDistance[1], d9);
        }
    }

    private static void setFixedDistance(DistanceRule[][] distanceRuleArray, int[] nArray, int[] nArray2, double d, int n) {
        if (distanceRuleArray[nArray[0]][nArray[1]] == null) {
            distanceRuleArray[nArray[0]][nArray[1]] = new DistanceRule(nArray, nArray2, d, n);
        } else if (distanceRuleArray[nArray[0]][nArray[1]].mDistance.length == 2 || distanceRuleArray[nArray[0]][nArray[1]].mPriority < n) {
            distanceRuleArray[nArray[0]][nArray[1]] = new DistanceRule(nArray, nArray2, d, n);
        } else if (distanceRuleArray[nArray[0]][nArray[1]].mPriority == n) {
            distanceRuleArray[nArray[0]][nArray[1]].mDistance[0] = (distanceRuleArray[nArray[0]][nArray[1]].mDistance[0] + d) / 2.0;
            distanceRuleArray[nArray[0]][nArray[1]].mNotList = DistanceRule.mergeNotLists(distanceRuleArray[nArray[0]][nArray[1]].mNotList, nArray2);
        }
    }

    private static final int[] mergeNotLists(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2;
        }
        if (nArray2 == null) {
            return nArray;
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        int n = 0;
        for (int n2 : nArray) {
            nArray3[n++] = n2;
        }
        for (int n2 : nArray2) {
            nArray3[n++] = n2;
        }
        return nArray3;
    }

    private static int[] combineAtoms(int n, int n2) {
        int[] nArray = new int[2];
        if (n > n2) {
            nArray[0] = n;
            nArray[1] = n2;
        } else {
            nArray[0] = n2;
            nArray[1] = n;
        }
        return nArray;
    }

    private static int[] calculateBondRingSizes(StereoMolecule stereoMolecule) {
        int[] nArray = new int[stereoMolecule.getBonds()];
        RingCollection ringCollection = stereoMolecule.getRingSet();
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            int[] nArray2 = ringCollection.getRingBonds(i);
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[nArray2[j]] != 0 && nArray[nArray2[j]] <= nArray2.length) continue;
                nArray[nArray2[j]] = nArray2.length;
            }
        }
        return nArray;
    }

    @Override
    public boolean apply(Conformer conformer, double d) {
        double d2 = conformer.getX(this.mAtom[1]) - conformer.getX(this.mAtom[0]);
        double d3 = conformer.getY(this.mAtom[1]) - conformer.getY(this.mAtom[0]);
        double d4 = conformer.getZ(this.mAtom[1]) - conformer.getZ(this.mAtom[0]);
        double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        double d6 = 0.0;
        if (this.mDistance.length == 2) {
            if (d5 < this.mDistance[0]) {
                d6 = (d5 - this.mDistance[0]) / d5;
            } else if (d5 > this.mDistance[1]) {
                d6 = (d5 - this.mDistance[1]) / d5;
            }
        } else if (d5 < this.mDistance[0]) {
            d6 = (d5 - this.mDistance[0]) / d5;
        } else if (d5 > this.mDistance[0]) {
            d6 = (d5 - this.mDistance[0]) / d5;
        }
        if (Math.abs(d6) < 0.001) {
            return false;
        }
        double d7 = d * d6;
        StereoMolecule stereoMolecule = conformer.getMolecule();
        if (this.mPriority == 10) {
            if (stereoMolecule.getAllConnAtoms(this.mAtom[0]) == 1 && stereoMolecule.getAllConnAtoms(this.mAtom[1]) != 1) {
                conformer.getCoordinates(this.mAtom[0]).add(d2 * d7, d3 * d7, d4 * d7);
                return true;
            }
            if (stereoMolecule.getAllConnAtoms(this.mAtom[0]) != 1 && stereoMolecule.getAllConnAtoms(this.mAtom[1]) == 1) {
                conformer.getCoordinates(this.mAtom[1]).add(-d2 * d7, -d3 * d7, -d4 * d7);
                return true;
            }
        }
        this.moveGroup(conformer, this.mAtom[0], this.mNotList, d2 * (d7 /= 2.0), d3 * d7, d4 * d7);
        this.moveGroup(conformer, this.mAtom[1], this.mNotList, -d2 * d7, -d3 * d7, -d4 * d7);
        return true;
    }

    @Override
    public double addStrain(Conformer conformer, double[] dArray) {
        double d = conformer.getCoordinates(this.mAtom[1]).distance(conformer.getCoordinates(this.mAtom[0]));
        double d2 = 0.0;
        if (this.mDistance.length == 2) {
            if (d < this.mDistance[0]) {
                double d3 = (this.mDistance[0] - d) / 2.0;
                double d4 = d3 * d3;
                int n = this.mAtom[0];
                dArray[n] = dArray[n] + d4;
                int n2 = this.mAtom[1];
                dArray[n2] = dArray[n2] + d4;
                d2 += 2.0 * d4;
            } else if (d > this.mDistance[1]) {
                double d5 = (d - this.mDistance[1]) / 2.0;
                double d6 = d5 * d5;
                int n = this.mAtom[0];
                dArray[n] = dArray[n] + d6;
                int n3 = this.mAtom[1];
                dArray[n3] = dArray[n3] + d6;
                d2 += 2.0 * d6;
            }
        } else {
            double d7 = (d - this.mDistance[0]) / 2.0;
            if (Math.abs(d7) > (double)0.005f) {
                double d8 = d7 * d7;
                int n = this.mAtom[0];
                dArray[n] = dArray[n] + d8;
                int n4 = this.mAtom[1];
                dArray[n4] = dArray[n4] + d8;
                d2 += 2.0 * d8;
            }
        }
        return d2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("distance rule:");
        super.addAtomList(stringBuilder);
        if (this.mDistance.length == 1) {
            stringBuilder.append(" distance:" + DoubleFormat.toString(this.mDistance[0]));
        } else {
            stringBuilder.append(" min:" + DoubleFormat.toString(this.mDistance[0]) + " max:" + DoubleFormat.toString(this.mDistance[1]));
        }
        if (this.mNotList != null) {
            stringBuilder.append(" not:" + this.mNotList[0]);
            for (int i = 1; i < this.mNotList.length; ++i) {
                stringBuilder.append("," + this.mNotList[i]);
            }
        }
        return stringBuilder.toString();
    }
}

