/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.so;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import java.util.ArrayList;
import java.util.Arrays;
import org.openmolecules.chem.conf.so.ConformationRule;

public class AxialStereoRule
extends ConformationRule {
    private int[] mRotatableAtom;
    private boolean mInverse;
    private boolean mPositiveTorsionWanted;

    public AxialStereoRule(StereoMolecule stereoMolecule, int[] nArray, int[] nArray2, boolean bl, boolean bl2) {
        super(nArray);
        this.mRotatableAtom = this.getRotatableAtoms(stereoMolecule, bl, nArray, nArray2);
        this.mPositiveTorsionWanted = bl2;
    }

    public static void calculateRules(ArrayList<ConformationRule> arrayList, StereoMolecule stereoMolecule) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int[] nArray2;
        int n6;
        int n7;
        for (n7 = 0; n7 < stereoMolecule.getAtoms(); ++n7) {
            if (!stereoMolecule.isCentralAlleneAtom(n7) || (n6 = stereoMolecule.getAtomParity(n7)) != 1 && n6 != 2) continue;
            nArray2 = new int[4];
            nArray = new int[2];
            for (n5 = 0; n5 < stereoMolecule.getConnAtoms(n7); ++n5) {
                n4 = stereoMolecule.getConnAtom(n7, n5);
                n3 = Integer.MAX_VALUE;
                for (n2 = 0; n2 < stereoMolecule.getConnAtoms(n4); ++n2) {
                    n = stereoMolecule.getConnAtom(n4, n2);
                    if (n == n7 || n3 <= n) continue;
                    n3 = n;
                }
                nArray2[3 * n5] = n3;
                nArray2[1 + n5] = n4;
                nArray[n5] = n7;
            }
            if (nArray2[0] == Integer.MAX_VALUE || nArray2[3] == Integer.MAX_VALUE) {
                System.out.println("Unexpected MAX_VALUE idcode:" + new Canonizer(stereoMolecule).getIDCode());
                break;
            }
            arrayList.add(new AxialStereoRule(stereoMolecule, nArray2, nArray, stereoMolecule.isRingAtom(n7), n6 == 1));
        }
        for (n7 = 0; n7 < stereoMolecule.getBonds(); ++n7) {
            n6 = stereoMolecule.getBondParity(n7);
            if (n6 != 1 && n6 != 2 || stereoMolecule.getBondOrder(n7) == 2) continue;
            nArray2 = new int[4];
            nArray = new int[2];
            for (n5 = 0; n5 < 2; ++n5) {
                n4 = stereoMolecule.getBondAtom(n5, n7);
                n3 = stereoMolecule.getBondAtom(1 - n5, n7);
                n2 = Integer.MAX_VALUE;
                for (n = 0; n < stereoMolecule.getConnAtoms(n4); ++n) {
                    int n8 = stereoMolecule.getConnAtom(n4, n);
                    if (n8 == n3 || n2 <= n8) continue;
                    n2 = n8;
                }
                nArray2[3 * n5] = n2;
                nArray2[1 + n5] = n4;
                nArray[n5] = stereoMolecule.getBondAtom(1 - n5, n7);
            }
            arrayList.add(new AxialStereoRule(stereoMolecule, nArray2, nArray, stereoMolecule.isRingBond(n7), n6 == 2));
        }
    }

    private int[] getAromaticFragmentAtoms(StereoMolecule stereoMolecule, int n, int n2) {
        int n3;
        int n4;
        int[] nArray = new int[stereoMolecule.getAtoms()];
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        blArray[n2] = true;
        blArray[n] = true;
        nArray[0] = n;
        int n5 = 1;
        for (int i = 0; i <= n5; ++i) {
            for (n4 = 0; n4 < stereoMolecule.getConnAtoms(nArray[i]); ++n4) {
                if (!stereoMolecule.isAromaticBond(stereoMolecule.getConnBond(nArray[i], n4)) || blArray[n3 = stereoMolecule.getConnAtom(nArray[i], n4)]) continue;
                nArray[++n5] = n3;
                blArray[n3] = true;
            }
        }
        for (n4 = 0; n4 <= n5; ++n4) {
            for (n3 = 0; n3 < stereoMolecule.getConnAtoms(nArray[n4]); ++n3) {
                int n6 = stereoMolecule.getConnAtom(nArray[n4], n3);
                if (blArray[n6] || stereoMolecule.isRingBond(stereoMolecule.getConnBond(nArray[n4], n3))) continue;
                stereoMolecule.getSubstituent(nArray[n4], n6, blArray, null, null);
            }
        }
        blArray[n2] = false;
        for (n4 = 0; n4 <= n5; ++n4) {
            blArray[nArray[n4]] = false;
        }
        for (n4 = 0; n4 < blArray.length; ++n4) {
            if (!blArray[n4]) continue;
            nArray[++n5] = n4;
        }
        return Arrays.copyOf(nArray, n5 + 1);
    }

    private int[] getRotatableAtoms(StereoMolecule stereoMolecule, boolean bl, int[] nArray, int[] nArray2) {
        int n;
        if (bl) {
            return this.getAromaticFragmentAtoms(stereoMolecule, nArray[1], nArray[2]);
        }
        boolean[][] blArray = new boolean[2][stereoMolecule.getAllAtoms()];
        int[] nArray3 = new int[2];
        for (n = 0; n < 2; ++n) {
            nArray3[n] = stereoMolecule.getSubstituent(nArray[1 + n], nArray2[n], blArray[n], null, null);
        }
        n = nArray3[0] < nArray3[1] ? 0 : 1;
        int[] nArray4 = new int[nArray3[n]];
        int n2 = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!blArray[n][i]) continue;
            nArray4[n2++] = i;
        }
        this.mInverse = n == 1;
        return nArray4;
    }

    @Override
    public boolean apply(Conformer conformer, double d) {
        double d2;
        double d3 = conformer.calculateTorsion(this.mAtom);
        if (d3 == 0.0 || this.mPositiveTorsionWanted == d3 > 0.0) {
            return false;
        }
        Coordinates coordinates = conformer.getCoordinates(this.mAtom[2]).subC(conformer.getCoordinates(this.mAtom[1]));
        coordinates.unit();
        double d4 = d2 = Math.abs(d3) < 1.5707963267948966 ? -2.0 * d3 : 2.0 * (Math.PI - d3);
        if (this.mInverse) {
            d2 = -d2;
        }
        for (int n : this.mRotatableAtom) {
            this.rotateAtom(conformer, n, this.mAtom[1], coordinates, d2);
        }
        return true;
    }

    @Override
    public double addStrain(Conformer conformer, double[] dArray) {
        return conformer.calculateTorsion(this.mAtom) < 0.0 ? 1.0 : 0.0;
    }

    @Override
    public int getRuleType() {
        return 5;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("binap rule (" + (this.mPositiveTorsionWanted ? "positive" : "negative") + " torsion):");
        super.addAtomList(stringBuilder);
        return stringBuilder.toString();
    }
}

