/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

public class TorsionSetEliminationRule {
    private long[] mMask;
    private long[] mData;
    private double mCollisionIntensity;

    public TorsionSetEliminationRule(long[] lArray, long[] lArray2, double d) {
        this.mMask = lArray;
        this.mData = lArray2;
        this.mCollisionIntensity = d;
    }

    public long[] getMask() {
        return this.mMask;
    }

    public long[] getData() {
        return this.mData;
    }

    public double getCollisionIntensity() {
        return this.mCollisionIntensity;
    }

    public boolean isCovered(long[] lArray, long[] lArray2) {
        boolean bl = true;
        for (int i = 0; i < this.mMask.length; ++i) {
            if (((lArray[i] ^ 0xFFFFFFFFFFFFFFFFL) & this.mMask[i]) == 0L && (lArray2[i] & this.mMask[i]) == this.mData[i]) continue;
            bl = false;
        }
        return bl;
    }

    public boolean isMoreGeneral(long[] lArray, long[] lArray2) {
        boolean bl = true;
        for (int i = 0; i < this.mMask.length; ++i) {
            if (((this.mMask[i] ^ 0xFFFFFFFFFFFFFFFFL) & lArray[i]) == 0L && (this.mData[i] & lArray[i]) == lArray2[i]) continue;
            bl = false;
        }
        return bl;
    }
}

