/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.IDCodeParserWithoutCoordinateInvention;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.gui.FileHelper;
import com.actelion.research.util.DoubleFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipInputStream;
import org.openmolecules.chem.conf.gen.ConformerGenerator;
import org.openmolecules.chem.conf.gen.RigidFragmentProvider;

public class RigidFragmentCache
extends ConcurrentHashMap<String, CacheEntry>
implements Serializable {
    private static final String DEFAULT_CACHE_FILE = "/resources/defaultRigidFragments.zip";
    private static RigidFragmentCache sInstance;
    private int mHitCount;
    private int mGetCount;
    private int mNonCachableCount;
    private boolean mDefaultCacheLoaded;
    private TreeSet<String> mSetOfLoadedCacheFiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RigidFragmentCache getDefaultInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        Class<RigidFragmentCache> clazz = RigidFragmentCache.class;
        synchronized (RigidFragmentCache.class) {
            if (sInstance == null) {
                sInstance = new RigidFragmentCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static RigidFragmentCache createInstance(String string) {
        RigidFragmentCache rigidFragmentCache = new RigidFragmentCache();
        if (string != null) {
            rigidFragmentCache.loadCache(string);
        }
        return rigidFragmentCache;
    }

    private RigidFragmentCache() {
    }

    @Override
    public void clear() {
        super.clear();
        this.mDefaultCacheLoaded = false;
    }

    @Override
    public CacheEntry get(Object object) {
        CacheEntry cacheEntry = (CacheEntry)super.get(object);
        ++this.mGetCount;
        if (cacheEntry != null) {
            cacheEntry.incrementHitCount();
            ++this.mHitCount;
        }
        return cacheEntry;
    }

    public double getHitQuote() {
        return (double)this.mHitCount / (double)this.mGetCount;
    }

    public int getHitCount() {
        return this.mHitCount;
    }

    public int getRequestCount() {
        return this.mGetCount;
    }

    public int getNonCachableCount() {
        return this.mNonCachableCount;
    }

    public void increaseNonCachableCount() {
        ++this.mNonCachableCount;
    }

    public void resetAllCounters() {
        this.mNonCachableCount = 0;
        this.mHitCount = 0;
        this.mGetCount = 0;
    }

    public boolean serializeCache(String string, int n) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            for (String string2 : this.keySet()) {
                CacheEntry cacheEntry = (CacheEntry)super.get(string2);
                if (cacheEntry.hitCount < n) continue;
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                bufferedWriter.write(Integer.toString(cacheEntry.coordinates.length));
                bufferedWriter.newLine();
                StereoMolecule stereoMolecule = new IDCodeParserWithoutCoordinateInvention().getCompactMolecule(string2);
                Canonizer canonizer = new Canonizer(stereoMolecule, 64);
                for (Coordinates[] coordinatesArray : cacheEntry.coordinates) {
                    bufferedWriter.write(canonizer.getEncodedCoordinates(true, coordinatesArray));
                    bufferedWriter.newLine();
                    canonizer.invalidateCoordinates();
                }
                for (double d : cacheEntry.likelihood) {
                    bufferedWriter.write(DoubleFormat.toString(d));
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public synchronized void loadDefaultCache() {
        if (!this.mDefaultCacheLoaded) {
            try {
                InputStream inputStream = RigidFragmentCache.class.getResourceAsStream(DEFAULT_CACHE_FILE);
                if (inputStream != null) {
                    ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                    zipInputStream.getNextEntry();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));
                    this.loadCache(bufferedReader);
                    bufferedReader.close();
                    this.mDefaultCacheLoaded = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void loadCache(String string) {
        if (this.mSetOfLoadedCacheFiles == null) {
            this.mSetOfLoadedCacheFiles = new TreeSet();
        }
        if (!this.mSetOfLoadedCacheFiles.contains(string)) {
            try {
                BufferedReader bufferedReader;
                if (string.endsWith(".zip")) {
                    ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));
                    zipInputStream.getNextEntry();
                    bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));
                } else {
                    bufferedReader = new BufferedReader(new FileReader(string));
                }
                this.loadCache(bufferedReader);
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.mSetOfLoadedCacheFiles.add(string);
        }
    }

    private void loadCache(BufferedReader bufferedReader) throws Exception {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            IDCodeParserWithoutCoordinateInvention iDCodeParserWithoutCoordinateInvention = new IDCodeParserWithoutCoordinateInvention();
            StereoMolecule stereoMolecule = iDCodeParserWithoutCoordinateInvention.getCompactMolecule(string);
            int n2 = Integer.parseInt(bufferedReader.readLine());
            Coordinates[][] coordinatesArray = new Coordinates[n2][stereoMolecule.getAllAtoms()];
            for (int i = 0; i < n2; ++i) {
                for (n = 0; n < coordinatesArray[i].length; ++n) {
                    coordinatesArray[i][n] = new Coordinates();
                }
                iDCodeParserWithoutCoordinateInvention.parseCoordinates(bufferedReader.readLine().getBytes(), 0, stereoMolecule, coordinatesArray[i]);
            }
            double[] dArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray[n] = Double.parseDouble(bufferedReader.readLine());
            }
            this.put(string, new CacheEntry(coordinatesArray, dArray));
        }
    }

    public static RigidFragmentCache createCache(String[] stringArray, String string, int n, boolean bl, int n2, RigidFragmentProvider rigidFragmentProvider) {
        boolean bl2 = false;
        for (String string2 : stringArray) {
            if (FileHelper.fileExists(new File(string2), 1000L)) continue;
            System.out.println("File not found: '" + string2 + "'");
            bl2 = true;
        }
        if (bl2) {
            return null;
        }
        RigidFragmentCache rigidFragmentCache = RigidFragmentCache.createInstance(null);
        if (rigidFragmentProvider != null) {
            rigidFragmentProvider.setCache(rigidFragmentCache);
        }
        for (String string3 : stringArray) {
            long l = n != 1 ? RigidFragmentCache.addFragmentsToCacheSMP(rigidFragmentCache, bl, string3, n2, rigidFragmentProvider, n) : RigidFragmentCache.addFragmentsToCache(rigidFragmentCache, bl, string3, n2, rigidFragmentProvider);
            System.out.println("File '" + string3 + "' processed in " + l + " milliseconds.");
        }
        if (stringArray != null) {
            System.out.print("Writing cache files... ");
            String string4 = string.concat("/cache_");
            int n3 = rigidFragmentCache.serializeCache(string4 + "1.txt", 0) && rigidFragmentCache.serializeCache(string4 + "2.txt", 1) && rigidFragmentCache.serializeCache(string4 + "3.txt", 2) && rigidFragmentCache.serializeCache(string4 + "5.txt", 4) && rigidFragmentCache.serializeCache(string4 + "10.txt", 9) ? 1 : 0;
            System.out.println(n3 != 0 ? "done" : "failure !!!");
        }
        return rigidFragmentCache;
    }

    private static long addFragmentsToCache(RigidFragmentCache rigidFragmentCache, boolean bl, String string, int n, RigidFragmentProvider rigidFragmentProvider) {
        ConformerGenerator conformerGenerator;
        long l = System.currentTimeMillis();
        System.out.println("Processing '" + string + "'... ('.' = 50 molecules)");
        CompoundFileParser compoundFileParser = CompoundFileParser.createParser(string);
        ConformerGenerator conformerGenerator2 = conformerGenerator = rigidFragmentProvider == null ? new ConformerGenerator(123L, rigidFragmentCache, bl) : new ConformerGenerator(123L, rigidFragmentProvider);
        for (int i = 0; compoundFileParser.next() && i < n; ++i) {
            if (i % 50 == 49) {
                System.out.print(".");
            }
            if (i % 5000 == 4999) {
                System.out.println(" hit-rate:" + DoubleFormat.toString(rigidFragmentCache.getHitQuote(), 5, false) + " millis:" + (System.currentTimeMillis() - l) + " cacheSize:" + rigidFragmentCache.size());
                rigidFragmentCache.resetAllCounters();
            }
            conformerGenerator.initialize(compoundFileParser.getMolecule(), false);
        }
        System.out.println();
        return System.currentTimeMillis() - l;
    }

    private static long addFragmentsToCacheSMP(RigidFragmentCache rigidFragmentCache, boolean bl, String string, int n, RigidFragmentProvider rigidFragmentProvider, int n2) {
        int n3;
        long l = System.currentTimeMillis();
        int n4 = 0;
        System.out.println("Processing '" + string + "'... ('.' = 50 molecules)");
        CompoundFileParser compoundFileParser = CompoundFileParser.createParser(string);
        if (n2 == 0) {
            n2 = Runtime.getRuntime().availableProcessors();
        }
        ArrayBlockingQueue<StereoMolecule> arrayBlockingQueue = new ArrayBlockingQueue<StereoMolecule>(2 * n2);
        Thread[] threadArray = new Thread[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            threadArray[n3] = new Thread(() -> RigidFragmentCache.consumeMoleculesToCacheFragments(arrayBlockingQueue, rigidFragmentCache, bl, rigidFragmentProvider));
            threadArray[n3].setPriority(1);
            threadArray[n3].start();
        }
        while (compoundFileParser.next() && n4 < n) {
            if (n4 % 50 == 49) {
                System.out.print(".");
            }
            if (n4 % 5000 == 4999) {
                System.out.println(" hit-rate:" + DoubleFormat.toString(rigidFragmentCache.getHitQuote(), 5, false) + " millis:" + (System.currentTimeMillis() - l) + " cacheSize:" + rigidFragmentCache.size());
                rigidFragmentCache.resetAllCounters();
            }
            try {
                StereoMolecule stereoMolecule = compoundFileParser.getMolecule();
                if (stereoMolecule.getAllAtoms() != 0) {
                    arrayBlockingQueue.put(stereoMolecule);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n4;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            threadArray[n3].interrupt();
        }
        for (n3 = 0; n3 < n2; ++n3) {
            try {
                threadArray[n3].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.println();
        return System.currentTimeMillis() - l;
    }

    private static void consumeMoleculesToCacheFragments(ArrayBlockingQueue<StereoMolecule> arrayBlockingQueue, RigidFragmentCache rigidFragmentCache, boolean bl, RigidFragmentProvider rigidFragmentProvider) {
        ConformerGenerator conformerGenerator = rigidFragmentProvider == null ? new ConformerGenerator(123L, rigidFragmentCache, bl) : new ConformerGenerator(123L, rigidFragmentProvider);
        try {
            while (true) {
                conformerGenerator.initialize(arrayBlockingQueue.take(), false);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public boolean writeTabDelimitedTable(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            bufferedWriter.write("Fragment No\tConformer No\tConformer Count\tidcode\tidcoords\tLikelihood");
            bufferedWriter.newLine();
            int n = 0;
            for (String string2 : this.keySet()) {
                ++n;
                CacheEntry cacheEntry = (CacheEntry)super.get(string2);
                StereoMolecule stereoMolecule = new IDCodeParserWithoutCoordinateInvention().getCompactMolecule(string2);
                Canonizer canonizer = new Canonizer(stereoMolecule, 64);
                for (int i = 0; i < cacheEntry.coordinates.length; ++i) {
                    bufferedWriter.write(Integer.toString(n));
                    bufferedWriter.write("\t");
                    bufferedWriter.write(Integer.toString(i + 1));
                    bufferedWriter.write("\t");
                    bufferedWriter.write(Integer.toString(cacheEntry.coordinates.length));
                    bufferedWriter.write("\t");
                    bufferedWriter.write(string2);
                    bufferedWriter.write("\t");
                    bufferedWriter.write(canonizer.getEncodedCoordinates(true, cacheEntry.coordinates[i]));
                    bufferedWriter.write("\t");
                    bufferedWriter.write(DoubleFormat.toString(cacheEntry.likelihood[i]));
                    bufferedWriter.newLine();
                    canonizer.invalidateCoordinates();
                }
            }
            bufferedWriter.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static class CacheEntry
    implements Comparable<CacheEntry> {
        Coordinates[][] coordinates;
        double[] likelihood;
        int hitCount;

        public CacheEntry(Coordinates[][] coordinatesArray, double[] dArray) {
            this.coordinates = coordinatesArray;
            this.likelihood = dArray;
        }

        public void incrementHitCount() {
            ++this.hitCount;
        }

        @Override
        public int compareTo(CacheEntry cacheEntry) {
            if (this.hitCount != cacheEntry.hitCount) {
                return this.hitCount < cacheEntry.hitCount ? -1 : 1;
            }
            return 0;
        }
    }
}

