/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.CU;
import javajs.util.M4d;
import javajs.util.V3d;
import org.jmol.util.C;

public class Shader {
    private static final int SHADE_INDEX_MAX = 64;
    public static final int SHADE_INDEX_LAST = 63;
    public static final byte SHADE_INDEX_NORMAL = 52;
    public static final byte SHADE_INDEX_NOISY_LIMIT = 56;
    private double xLight;
    private double yLight;
    private double zLight;
    V3d lightSource = new V3d();
    boolean specularOn = true;
    boolean usePhongExponent = false;
    int ambientPercent = 45;
    int diffusePercent = 84;
    int specularExponent = 6;
    int specularPercent = 22;
    int specularPower = 40;
    int phongExponent = 64;
    double ambientFraction = (double)this.ambientPercent / 100.0;
    double diffuseFactor = (double)this.diffusePercent / 100.0;
    double intenseFraction = (double)this.specularPower / 100.0;
    double specularFactor = (double)this.specularPercent / 100.0;
    private int[][] ashades = AU.newInt2(128);
    private int[][] ashadesGreyscale;
    boolean celOn;
    int celPower = 10;
    private int celRGB;
    private double celZ;
    private boolean useLight;
    public byte[] sphereShadeIndexes = new byte[65536];
    private int seed = 305419897;
    private static final int SLIM = 20;
    private static final int SDIM = 40;
    public static final int maxSphereCache = 128;
    public int[][] sphereShapeCache = AU.newInt2(128);
    public byte[][][] ellipsoidShades;
    public int nOut;
    public int nIn;

    public Shader() {
        this.setLightSource(-1.0, -1.0, 2.5);
    }

    private void setLightSource(double x, double y, double z) {
        this.lightSource.set(x, y, z);
        this.lightSource.normalize();
        this.xLight = this.lightSource.x;
        this.yLight = this.lightSource.y;
        this.zLight = this.lightSource.z;
    }

    void setCel(boolean celShading, int celShadingPower, int argb) {
        celShading = celShading && celShadingPower != 0;
        int n = (argb = C.getArgb(C.getBgContrast(argb))) == -16777216 ? -16514044 : (argb = argb == -1 ? -2 : argb + 1);
        if (this.celOn == celShading && this.celRGB == argb && this.celPower == celShadingPower) {
            return;
        }
        this.celOn = celShading;
        this.celPower = celShadingPower;
        this.useLight = !this.celOn || celShadingPower > 0;
        this.celZ = 1.0 - Math.pow(2.0, (double)(-Math.abs(celShadingPower)) / 10.0);
        this.celRGB = argb;
        this.flushCaches();
    }

    void flushCaches() {
        this.checkShades(C.colixMax);
        int i = C.colixMax;
        while (--i >= 0) {
            this.ashades[i] = null;
        }
        this.calcSphereShading();
        i = 128;
        while (--i >= 0) {
            this.sphereShapeCache[i] = null;
        }
        this.ellipsoidShades = null;
    }

    public void setLastColix(int argb, boolean asGrey) {
        C.allocateColix(argb, true);
        this.checkShades(2047);
        if (asGrey) {
            C.setLastGrey(argb);
        }
        this.ashades[2047] = this.getShades2(argb, false);
    }

    int[] getShades(short colix) {
        this.checkShades(C.colixMax);
        colix = (short)(colix & 0xFFFF87FF);
        int[] shades = this.ashades[colix];
        if (shades == null) {
            this.ashades[colix] = this.getShades2(C.argbs[colix], false);
            shades = this.ashades[colix];
        }
        return shades;
    }

    int[] getShadesG(short colix) {
        int[] shadesGreyscale;
        this.checkShades(C.colixMax);
        colix = (short)(colix & 0xFFFF87FF);
        if (this.ashadesGreyscale == null) {
            this.ashadesGreyscale = AU.newInt2(this.ashades.length);
        }
        if ((shadesGreyscale = this.ashadesGreyscale[colix]) == null) {
            this.ashadesGreyscale[colix] = this.getShades2(C.argbs[colix], true);
            shadesGreyscale = this.ashadesGreyscale[colix];
        }
        return shadesGreyscale;
    }

    private void checkShades(int n) {
        if (this.ashades != null && this.ashades.length >= n) {
            return;
        }
        if (n == 2047) {
            ++n;
        }
        this.ashades = AU.arrayCopyII(this.ashades, n);
        if (this.ashadesGreyscale != null) {
            this.ashadesGreyscale = AU.arrayCopyII(this.ashadesGreyscale, n);
        }
    }

    private int[] getShades2(int rgb, boolean greyScale) {
        int i;
        int[] shades = new int[64];
        if (rgb == 0) {
            return shades;
        }
        double red0 = rgb >> 16 & 0xFF;
        double grn0 = rgb >> 8 & 0xFF;
        double blu0 = rgb & 0xFF;
        double red = 0.0;
        double grn = 0.0;
        double blu = 0.0;
        double f = this.ambientFraction;
        while (true) {
            red = red0 * f + 0.5;
            grn = grn0 * f + 0.5;
            blu = blu0 * f + 0.5;
            if (!(f > 0.0) || !(red < 4.0) || !(grn < 4.0) || !(blu < 4.0)) break;
            red0 += 1.0;
            grn0 += 1.0;
            blu0 += 1.0;
            if (f < 0.1) {
                f += 0.1;
            }
            rgb = CU.rgb((int)Math.floor(red0), (int)Math.floor(grn0), (int)Math.floor(blu0));
        }
        f = (1.0 - f) / 52.0;
        double redStep = red0 * f;
        double grnStep = grn0 * f;
        double bluStep = blu0 * f;
        if (this.celOn) {
            int max = 32;
            int _rgb = CU.rgb((int)Math.floor(red), (int)Math.floor(grn), (int)Math.floor(blu));
            if (this.celPower >= 0) {
                for (i = 0; i < max; ++i) {
                    shades[i] = _rgb;
                }
            }
            _rgb = CU.rgb((int)Math.floor(red += redStep * (double)max), (int)Math.floor(grn += grnStep * (double)max), (int)Math.floor(blu += bluStep * (double)max));
            while (i < 64) {
                shades[i] = _rgb;
                ++i;
            }
            shades[0] = shades[1] = this.celRGB;
        } else {
            while (i < 52) {
                shades[i] = CU.rgb((int)Math.floor(red), (int)Math.floor(grn), (int)Math.floor(blu));
                red += redStep;
                grn += grnStep;
                blu += bluStep;
                ++i;
            }
            shades[i++] = rgb;
            f = this.intenseFraction / (double)(64 - i);
            redStep = (255.5 - red) * f;
            grnStep = (255.5 - grn) * f;
            bluStep = (255.5 - blu) * f;
            while (i < 64) {
                shades[i] = CU.rgb((int)Math.floor(red += redStep), (int)Math.floor(grn += grnStep), (int)Math.floor(blu += bluStep));
                ++i;
            }
        }
        if (greyScale) {
            while (--i >= 0) {
                shades[i] = CU.toFFGGGfromRGB(shades[i]);
            }
        }
        return shades;
    }

    public int getShadeIndex(double x, double y, double z) {
        double magnitude = Math.sqrt(x * x + y * y + z * z);
        return (int)Math.round(this.getShadeF(x / magnitude, y / magnitude, z / magnitude) * 63.0);
    }

    public byte getShadeB(double x, double y, double z) {
        return (byte)Math.round(this.getShadeF(x, y, z) * 63.0);
    }

    public int getShadeFp8(double x, double y, double z) {
        double magnitude = Math.sqrt(x * x + y * y + z * z);
        return (int)Math.floor(this.getShadeF(x / magnitude, y / magnitude, z / magnitude) * 63.0 * 256.0);
    }

    private double getShadeF(double x, double y, double z) {
        double k_specular;
        double NdotL;
        double d = NdotL = this.useLight ? x * this.xLight + y * this.yLight + z * this.zLight : z;
        if (NdotL <= 0.0) {
            return 0.0;
        }
        double intensity = NdotL * this.diffuseFactor;
        if (this.specularOn && (k_specular = 2.0 * NdotL * z - this.zLight) > 0.0) {
            if (this.usePhongExponent) {
                k_specular = Math.pow(k_specular, this.phongExponent);
            } else {
                int n = this.specularExponent;
                while (--n >= 0 && k_specular > (double)1.0E-4f) {
                    k_specular *= k_specular;
                }
            }
            intensity += k_specular * this.specularFactor;
        }
        return this.celOn && z < this.celZ ? 0.0 : (intensity > 1.0 ? 1.0 : intensity);
    }

    public byte getShadeN(double x, double y, double z, double r) {
        int random16bit;
        int fp8ShadeIndex = (int)Math.floor(this.getShadeF(x / r, y / r, z / r) * 63.0 * 256.0);
        int shadeIndex = fp8ShadeIndex >> 8;
        if (!this.useLight) {
            return (byte)shadeIndex;
        }
        if ((fp8ShadeIndex & 0xFF) > this.nextRandom8Bit()) {
            ++shadeIndex;
        }
        if ((random16bit = this.seed & 0xFFFF) < 21845 && shadeIndex > 0) {
            --shadeIndex;
        } else if (random16bit > 43690 && shadeIndex < 63) {
            ++shadeIndex;
        }
        return (byte)shadeIndex;
    }

    private synchronized void calcSphereShading() {
        double xF = -127.5;
        double r2 = 16900.0;
        for (int i = 0; i < 256; ++i) {
            double yF = -127.5;
            double xF2 = xF * xF;
            for (int j = 0; j < 256; ++j) {
                byte shadeIndex = 0;
                double z2 = r2 - xF2 - yF * yF;
                if (z2 > 0.0) {
                    double z = Math.sqrt(z2);
                    shadeIndex = this.getShadeN(xF, yF, z, 130.0);
                }
                this.sphereShadeIndexes[(j << 8) + i] = shadeIndex;
                yF += 1.0;
            }
            xF += 1.0;
        }
    }

    public int nextRandom8Bit() {
        int t = this.seed;
        this.seed = t = (t << 16) + (t << 1) + t & Integer.MAX_VALUE;
        return t >> 23;
    }

    public int getEllipsoidShade(double x, double y, double z, int radius, M4d mDeriv) {
        boolean outside;
        double tx = mDeriv.m00 * x + mDeriv.m01 * y + mDeriv.m02 * z + mDeriv.m03;
        double ty = mDeriv.m10 * x + mDeriv.m11 * y + mDeriv.m12 * z + mDeriv.m13;
        double tz = mDeriv.m20 * x + mDeriv.m21 * y + mDeriv.m22 * z + mDeriv.m23;
        double f = Math.min((double)radius / 2.0, 45.0) / Math.sqrt(tx * tx + ty * ty + tz * tz);
        int i = (int)(-tx * f);
        int j = (int)(-ty * f);
        int k = (int)(tz * f);
        boolean bl = outside = i < -20 || i >= 20 || j < -20 || j >= 20 || k < 0 || k >= 40;
        if (outside) {
            while (i % 2 == 0 && j % 2 == 0 && k % 2 == 0 && i + j + k > 0) {
                i >>= 1;
                j >>= 1;
                k >>= 1;
            }
            boolean bl2 = outside = i < -20 || i >= 20 || j < -20 || j >= 20 || k < 0 || k >= 40;
        }
        if (outside) {
            ++this.nOut;
        } else {
            ++this.nIn;
        }
        return outside ? this.getShadeIndex(i, j, k) : this.ellipsoidShades[i + 20][j + 20][k];
    }

    public void createEllipsoidShades() {
        this.ellipsoidShades = new byte[40][40][40];
        for (int ii = 0; ii < 40; ++ii) {
            for (int jj = 0; jj < 40; ++jj) {
                for (int kk = 0; kk < 40; ++kk) {
                    this.ellipsoidShades[ii][jj][kk] = (byte)this.getShadeIndex(ii - 20, jj - 20, kk);
                }
            }
        }
    }
}

