/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import org.jmol.api.FontManager;

public final class Font {
    public final int fid;
    public final String fontFace;
    public final String fontStyle;
    public final double fontSizeNominal;
    public final int idFontFace;
    public final int idFontStyle;
    public final double fontSize;
    public final Object font;
    private final Object fontMetrics;
    private FontManager manager;
    private int ascent;
    private int descent;
    private boolean isBold;
    private boolean isItalic;
    public double fontSizeAngstroms;
    private static final int FONT_ALLOCATION_UNIT = 8;
    private static int fontkeyCount = 1;
    private static int[] fontkeys = new int[8];
    private static Font[] font3ds = new Font[8];
    public static final int FONT_FACE_SANS = 0;
    public static final int FONT_FACE_SERIF = 1;
    public static final int FONT_FACE_MONO = 2;
    private static final String[] fontFaces = new String[]{"SansSerif", "Serif", "Monospaced", ""};
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLDITALIC = 3;
    private static final String[] fontStyles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};

    private Font(FontManager manager, int fid, int idFontFace, int idFontStyle, double fontSize, double fontSizeNominal, double fontSizeAngstroms, Object graphics) {
        this.manager = manager;
        this.fid = fid;
        this.fontFace = fontFaces[idFontFace];
        this.fontStyle = fontStyles[idFontStyle];
        this.idFontFace = idFontFace;
        this.idFontStyle = idFontStyle;
        this.fontSize = fontSize;
        this.fontSizeAngstroms = fontSizeAngstroms;
        this.isBold = (idFontStyle & 1) == 1;
        this.isItalic = (idFontStyle & 2) == 2;
        this.fontSizeNominal = fontSizeNominal;
        this.font = manager.newFont(fontFaces[idFontFace], this.isBold, this.isItalic, (float)fontSize);
        this.fontMetrics = manager.getFontMetrics(this, graphics);
        this.descent = manager.getFontDescent(this.fontMetrics);
        this.ascent = manager.getFontAscent(this.fontMetrics);
    }

    public static Font getFont3D(int fontID) {
        return font3ds[fontID];
    }

    public static synchronized Font createFont3D(int fontface, int fontstyle, double fontsize, double fontsizeNominal, double fontSizeAngstroms, FontManager manager, Object graphicsForMetrics) {
        Font font3d;
        int fontIndexNext;
        if (fontsize > 255.0) {
            fontsize = 255.0;
        }
        if (fontsize < 0.0) {
            fontSizeAngstroms = -fontsize;
            fontsize = 10.0;
            fontsizeNominal = 10.0;
        }
        int fontsizeX16 = (int)fontsize << 4;
        int fontkey = fontface & 3 | (fontstyle & 3) << 2 | fontsizeX16 << 4;
        int i = fontkeyCount;
        while (--i > 0) {
            if (fontkey != fontkeys[i] || Font.font3ds[i].fontSizeNominal != fontsizeNominal) continue;
            return font3ds[i];
        }
        if ((fontIndexNext = fontkeyCount++) == fontkeys.length) {
            fontkeys = AU.arrayCopyI(fontkeys, fontIndexNext + 8);
            font3ds = (Font[])AU.arrayCopyObject(font3ds, fontIndexNext + 8);
        }
        Font.font3ds[fontIndexNext] = font3d = new Font(manager, fontIndexNext, fontface, fontstyle, fontsize, fontsizeNominal, fontSizeAngstroms, graphicsForMetrics);
        Font.fontkeys[fontIndexNext] = fontkey;
        return font3d;
    }

    public static int getFontFaceID(String fontface) {
        return "Monospaced".equalsIgnoreCase(fontface) ? 2 : ("Serif".equalsIgnoreCase(fontface) ? 1 : 0);
    }

    public static int getFontStyleID(String fontstyle) {
        int i = 4;
        while (--i >= 0) {
            if (!fontStyles[i].equalsIgnoreCase(fontstyle)) continue;
            return i;
        }
        return -1;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getHeight() {
        return this.getAscent() + this.getDescent();
    }

    public Object getFontMetrics() {
        return this.fontMetrics;
    }

    public int stringWidth(String text) {
        return this.manager.fontStringWidth(this, text);
    }

    public String getInfo() {
        return (this.fontSizeAngstroms > 0.0 ? -this.fontSizeAngstroms : this.fontSizeNominal) + " " + this.fontFace + " " + this.fontStyle;
    }

    public String toString() {
        return "[" + this.getInfo() + "]";
    }
}

