/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.CU;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.c.PAL;
import org.jmol.util.Escape;
import org.jmol.util.Int2IntHash;
import org.jmol.util.Logger;

public final class C {
    public static final short INHERIT_ALL = 0;
    public static final short INHERIT_COLOR = 1;
    public static final short USE_PALETTE = 2;
    public static final short COLIX_CONTRAST = 3;
    public static final short SPECIAL_COLIX_MAX = 4;
    static int colixMax = 4;
    static int[] argbs = new int[128];
    private static int[] argbsGreyscale;
    private static final Int2IntHash colixHash;
    public static final short UNMASK_CHANGEABLE_TRANSLUCENT = 2047;
    public static final short CHANGEABLE_MASK = Short.MIN_VALUE;
    public static final int LAST_AVAILABLE_COLIX = 2047;
    public static final int TRANSLUCENT_SHIFT = 11;
    public static final int TRANSPARENT_LEVEL = 255;
    public static final int ALPHA_SHIFT = 13;
    public static final int TRANSLUCENT_MASK = 30720;
    public static final int TRANSLUCENT_SCREENED = 30720;
    public static final int TRANSPARENT = 16384;
    public static final short OPAQUE_MASK = -30721;
    public static final short BLACK = 4;
    public static final short ORANGE = 5;
    public static final short PINK = 6;
    public static final short BLUE = 7;
    public static final short WHITE = 8;
    public static final short CYAN = 9;
    public static final short RED = 10;
    public static final short GREEN = 11;
    public static final short GRAY = 12;
    public static final short SILVER = 13;
    public static final short LIME = 14;
    public static final short MAROON = 15;
    public static final short NAVY = 16;
    public static final short OLIVE = 17;
    public static final short PURPLE = 18;
    public static final short TEAL = 19;
    public static final short MAGENTA = 20;
    public static final short YELLOW = 21;
    public static final short HOTPINK = 22;
    public static final short GOLD = 23;

    public static short getColix(int argb) {
        if (argb == 0) {
            return 0;
        }
        int translucentFlag = 0;
        int c = colixHash.get(argb |= 0xFF000000);
        return (short)((c > 0 ? c : C.allocateColix(argb, false)) | translucentFlag);
    }

    public static synchronized int allocateColix(int argb, boolean forceLast) {
        int n;
        int n2;
        if (forceLast) {
            n2 = 2047;
        } else {
            if (argb == -74566) {
                return 3;
            }
            int i = colixMax;
            while (--i >= 4) {
                if ((argb & 0xFFFFFF) != (argbs[i] & 0xFFFFFF)) continue;
                return i;
            }
            n2 = colixMax;
        }
        if (n2 >= argbs.length) {
            int newSize;
            int n3 = newSize = forceLast ? n2 + 1 : colixMax * 2;
            if (newSize > 2048) {
                newSize = 2048;
            }
            argbs = AU.arrayCopyI(argbs, newSize);
            if (argbsGreyscale != null) {
                argbsGreyscale = AU.arrayCopyI(argbsGreyscale, newSize);
            }
        }
        C.argbs[n2] = argb;
        if (argbsGreyscale != null) {
            C.argbsGreyscale[n2] = CU.toFFGGGfromRGB(argb);
        }
        colixHash.put(argb, n2);
        if (n2 < 2047) {
            int n4 = colixMax;
            n = n4;
            colixMax = n4 + 1;
        } else {
            n = colixMax;
        }
        return n;
    }

    static void setLastGrey(int argb) {
        C.calcArgbsGreyscale();
        C.argbsGreyscale[2047] = CU.toFFGGGfromRGB(argb);
    }

    static synchronized void calcArgbsGreyscale() {
        if (argbsGreyscale != null) {
            return;
        }
        int[] a = new int[argbs.length];
        int i = argbs.length;
        while (--i >= 4) {
            a[i] = CU.toFFGGGfromRGB(argbs[i]);
        }
        argbsGreyscale = a;
    }

    public static final int getArgbGreyscale(short colix) {
        if (argbsGreyscale == null) {
            C.calcArgbsGreyscale();
        }
        return argbsGreyscale[colix & 0xFFFF87FF];
    }

    public static short getColixO(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof PAL) {
            return (PAL)((Object)obj) == PAL.NONE ? (short)0 : 2;
        }
        if (obj instanceof Integer) {
            return C.getColix((Integer)obj);
        }
        if (obj instanceof String) {
            return C.getColixS((String)obj);
        }
        if (obj instanceof Byte) {
            return (Byte)obj == 0 ? (short)0 : 2;
        }
        if (Logger.debugging) {
            Logger.debug("?? getColix(" + obj + ")");
        }
        return 22;
    }

    private static int getTranslucentFlag(double translucentLevel) {
        if (translucentLevel == 0.0) {
            return 0;
        }
        if (translucentLevel < 0.0) {
            return 30720;
        }
        if (Double.isNaN(translucentLevel) || translucentLevel >= 255.0 || translucentLevel == 1.0) {
            return 16384;
        }
        int iLevel = (int)Math.floor(translucentLevel < 1.0 ? translucentLevel * 256.0 : (translucentLevel >= 15.0 ? translucentLevel : (translucentLevel <= 9.0 ? (double)((int)Math.floor(translucentLevel - 1.0) << 5) : 256.0)));
        return (iLevel >> 5 & 0xF) << 11;
    }

    public static boolean isColixLastAvailable(short colix) {
        return colix > 0 && (colix & 0x7FF) == 2047;
    }

    public static int getArgb(short colix) {
        return argbs[colix & 0xFFFF87FF];
    }

    public static final boolean isColixColorInherited(short colix) {
        switch (colix) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return (colix & 0xFFFF87FF) == 1;
    }

    public static final short getColixInherited(short myColix, short parentColix) {
        switch (myColix) {
            case 0: {
                return parentColix;
            }
            case 1: {
                return (short)(parentColix & 0xFFFF87FF);
            }
        }
        return (myColix & 0xFFFF87FF) == 1 ? (short)(parentColix & 0xFFFF87FF | myColix & 0x7800) : myColix;
    }

    public static final boolean renderPass2(short colix) {
        int c = colix & 0x7800;
        return c != 0 && c != 30720;
    }

    public static final boolean isColixTranslucent(short colix) {
        return (colix & 0x7800) != 0;
    }

    public static final short getChangeableColixIndex(short colix) {
        return colix >= 0 ? (short)-1 : (short)(colix & 0x7FF);
    }

    public static final short getColixTranslucent3(short colix, boolean isTranslucent, double translucentLevel) {
        if ((colix = (short)(colix & 0xFFFF87FF)) == 0) {
            colix = 1;
        }
        return isTranslucent ? (short)(colix | C.getTranslucentFlag(translucentLevel)) : colix;
    }

    public static final short copyColixTranslucency(short colixFrom, short colixTo) {
        return C.getColixTranslucent3(colixTo, C.isColixTranslucent(colixFrom), C.getColixTranslucencyLevel(colixFrom));
    }

    public static double getColixTranslucencyFractional(short colix) {
        int translevel = C.getColixTranslucencyLevel(colix);
        return translevel == -1 ? 0.5 : (translevel == 0 ? 0.0 : (translevel == 255 ? 1.0 : (double)translevel / 256.0));
    }

    public static String getColixTranslucencyLabel(short colix) {
        return "translucent " + ((colix & 0x7800) == 30720 ? -1.0 : C.getColixTranslucencyFractional(colix));
    }

    public static final int getColixTranslucencyLevel(short colix) {
        int logAlpha = colix >> 11 & 0xF;
        switch (logAlpha) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return logAlpha << 5;
            }
            case 15: {
                return -1;
            }
        }
        return 255;
    }

    public static boolean isTransparent(short colix) {
        return (colix & 0x7800) == 16384;
    }

    public static short getColixS(String colorName) {
        int argb = CU.getArgbFromString(colorName);
        if (argb != 0) {
            return C.getColix(argb);
        }
        if ("none".equalsIgnoreCase(colorName)) {
            return 0;
        }
        if ("opaque".equalsIgnoreCase(colorName)) {
            return 1;
        }
        return 2;
    }

    public static short[] getColixArray(String colorNames) {
        if (colorNames == null || colorNames.length() == 0) {
            return null;
        }
        String[] colors = PT.getTokens(colorNames);
        short[] colixes = new short[colors.length];
        for (int j = 0; j < colors.length; ++j) {
            colixes[j] = C.getColix(CU.getArgbFromString(colors[j]));
            if (colixes[j] != 0) continue;
            return null;
        }
        return colixes;
    }

    public static String getHexCode(short colix) {
        return Escape.escapeColor(C.getArgb(colix));
    }

    public static String getHexCodes(short[] colixes) {
        if (colixes == null) {
            return null;
        }
        SB s = new SB();
        for (int i = 0; i < colixes.length; ++i) {
            s.append(i == 0 ? "" : " ").append(C.getHexCode(colixes[i]));
        }
        return s.toString();
    }

    public static short getColixTranslucent(int argb) {
        int a = argb >> 24 & 0xFF;
        return a == 255 ? C.getColix(argb) : C.getColixTranslucent3(C.getColix(argb), true, (double)a / 255.0);
    }

    public static short getBgContrast(int argb) {
        return (CU.toFFGGGfromRGB(argb) & 0xFF) < 128 ? (short)8 : 4;
    }

    static {
        C.argbs[3] = -74566;
        colixHash = new Int2IntHash(256);
        int[] predefinedArgbs = new int[]{-16777216, -23296, -16181, -16776961, -1, -16711681, -65536, -16744448, -8355712, -4144960, -16711936, -8388608, -16777088, -8355840, -8388480, -16744320, -65281, -256, -38476, -10496};
        for (int i = 0; i < predefinedArgbs.length; ++i) {
            C.getColix(predefinedArgbs[i]);
        }
    }
}

