/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4d;
import javajs.util.P3d;
import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class SpinThread
extends JmolThread {
    private TransformManager transformManager;
    private double endDegrees;
    private int nFrames = -1;
    private Lst<P3d> endPositions;
    private P3d[][] centerAndPoints;
    private double[] dihedralList;
    private double nDegrees;
    private BS bsAtoms;
    private boolean isNav;
    private boolean isGesture;
    private double myFps;
    private double angle;
    private boolean haveNotified;
    private int index;
    private BS[] bsBranches;
    private boolean isDone = false;
    private M4d m4;
    private P3d ptemp;

    @Override
    public int setManager(Object manager, Viewer vwr, Object params) {
        this.transformManager = (TransformManager)manager;
        this.setViewer(vwr, "SpinThread");
        Object[] options = (Object[])params;
        if (options == null) {
            this.isNav = true;
        } else {
            this.endDegrees = ((Number)options[0]).doubleValue();
            this.endPositions = (Lst)options[1];
            this.dihedralList = (double[])options[2];
            if (this.dihedralList != null) {
                this.bsBranches = vwr.ms.getBsBranches(this.dihedralList);
            }
            this.bsAtoms = (BS)options[3];
            this.isGesture = options[4] != null;
            this.centerAndPoints = (P3d[][])options[5];
            if (this.centerAndPoints != null) {
                this.ptemp = new P3d();
                this.nFrames = (Integer)options[6];
            }
        }
        return 0;
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    this.myFps = this.isNav ? this.transformManager.navFps : this.transformManager.spinFps;
                    this.vwr.g.setB(this.isNav ? "_navigating" : "_spinning", true);
                    this.haveReference = true;
                    this.vwr.startHoverWatcher(false);
                    mode = 0;
                    break;
                }
                case 0: {
                    boolean isInMotion;
                    if (this.isReset || this.checkInterrupted(this.transformManager.spinThread)) {
                        mode = -2;
                        break;
                    }
                    if (this.isNav && this.myFps != this.transformManager.navFps) {
                        this.myFps = this.transformManager.navFps;
                        this.index = 0;
                        this.startTime = System.currentTimeMillis();
                    } else if (!this.isNav && this.myFps != this.transformManager.spinFps && this.bsAtoms == null) {
                        this.myFps = this.transformManager.spinFps;
                        this.index = 0;
                        this.startTime = System.currentTimeMillis();
                    }
                    if (this.myFps == 0.0 || !(!this.isNav ? this.transformManager.spinOn : this.transformManager.navOn)) {
                        mode = -2;
                        break;
                    }
                    boolean refreshNeeded = this.endDegrees >= 1.0E10 ? true : (this.isNav ? this.transformManager.navX != 0.0 || this.transformManager.navY != 0.0 || this.transformManager.navZ != 0.0 : this.transformManager.isSpinInternal && this.transformManager.internalRotationAxis.angle != 0.0 || this.transformManager.isSpinFixed && this.transformManager.fixedRotationAxis.angle != 0.0 || !this.transformManager.isSpinFixed && !this.transformManager.isSpinInternal && (this.transformManager.spinX != 0.0 || this.transformManager.spinY != 0.0 || this.transformManager.spinZ != 0.0));
                    this.targetTime = (long)((double)(++this.index * 1000) / this.myFps);
                    this.currentTime = System.currentTimeMillis() - this.startTime;
                    this.sleepTime = (int)(this.targetTime - this.currentTime);
                    if (this.sleepTime < 0) {
                        if (!this.haveNotified) {
                            Logger.info("spinFPS is set too fast (" + this.myFps + ") -- can't keep up!");
                        }
                        this.haveNotified = true;
                        this.startTime -= (long)this.sleepTime;
                        this.sleepTime = 0;
                    }
                    boolean bl = isInMotion = this.bsAtoms == null && this.vwr.getInMotion(false);
                    if (isInMotion) {
                        if (this.isGesture) {
                            mode = -2;
                            break;
                        }
                        this.sleepTime += 1000;
                    }
                    if (refreshNeeded && !isInMotion && (this.transformManager.spinOn || this.transformManager.navOn)) {
                        this.doTransform();
                    }
                    mode = 1;
                    break;
                }
                case 1: {
                    while (!this.checkInterrupted(this.transformManager.spinThread) && !this.vwr.getRefreshing()) {
                        if (this.runSleep(10, 1)) continue;
                        return;
                    }
                    if (this.bsAtoms != null || this.vwr.g.waitForMoveTo && this.endDegrees != Double.MAX_VALUE) {
                        this.vwr.requestRepaintAndWait("spin thread");
                    } else {
                        this.vwr.refresh(1, "SpinThread");
                    }
                    if (this.nFrames >= 0 && this.index >= this.nFrames || (this.endDegrees >= 1.0E10 ? this.nDegrees / this.endDegrees > 0.99 : (!this.isNav && this.endDegrees >= 0.0 ? this.nDegrees >= this.endDegrees - 0.001 : -this.nDegrees <= this.endDegrees + 0.001))) {
                        this.isDone = true;
                        this.transformManager.setSpinOff();
                    }
                    if (!this.runSleep(this.sleepTime, 0)) {
                        return;
                    }
                    mode = 0;
                    break;
                }
                case -2: {
                    if (this.dihedralList != null) {
                        this.vwr.setDihedrals(this.dihedralList, this.bsBranches, 0.0);
                    } else if (this.bsAtoms != null && this.endPositions != null) {
                        this.vwr.setAtomCoords(this.bsAtoms, 1145047049, this.endPositions);
                        this.bsAtoms = null;
                        this.endPositions = null;
                    }
                    if (!this.isReset) {
                        this.transformManager.setSpinOff();
                        this.vwr.startHoverWatcher(true);
                    }
                    this.stopped = !this.isDone;
                    this.resumeEval();
                    this.stopped = true;
                    return;
                }
            }
        }
    }

    private void doTransform() {
        if (this.centerAndPoints != null) {
            double f = (double)this.index * 1.0 / (double)this.nFrames;
            this.vwr.ms.morphAtoms(this.bsAtoms, this.centerAndPoints, 0, f, this.ptemp);
        } else if (this.dihedralList != null) {
            double f = 1.0 / this.myFps / this.endDegrees;
            this.vwr.setDihedrals(this.dihedralList, this.bsBranches, f);
            this.nDegrees += 1.0 / this.myFps;
        } else if (this.isNav) {
            this.transformManager.setNavigationOffsetRelative();
        } else if (this.transformManager.isSpinInternal || this.transformManager.isSpinFixed) {
            this.angle = (this.transformManager.isSpinInternal ? this.transformManager.internalRotationAxis : this.transformManager.fixedRotationAxis).angle / this.myFps;
            if (this.transformManager.isSpinInternal) {
                this.transformManager.rotateAxisAngleRadiansInternal(this.angle, this.bsAtoms, this.m4, false);
            } else {
                this.transformManager.rotateAxisAngleRadiansFixed(this.angle, this.bsAtoms);
            }
            this.nDegrees += Math.abs(this.angle * 57.29577951308232);
        } else {
            if (this.transformManager.spinX != 0.0) {
                this.transformManager.rotateXRadians(this.transformManager.spinX * (Math.PI / 180) / this.myFps, null);
            }
            if (this.transformManager.spinY != 0.0) {
                this.transformManager.rotateYRadians(this.transformManager.spinY * (Math.PI / 180) / this.myFps, null);
            }
            if (this.transformManager.spinZ != 0.0) {
                this.transformManager.rotateZRadians(this.transformManager.spinZ * (Math.PI / 180) / this.myFps);
            }
        }
    }
}

