/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javajs.util.BS;
import javajs.util.P3d;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.api.SymmetryInterface;
import org.jmol.shape.FontLineShape;
import org.jmol.util.Escape;
import org.jmol.util.Font;
import org.jmol.viewer.JC;

public class Axes
extends FontLineShape {
    public P3d axisXY = new P3d();
    public double scale;
    public P3d fixedOrigin;
    public final P3d originPoint = new P3d();
    public final P3d[] axisPoints = new P3d[6];
    public String[] labels;
    public String axisType;
    public String axes2;
    private static final double MIN_AXIS_LEN = 1.5;
    private final P3d pt0;
    public final P3d fixedOriginUC;
    V3d corner;

    public Axes() {
        int i = 6;
        while (--i >= 0) {
            this.axisPoints[i] = new P3d();
        }
        this.pt0 = new P3d();
        this.fixedOriginUC = new P3d();
        this.corner = new V3d();
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("position" == propertyName) {
            boolean doSetScale = this.axisXY.z == 0.0 && ((P3d)value).z != 0.0;
            this.axisXY = (P3d)value;
            this.setScale(doSetScale ? 1.0 : this.scale);
            return;
        }
        if ("origin" == propertyName) {
            if (value == null || ((P3d)value).length() == 0.0) {
                this.fixedOrigin = null;
            } else {
                if (this.fixedOrigin == null) {
                    this.fixedOrigin = new P3d();
                }
                this.fixedOrigin.setT((P3d)value);
            }
            this.reinitShape();
            return;
        }
        if ("labels" == propertyName) {
            this.labels = (String[])value;
            return;
        }
        if ("labelsOn" == propertyName) {
            this.labels = null;
            return;
        }
        if ("labelsOff" == propertyName) {
            this.labels = new String[]{"", "", ""};
            return;
        }
        if ("type" == propertyName) {
            this.axisType = (String)value;
            if ("abc".equals(this.axisType)) {
                this.axisType = null;
            }
        }
        if ("axes2" == propertyName) {
            this.axes2 = value == null || value.equals("") ? null : (String)value;
            return;
        }
        this.setPropFLS(propertyName, value);
    }

    @Override
    public void initShape() {
        this.translucentAllowed = false;
        this.myType = "axes";
        this.font3d = this.vwr.gdata.getFont3D(16.0);
        this.setPoints(this.vwr.g.axesMode);
    }

    public void setPoints(int axesMode) {
        SymmetryInterface unitcell;
        if (axesMode != 0x24000020 || this.ms.unitCells == null || (unitcell = this.vwr.getCurrentUnitCell()) == null) {
            this.originPoint.setT(this.fixedOrigin != null ? this.fixedOrigin : (axesMode == 603979809 ? this.vwr.getBoundBoxCenter() : this.pt0));
            this.setScale(this.vwr.getDouble(0x22000002) / 2.0);
            return;
        }
        T3d fset = unitcell.getUnitCellMultiplier();
        unitcell = unitcell.getUnitCellMultiplied();
        double voffset = this.vwr.getDouble(0x22000001);
        this.fixedOriginUC.set(voffset, voffset, voffset);
        P3d offset = unitcell.getCartesianOffset();
        P3d[] vertices = unitcell.getUnitCellVerticesNoOffset();
        this.originPoint.add2(offset, vertices[0]);
        if (voffset != 0.0) {
            unitcell.toCartesian(this.fixedOriginUC, false);
        } else if (this.fixedOrigin != null) {
            this.originPoint.setT(this.fixedOrigin);
        }
        if (voffset != 0.0) {
            this.originPoint.add(this.fixedOriginUC);
        }
        double scale = this.scale = this.vwr.getDouble(0x22000002) / 2.0;
        if (fset != null && fset.z > 0.0) {
            scale *= Math.abs(fset.z);
        }
        this.axisPoints[0].scaleAdd2(scale, vertices[4], this.originPoint);
        this.axisPoints[1].scaleAdd2(scale, vertices[2], this.originPoint);
        this.axisPoints[2].scaleAdd2(scale, vertices[1], this.originPoint);
    }

    public void reinitShape() {
        Font f = this.font3d;
        this.initShape();
        if (f != null) {
            this.font3d = f;
        }
    }

    public P3d getAxisPoint(int i, boolean actual, P3d ptTemp) {
        if (actual) {
            ptTemp.setT(this.axisPoints[i]);
        } else {
            ptTemp.sub2(this.axisPoints[i], this.originPoint);
            ptTemp.scale(0.5);
        }
        return ptTemp;
    }

    @Override
    public Object getProperty(String property, int index) {
        if (property == "originPoint") {
            return this.originPoint;
        }
        if (property == "axisPoints") {
            this.setPoints(this.vwr.g.axesMode);
            return this.axisPoints;
        }
        if (property == "axesTypeXY") {
            return this.axisXY.z == 0.0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (property == "origin") {
            return this.fixedOrigin;
        }
        return null;
    }

    void setScale(double scale) {
        this.scale = scale;
        this.corner.setT(this.vwr.getBoundBoxCornerVector());
        int i = 6;
        while (--i >= 0) {
            P3d axisPoint = this.axisPoints[i];
            axisPoint.setT(JC.unitAxisVectors[i]);
            if (this.corner.x < 1.5) {
                this.corner.x = 1.5;
            }
            if (this.corner.y < 1.5) {
                this.corner.y = 1.5;
            }
            if (this.corner.z < 1.5) {
                this.corner.z = 1.5;
            }
            if (this.axisXY.z == 0.0) {
                axisPoint.x *= this.corner.x * scale;
                axisPoint.y *= this.corner.y * scale;
                axisPoint.z *= this.corner.z * scale;
            }
            axisPoint.add(this.originPoint);
        }
    }

    public String getAxesState(SB sb) {
        sb.append("  axes scale ").appendD(this.vwr.getDouble(0x22000002)).append(";\n");
        if (this.fixedOrigin != null) {
            sb.append("  axes center ").append(Escape.eP(this.fixedOrigin)).append(";\n");
        }
        if (this.axisXY.z != 0.0) {
            sb.append("  axes position [").appendI((int)this.axisXY.x).append(" ").appendI((int)this.axisXY.y).append(" ").append(this.axisXY.z < 0.0 ? " %" : "").append("]");
        }
        if (this.axes2 != null) {
            sb.append(" ").append(PT.esc(this.axes2));
        }
        sb.append(";\n");
        if (this.labels != null) {
            sb.append("  axes labels ");
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] == null) continue;
                sb.append(PT.esc(this.labels[i])).append(" ");
            }
            sb.append(";\n");
        }
        if (this.axisType != null) {
            sb.append("  axes type " + PT.esc(this.axisType));
        }
        return sb.toString();
    }
}

