/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.BS;
import javajs.util.P3d;
import javajs.util.T3d;
import org.jmol.modelset.Atom;
import org.jmol.quantum.QMAtom;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public abstract class QuantumCalculation {
    protected boolean doDebug = false;
    protected BS bsExcluded;
    protected double integration = Double.NaN;
    protected static final double bohr_per_angstrom = 1.8897161646320724;
    protected double[][][] voxelData;
    public double[][][] voxelDataTemp;
    protected int[] countsXYZ;
    protected T3d[] points;
    public int xMin;
    public int xMax;
    public int yMin;
    public int yMax;
    public int zMin;
    public int zMax;
    protected QMAtom[] qmAtoms;
    protected int atomIndex;
    protected QMAtom thisAtom;
    protected int firstAtomOffset;
    protected double[] xBohr;
    protected double[] yBohr;
    protected double[] zBohr;
    protected double[] originBohr = new double[3];
    protected double[] stepBohr = new double[3];
    protected int nX;
    protected int nY;
    protected int nZ;
    public double[] X;
    public double[] Y;
    public double[] Z;
    public double[] X2;
    public double[] Y2;
    public double[] Z2;
    protected double rangeBohrOrAngstroms = 10.0;
    protected double unitFactor = 1.8897161646320724;
    protected double volume = 1.0;

    public double getIntegration() {
        return this.integration;
    }

    protected void initialize(int nX, int nY, int nZ, T3d[] points) {
        this.initialize0(nX, nY, nZ, points);
    }

    protected void initialize0(int nX, int nY, int nZ, T3d[] points) {
        if (points != null) {
            this.points = points;
            nY = nZ = points.length;
            nX = nZ;
        }
        this.nX = this.xMax = nX;
        this.nY = this.yMax = nY;
        this.nZ = this.zMax = nZ;
        if (this.xBohr != null && this.xBohr.length >= nX) {
            return;
        }
        this.xBohr = new double[nX];
        this.yBohr = new double[nY];
        this.zBohr = new double[nZ];
        this.X = new double[nX];
        this.Y = new double[nY];
        this.Z = new double[nZ];
        this.X2 = new double[nX];
        this.Y2 = new double[nY];
        this.Z2 = new double[nZ];
    }

    protected void setupCoordinates(double[] originXYZ, double[] stepsXYZ, BS bsSelected, T3d[] xyz, Atom[] atoms, T3d[] points, boolean renumber) {
        int i0;
        if (atoms == null) {
            atoms = (Atom[])xyz;
        }
        double[] range = new double[]{this.nX, this.nY, this.nZ};
        if (points == null) {
            this.volume = 1.0;
            int i = 3;
            while (--i >= 0) {
                this.originBohr[i] = originXYZ[i] * this.unitFactor;
                this.stepBohr[i] = stepsXYZ[i] * this.unitFactor;
                range[i] = stepsXYZ[i] * range[i] * this.unitFactor / 1.8897161646320724;
                this.volume *= this.stepBohr[i];
            }
            Logger.info("QuantumCalculation:\n origin = " + Escape.eAD(originXYZ) + "\n range (Ang) = " + Escape.eAD(range) + "\n steps (Bohr)= " + Escape.eAD(this.stepBohr) + "\n origin(Bohr)= " + Escape.eAD(this.originBohr) + "\n steps = " + Escape.eAD(this.stepBohr) + "\n counts= " + this.nX + " " + this.nY + " " + this.nZ);
        }
        if (atoms == null) {
            return;
        }
        this.qmAtoms = new QMAtom[renumber ? bsSelected.cardinality() : xyz.length];
        boolean isAll = bsSelected == null;
        int i = i0 = isAll ? this.qmAtoms.length - 1 : bsSelected.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            this.qmAtoms[renumber ? j++ : i] = new QMAtom(i, xyz[i], atoms[i], this.X, this.Y, this.Z, this.X2, this.Y2, this.Z2, this.unitFactor);
            i = isAll ? i - 1 : bsSelected.nextSetBit(i + 1);
        }
    }

    public double processPt(T3d pt) {
        this.doDebug = false;
        if (this.points == null || this.nX != 1) {
            this.initializeOnePoint();
        }
        this.points[0].setT(pt);
        this.voxelDataTemp[0][0][0] = 0.0;
        this.voxelData[0][0][0] = 0.0;
        this.setXYZBohr(this.points);
        this.processPoints();
        return this.voxelData[0][0][0];
    }

    protected void processPoints() {
        this.process();
    }

    protected void initializeOnePoint() {
        this.initializeOnePointQC();
    }

    protected void initializeOnePointQC() {
        this.points = new P3d[1];
        this.points[0] = new P3d();
        if (this.voxelData == null || this.voxelData == this.voxelDataTemp) {
            this.voxelDataTemp = new double[1][1][1];
            this.voxelData = this.voxelDataTemp;
        } else {
            this.voxelData = new double[1][1][1];
            this.voxelDataTemp = new double[1][1][1];
        }
        this.zMin = 0;
        this.yMin = 0;
        this.xMin = 0;
        this.initialize(1, 1, 1, this.points);
    }

    protected abstract void process();

    protected void setXYZBohr(T3d[] points) {
        this.setXYZBohrI(this.xBohr, 0, this.nX, points);
        this.setXYZBohrI(this.yBohr, 1, this.nY, points);
        this.setXYZBohrI(this.zBohr, 2, this.nZ, points);
    }

    private void setXYZBohrI(double[] bohr, int i, int n, T3d[] points) {
        if (points != null) {
            double x = 0.0;
            for (int j = 0; j < n; ++j) {
                switch (i) {
                    case 0: {
                        x = points[j].x;
                        break;
                    }
                    case 1: {
                        x = points[j].y;
                        break;
                    }
                    case 2: {
                        x = points[j].z;
                    }
                }
                bohr[j] = x * this.unitFactor;
            }
            return;
        }
        bohr[0] = this.originBohr[i];
        double inc = this.stepBohr[i];
        int j = 0;
        while (++j < n) {
            bohr[j] = bohr[j - 1] + inc;
        }
    }

    public void setMinMax(int ix) {
        this.zMax = ix < 0 ? this.xMax : ix + 1;
        this.yMax = this.zMax;
        this.zMin = ix < 0 ? 0 : ix;
        this.yMin = this.zMin;
    }

    public abstract void createCube();
}

