/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.BS;
import org.jmol.modelset.Atom;
import org.jmol.quantum.MepCalculation;
import org.jmol.util.Logger;

public class MlpCalculation
extends MepCalculation {
    public MlpCalculation() {
        this.distanceMode = 3;
    }

    @Override
    public void assignPotentials(Atom[] atoms, double[] potentials, BS bsAromatic, BS bsCarbonyl, BS bsIgnore, String data) {
        this.getAtomicPotentials(data, "atomicLipophilicity.txt");
        for (int i = 0; i < atoms.length; ++i) {
            double f = Math.abs(atoms[i].getFormalCharge());
            if (f == 0.0) {
                if (bsIgnore != null && bsIgnore.get(i)) {
                    f = Double.NaN;
                } else {
                    f = this.getTabulatedPotential(atoms[i]);
                    if (Double.isNaN(f)) {
                        switch (atoms[i].getElementNumber()) {
                            case 6: {
                                f = bsAromatic.get(i) ? (double)0.31f : (bsCarbonyl.get(i) ? -0.54 : 0.45);
                                break;
                            }
                            case 7: {
                                f = bsAromatic.get(i) ? -0.6 : (bsCarbonyl.get(i) ? -0.44 : -1.0);
                                break;
                            }
                            case 8: {
                                f = bsCarbonyl.get(i) ? -0.9 : -0.17;
                                break;
                            }
                            default: {
                                f = Double.NaN;
                            }
                        }
                    }
                }
            }
            if (Logger.debugging) {
                Logger.debug(atoms[i].getInfo() + " " + f);
            }
            potentials[i] = f;
        }
    }
}

