/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.viewer.Viewer;

class PltFormattedReader
extends VolumeFileReader {
    PltFormattedReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
        this.isAngstroms = true;
        this.jvxlData.wasCubic = true;
        this.jvxlFileHeaderBuffer = new SB();
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        int n1 = this.parseIntStr(this.rd());
        int n2 = this.parseInt();
        this.nPointsX = this.parseIntStr(this.rd());
        this.nPointsY = this.parseInt();
        this.nPointsZ = this.parseInt();
        this.jvxlFileHeaderBuffer.append("Plt formatted data (" + n1 + "," + n2 + ") " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " \nJmol " + Viewer.getJmolVersion() + '\n');
        this.volumetricOrigin.set(0.0, 0.0, 0.0);
        double xmin = this.parseDoubleStr(this.rd().substring(0, 12));
        double xmax = this.parseDoubleRange(this.line, 12, 24);
        double ymin = this.parseDoubleRange(this.line, 24, 36);
        double ymax = this.parseDoubleRange(this.line, 36, 48);
        double zmin = this.parseDoubleRange(this.line, 48, 60);
        double zmax = this.parseDoubleRange(this.line, 60, 72);
        this.volumetricOrigin.set(xmin, ymin, zmin);
        this.voxelCounts[0] = this.nPointsX;
        this.voxelCounts[1] = this.nPointsY;
        this.voxelCounts[2] = this.nPointsZ;
        this.volumetricVectors[0].set(0.0, 0.0, (xmax - xmin) / (double)this.nPointsX);
        this.volumetricVectors[1].set(0.0, (ymax - ymin) / (double)this.nPointsY, 0.0);
        this.volumetricVectors[2].set((zmax - zmin) / (double)this.nPointsZ, 0.0, 0.0);
    }
}

