/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import javajs.util.V3d;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;

class DelPhiBinaryReader
extends VolumeFileReader {
    private double[] data;
    private int pt;

    DelPhiBinaryReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        String fileName = (String)((Object[])sg.getReaderData())[0];
        this.init2VFR(sg, br);
        this.binarydoc = this.newBinaryDocument();
        this.setStream(fileName, false);
        this.nSurfaces = 1;
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.allowSigma = false;
        this.isAngstroms = true;
    }

    @Override
    protected void readParameters() throws Exception {
        int nx;
        String uplbl = this.readString();
        Logger.info(uplbl);
        String nxttoplbl = this.readString();
        Logger.info(nxttoplbl);
        this.data = this.readFloatArray();
        Logger.info("DelPhi data length: " + this.data.length);
        String botlbl = this.readString();
        Logger.info(botlbl);
        double[] scalemid = this.readFloatArray();
        double scale = scalemid[0];
        Logger.info("DelPhi scale: " + scale);
        double dx = scale == 1.0 ? 0.84375 : 1.0 / scale;
        this.volumetricVectors[0] = V3d.new3(0.0, 0.0, dx);
        this.volumetricVectors[1] = V3d.new3(0.0, dx, 0.0);
        this.volumetricVectors[2] = V3d.new3(dx, 0.0, 0.0);
        Logger.info("DelPhi resolution (pts/angstrom) set to: " + dx);
        this.voxelCounts[1] = this.voxelCounts[2] = (nx = 65);
        this.voxelCounts[0] = this.voxelCounts[2];
        Logger.info("DelPhi voxel counts: " + nx);
        this.volumetricOrigin.set(scalemid[1], scalemid[2], scalemid[3]);
        Logger.info("DelPhi center " + this.volumetricOrigin);
        this.volumetricOrigin.x -= (dx *= (double)((nx - 1) / 2));
        this.volumetricOrigin.y -= dx;
        this.volumetricOrigin.z -= dx;
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("DelPhi DATA ").append(nxttoplbl.replace('\n', ' ').trim()).append("\n\n");
    }

    private String readString() throws Exception {
        int n = this.binarydoc.readInt();
        byte[] buf = new byte[n];
        this.binarydoc.readByteArray(buf, 0, n);
        this.binarydoc.readInt();
        return new String(buf);
    }

    private double[] readFloatArray() throws Exception {
        int n = this.binarydoc.readInt() >> 2;
        double[] a = new double[n];
        for (int i = 0; i < n; ++i) {
            a[i] = this.binarydoc.readFloat();
        }
        this.binarydoc.readInt();
        return a;
    }

    @Override
    protected double nextVoxel() throws Exception {
        this.nBytes += 4L;
        return this.data[this.pt++];
    }

    @Override
    protected void skipData(int nPoints) throws Exception {
        this.pt += nPoints;
    }
}

