/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;

class CubeReader
extends VolumeFileReader {
    CubeReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
    }

    @Override
    protected void readParameters() throws Exception {
        int i;
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append(this.rd()).appendC('\n');
        this.jvxlFileHeaderBuffer.append(this.rd()).appendC('\n');
        String atomLine = this.rd();
        String[] tokens = PT.getTokensAt(atomLine, 0);
        this.ac = this.parseIntStr(tokens[0]);
        boolean bl = this.negativeAtomCount = this.ac < 0;
        if (this.negativeAtomCount) {
            this.ac = -this.ac;
        }
        this.volumetricOrigin.set(this.parseDoubleStr(tokens[1]), this.parseDoubleStr(tokens[2]), this.parseDoubleStr(tokens[3]));
        VolumeFileReader.checkAtomLine(this.isXLowToHigh, this.isAngstroms, tokens[0], atomLine, this.jvxlFileHeaderBuffer);
        if (!this.isAngstroms) {
            this.volumetricOrigin.scale(0.529177188873291);
        }
        for (i = 0; i < 3; ++i) {
            this.readVoxelVector(i);
        }
        for (i = 0; i < this.ac; ++i) {
            this.jvxlFileHeaderBuffer.append(this.rd() + "\n");
        }
        if (!this.negativeAtomCount) {
            this.nSurfaces = 1;
        } else {
            this.rd();
            Logger.info("Reading extra CUBE information line: " + this.line);
            this.nSurfaces = this.parseIntStr(this.line);
        }
    }
}

