/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.OC;
import javajs.util.P3d;
import javajs.util.Qd;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.Atom;
import org.jmol.util.C;
import org.jmol.util.Font;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public abstract class ___Exporter {
    protected boolean solidOnly;
    protected Viewer vwr;
    protected TransformManager tm;
    protected double privateKey;
    protected JmolRendererInterface export3D;
    protected OC out;
    protected String fileName;
    protected String commandLineOptions;
    protected GData gdata;
    protected short backgroundColix;
    protected int screenWidth;
    protected int screenHeight;
    protected int slabZ;
    protected int depthZ;
    protected V3d lightSource;
    protected P3d fixedRotationCenter;
    protected P3d referenceCenter;
    protected P3d cameraPosition;
    protected double cameraDistance;
    protected double apertureAngle;
    protected double scalePixelsPerAngstrom;
    protected double exportScale = 1.0;
    int exportType;
    protected static final double degreesPerRadian = 57.29577951308232;
    protected final P3d tempP1 = new P3d();
    protected final P3d tempP2 = new P3d();
    protected final P3d tempP3 = new P3d();
    protected final P3d center = new P3d();
    protected final V3d tempV1 = new V3d();
    protected final V3d tempV2 = new V3d();
    private boolean isWebGL;
    protected String commentChar;
    private final P3d tempC = new P3d();
    private int nText;
    private int nImage;
    public short lineWidthMad;

    boolean initializeOutput(Viewer vwr, double privateKey, GData gdata, Map<String, Object> params) {
        return this.initOutput(vwr, privateKey, gdata, params);
    }

    protected boolean initOutput(Viewer vwr, double privateKey, GData g3d, Map<String, Object> params) {
        this.vwr = vwr;
        this.tm = vwr.tm;
        this.isWebGL = params.get("type").equals("JS");
        this.gdata = g3d;
        this.privateKey = privateKey;
        this.backgroundColix = vwr.getObjectColix(0);
        this.center.setT(this.tm.fixedRotationCenter);
        this.exportScale = vwr.getDouble(0x2200000D);
        if (this.exportScale == 0.0) {
            this.exportScale = 10.0;
        }
        Logger.info("__Exporter exportScale: " + this.exportScale);
        if (this.screenWidth <= 0 || this.screenHeight <= 0) {
            this.screenWidth = vwr.getScreenWidth();
            this.screenHeight = vwr.getScreenHeight();
        }
        this.slabZ = g3d.slab;
        this.depthZ = g3d.depth;
        this.lightSource = g3d.getLightSource();
        P3d[] cameraFactors = vwr.tm.getCameraFactors();
        this.referenceCenter = cameraFactors[0];
        this.cameraPosition = cameraFactors[1];
        this.fixedRotationCenter = cameraFactors[2];
        this.cameraDistance = cameraFactors[3].x;
        this.apertureAngle = cameraFactors[3].y;
        this.scalePixelsPerAngstrom = cameraFactors[3].z;
        this.out = (OC)params.get("outputChannel");
        this.commandLineOptions = (String)params.get("params");
        if (this.out != null) {
            this.fileName = this.out.getFileName();
        }
        this.outputHeader();
        return true;
    }

    protected abstract void outputHeader();

    protected void output(String data) {
        this.out.append(data);
    }

    protected int getByteCount() {
        return this.out.getByteCount();
    }

    protected void outputComment(String comment) {
        if (this.commentChar != null) {
            this.output(this.commentChar + comment + "\n");
        }
    }

    protected static void setTempVertex(T3d pt, T3d offset, T3d ptTemp) {
        ptTemp.setT(pt);
        if (offset != null) {
            ptTemp.add(offset);
        }
    }

    protected void outputVertices(T3d[] vertices, int nVertices, T3d offset) {
        for (int i = 0; i < nVertices; ++i) {
            if (Double.isNaN(vertices[i].x)) continue;
            this.outputVertex(vertices[i], offset);
            this.output("\n");
        }
    }

    protected void outputVertex(T3d pt, T3d offset) {
        ___Exporter.setTempVertex(pt, offset, this.tempV1);
        this.output(this.tempV1);
    }

    protected abstract void output(T3d var1);

    protected void outputJmolPerspective() {
        this.outputComment(this.getJmolPerspective());
    }

    protected String getJmolPerspective() {
        if (this.commentChar == null) {
            return "";
        }
        SB sb = new SB();
        sb.append(this.commentChar).append("Jmol perspective:");
        sb.append("\n").append(this.commentChar).append("screen width height dim: " + this.screenWidth + " " + this.screenHeight + " " + this.vwr.getScreenDim());
        sb.append("\n").append(this.commentChar).append("perspectiveDepth: " + this.vwr.tm.perspectiveDepth);
        sb.append("\n").append(this.commentChar).append("cameraDistance(angstroms): " + this.cameraDistance);
        sb.append("\n").append(this.commentChar).append("aperatureAngle(degrees): " + this.apertureAngle);
        sb.append("\n").append(this.commentChar).append("scalePixelsPerAngstrom: " + this.scalePixelsPerAngstrom);
        sb.append("\n").append(this.commentChar).append("light source: " + this.lightSource);
        sb.append("\n").append(this.commentChar).append("lighting: " + this.vwr.getLightingState().replace('\n', ' '));
        sb.append("\n").append(this.commentChar).append("center: " + this.center);
        sb.append("\n").append(this.commentChar).append("rotationRadius: " + this.vwr.getDouble(0x2200002C));
        sb.append("\n").append(this.commentChar).append("boundboxCenter: " + this.vwr.getBoundBoxCenter());
        sb.append("\n").append(this.commentChar).append("translationOffset: " + this.tm.getTranslationScript());
        sb.append("\n").append(this.commentChar).append("zoom: " + this.vwr.tm.zmPct);
        sb.append("\n").append(this.commentChar).append("moveto command: " + this.vwr.getOrientation(4129, null, null, null));
        sb.append("\n");
        return sb.toString();
    }

    protected void outputFooter() {
    }

    protected String finalizeOutput() {
        return this.finalizeOutput2();
    }

    protected String finalizeOutput2() {
        this.outputFooter();
        if (this.out == null) {
            return null;
        }
        String ret = this.out.closeChannel();
        if (this.fileName == null) {
            return ret;
        }
        if (ret != null) {
            Logger.info(ret);
            return "ERROR EXPORTING FILE: " + ret;
        }
        return "OK " + this.out.getByteCount() + " " + this.export3D.getExportName() + " " + this.fileName;
    }

    protected String getExportDate() {
        return this.vwr.apiPlatform.getDateFormat(null);
    }

    protected String rgbFractionalFromColix(short colix) {
        return this.rgbFractionalFromArgb(this.gdata.getColorArgbOrGray(colix));
    }

    protected String getTriadC(T3d t) {
        return this.getTriad(t);
    }

    protected String getTriad(T3d t) {
        return ___Exporter.round(t.x) + " " + ___Exporter.round(t.y) + " " + ___Exporter.round(t.z);
    }

    protected String rgbFractionalFromArgb(int argb) {
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        this.tempC.set(red == 0 ? 0.0 : (double)(red + 1) / 256.0, green == 0 ? 0.0 : (double)(green + 1) / 256.0, blue == 0 ? 0.0 : (double)(blue + 1) / 256.0);
        return this.getTriadC(this.tempC);
    }

    protected static String translucencyFractionalFromColix(short colix) {
        return ___Exporter.round(C.getColixTranslucencyFractional(colix));
    }

    protected static String opacityFractionalFromColix(short colix) {
        return ___Exporter.round(1.0 - C.getColixTranslucencyFractional(colix));
    }

    protected static String opacityFractionalFromArgb(int argb) {
        int opacity = argb >> 24 & 0xFF;
        return ___Exporter.round(opacity == 0 ? 0.0 : (double)(opacity + 1) / 256.0);
    }

    /*
     * WARNING - void declaration
     */
    protected static String round(double number) {
        void var2_1;
        String s;
        return number == 0.0 ? "0" : (number == 1.0 ? "1" : ((s = "" + (double)Math.round(number * 1000.0) / 1000.0).startsWith("0.") ? s.substring(1) : (s.startsWith("-0.") ? "-" + s.substring(2) : (s.endsWith(".0") ? s.substring(0, s.length() - 2) : var2_1))));
    }

    protected static String round(T3d pt) {
        return ___Exporter.round(pt.x) + " " + ___Exporter.round(pt.y) + " " + ___Exporter.round(pt.z);
    }

    protected Lst<Short> getColorList(int i00, short[] colixes, int nVertices, BS bsSelected, Map<Short, Integer> htColixes) {
        int i0;
        int nColix = 0;
        Lst<Short> list = new Lst<Short>();
        boolean isAll = bsSelected == null;
        int i = i0 = isAll ? nVertices - 1 : bsSelected.nextSetBit(0);
        while (i >= 0) {
            Short color = colixes[i];
            if (!htColixes.containsKey(color)) {
                list.addLast(color);
                htColixes.put(color, i00 + nColix++);
            }
            i = isAll ? i - 1 : bsSelected.nextSetBit(i + 1);
        }
        return list;
    }

    protected static MeshSurface getConeMesh(P3d centerBase, M3d matRotateScale, short colix) {
        int i;
        MeshSurface ms = new MeshSurface();
        int ndeg = 10;
        int n = 360 / ndeg;
        ms.colix = colix;
        ms.vc = n + 1;
        ms.vs = new P3d[ms.vc];
        ms.pc = n;
        ms.pis = AU.newInt2(ms.pc);
        for (int i2 = 0; i2 < n; ++i2) {
            ms.pis[i2] = new int[]{i2, (i2 + 1) % n, n};
        }
        double d = (double)ndeg / 180.0 * Math.PI;
        for (i = 0; i < n; ++i) {
            double x = Math.cos((double)i * d);
            double y = Math.sin((double)i * d);
            ms.vs[i] = P3d.new3(x, y, 0.0);
        }
        ms.vs[n] = P3d.new3(0.0, 0.0, 1.0);
        if (matRotateScale != null) {
            ms.normals = new V3d[ms.vc];
            for (i = 0; i < ms.vc; ++i) {
                matRotateScale.rotate(ms.vs[i]);
                ms.normals[i] = V3d.newV(ms.vs[i]);
                ms.normals[i].normalize();
                ms.vs[i].add(centerBase);
            }
        }
        return ms;
    }

    protected M3d getRotationMatrix(P3d pt1, P3d pt2, double radius) {
        M3d m1;
        M3d m = new M3d();
        if (pt2.x == pt1.x && pt2.y == pt1.y) {
            m1 = M3d.newM3(null);
            if (pt1.z > pt2.z) {
                m1.m22 = -1.0;
                m1.m11 = -1.0;
            }
        } else {
            this.tempV1.sub2(pt2, pt1);
            this.tempV2.set(0.0, 0.0, 1.0);
            this.tempV2.cross(this.tempV2, this.tempV1);
            this.tempV1.cross(this.tempV1, this.tempV2);
            Qd q = Qd.getQuaternionFrameV(this.tempV2, this.tempV1, null, false);
            m1 = q.getMatrix();
        }
        m.m00 = radius;
        m.m11 = radius;
        m.m22 = pt2.distance(pt1);
        m1.mul(m);
        return m1;
    }

    protected M3d getRotationMatrix(P3d pt1, P3d ptZ, double radius, P3d ptX, P3d ptY) {
        M3d m = new M3d();
        m.m00 = ptX.distance(pt1) * radius;
        m.m11 = ptY.distance(pt1) * radius;
        m.m22 = ptZ.distance(pt1) * 2.0;
        Qd q = Qd.getQuaternionFrame(pt1, ptX, ptY);
        M3d m1 = q.getMatrix();
        m1.mul(m);
        return m1;
    }

    abstract void drawAtom(Atom var1, double var2);

    abstract void drawCircle(int var1, int var2, int var3, int var4, short var5, boolean var6);

    abstract boolean drawEllipse(P3d var1, P3d var2, P3d var3, short var4, boolean var5);

    void drawSurface(MeshSurface meshSurface, short colix) {
        int i0;
        int nVertices = meshSurface.vc;
        if (nVertices == 0) {
            return;
        }
        int nTriangles = 0;
        int nPolygons = meshSurface.pc;
        BS bsPolygons = meshSurface.bsPolygons;
        int faceVertexMax = meshSurface.haveQuads ? 4 : 3;
        int[][] indices = meshSurface.pis;
        boolean isAll = bsPolygons == null;
        int i = i0 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
        while (i >= 0) {
            nTriangles += faceVertexMax == 4 && indices[i].length == 4 ? 2 : 1;
            i = isAll ? i - 1 : bsPolygons.nextSetBit(i + 1);
        }
        if (nTriangles == 0) {
            return;
        }
        T3d[] vertices = meshSurface.getVertices();
        T3d[] normals = meshSurface.normals;
        boolean colorSolid = colix != 0;
        short[] colixes = colorSolid ? null : meshSurface.vcs;
        short[] polygonColixes = colorSolid ? meshSurface.pcs : null;
        Hashtable<Short, Integer> htColixes = null;
        Lst<Short> colorList = null;
        if (!this.isWebGL) {
            htColixes = new Hashtable<Short, Integer>();
            if (polygonColixes != null) {
                colorList = this.getColorList(0, polygonColixes, nPolygons, bsPolygons, htColixes);
            } else if (colixes != null) {
                colorList = this.getColorList(0, colixes, nVertices, null, htColixes);
            }
        }
        this.outputSurface(vertices, normals, colixes, indices, polygonColixes, nVertices, nPolygons, nTriangles, bsPolygons, faceVertexMax, colix, colorList, htColixes, meshSurface.offset);
    }

    protected void outputSurface(T3d[] vertices, T3d[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nTriangles, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3d offset) {
    }

    abstract void drawPixel(short var1, int var2, int var3, int var4, int var5);

    abstract void drawTextPixel(int var1, int var2, int var3, int var4);

    abstract void fillConeScreen(short var1, byte var2, int var3, P3d var4, P3d var5, boolean var6);

    abstract void drawCylinder(P3d var1, P3d var2, short var3, short var4, byte var5, int var6, int var7);

    abstract void fillCylinderScreenMad(short var1, byte var2, int var3, P3d var4, P3d var5);

    abstract void fillCylinderScreen(short var1, byte var2, int var3, P3d var4, P3d var5, P3d var6, P3d var7, double var8);

    abstract void fillEllipsoid(P3d var1, P3d[] var2, short var3, int var4, int var5, int var6, int var7, M3d var8, double[] var9, M4d var10, P3d[] var11);

    void drawFilledCircle(short colixRing, short colixFill, int diameter, int x, int y, int z) {
        if (colixRing != 0) {
            this.drawCircle(x, y, z, diameter, colixRing, false);
        }
        if (colixFill != 0) {
            this.drawCircle(x, y, z, diameter, colixFill, true);
        }
    }

    abstract void fillSphere(short var1, int var2, P3d var3);

    protected abstract void fillTriangle(short var1, T3d var2, T3d var3, T3d var4, boolean var5);

    protected int fixScreenZ(int z) {
        return z <= 3 ? z + (int)this.tm.cameraDistance : z;
    }

    void plotImage(int x, int y, int z, Object image, short bgcolix, int width, int height) {
        this.outputComment("start image " + ++this.nImage);
        this.gdata.plotImage(x, y, z, image, this.export3D, bgcolix, width, height);
        this.outputComment("end image " + this.nImage);
    }

    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
        this.outputComment("start text " + ++this.nText + ": " + text);
        this.gdata.plotText(x, y, z, this.gdata.getColorArgbOrGray(colix), 0, text, font3d, this.export3D);
        this.outputComment("end text " + this.nText + ": " + text);
    }
}

