/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3d;
import javajs.util.T3d;
import org.jmol.export.__CartesianExporter;

public class _MayaExporter
extends __CartesianExporter {
    private int nBalls = 0;
    private int nCyl = 0;
    private String name;
    private String id;

    public _MayaExporter() {
        this.commentChar = "// ";
    }

    @Override
    protected void outputHeader() {
        this.output("//  Maya ASCII 8.5 scene\n");
        this.output("//  Name: ball_stripped.ma\n");
        this.output("//  Last modified: Thu, Jul 5, 2007 10:25:55 PM\n");
        this.output("//  Codeset: UTF-8\n");
        this.output("requires maya \"8.5\";\n");
        this.output("currentUnit -l centimeter -a degree -t film;\n");
        this.output("fileInfo \"application\" \"maya\";\n");
        this.output("fileInfo \"product\" \"Maya Unlimited 8.5\";\n");
        this.output("fileInfo \"version\" \"8.5\";\n");
        this.output("fileInfo \"cutIdentifier\" \"200612170012-692032\";\n");
        this.output("fileInfo \"osv\" \"Mac OS X 10.4.9\";  \n");
    }

    private void addAttr() {
        this.output(" setAttr -k off \".v\";\n");
        this.output(" setAttr \".vir\" yes;\n");
        this.output(" setAttr \".vif\" yes;\n");
        this.output(" setAttr \".tw\" yes;\n");
        this.output(" setAttr \".covm[0]\"  0 1 1;\n");
        this.output(" setAttr \".cdvm[0]\"  0 1 1;\n");
    }

    private void addConnect() {
        this.output(" connectAttr \"make" + this.name + ".os\" \"" + this.id + ".cr\";\n");
        this.output("connectAttr \"" + this.id + ".iog\" \":initialShadingGroup.dsm\" -na;\n");
    }

    private void setAttr(String attr, double val) {
        this.output(" setAttr \"." + attr + "\" " + val + ";\n");
    }

    private void setAttr(String attr, int val) {
        this.output(" setAttr \"." + attr + "\" " + val + ";\n");
    }

    private void setAttr(String attr, T3d pt) {
        this.output(" setAttr \"." + attr + "\" -type \"double3\" " + pt.x + " " + pt.y + " " + pt.z + ";\n");
    }

    @Override
    protected boolean outputCylinder(P3d ptCenter, P3d pt1, P3d pt2, short colix, byte endcaps, double radius, P3d ptX, P3d ptY, boolean checkRadius) {
        if (ptX != null) {
            return false;
        }
        ++this.nCyl;
        this.name = "nurbsCylinder" + this.nCyl;
        this.id = "nurbsCylinderShape" + this.nCyl;
        this.output(" createNode transform -n \"" + this.name + "\";\n");
        double length = pt1.distance(pt2);
        this.tempV1.ave(pt2, pt1);
        this.setAttr("t", this.tempV1);
        this.tempV1.sub(pt1);
        this.tempV2.setT(this.tempV1);
        this.tempV2.normalize();
        double r = this.tempV1.length();
        double rX = Math.acos(this.tempV1.y / r) * 57.29577951308232;
        if (this.tempV1.x < 0.0) {
            rX += 180.0;
        }
        double rY = Math.atan2(this.tempV1.x, this.tempV1.z) * 57.29577951308232;
        this.tempV2.set(rX, rY, 0.0);
        this.setAttr("r", this.tempV2);
        this.output(" createNode nurbsSurface -n \"" + this.id + "\" -p \"" + this.name + "\";\n");
        this.addAttr();
        this.output("createNode makeNurbCylinder -n \"make" + this.name + "\";\n");
        this.output(" setAttr \".ax\" -type \"double3\" 0 1 0;\n");
        this.setAttr("r", radius);
        this.setAttr("s", 4);
        this.setAttr("hr", length / radius);
        this.addConnect();
        return true;
    }

    @Override
    protected void outputSphere(P3d pt, double radius, short colix, boolean checkRadius) {
        ++this.nBalls;
        this.name = "nurbsSphere" + this.nBalls;
        this.id = "nurbsSphereShape" + this.nBalls;
        this.output("createNode transform -n \"" + this.name + "\";\n");
        this.setAttr("t", pt);
        this.output("createNode nurbsSurface -n \"" + this.id + "\" -p \"" + this.name + "\";\n");
        this.addAttr();
        this.output("createNode makeNurbSphere -n \"make" + this.name + "\";\n");
        this.output(" setAttr \".ax\" -type \"double3\" 0 1 0;\n");
        this.setAttr("r", radius);
        this.setAttr("s", 4);
        this.setAttr("nsp", 3);
        this.addConnect();
    }

    @Override
    void drawTextPixel(int argb, int x, int y, int z) {
    }

    @Override
    protected void outputTextPixel(P3d pt, int argb) {
    }

    @Override
    protected void outputSurface(T3d[] vertices, T3d[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nTriangles, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3d offset) {
    }

    @Override
    protected void outputTriangle(T3d pt1, T3d pt2, T3d pt3, short colix) {
    }

    @Override
    protected void outputCircle(P3d pt1, P3d pt2, double radius, short colix, boolean doFill) {
    }

    @Override
    protected void outputCone(P3d ptBase, P3d ptTip, double radius, short colix) {
    }

    @Override
    protected void outputEllipsoid(P3d center, P3d[] points, short colix) {
    }

    @Override
    protected void outputFace(int[] is, int[] coordMap, int faceVertexMax) {
    }

    @Override
    protected void output(T3d pt) {
    }
}

