/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import javajs.util.AU;
import javajs.util.P3d;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.util.MeshSurface;

class MeshData {
    MeshData() {
    }

    static MeshSurface getCircleData() {
        int ndeg = 10;
        int n = 360 / ndeg;
        int vertexCount = n + 1;
        int[][] faces = AU.newInt2(n);
        for (int i = 0; i < n; ++i) {
            faces[i] = new int[]{i, (i + 1) % n, n};
        }
        T3d[] vertexes = new P3d[vertexCount];
        T3d[] normals = new P3d[vertexCount];
        for (int i = 0; i < n; ++i) {
            double x = Math.cos((double)(i * ndeg) / 180.0 * Math.PI);
            double y = Math.sin((double)(i * ndeg) / 180.0 * Math.PI);
            vertexes[i] = P3d.new3(x, y, 0.0);
            normals[i] = P3d.new3(0.0, 0.0, 1.0);
        }
        vertexes[n] = P3d.new3(0.0, 0.0, 0.0);
        normals[n] = P3d.new3(0.0, 0.0, 1.0);
        return MeshSurface.newMesh(false, vertexes, 0, faces, normals, 0);
    }

    static MeshSurface getTriangleData(T3d pt1, T3d pt2, T3d pt3) {
        T3d[] vertexes = new T3d[]{pt1, pt2, pt3};
        V3d v1 = V3d.newVsub(pt3, pt1);
        V3d v2 = V3d.newVsub(pt2, pt1);
        v2.cross(v2, v1);
        v2.normalize();
        T3d[] normals = new V3d[]{v2, v2, v2};
        int[][] faces = new int[][]{{0, 1, 2}};
        return MeshSurface.newMesh(false, vertexes, 0, faces, normals, 0);
    }

    static MeshSurface getConeData() {
        int ndeg = 10;
        int n = 360 / ndeg;
        T3d[] vertices = new P3d[n + 1];
        int[][] faces = AU.newInt2(n);
        for (int i = 0; i < n; ++i) {
            faces[i] = new int[]{i, (i + 1) % n, n};
        }
        double d = (double)ndeg / 180.0 * Math.PI;
        for (int i = 0; i < n; ++i) {
            double x = Math.cos((double)i * d);
            double y = Math.sin((double)i * d);
            vertices[i] = P3d.new3(x, y, 0.0);
        }
        vertices[n] = P3d.new3(0.0, 0.0, 1.0);
        return MeshSurface.newMesh(false, vertices, 0, faces, vertices, 0);
    }

    static MeshSurface getCylinderData(boolean inSide) {
        double y;
        double x;
        int i;
        int ndeg = 10;
        int vertexCount = 360 / ndeg * 2;
        int n = vertexCount / 2;
        int[][] faces = AU.newInt2(vertexCount);
        int fpt = -1;
        for (int i2 = 0; i2 < n; ++i2) {
            if (inSide) {
                faces[++fpt] = new int[]{i2 + n, (i2 + 1) % n, i2};
                faces[++fpt] = new int[]{i2 + n, (i2 + 1) % n + n, (i2 + 1) % n};
                continue;
            }
            faces[++fpt] = new int[]{i2, (i2 + 1) % n, i2 + n};
            faces[++fpt] = new int[]{(i2 + 1) % n, (i2 + 1) % n + n, i2 + n};
        }
        T3d[] vertexes = new P3d[vertexCount];
        T3d[] normals = new P3d[vertexCount];
        for (i = 0; i < n; ++i) {
            x = Math.cos((double)(i * ndeg) / 180.0 * Math.PI);
            y = Math.sin((double)(i * ndeg) / 180.0 * Math.PI);
            vertexes[i] = P3d.new3(x, y, 0.0);
            normals[i] = P3d.new3(x, y, 0.0);
        }
        for (i = 0; i < n; ++i) {
            x = Math.cos(((double)i + 0.5) * (double)ndeg / 180.0 * Math.PI);
            y = Math.sin(((double)i + 0.5) * (double)ndeg / 180.0 * Math.PI);
            vertexes[i + n] = P3d.new3(x, y, 1.0);
            normals[i + n] = normals[i];
        }
        if (inSide) {
            for (i = 0; i < n; ++i) {
                normals[i].scale(-1.0);
            }
        }
        return MeshSurface.newMesh(false, vertexes, 0, faces, normals, 0);
    }
}

