/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.BS;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class MopacReader
extends AtomSetCollectionReader {
    private boolean chargesFound = false;
    private boolean haveHeader;
    private int mopacVersion;

    @Override
    protected void initializeReader() throws Exception {
        while (this.mopacVersion == 0) {
            this.discardLinesUntilContains("MOPAC");
            if (this.line.indexOf("2009") >= 0) {
                this.mopacVersion = 2009;
                continue;
            }
            if (this.line.indexOf("6.") >= 0) {
                this.mopacVersion = 6;
                continue;
            }
            if (this.line.indexOf("7.") >= 0) {
                this.mopacVersion = 7;
                continue;
            }
            if (this.line.indexOf("93") >= 0) {
                this.mopacVersion = 93;
                continue;
            }
            if (this.line.indexOf("2002") >= 0) {
                this.mopacVersion = 2002;
                continue;
            }
            if (this.line.indexOf("MOPAC2") < 0) continue;
            this.mopacVersion = PT.parseInt(this.line.substring(this.line.indexOf("MOPAC2") + 5));
        }
        Logger.info("MOPAC version " + this.mopacVersion);
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (!this.haveHeader) {
            if (this.line.trim().equals("CARTESIAN COORDINATES")) {
                this.processCoordinates();
                this.asc.setAtomSetName("Input Structure");
                return true;
            }
            this.haveHeader = this.line.startsWith(" ---");
            return true;
        }
        if (this.line.indexOf("TOTAL ENERGY") >= 0) {
            this.processTotalEnergy();
            return true;
        }
        if (this.line.indexOf("ATOMIC CHARGES") >= 0) {
            this.processAtomicCharges();
            return true;
        }
        if (this.line.trim().equals("CARTESIAN COORDINATES")) {
            this.processCoordinates();
            return true;
        }
        if (this.line.indexOf("ORIENTATION OF MOLECULE IN FORCE") >= 0) {
            this.processCoordinates();
            this.asc.setAtomSetName("Orientation in Force Field");
            return true;
        }
        if (this.line.indexOf("NORMAL COORDINATE ANALYSIS") >= 0) {
            this.readFrequencies();
            return true;
        }
        return true;
    }

    void processTotalEnergy() {
    }

    void processAtomicCharges() throws Exception {
        int atomNumber;
        this.readLines(2);
        this.asc.newAtomSet();
        this.baseAtomIndex = this.asc.ac;
        int expectedAtomNumber = 0;
        while (this.rd() != null && (atomNumber = this.parseIntStr(this.line)) != Integer.MIN_VALUE) {
            if (atomNumber != ++expectedAtomNumber) {
                throw new Exception("unexpected atom number in atomic charges");
            }
            Atom atom = this.asc.addNewAtom();
            atom.elementSymbol = this.parseToken();
            atom.partialCharge = this.parseDouble();
        }
        this.chargesFound = true;
    }

    void processCoordinates() throws Exception {
        int atomNumber;
        String[] tokens;
        if (!this.chargesFound) {
            this.asc.newAtomSet();
            this.baseAtomIndex = this.asc.ac;
        } else {
            this.chargesFound = false;
        }
        Atom[] atoms = this.asc.atoms;
        while (this.rd().trim().length() == 0 || this.line.indexOf("ATOM") >= 0) {
        }
        while (this.line != null && (tokens = this.getTokens()).length != 0 && (atomNumber = this.parseIntStr(tokens[0])) != Integer.MIN_VALUE) {
            Atom atom = atoms[this.baseAtomIndex + atomNumber - 1];
            if (atom == null) {
                atom = this.asc.addNewAtom();
            }
            atom.atomSerial = atomNumber;
            this.setAtomCoordTokens(atom, tokens, 2);
            String elementSymbol = tokens[1];
            int atno = this.parseIntStr(elementSymbol);
            if (atno != Integer.MIN_VALUE) {
                elementSymbol = MopacReader.getElementSymbol(atno);
            }
            atom.elementSymbol = elementSymbol;
            this.rd();
        }
    }

    private void readFrequencies() throws Exception {
        String[] tokens;
        BS bsOK = new BS();
        int n0 = this.asc.iSet + 1;
        boolean done = false;
        while (!done && this.rd() != null && this.line.indexOf("DESCRIPTION") < 0 && this.line.indexOf("MASS-WEIGHTED") < 0) {
            if (this.line.toUpperCase().indexOf("ROOT") < 0) continue;
            this.discardLinesUntilNonBlank();
            tokens = this.getTokens();
            if (Double.isNaN(PT.parseDoubleStrict(tokens[tokens.length - 1]))) {
                this.discardLinesUntilNonBlank();
                tokens = this.getTokens();
            }
            int frequencyCount = tokens.length;
            this.rd();
            int iAtom0 = this.asc.ac;
            int ac = this.asc.getLastAtomSetAtomCount();
            boolean[] ignore = new boolean[frequencyCount];
            double freq1 = PT.parseDoubleStrict(tokens[0]);
            boolean ignoreNegative = freq1 < 0.0;
            for (int i = 0; i < frequencyCount; ++i) {
                boolean bl = done || (done = !ignoreNegative && PT.parseDoubleStrict(tokens[i]) < 1.0) || !this.doGetVibration(++this.vibrationNumber) ? true : (ignore[i] = false);
                if (ignore[i]) continue;
                bsOK.set(this.vibrationNumber - 1);
                this.asc.cloneLastAtomSet();
            }
            this.fillFrequencyData(iAtom0, ac, ac, ignore, false, 0, 0, null, 2, null);
        }
        String[][] info = new String[this.vibrationNumber][];
        if (this.line.indexOf("DESCRIPTION") < 0) {
            this.discardLinesUntilContains("DESCRIPTION");
        }
        while (this.discardLinesUntilContains("VIBRATION") != null) {
            tokens = this.getTokens();
            int freqNo = this.parseIntStr(tokens[1]);
            tokens[0] = PT.getTokens(this.rd())[1];
            if (tokens[2].equals("ATOM")) {
                tokens[2] = null;
            }
            info[freqNo - 1] = tokens;
            if (freqNo != this.vibrationNumber) continue;
            break;
        }
        int i = this.vibrationNumber - 1;
        while (--i >= 0) {
            if (info[i] != null) continue;
            info[i] = info[i + 1];
        }
        int n = n0;
        for (i = 0; i < this.vibrationNumber; ++i) {
            if (!bsOK.get(i)) continue;
            this.asc.iSet = n++;
            this.asc.setAtomSetFrequency(this.vibrationNumber, null, info[i][2], info[i][0], null);
        }
    }
}

