/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.V3d;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.GaussianReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class GaussianFchkReader
extends GaussianReader {
    private Map<String, Object> fileData;
    private int atomCount;
    private static String[] AO_TYPES = new String[]{"F7", "D5", "L", "S", "P", "D", "F", "G", "H"};

    @Override
    protected void initializeReader() throws Exception {
        super.initializeReader();
        this.energyUnits = "";
        this.fileData = new Hashtable<String, Object>();
        this.fileData.put("title", this.rd().trim());
        this.calculationType = PT.rep(this.rd(), "  ", " ");
        this.asc.newAtomSet();
        this.asc.setCurrentModelInfo("fileData", this.fileData);
        this.readAllData();
        this.readAtoms();
        this.readBonds();
        this.readDipoleMoment();
        this.readPartialCharges();
        this.readBasis();
        this.readMolecularObitals();
        this.checkForFreq();
        this.continuing = false;
    }

    private void checkForFreq() throws Exception {
        Integer n = (Integer)this.fileData.get("Vib-NDim");
        if (n == null) {
            this.readFrequencies("NumFreq", false);
            return;
        }
        try {
            int nModes = n;
            double[] vibE2 = (double[])this.fileData.get("Vib-E2");
            double[] modes = (double[])this.fileData.get("Vib-Modes");
            double[] frequencies = this.fillFloat(vibE2, 0, nModes);
            double[] red_masses = this.fillFloat(vibE2, nModes, nModes);
            double[] frc_consts = this.fillFloat(vibE2, nModes * 2, nModes);
            double[] intensities = this.fillFloat(vibE2, nModes * 3, nModes);
            int ac = this.asc.getLastAtomSetAtomCount();
            boolean[] ignore = new boolean[nModes];
            int fpt = 0;
            for (int i = 0; i < nModes; ++i) {
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i]) continue;
                int iAtom0 = this.asc.ac;
                this.asc.cloneAtomSetWithBonds(true);
                String name = this.asc.setAtomSetFrequency(this.vibrationNumber, "Calculation " + this.calculationNumber, null, "" + frequencies[i], null);
                this.appendLoadNote("model " + this.asc.atomSetCount + ": " + name);
                this.namedSets.set(this.asc.iSet);
                this.asc.setAtomSetModelProperty("ReducedMass", red_masses[i] + " AMU");
                this.asc.setAtomSetModelProperty("ForceConstant", frc_consts[i] + " mDyne/A");
                this.asc.setAtomSetModelProperty("IRIntensity", intensities[i] + " KM/Mole");
                for (int iAtom = 0; iAtom < ac; ++iAtom) {
                    this.asc.addVibrationVectorWithSymmetry(iAtom0 + iAtom, modes[fpt++], modes[fpt++], modes[fpt++], false);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Could not read Vib-E2 section: " + e.getMessage());
        }
    }

    private double[] fillFloat(double[] f0, int i, int n) {
        double[] f = new double[n];
        int i1 = 0;
        int ilast = i + n;
        while (i < ilast) {
            f[i1] = f0[i];
            ++i;
            ++i1;
        }
        return f;
    }

    private void readAllData() throws Exception {
        while ((this.line == null ? this.rd() : this.line) != null) {
            if (this.line.length() < 40) {
                if (this.line.indexOf("NumAtom") != 0) continue;
                return;
            }
            String name = PT.rep(this.line.substring(0, 40).trim(), " ", "");
            char type = this.line.charAt(43);
            boolean isArray = this.line.indexOf("N=") >= 0;
            String v = this.line.substring(50).trim();
            Logger.info(name + " = " + v + " " + isArray);
            Object o = null;
            if (isArray) {
                switch (type) {
                    case 'I': 
                    case 'R': {
                        o = this.fillDoubleArray(null, 0, new double[this.parseIntStr(v)]);
                        this.line = null;
                        break;
                    }
                    default: {
                        v = this.rd().trim();
                        while (this.rd() != null && this.line.indexOf("   N=   ") < 0) {
                            v = v + " " + this.line.trim();
                        }
                        o = v;
                        break;
                    }
                }
            } else {
                switch (type) {
                    case 'I': {
                        o = this.parseIntStr(v);
                        break;
                    }
                    case 'R': {
                        o = Double.parseDouble(v);
                        break;
                    }
                    case 'C': 
                    case 'L': {
                        o = v;
                    }
                }
                this.line = null;
            }
            if (o == null) continue;
            this.fileData.put(name, o);
        }
    }

    @Override
    protected void readAtoms() throws Exception {
        double[] atomNumbers = (double[])this.fileData.get("Atomicnumbers");
        double[] data = (double[])this.fileData.get("Currentcartesiancoordinates");
        String e = "" + this.fileData.get("TotalEnergy");
        this.asc.setAtomSetEnergy(e, this.parseDoubleStr(e));
        this.atomCount = atomNumbers.length;
        double f = 0.5291772;
        int pt = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)atomNumbers[i];
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            this.setAtomCoordXYZ(atom, data[pt++] * f, data[pt++] * f, data[pt++] * f);
        }
    }

    protected void readBonds() {
        try {
            double[] nBond = (double[])this.fileData.get("NBond");
            double[] iBond = (double[])this.fileData.get("IBond");
            if (nBond.length == 0) {
                return;
            }
            double[] rBond = (double[])this.fileData.get("RBond");
            int mxBond = rBond.length / nBond.length;
            int pt = 0;
            for (int ia = 0; ia < this.atomCount; ++ia) {
                int j = 0;
                while (j < mxBond) {
                    int ib = (int)iBond[pt] - 1;
                    if (ib > ia) {
                        double order = rBond[pt];
                        int iorder = order == 1.5 ? 515 : (int)order;
                        this.asc.addBond(new Bond(ia, ib, iorder));
                    }
                    ++j;
                    ++pt;
                }
            }
            this.addJmolScript("connect 1.1 {_H} {*} ");
        }
        catch (Exception e) {
            Logger.info("GaussianFchkReader -- bonding ignored");
        }
    }

    @Override
    protected void readDipoleMoment() throws Exception {
        double[] data = (double[])this.fileData.get("DipoleMoment");
        if (data == null) {
            return;
        }
        V3d dipole = V3d.new3(data[0], data[1], data[2]);
        Logger.info("Molecular dipole for model " + this.asc.atomSetCount + " = " + dipole);
        this.asc.setCurrentModelInfo("dipole", dipole);
    }

    @Override
    protected void readPartialCharges() throws Exception {
        double[] data = (double[])this.fileData.get("Mulliken Charges");
        if (data == null) {
            return;
        }
        Atom[] atoms = this.asc.atoms;
        for (int i = 0; i < this.atomCount; ++i) {
            double c;
            atoms[i].partialCharge = c = data[i];
            if (!(Math.abs(c) > 0.8)) continue;
            atoms[i].formalCharge = (int)Math.round(c);
        }
        Logger.info("Mulliken charges found for Model " + this.asc.atomSetCount);
    }

    @Override
    protected void readBasis() throws Exception {
        double[] types = (double[])this.fileData.get("Shelltypes");
        this.gaussianCount = 0;
        this.shellCount = 0;
        if (types == null) {
            return;
        }
        this.shellCount = types.length;
        this.shells = new Lst();
        double[] pps = (double[])this.fileData.get("Numberofprimitivespershell");
        double[] atomMap = (double[])this.fileData.get("Shelltoatommap");
        double[] exps = (double[])this.fileData.get("Primitiveexponents");
        double[] coefs = (double[])this.fileData.get("Contractioncoefficients");
        double[] spcoefs = (double[])this.fileData.get("P(S=P)Contractioncoefficients");
        this.gaussians = AU.newDouble2(exps.length);
        for (int i = 0; i < this.shellCount; ++i) {
            String oType = AO_TYPES[(int)types[i] + 3];
            int nGaussians = (int)pps[i];
            int iatom = (int)atomMap[i];
            int[] slater = new int[]{iatom, oType.equals("F7") || oType.equals("D5") ? BasisFunctionReader.getQuantumShellTagIDSpherical(oType.substring(0, 1)) : BasisFunctionReader.getQuantumShellTagID(oType), this.gaussianCount + 1, nGaussians};
            if (this.debugging) {
                Logger.debug("Slater " + this.shells.size() + " " + Escape.eAI(slater));
            }
            this.shells.addLast(slater);
            for (int j = 0; j < nGaussians; ++j) {
                this.gaussians[this.gaussianCount] = new double[3];
                double[] g = this.gaussians[this.gaussianCount];
                g[0] = exps[this.gaussianCount];
                g[1] = coefs[this.gaussianCount];
                if (spcoefs != null) {
                    g[2] = spcoefs[this.gaussianCount];
                }
                ++this.gaussianCount;
            }
        }
        Logger.info(this.shellCount + " slater shells read");
        Logger.info(this.gaussianCount + " gaussian primitives read");
    }

    protected void readMolecularObitals() throws Exception {
        if (this.shells == null) {
            return;
        }
        int nElec = (Integer)this.fileData.get("Numberofelectrons");
        int nAlpha = (Integer)this.fileData.get("Numberofalphaelectrons");
        int nBeta = (Integer)this.fileData.get("Numberofbetaelectrons");
        double[] aenergies = (double[])this.fileData.get("AlphaOrbitalEnergies");
        double[] benergies = (double[])this.fileData.get("BetaOrbitalEnergies");
        double[] acoefs = (double[])this.fileData.get("AlphaMOcoefficients");
        double[] bcoefs = (double[])this.fileData.get("BetaMOcoefficients");
        if (acoefs == null) {
            return;
        }
        int occ = bcoefs == null ? 2 : 1;
        int n = bcoefs == null ? nElec : nAlpha;
        this.getOrbitals(aenergies, acoefs, occ, n);
        if (bcoefs != null) {
            this.getOrbitals(benergies, bcoefs, occ, nBeta);
        }
        this.setMOData(false);
    }

    private void getOrbitals(double[] e, double[] c, int occ, int nElec) {
        int nOrb = e.length;
        int nCoef = c.length;
        nCoef /= nOrb;
        this.alphaBeta = occ == 2 ? "" : (this.alphaBeta.equals("alpha") ? "beta" : "alpha");
        int pt = 0;
        int n = 0;
        for (int i = 0; i < nOrb; ++i) {
            double[] coefs = new double[nCoef];
            for (int j = 0; j < nCoef; ++j) {
                coefs[j] = c[pt++];
            }
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            mo.put("coefficients", coefs);
            mo.put("occupancy", Double.valueOf(occ));
            if ((n += occ) >= nElec) {
                occ = 0;
            }
            mo.put("energy", e[i]);
            mo.put("type", this.alphaBeta);
            this.setMO(mo);
        }
    }
}

