/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import org.iupac.fairdata.api.IFDSerializableI;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.core.IFDObject;

public class IFDReference
implements IFDSerializableI {
    static int test;
    private final String resourceID;
    private Object originPath;
    private final String localDir;
    private final String localName;
    private String url;
    private String doi;
    private int index = ++test;
    private String insituExt;

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getDOI() {
        return this.doi;
    }

    public void setDOI(String doi) {
        this.doi = doi;
    }

    public IFDReference() {
        this(null, null, null, null);
    }

    public IFDReference(String resourceID, Object originPath, String localDir, String localName) {
        this.resourceID = resourceID;
        this.setOriginPath(originPath);
        this.localDir = localDir;
        this.localName = localName;
    }

    public Object getOriginPath() {
        return this.originPath;
    }

    public void setOriginPath(Object path) {
        this.originPath = path;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public String getlocalDir() {
        return this.localDir;
    }

    public String getLocalPath() {
        return (this.localDir == null ? "" : this.localDir + "/") + this.localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean checkInSitu() {
        String ext;
        if (this.originPath == null || this.localName == null) {
            return false;
        }
        String op = this.originPath.toString();
        if (op.indexOf("|") >= 0) {
            this.insituExt = "";
            return false;
        }
        int pt = this.localName.lastIndexOf(".");
        String string = ext = pt >= 0 ? this.localName.substring(pt) : "";
        if (pt >= 0 && !op.endsWith(ext)) {
            this.insituExt = ext;
            return false;
        }
        this.insituExt = "";
        return true;
    }

    public String toString() {
        return "[IFDReference " + this.index + " " + (this.localDir == null ? "" : this.localDir + "::") + this.originPath + ">as>" + this.localName + " url:" + this.url + " doi:" + this.doi + "]";
    }

    @Override
    public void serialize(IFDSerializerI serializer) {
        IFDObject.serializeClass(serializer, this.getClass(), null);
        if (this.resourceID != null) {
            serializer.addAttr("resourceID", this.resourceID);
        }
        if (this.doi != null) {
            serializer.addAttr("doi", this.doi);
        }
        if (this.url != null) {
            serializer.addAttr("url", this.url);
        }
        if (this.insituExt != null) {
            serializer.addAttr("localPath", this.originPath + this.insituExt);
        } else {
            if (this.originPath != null && !this.originPath.equals(this.doi) && !this.originPath.equals(this.url)) {
                serializer.addAttr("originPath", this.originPath.toString());
            }
            if (this.localName != null) {
                if (this.url != null || this.doi != null || this.localDir == null) {
                    serializer.addAttr("localName", this.localName);
                } else {
                    serializer.addAttr("localPath", this.getLocalPath());
                }
            }
        }
    }

    @Override
    public String getSerializedType() {
        return "IFDReference";
    }
}

