/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javajs.util.BS;
import javajs.util.PT;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.gennbo.File47AndFileCopy;
import org.gennbo.NBOConfig;
import org.gennbo.NBOFileHandler;
import org.gennbo.NBOModel;
import org.gennbo.NBOPlugin;
import org.gennbo.NBORun;
import org.gennbo.NBOSearch;
import org.gennbo.NBOService;
import org.gennbo.NBOUtil;
import org.gennbo.NBOView;
import org.jmol.c.CBK;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

public class NBODialog
extends JDialog {
    protected JLabel licenseInfo;
    private JButton helpBtn;
    private JButton helpBtn_M;
    private JButton helpBtn_R;
    private JButton helpBtn_V;
    private JButton helpBtn_S;
    private JButton helpBtn_Main;
    private JDialog settingsDialog;
    private JPanel topPanel;
    protected JButton modelButton;
    protected JButton runButton;
    protected JButton viewButton;
    protected JButton searchButton;
    protected JPanel settingsPanel;
    private JPanel homePanel;
    protected JPanel nboOutput;
    protected String lastOutputSaveName;
    protected NBOModel modelPanel;
    protected NBORun runPanel;
    private NBOSearch searchPanel;
    protected NBOView viewPanel;
    protected JPanel viewSettingsBox;
    protected static final int DIALOG_HOME = 0;
    protected static final int DIALOG_MODEL = 1;
    protected static final int DIALOG_RUN = 2;
    protected static final int DIALOG_VIEW = 3;
    protected static final int DIALOG_SEARCH = 4;
    protected static final int DIALOG_CONFIG = 5;
    protected static final int DIALOG_HELP = 6;
    private static final String[] dialogNames = new String[]{"Home", "Model", "Run", "View", "Search", "Settings", "Help"};
    protected static final int ORIGIN_UNKNOWN = 0;
    protected static final int ORIGIN_NIH = 1;
    protected static final int ORIGIN_LINE_FORMULA = 2;
    protected static final int ORIGIN_FILE_INPUT = 3;
    protected static final int ORIGIN_NBO_ARCHIVE = 4;
    protected int modelOrigin = 0;
    protected boolean jmolOptionNOZAP = false;
    protected boolean jmolOptionNOSET = false;
    protected boolean jmolOptionVIEW = false;
    protected boolean jmolOptionNONBO = false;
    protected Viewer vwr;
    protected NBOService nboService;
    protected NBOPlugin nboPlugin;
    protected String nboOutputBodyText = "";
    protected NBOFileHandler inputFileHandler;
    protected JLabel icon;
    protected JSplitPane centerPanel;
    protected JPanel modulePanel;
    protected JLabel statusLab;
    protected JTextPane jpNBODialog;
    protected boolean haveService;
    protected int dialogMode;
    protected NBOConfig config;
    private boolean isOpenShell;
    private boolean isCaretEnabled = true;
    private List<File47AndFileCopy> filecopy;
    Timer runTimer;
    private long runStartTime;
    protected boolean iAmLoading;

    protected static String getDialogName(int type) {
        return dialogNames[type];
    }

    protected void setJmolOptions(Map<String, Object> jmolOptions) {
        String options = ("" + (jmolOptions == null ? "" : jmolOptions.get("options"))).toUpperCase();
        if (options.equals("VIEW")) {
            options = "VIEW;NOZAP;NOSET;NONBO";
        }
        this.jmolOptionVIEW = options.indexOf("VIEW") >= 0;
        this.jmolOptionNOZAP = options.indexOf("NOZAP") >= 0;
        this.jmolOptionNOSET = options.indexOf("NOSET") >= 0;
        this.jmolOptionNONBO = options.indexOf("NONBO") >= 0;
    }

    protected void setCaretEnabled(boolean tf) {
        this.isCaretEnabled = tf;
        if (tf) {
            this.log("\n", 'b');
        }
    }

    public NBODialog(NBOPlugin plugin, JFrame jmolFrame, Viewer vwr, Map<String, Object> jmolOptions) {
        super(jmolFrame);
        this.setName(plugin.getName());
        this.setTitle(this.getName() + " " + plugin.getVersion());
        this.setJmolOptions(jmolOptions);
        this.vwr = vwr;
        this.nboPlugin = plugin;
        this.nboService = new NBOService(this, vwr, !this.jmolOptionNONBO);
        this.config = new NBOConfig(this);
        this.setIconImage(this.nboPlugin.getIcon("nbo7logo").getImage());
        this.setLayout(new BorderLayout());
        if (!this.jmolOptionNOSET) {
            this.runScriptQueued("zap;set nbocharges false;set antialiasdisplay;set fontscaling;set bondpicking true;set multipleBondSpacing -0.2; set multipleBondRadiusFactor 0.6;set zoomlarge false;select none;");
        }
        this.modelPanel = new NBOModel(this);
        this.runPanel = new NBORun(this);
        this.searchPanel = new NBOSearch(this);
        this.viewPanel = this.searchPanel;
        this.filecopy = new ArrayList<File47AndFileCopy>();
        this.createDialog(jmolFrame);
        if (!this.jmolOptionNOSET) {
            this.config.doSetDefaults(false);
        }
        if (this.jmolOptionVIEW || this.jmolOptionNONBO) {
            this.doOpenPanel(3);
        }
    }

    protected void doOpenPanel(int type) {
        int i;
        if (this.jmolOptionNONBO && "rsm".indexOf("" + type) >= 0) {
            this.vwr.alert("This option requires NBOServe");
            return;
        }
        if (type == 5) {
            this.settingsDialog.setVisible(true);
            return;
        }
        if (this.nboService.isWorking() && (i = JOptionPane.showConfirmDialog(this, "NBOServe is working. Cancel current job?\nThis could affect input/output files\nif GenNBO is running.", "Message", 0)) == 1) {
            return;
        }
        this.logCmd("Entering " + NBODialog.getDialogName(type));
        this.nboService.restartIfNecessary();
        this.nboService.clearQueue();
        if (!this.checkEnabled()) {
            this.doOpenPanel(5);
            return;
        }
        if (type != 5) {
            if (this.dialogMode == 0) {
                this.remove(this.homePanel);
                this.add((Component)this.centerPanel, "Center");
            }
            this.resetModuleVariables();
        }
        this.viewSettingsBox.setVisible(false);
        if (this.topPanel != null) {
            this.topPanel.remove(this.icon);
        }
        this.dialogMode = type;
        switch (this.dialogMode) {
            case 5: {
                break;
            }
            case 1: {
                this.modulePanel = this.modelPanel.buildModelPanel();
                this.centerPanel.setLeftComponent(this.modulePanel);
                this.icon = new JLabel(this.nboPlugin.getIcon("nbomodel_logo"));
                this.setThis(this.modelButton);
                break;
            }
            case 2: {
                this.modulePanel = this.runPanel.buildRunPanel();
                this.centerPanel.setLeftComponent(this.modulePanel);
                this.icon = new JLabel(this.nboPlugin.getIcon("nborun_logo"));
                this.setThis(this.runButton);
                break;
            }
            case 3: {
                this.modulePanel = this.viewPanel.buildViewPanel();
                this.centerPanel.setLeftComponent(this.modulePanel);
                this.icon = new JLabel(this.nboPlugin.getIcon("nboview_logo"));
                if (!NBOConfig.nboView) break;
                this.setThis(this.viewButton);
                break;
            }
            case 4: {
                this.modulePanel = this.searchPanel.buildSearchPanel();
                this.centerPanel.setLeftComponent(this.modulePanel);
                this.icon = new JLabel(this.nboPlugin.getIcon("nbosearch_logo"));
                this.setThis(this.searchButton);
            }
        }
        this.resetDivider();
        if (this.topPanel != null) {
            this.topPanel.add((Component)this.icon, "East");
        }
        this.setStatus("");
        this.invalidate();
        this.setVisible(true);
        this.runScriptQueued("image close;" + (this.jmolOptionNOZAP ? "select none" : "zap"));
    }

    private void resetModuleVariables() {
        this.viewPanel.resetCurrentOrbitalClicked();
        this.resetVariables_c();
    }

    private void createDialog(JFrame jmolFrame) {
        this.dialogMode = 0;
        Rectangle bounds = jmolFrame.getBounds();
        if (bounds.height < 662) {
            bounds.setBounds(bounds.x, bounds.y, 580, 662);
            jmolFrame.setSize(bounds.width, bounds.height);
        }
        this.setBounds(bounds.x + bounds.width, bounds.y, 650, Math.max(bounds.height, 662));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NBODialog.this.nboService.closeProcess(false);
                NBODialog.this.close();
            }
        });
        this.placeNBODialog(this);
        this.licenseInfo = new JLabel("License not found", 0);
        this.licenseInfo.setOpaque(true);
        this.licenseInfo.setForeground(Color.white);
        this.licenseInfo.setBackground(Color.black);
        this.createOutputDialog();
        this.centerPanel = new JSplitPane(1, new JPanel(), this.nboOutput);
        this.topPanel = this.buildTopPanel();
        this.homePanel = this.mainPage();
        this.getContentPane().add((Component)this.homePanel, "Center");
        this.getContentPane().add((Component)this.licenseInfo, "South");
        this.resetDivider();
        this.dialogMode = 0;
        this.getContentPane().add((Component)this.topPanel, "North");
        this.settingsDialog = new JDialog((Dialog)this, "Settings");
        this.settingsDialog.setSize(new Dimension(350, 400));
        this.settingsDialog.setLocation(this.getX() + 100, this.getY() + 100);
        this.settingsPanel = new JPanel();
        this.config.buildSettingsPanel(this.settingsPanel);
        this.settingsDialog.add(this.settingsPanel);
        this.setVisible(true);
        if (!this.jmolOptionNONBO && this.nboService.isOffLine()) {
            this.settingsDialog.setVisible(true);
        }
    }

    private void placeNBODialog(JDialog d) {
        Dimension screenSize = d.getToolkit().getScreenSize();
        Dimension size = d.getSize();
        int x = Math.min(screenSize.width - size.width, d.getParent().getX() + d.getParent().getWidth()) - 10;
        int y = d.getParent().getY();
        d.setLocation(x, y);
    }

    private JButton getMainButton(JButton b, final int mode, Font font) {
        b.setBorder(null);
        b.setMargin(new Insets(5, 5, 5, 5));
        b.setContentAreaFilled(false);
        b.setForeground(Color.white);
        b.setFont(font);
        switch (mode) {
            case 0: 
            case 6: {
                break;
            }
            default: {
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NBODialog.this.doOpenPanel(mode);
                    }
                });
            }
        }
        return b;
    }

    private JPanel buildTopPanel() {
        this.modelButton = new JButton("Model");
        this.runButton = new JButton("Run");
        this.viewButton = new JButton("View");
        this.searchButton = new JButton("Search");
        this.helpBtn = new HelpBtn(null);
        JPanel p = new JPanel(new BorderLayout());
        if (!this.jmolOptionNONBO) {
            Box b = Box.createHorizontalBox();
            b.add(Box.createRigidArea(new Dimension(20, 0)));
            b.add(this.getMainButton(this.modelButton, 1, NBOConfig.topFont));
            b.add(Box.createRigidArea(new Dimension(20, 0)));
            b.add(this.getMainButton(this.runButton, 2, NBOConfig.topFont));
            b.add(Box.createRigidArea(new Dimension(20, 0)));
            b.add(this.getMainButton(this.viewButton, 3, NBOConfig.topFont));
            b.add(Box.createRigidArea(new Dimension(20, 0)));
            b.add(this.getMainButton(this.searchButton, 4, NBOConfig.topFont));
            b.add(Box.createRigidArea(new Dimension(30, 50)));
            b.add(this.getMainButton(new JButton("Settings"), 5, NBOConfig.settingHelpFont));
            b.add(Box.createRigidArea(new Dimension(20, 0)));
            b.add(this.getMainButton(this.helpBtn, 6, NBOConfig.settingHelpFont));
            b.add(Box.createRigidArea(new Dimension(20, 0)));
            b.add(this.getMainButton(new HelpBtn("Manual", "NBOPro6_man.pdf", "NBOPro6"), 0, NBOConfig.settingHelpFont));
            p.add((Component)b, "Center");
        }
        this.icon = new JLabel();
        this.icon.setFont(NBOConfig.nboFont);
        this.icon.setForeground(Color.white);
        p.add((Component)this.icon, "East");
        p.setBackground(Color.BLACK);
        p.setPreferredSize(new Dimension(500, 60));
        return p;
    }

    private void setComponents(Component comp, Color foregroundColor, Color backgroundColor) {
        if (comp instanceof JTextField || comp instanceof JTextPane || comp instanceof JButton) {
            return;
        }
        if (comp instanceof JComboBox) {
            comp.setBackground(new Color(248, 248, 248));
        }
        if (foregroundColor != null) {
            comp.setForeground(foregroundColor);
        }
        if (backgroundColor != null) {
            comp.setBackground(backgroundColor);
        }
        if (comp instanceof Container) {
            for (Component c : ((Container)comp).getComponents()) {
                this.setComponents(c, foregroundColor, backgroundColor);
            }
        }
    }

    private JPanel mainPage() {
        JPanel p = new JPanel();
        p.setBackground(Color.white);
        this.haveService = this.nboService.restartIfNecessary();
        p.setLayout(new BoxLayout(p, 1));
        ImageIcon imageIcon = this.nboPlugin.getIcon("nbo7logo20x20");
        Image image = imageIcon.getImage();
        Image newimg = image.getScaledInstance(20, 20, 4);
        imageIcon = new ImageIcon(newimg);
        JLabel lab = new JLabel(imageIcon);
        Box b = Box.createHorizontalBox();
        b.add(lab);
        lab = new JLabel("NBOPro@Jmol toolbox");
        b.add(lab);
        b.add(Box.createRigidArea(new Dimension(370, 0)));
        this.icon.setOpaque(true);
        this.icon.setBackground(Color.LIGHT_GRAY);
        this.icon.setText(this.haveService ? "  Connected  " : "<html><center>Not<br>Connected</center></html>");
        this.icon.setForeground(this.haveService ? Color.black : Color.red);
        this.icon.setBorder(BorderFactory.createLineBorder(Color.black));
        p.add(b);
        JPanel titleAndHelpBtn = new JPanel();
        titleAndHelpBtn.setBackground(Color.WHITE);
        titleAndHelpBtn.setLayout(new BoxLayout(titleAndHelpBtn, 0));
        lab = new JLabel(this.getName());
        lab.setFont(NBOConfig.nboProTitleFont);
        lab.setForeground(Color.red);
        this.helpBtn_Main = new HelpBtn("Jmol_NBOPro6_help.htm");
        this.helpBtn_Main.setBackground(Color.RED);
        this.helpBtn_Main.setForeground(Color.white);
        titleAndHelpBtn.add(Box.createRigidArea(new Dimension(195, 5)));
        titleAndHelpBtn.add(lab);
        titleAndHelpBtn.add(Box.createRigidArea(new Dimension(166, 5)));
        titleAndHelpBtn.add(this.helpBtn_Main);
        lab.setAlignmentX(0.5f);
        p.add(titleAndHelpBtn);
        lab = new JLabel("Frank Weinhold, Dylan Phillips, Foo Zhi Yuan, Eric Glendening and Robert Hanson");
        lab.setAlignmentX(0.5f);
        p.add(lab);
        JPanel p2 = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        p2.setBorder(BorderFactory.createLineBorder(Color.black));
        JButton btn = new JButton("Model");
        this.helpBtn_M = new HelpBtn("model_help.htm");
        btn.setForeground(Color.WHITE);
        btn.setBackground(Color.BLUE);
        btn.setMinimumSize(new Dimension(150, 30));
        btn.setFont(NBOConfig.homeButtonFont);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.doOpenPanel(1);
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        p2.add((Component)btn, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 3;
        lab = new JLabel("  Create & edit molecular model and input files");
        p2.add((Component)lab, c);
        c.gridx = 6;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        p2.add((Component)this.helpBtn_M, c);
        c.gridx = 5;
        c.gridwidth = 1;
        p2.add(Box.createRigidArea(new Dimension(60, 10)), c);
        lab.setFont(NBOConfig.homeTextFont);
        JTextPane tp = new JTextPane();
        tp.setContentType("text/html");
        tp.setText("<HTML><center>Frank Weinhold<br><I>(Acknowledgments: Eric Glendening, John Carpenter, Mark Muyskens, Isaac Mades, Scott Ostrander, John Blair, Craig Weinhold)</I></center></HTML>");
        tp.setEditable(false);
        tp.setBackground(null);
        tp.setPreferredSize(new Dimension(430, 60));
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 3;
        c.fill = 2;
        p2.add((Component)tp, c);
        c.weightx = 0.0;
        btn = new JButton("Run");
        this.helpBtn_R = new HelpBtn("run_help.htm");
        btn.setForeground(Color.WHITE);
        btn.setBackground(Color.BLUE);
        btn.setMinimumSize(new Dimension(150, 30));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.doOpenPanel(2);
            }
        });
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        btn.setFont(NBOConfig.homeButtonFont);
        p2.add((Component)btn, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 3;
        lab = new JLabel("  Launch NBO analysis for chosen archive file");
        p2.add((Component)lab, c);
        c.gridx = 6;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        p2.add((Component)this.helpBtn_R, c);
        lab.setFont(NBOConfig.homeTextFont);
        tp = new JTextPane();
        tp.setContentType("text/html");
        tp.setBackground(null);
        tp.setText("<HTML><center>Eric Glendening, Jay Badenhoop, Alan Reed, John Carpenter, Jon Bohmann, Christine Morales, P. Karafiloglou, C. R. Landis, and Frank Weinhold</center></HTML>");
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 3;
        p2.add((Component)tp, c);
        btn = new JButton("View");
        this.helpBtn_V = new HelpBtn("view_help.htm");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.doOpenPanel(3);
            }
        });
        btn.setFont(NBOConfig.homeButtonFont);
        btn.setForeground(Color.WHITE);
        btn.setBackground(Color.BLUE);
        btn.setMinimumSize(new Dimension(150, 30));
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        p2.add((Component)btn, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 3;
        lab = new JLabel("  Display NBO orbitals in 1D/2D/3D imagery");
        p2.add((Component)lab, c);
        c.gridx = 6;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        p2.add((Component)this.helpBtn_V, c);
        lab.setFont(NBOConfig.homeTextFont);
        tp = new JTextPane();
        tp.setMaximumSize(new Dimension(430, 60));
        tp.setContentType("text/html");
        tp.setBackground(null);
        tp.setText("<HTML><center>Mark Wendt and Frank Weinhold<br><I> (Acknowledgments: Eric Glendening, John Carpenter, Mark Muyskens, Scott Ostrander, Zdenek Havlas, Dave Anderson)</I></center></HTML>");
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 3;
        p2.add((Component)tp, c);
        btn = new JButton("Search");
        this.helpBtn_S = new HelpBtn("search_help.htm");
        btn.setForeground(Color.WHITE);
        btn.setBackground(Color.BLUE);
        btn.setMinimumSize(new Dimension(150, 30));
        btn.setFont(NBOConfig.homeButtonFont);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.doOpenPanel(4);
            }
        });
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        p2.add((Component)btn, c);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 3;
        lab = new JLabel("  Search NBO output interactively");
        p2.add((Component)lab, c);
        c.gridx = 6;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        p2.add((Component)this.helpBtn_S, c);
        lab.setFont(NBOConfig.homeTextFont);
        tp = new JTextPane();
        tp.setMaximumSize(new Dimension(430, 60));
        tp.setContentType("text/html");
        tp.setBackground(null);
        tp.setText("<HTML><center>Frank Weinhold</center></HTML>");
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 3;
        p2.add((Component)tp, c);
        p.add(p2);
        JTextPane t = new JTextPane();
        t.setContentType("text/html");
        t.setText("<HTML><Font color=\"RED\"><center>\u00a9Copyright 2018 Board of Regents of the University of Wisconsin System on behalf of \nthe Theoretical Chemistry Institute.  All Rights Reserved</center></font></HTML>");
        t.setForeground(Color.RED);
        t.setBackground(null);
        t.setAlignmentX(0.5f);
        t.setMaximumSize(new Dimension(10000, 80));
        p.add(t);
        return p;
    }

    private void resetDivider() {
        this.centerPanel.setDividerLocation(360);
    }

    private void createOutputDialog() {
        this.nboOutput = new JPanel(new BorderLayout());
        this.viewSettingsBox = new JPanel(new BorderLayout());
        this.viewSettingsBox.add((Component)new JLabel("Settings"), "North");
        JPanel s = new JPanel(new BorderLayout());
        s.add((Component)this.viewSettingsBox, "North");
        this.viewSettingsBox.setVisible(!this.jmolOptionNONBO);
        this.nboOutput.add((Component)this.viewSettingsBox, "North");
        this.nboOutput.add((Component)s, "Center");
        JLabel lab = new JLabel("Session Dialog");
        lab.setFont(NBOConfig.monoFont);
        s.add((Component)lab, "First");
        JScrollPane p1 = new JScrollPane();
        if (this.jpNBODialog == null) {
            this.jpNBODialog = new JTextPane();
            this.jpNBODialog.setEditable(false);
            this.jpNBODialog.setBorder(null);
            this.nboOutputBodyText = "";
        }
        this.jpNBODialog.setContentType("text/html");
        this.setComponents(s, Color.WHITE, Color.BLACK);
        p1.getViewport().add(this.jpNBODialog);
        p1.setBorder(null);
        s.add((Component)p1, "Center");
        JPanel box = new JPanel(new GridLayout(2, 1));
        this.statusLab = new JLabel();
        this.statusLab.setForeground(Color.red);
        this.statusLab.setBackground(Color.white);
        this.statusLab.setFont(NBOConfig.statusFont);
        this.statusLab.setOpaque(true);
        box.add(this.statusLab);
        Box box2 = Box.createHorizontalBox();
        JButton clear = new JButton("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.doClearOutput();
            }
        });
        box2.add(clear);
        JButton btn = new JButton("Save Output");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.doSaveOutput();
            }
        });
        box2.add(btn);
        box.add(box2);
        s.add((Component)box, "South");
    }

    protected void doSaveOutput() {
        if (this.jpNBODialog == null) {
            return;
        }
        JFileChooser myChooser = new JFileChooser();
        if (this.lastOutputSaveName == null) {
            this.lastOutputSaveName = this.inputFileHandler.tfDir.getText() + "/nboDialog.txt";
        }
        String savePath = this.lastOutputSaveName;
        myChooser.setSelectedFile(new File(savePath));
        myChooser.setFileFilter(new FileNameExtensionFilter(".txt", ".txt"));
        myChooser.setFileHidingEnabled(true);
        int button = myChooser.showSaveDialog(this.jpNBODialog);
        if (button == 0) {
            this.saveDialogOutput(myChooser.getSelectedFile().toString());
        }
    }

    protected void saveDialogOutput(String saveFileName) {
        String output = this.nboOutputBodyText.replaceAll("<br>", NBOUtil.sep);
        output = output.replaceAll("<b>", "");
        output = output.replaceAll("</b>", "");
        output = output.replaceAll("<i>", "");
        output = output.replaceAll("</i>", "");
        this.inputFileHandler.writeToFile(saveFileName, output);
    }

    public void close() {
        this.restore47filesFromFileCopy();
        this.removeAll48Files();
        if (this.modulePanel != null) {
            this.inputFileHandler.clearInputFile(false);
        }
        this.runScriptQueued("select off");
        this.dispose();
    }

    private void setThis(JButton btn) {
        for (Component c : ((Container)this.topPanel.getComponent(0)).getComponents()) {
            if (!(c instanceof JButton)) continue;
            if (((JButton)c).equals(btn)) {
                btn.setEnabled(false);
                btn.setBorder(new LineBorder(Color.WHITE, 2));
                continue;
            }
            ((JButton)c).setBorder(null);
            ((JButton)c).setEnabled(true);
        }
        this.invalidate();
    }

    public void notifyCallback(CBK type, Object[] data) {
        if (!this.isVisible()) {
            return;
        }
        switch (type) {
            case STRUCTUREMODIFIED: {
                if (this.dialogMode != 1) break;
                break;
            }
            case PICK: {
                int[] picked = NBOUtil.getAtomsPicked(data);
                if (picked[0] < 0) {
                    return;
                }
                switch (this.dialogMode) {
                    case 1: {
                        this.modelPanel.notifyPick(picked);
                        return;
                    }
                    case 3: {
                        this.viewPanel.notifyPick_v(picked);
                        return;
                    }
                    case 4: {
                        this.searchPanel.notifyPick_s(picked);
                        return;
                    }
                }
                break;
            }
            case LOADSTRUCT: {
                if (this.vwr.ms.ac == 0) {
                    return;
                }
                String f = "" + this.vwr.getParameter("_modelFile");
                if (!this.iAmLoading) {
                    if (!f.endsWith(".47") && this.dialogMode != 1) {
                        this.doOpenPanel(1);
                        return;
                    }
                    if (this.dialogMode == 1) {
                        this.modelPanel.setModelNotFromNBO();
                    } else {
                        if (this.dialogMode != 2) {
                            this.doOpenPanel(2);
                            return;
                        }
                        if (f.startsWith("http")) {
                            this.runPanel.retrieveFile(f, null);
                            return;
                        }
                        if (f.startsWith("file:")) {
                            f = PT.trim(f.substring(5), "/");
                        }
                        if (!f.contains(":")) {
                            f = "/" + f;
                        }
                        this.inputFileHandler.loadSelectedFile(new File(f));
                        return;
                    }
                }
                this.iAmLoading = false;
                if (NBOConfig.nboView) {
                    this.runScriptQueued("select 1.1;color bonds lightgrey;wireframe 0.1;select none");
                }
                this.isOpenShell = false;
                ArrayList<String> l = new ArrayList<String>(this.vwr.ms.getModelAuxiliaryInfo(0).keySet());
                for (int i = 0; i < l.size(); ++i) {
                    if (!((String)l.get(i)).trim().equals("isOpenShell")) continue;
                    this.isOpenShell = true;
                }
                switch (this.dialogMode) {
                    case 1: {
                        this.modelPanel.notifyFileLoaded();
                        return;
                    }
                    case 2: {
                        this.runPanel.notifyFileLoaded();
                        return;
                    }
                    case 3: {
                        this.viewPanel.notifyFileLoaded_v();
                        return;
                    }
                    case 4: {
                        this.searchPanel.notifyFileLoaded_s();
                        return;
                    }
                }
            }
        }
    }

    protected void doClearOutput() {
        this.nboOutputBodyText = "";
        if (this.jpNBODialog != null) {
            this.jpNBODialog.setText("");
        }
    }

    protected void updatePanelSettings() {
        switch (this.dialogMode) {
            case 3: {
                this.viewPanel.doSetNewBasis(false, false);
            }
        }
    }

    void loadNewFile(File file) {
        this.viewPanel.isNewModel = true;
        switch (this.dialogMode) {
            case 3: {
                this.viewPanel.loadNewFileIfAble();
                break;
            }
            default: {
                this.loadModelFileQueued(file, false);
            }
        }
    }

    void setLicense(String data) {
        String[] lines = PT.split(data, "\n");
        this.licenseInfo.setText("<html><div style='text-align: center'>" + lines[1] + "</html>");
    }

    protected void setStatus(String statusInfo) {
        boolean isBusy = statusInfo != null && statusInfo.length() > 0;
        this.statusLab.setText(statusInfo);
        this.centerPanel.setCursor(Cursor.getPredefinedCursor(isBusy ? 3 : 0));
        if (isBusy) {
            this.logStatus(statusInfo);
            if (statusInfo.indexOf("...") >= 0) {
                if (this.runTimer != null) {
                    this.runTimer.stop();
                }
                this.runTimer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NBODialog.this.doShowRunTime();
                    }
                });
                this.runStartTime = System.currentTimeMillis();
                this.runTimer.setRepeats(true);
                this.runTimer.start();
            }
        } else if (this.runTimer != null) {
            this.runTimer.stop();
            this.runTimer = null;
        }
    }

    protected synchronized void doShowRunTime() {
        block3: {
            String t = this.statusLab.getText();
            int pt = t.indexOf("...");
            if (pt < 0) {
                return;
            }
            try {
                int time = (int)(System.currentTimeMillis() - this.runStartTime);
                int minutes = time / 60000;
                int seconds = time % 60000 / 1000;
                String s = "00" + seconds;
                s = minutes + ":" + s.substring(s.length() - 2);
                this.statusLab.setText(t.substring(0, pt + 3) + " " + s);
            }
            catch (Exception e) {
                if (this.runTimer == null) break block3;
                this.runTimer.stop();
                this.runTimer = null;
            }
        }
    }

    protected void showSelected(String s) {
        BS bs = new BS();
        for (String x : PT.getTokens(s)) {
            bs.set(Integer.parseInt(x) - 1);
        }
        String script = "select on " + bs + ";";
        this.runScriptQueued(script);
    }

    protected String getJmolWorkingPath() {
        String path = JmolPanel.getJmolProperty((String)"workingPath", (String)System.getProperty("user.home"));
        this.saveWorkingPath(path);
        return path;
    }

    protected String getWorkingPath() {
        String path = this.nboPlugin.getNBOProperty("workingPath", null);
        return path == null ? this.getJmolWorkingPath() : path;
    }

    protected void saveWorkingPath(String path) {
        this.nboPlugin.setNBOProperty("workingPath", path);
    }

    protected static void colorMeshes() {
    }

    protected void resetVariables_c() {
    }

    protected void alertRequiresNBOServe() {
        this.vwr.alert("This functionality requires NBOServe.");
    }

    protected void logCmd(String msg) {
        this.log(msg, 'I');
    }

    protected void logValue(String msg) {
        this.log(msg, 'b');
    }

    protected void logStatus(String msg) {
        this.log(msg, 'p');
    }

    protected void logError(String msg) {
        this.log(msg, 'r');
    }

    protected synchronized void log(String line, char chFormat) {
        if (this.dontLog(line, chFormat)) {
            return;
        }
        if (line.equals("\n") || line.trim().length() >= 1) {
            String format0;
            line = PT.rep(line.trim(), "<", "&lt;");
            line = PT.rep(line, ">", "&gt;");
            line = PT.rep(line, "&lt;br&gt;", "<br>");
            String format1 = format0 = "" + chFormat;
            if (chFormat == 'r') {
                format0 = "b style=color:red";
                format1 = "b";
                this.setStatus("");
            }
            if (!format0.equals("p")) {
                line = "<" + format0 + ">" + line + "</" + format1 + ">";
            }
            this.nboOutputBodyText = this.nboOutputBodyText + line + "\n<br>";
            this.jpNBODialog.setText("<html><font face=\"Arial\">" + this.nboOutputBodyText + "</font></html>");
        }
        if (this.isCaretEnabled) {
            this.jpNBODialog.setCaretPosition(this.jpNBODialog.getDocument().getLength());
        }
    }

    private boolean dontLog(String line, char chFormat) {
        return this.jpNBODialog == null || line.indexOf("read/unit=5/attempt to read past end") >= 0 || line.indexOf("*end*") >= 0 || !NBOConfig.debugVerbose && "b|r|I".indexOf("" + chFormat) < 0;
    }

    protected void alertError(String line) {
        line = PT.rep(line.replace('\r', ' '), "\n\n", "\n");
        this.logError(line);
        this.vwr.alert(line);
    }

    protected void logInfo(String msg, int mode) {
        Logger.info(msg);
        this.log(msg, (char)(mode == 4 ? 112 : (mode == 2 ? 114 : (mode == 3 ? 98 : 105))));
    }

    protected void runScriptQueued(String script) {
        this.logInfo("_$ " + PT.rep(script, "\n", "<br>"), 5);
        this.vwr.script(script);
    }

    protected void loadModelFileQueued(File f, boolean saveOrientation) {
        saveOrientation = false;
        this.iAmLoading = true;
        String s = "load \"" + f.getAbsolutePath().replace('\\', '/') + "\"" + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;";
        if (saveOrientation) {
            s = "save orientation o1;" + s + ";restore orientation o1";
        }
        this.runScriptQueued(s);
    }

    protected void loadModelDataQueued(String s) {
        this.iAmLoading = true;
        this.runScriptQueued(s);
    }

    protected String loadModelFileNow(String s) {
        String script = "load " + s.replace('\\', '/');
        this.logInfo("!$ " + script, 5);
        script = script.replace('\"', '\'');
        return PT.trim(this.vwr.runScript(script), "\n");
    }

    public String getCFIData() {
        return this.evaluateJmolString("data({*},'cfi')");
    }

    protected boolean checkEnabled() {
        return this.jmolOptionNONBO || this.nboService.isEnabled() && this.nboService.restartIfNecessary();
    }

    String evaluateJmolString(String expr) {
        return this.vwr.evaluateExpressionAsVariable(expr).asString();
    }

    protected String getJmolFilename() {
        return this.evaluateJmolString("getProperty('filename')");
    }

    protected void getNewInputFileHandler(int mode) {
        this.inputFileHandler = new NBOFileHandler(this.inputFileHandler == null ? "" : this.inputFileHandler.jobStem, "47", mode, "47", this);
    }

    protected void doSetStructure(String type) {
        this.doSearchSetResStruct(type, -1);
    }

    protected void doSearchSetResStruct(String type, int rsNum) {
        if (type == null || !this.isOpenShell() && type.equals("beta")) {
            type = "alpha";
        }
        String script = "measurements off;isosurface off;select 1.1;select 1.1;color labels white;select 1.1 & _H;color labels " + (NBOConfig.nboView ? "black" : "gray") + ";set labeloffset 0 0 {1.1}; select none;;select 1.1;connect nbo " + type + (rsNum >= 0 ? "_" + (rsNum + 1) : "") + (NBOConfig.showAtNum ? "; label %[nbo];" : "off");
        if (NBOConfig.nboView) {
            script = script + "select 1.1;color bonds lightgrey;wireframe 0.1;";
        }
        script = script + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;";
        this.runScriptQueued(script);
    }

    public void convertUnix2Dos(String workingDirectory, String jobstem, String extension) {
        if (workingDirectory == null || jobstem == null || extension == null || workingDirectory.equals("") || jobstem.equals("") || extension.equals("")) {
            return;
        }
        if (!extension.equals("47") && !extension.equals("47$")) {
            return;
        }
        try {
            String filename = jobstem + "." + extension;
            String executablePath = this.nboService.getServerPath(null);
            Path filePath = Paths.get(workingDirectory, filename);
            Path unix2dos = Paths.get(executablePath, "unix2dos");
            Process process = Runtime.getRuntime().exec(unix2dos.toString() + " " + filePath);
            process.waitFor();
        }
        catch (InterruptedException e) {
            this.logError("Sleep Interrupted");
        }
        catch (IOException ex) {
            String s = ex.getMessage();
            System.out.println(s);
            if (s.contains("error=1455")) {
                s = "Jmol can't do that - low on memory";
            }
            this.logError(s);
        }
    }

    boolean backupFileExists(String jobName) {
        for (int i = 0; i < this.filecopy.size(); ++i) {
            File47AndFileCopy pair = this.filecopy.get(i);
            if (!pair.getJobname().equals(jobName)) continue;
            return true;
        }
        return false;
    }

    void insertNewFileCopy(File47AndFileCopy filePair) {
        if (filePair != null) {
            this.filecopy.add(filePair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restore47filesFromFileCopy() {
        int i;
        FileInputStream sourceFilecopy = null;
        FileOutputStream destinationFile47 = null;
        for (i = 0; i < this.filecopy.size(); ++i) {
            File47AndFileCopy filePair = this.filecopy.get(i);
            String file47_path = filePair.getFile47();
            String fileCopy_path = filePair.getFilecopy();
            File file47 = new File(file47_path);
            File filecopy = new File(fileCopy_path);
            try {
                sourceFilecopy = new FileInputStream(filecopy);
                destinationFile47 = new FileOutputStream(file47, false);
                destinationFile47.getChannel().transferFrom(sourceFilecopy.getChannel(), 0L, sourceFilecopy.getChannel().size());
                continue;
            }
            catch (IOException ex) {
                this.logInfo("Could not restore file " + file47_path + " to its original state.\nThe file47 might now be corrupted.", 2);
                continue;
            }
            finally {
                try {
                    if (sourceFilecopy != null) {
                        sourceFilecopy.close();
                    }
                    if (destinationFile47 != null) {
                        destinationFile47.close();
                    }
                }
                catch (IOException ex) {
                    this.logInfo("Could not close file " + file47_path, 2);
                }
            }
        }
        for (i = 0; i < this.filecopy.size(); ++i) {
            String fileCopy_path = this.filecopy.get(i).getFilecopy();
            File file = new File(fileCopy_path);
            file.delete();
        }
        this.filecopy.clear();
    }

    private File[] finder(String directory) {
        File dir = new File(directory);
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".48");
            }
        });
    }

    void removeAll48Files() {
        Path exec;
        int i;
        File[] f;
        Path path;
        String ExecutablePath = this.nboService.getServerPath(null);
        String userWorkingPath = this.getWorkingPath();
        if (userWorkingPath != null && userWorkingPath != "" && Files.exists(path = Paths.get(userWorkingPath, new String[0]), new LinkOption[0])) {
            f = this.finder(userWorkingPath);
            for (i = 0; i < f.length; ++i) {
                f[i].delete();
            }
        }
        if (ExecutablePath != null && ExecutablePath != "" && Files.exists(exec = Paths.get(ExecutablePath, new String[0]), new LinkOption[0])) {
            f = this.finder(ExecutablePath);
            for (i = 0; i < f.length; ++i) {
                f[i].delete();
            }
        }
    }

    protected boolean isOpenShell() {
        return this.isOpenShell;
    }

    class HelpBtn
    extends JButton {
        String page;

        protected HelpBtn(String page) {
            this("Help", page, null);
        }

        protected HelpBtn(String label, String page, String tooltip) {
            super(label);
            this.setBackground(Color.black);
            this.setForeground(Color.white);
            this.page = page;
            tooltip = "Help for " + (tooltip != null ? tooltip : (page == null || page.length() == 1 ? "this module" : page));
            this.setToolTipText(tooltip);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    HelpBtn.this.doHelp();
                }
            });
        }

        protected void doHelp() {
            NBODialog.this.vwr.showUrl("http://nbo7.chem.wisc.edu/jmol_help/" + this.getHelpPage());
        }

        protected String getHelpPage() {
            if (this.page != null) {
                return this.page;
            }
            switch (NBODialog.this.dialogMode) {
                case 1: {
                    return "model_help.htm";
                }
                case 2: {
                    return "run_help.htm";
                }
                case 3: {
                    return "view_help.htm";
                }
                case 4: {
                    return "search_help.htm";
                }
            }
            return "Jmol_NBOPro6_help.htm";
        }
    }
}

