/*
 * Decompiled with CFR 0.152.
 */
package jme.ocl;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.MolfileCreator;
import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SVGDepictor;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.moreparsers.CDXParser;
import com.actelion.research.chem.moreparsers.InChIKeyParser;
import com.actelion.research.chem.moreparsers.InChIParser;
import com.actelion.research.gui.generic.GenericRectangle;
import jme.JMEmol;
import jme.core.Atom;
import jme.core.Bond;
import jme.core.JMECore;
import jme.gui.GUI;
import jme.io.JMEReader;
import jme.io.JMESVGWriter;

public class OclAdapter {
    public String getOclCode(String molFile) {
        String result = null;
        StereoMolecule mol = new StereoMolecule();
        if (new MolfileParser().parse(mol, molFile)) {
            result = mol.getIDCode();
        }
        return result;
    }

    public String getOclSVG(String molFile) {
        double width = 400.0;
        double height = 300.0;
        StereoMolecule mol = new StereoMolecule();
        if (new MolfileParser().parse(mol, molFile)) {
            JMESVGWriter svgd = new JMESVGWriter(mol, molFile);
            svgd.setLegacyMode(false);
            svgd.validateView(null, new GenericRectangle(0.0, 0.0, width, height), 131072);
            svgd.paint(null);
            return ((SVGDepictor)svgd).toString();
        }
        return null;
    }

    public String OclCodeToMOL(String oclCode) {
        StereoMolecule mol = new IDCodeParser().getCompactMolecule(oclCode.trim());
        MolfileCreator mfc = new MolfileCreator(mol);
        return mfc.getMolfile();
    }

    public String SMILEStoMOL(String smiles) throws Exception {
        if (smiles == null || smiles.length() == 0 || smiles.trim().length() == 0) {
            return new JMEmol().createMolFile("");
        }
        StereoMolecule mol = new StereoMolecule();
        new SmilesParser().parse(mol, smiles.trim());
        MolfileCreator mfc = new MolfileCreator(mol);
        return mfc.getMolfile();
    }

    public String v3000toV2000MOL(String v3000Mol) {
        StereoMolecule mol = new StereoMolecule();
        boolean success = new MolfileParser().parse(mol, v3000Mol);
        if (success) {
            MolfileCreator mfc = new MolfileCreator(mol);
            return mfc.getMolfile();
        }
        return null;
    }

    public String inchiToMOL(String inchi) {
        StereoMolecule mol = new StereoMolecule();
        boolean success = new InChIParser().parse(mol, inchi);
        if (success) {
            MolfileCreator mfc = new MolfileCreator(mol);
            return mfc.getMolfile();
        }
        return null;
    }

    public String inchikeyToMOL(String inchikey) {
        StereoMolecule mol = new StereoMolecule();
        boolean success = new InChIKeyParser().parse(mol, inchikey);
        if (success) {
            MolfileCreator mfc = new MolfileCreator(mol);
            return mfc.getMolfile();
        }
        return null;
    }

    public String cdxmlToMOL(String xml) {
        StereoMolecule mol = new StereoMolecule();
        boolean success = new CDXParser().parse(mol, xml);
        if (success) {
            MolfileCreator mfc = new MolfileCreator(mol);
            return mfc.getMolfile();
        }
        return null;
    }

    public String cdxToMOL(byte[] bytes) {
        StereoMolecule mol = new StereoMolecule();
        boolean success = new CDXParser().parse(mol, bytes);
        if (success) {
            MolfileCreator mfc = new MolfileCreator(mol);
            return mfc.getMolfile();
        }
        return null;
    }

    public static JMEmol compute2Dcoordinates(JMEmol mol) {
        String molFile;
        StereoMolecule oclMol;
        JMEmol result = mol;
        JMEmol molCopy = mol;
        boolean hasExplicitHydrogens = mol.hasHydrogen();
        if (hasExplicitHydrogens) {
            molCopy = mol.deepCopy();
            for (int i = 1; i <= molCopy.natoms; ++i) {
                Atom atom = molCopy.getAtom(i);
                if (atom.an != 1) continue;
                atom.an = 32;
                atom.iso = 0;
                atom.label = "A" + i;
            }
        }
        if (new MolfileParser().parse(oclMol = new StereoMolecule(), molFile = molCopy.createMolFile(""))) {
            boolean computed2D = true;
            try {
                new CoordinateInventor(0).invent(oclMol);
            }
            catch (Exception e) {
                computed2D = false;
                result = null;
            }
            if (computed2D) {
                if (oclMol.getAllAtoms() == mol.nAtoms()) {
                    for (int i = 0; i < oclMol.getAllAtoms(); ++i) {
                        mol.XY(i + 1, oclMol.getAtomX(i), oclMol.getAtomY(i));
                    }
                    mol.internalBondLengthScaling();
                } else {
                    MolfileCreator mfc = new MolfileCreator(oclMol);
                    try {
                        result = new JMEmol(mol.jme, mfc.getMolfile(), JMEReader.SupportedInputFileFormat.MOL, mol.parameters);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    result.chiralFlag = mol.chiralFlag;
                    result.internalBondLengthScaling();
                }
            }
        }
        return result;
    }

    public static JMEmol reComputeBondOrderIfAromaticBondType(JMEmol mol) {
        if (!mol.hasAromaticBondType()) {
            return mol;
        }
        String molFile = mol.createMolFile("");
        JMEmol result = mol.deepCopy();
        StereoMolecule oclMol = new StereoMolecule();
        if (!new MolfileParser().parse(oclMol, molFile)) {
            return mol;
        }
        if (oclMol.getAllAtoms() != mol.nAtoms() || oclMol.getAllBonds() != mol.nBonds()) {
            return null;
        }
        boolean computeBondOrder = true;
        try {
            AromaticityResolver bondFixer = new AromaticityResolver(oclMol);
            bondFixer.locateDelocalizedDoubleBonds(null);
        }
        catch (Exception e) {
            computeBondOrder = false;
            result = null;
        }
        if (computeBondOrder) {
            for (int b = 0; b < oclMol.getAllBonds(); ++b) {
                int bo = oclMol.getBondOrder(b);
                int at1 = oclMol.getBondAtom(0, b);
                int at2 = oclMol.getBondAtom(1, b);
                int charge1 = oclMol.getAtomCharge(at1++);
                int charge2 = oclMol.getAtomCharge(at2++);
                if (mol.q(at1) != charge1 || mol.q(at2) != charge2) {
                    return null;
                }
                Bond bond = result.bonds[b + 1];
                if (!(at1 == bond.va && at2 == bond.vb || at2 == bond.va && at1 == bond.vb)) {
                    return null;
                }
                bond.bondType = bo;
            }
        }
        return result;
    }

    public void getRingInfo(GUI.RingInfo info, JMECore mol) {
        int i;
        StereoMolecule m = new StereoMolecule();
        for (i = 1; i <= mol.natoms; ++i) {
            Atom a = mol.atoms[i];
            int an = 6;
            switch (a.an) {
                case 2: {
                    an = 5;
                    break;
                }
                case 4: {
                    an = 7;
                    break;
                }
                case 5: {
                    an = 8;
                }
                case 7: {
                    an = 15;
                    break;
                }
                case 8: {
                    an = 16;
                }
                case 13: {
                    an = 34;
                    break;
                }
                case 6: {
                    an = 14;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    an = 9;
                    break;
                }
                case 1: {
                    an = 1;
                }
            }
            m.setAtomicNo(m.addAtom(a.x, a.y), an);
        }
        for (i = 1; i <= mol.nbonds; ++i) {
            Bond b = mol.bonds[i];
            int type = b.bondType;
            switch (b.bondType) {
                case 1: 
                case 2: {
                    type = b.bondType;
                    break;
                }
                case 3: {
                    type = 4;
                    break;
                }
                default: {
                    type = 1;
                }
            }
            m.setBondType(m.addBond(b.va - 1, b.vb - 1), type);
        }
        try {
            RingCollection sys = m.getRingSet();
            int i2 = sys.getSize();
            while (--i2 >= 0) {
                boolean isAromatic = sys.isAromatic(i2);
                if (isAromatic) {
                    info.bsAromaticRings.set(i2);
                }
                GUI.Ring r = new GUI.Ring();
                info.rings.add(r);
                int[] bonds = sys.getRingBonds(i2);
                int j = bonds.length;
                while (--j >= 0) {
                    int pt = bonds[j] + 1;
                    r.bsBonds.set(pt);
                    int a1 = mol.bonds[pt].va;
                    int a2 = mol.bonds[pt].vb;
                    r.bsAtoms.set(a1);
                    r.bsAtoms.set(a2);
                    r.isAromatic = isAromatic;
                    if (mol.atoms[a1].an == 3) continue;
                    r.isHetero = true;
                }
                r.size = r.bsAtoms.cardinality();
                r.bondCount = r.bsBonds.cardinality();
                info.bsRingAtoms.or(r.bsAtoms);
                info.bsRingBonds.or(r.bsBonds);
                if (!isAromatic) continue;
                info.bsAromaticAtoms.or(r.bsAtoms);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

