/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.ifd.vendor.mestrelab;

import com.integratedgraphics.ifd.vendor.ByteBlockReader;
import com.integratedgraphics.ifd.vendor.mestrelab.MestrelabIFDVendorPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.TreeMap;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.util.IFDDefaultJSONSerializer;

class MNovaMetadataReader
extends ByteBlockReader {
    private static final int magicNumber = 1298494324;
    private static final int magicNumberBE = -236792892;
    private static final int magicNumberLE = -992746767;
    private static final byte[] molKey = new byte[]{77, 32, 32, 69, 78, 68};
    private static final byte[] cdxKey = new byte[]{86, 106, 67, 68};
    private static final byte[] cdxmlKey = new byte[]{60, 67, 68, 88, 77, 76};
    private static final byte[] pngKey = new byte[]{-119, 80, 78, 71};
    private static final int minBlockLengthForStructureData = 50;
    private MestrelabIFDVendorPlugin plugin;
    public String mnovaVersion;
    public int mnovaVersionNumber;
    private int nPages;
    private int nSpectra;
    private int nCDX;
    private int nMOL;
    private int nPNG;
    private ByteOrder byteOrder0;
    private Object outdir;
    ArrayList<TreeMap<String, Object>> reportData;
    private TreeMap<String, Object> pageData;
    private int nPagesTotal;
    private static boolean createStructureFiles = false;
    private static final String zeros = "0000";
    private static String testFile;
    private static int defaultTest;
    private static int nTests;
    static final String[] testFiles;

    MNovaMetadataReader(byte[] bytes) throws IOException {
        super(bytes);
    }

    MNovaMetadataReader(MestrelabIFDVendorPlugin mestrelabIFDVendorPlugin, byte[] bytes) throws IOException {
        super(bytes);
        this.plugin = mestrelabIFDVendorPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process() {
        boolean bl;
        try {
            this.setByteOrder(ByteOrder.BIG_ENDIAN);
            if (!this.readMagicNumberAndByteOrder()) {
                boolean bl2 = false;
                return bl2;
            }
            this.test();
            this.readFileAsStack();
            System.out.println("MNovaReader ------- nPages=" + this.nPages + " nSpectra=" + this.nSpectra + " nMOL=" + this.nMOL + " nCDX=" + this.nCDX + " nPNG=" + this.nPNG);
            bl = true;
        }
        catch (Exception e) {
            MNovaMetadataReader.logError(e);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                System.out.println("closing pos=" + this.readPosition() + " avail=" + this.readAvailable());
                this.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    private boolean readMagicNumberAndByteOrder() throws IOException {
        if (!this.checkMagicNumber(1298494324)) {
            return false;
        }
        this.readSimpleString(23);
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        if (!this.checkMagicNumber(-236792892)) {
            if (!this.checkMagicNumber(-992746767)) {
                return false;
            }
            this.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        this.byteOrder0 = this.byteOrder;
        this.readInt();
        return true;
    }

    private void readVersion() throws IOException {
        this.readUTF16String();
        this.mnovaVersion = this.readUTF16String();
        if (this.plugin != null) {
            this.plugin.setVersion(this.mnovaVersion);
        } else {
            this.report("version", this.mnovaVersion, null, null);
        }
        System.out.println("MNova version " + this.mnovaVersion);
        try {
            this.mnovaVersionNumber = Integer.parseInt(this.mnovaVersion.substring(0, this.mnovaVersion.indexOf(".")));
        }
        catch (NumberFormatException nfe) {
            this.mnovaVersionNumber = Integer.MAX_VALUE;
        }
    }

    private void readFileAsStack() throws IOException {
        this.rewindIn();
        this.seekIn(27L);
        Stack<ByteBlockReader.BlockData> objects = this.getObjectStack();
        long pt = this.readPosition();
        ByteBlockReader.BlockData verObject = objects.pop();
        verObject.seek();
        this.readVersion();
        this.seekIn(pt);
        this.nextBlock();
        this.nextBlock();
        this.readPages(this.readPosition());
        try {
            while (this.readAvailable() > 0) {
                this.nextBlock();
            }
        }
        catch (Exception e) {
            MNovaMetadataReader.logError(e);
        }
        System.out.println(this.nPagesTotal + " pages processed, version=" + this.mnovaVersion);
    }

    private void readPages(long pt) throws IOException {
        this.seekIn(pt);
        if (testing) {
            System.out.println("--- readPages " + this.readPosition());
        }
        this.readPointer();
        this.readPageInsets();
        this.readInt();
        this.readPointer();
        this.nPagesTotal = this.readInt();
        this.readPointer();
        this.nSpectra = 0;
        for (int i = 0; i < this.nPagesTotal; ++i) {
            this.readPage(this.readPosition(), i);
        }
        if (testing) {
            System.out.println("--- " + this.nPagesTotal + " pages read");
        }
    }

    private void readPageInsets() throws IOException {
        this.nextBlock();
    }

    private void readPage(long ptr, int index) throws IOException {
        this.seekIn(ptr);
        ++this.nPages;
        System.out.println("reading page " + (index + 1) + " pos=" + this.readPosition());
        this.readPageHeader();
        long ptNext = this.readPointer();
        String header = this.readPageTextHeader(this.readPosition(), ptNext);
        if (header != null) {
            System.out.println("page header = " + header);
            if (this.readToParameters(this.readPosition())) {
                ++this.nSpectra;
                if (this.plugin != null) {
                    this.plugin.newPage(this.nPagesTotal > 1 ? this.nPages : 1);
                }
                this.report("page", null, null, null);
                if (header != null && header.length() > 0) {
                    this.reportParam("Page_Header", new Param(header), null);
                }
                this.readParams();
                this.searchForExports(this.readPosition(), index, ptNext);
            }
        }
        this.seekIn(ptNext);
    }

    private String readPageTextHeader(long pt0, long pt) throws IOException {
        this.seekIn(pt0);
        this.readPageHeader2();
        this.readPageInsets();
        this.readFourUnknownInts();
        this.readInt();
        this.readPointer();
        this.readInt();
        this.readPointer();
        if (this.readPosition() == pt) {
            return null;
        }
        this.readInt();
        this.readPointer();
        this.readInt();
        if (this.peekInt() == 0) {
            return null;
        }
        this.readFourUnknownInts();
        this.readInt();
        this.nextBlock();
        this.nextBlock();
        this.readPointer();
        this.nextBlock();
        Stack<ByteBlockReader.BlockData> s = this.getObjectStack();
        long pt1 = this.readPosition();
        ((ByteBlockReader.BlockData)s.get(s.size() - 1)).seek();
        Stack<ByteBlockReader.BlockData> s1 = this.getObjectStack();
        ((ByteBlockReader.BlockData)s1.get(s1.size() - 8)).seek();
        String header = this.readUTF16String();
        this.seekIn(pt1);
        return header == null || header.startsWith("{") ? "" : header;
    }

    private boolean readToParameters(long pt0) throws IOException {
        this.seekIn(pt0);
        Stack<ByteBlockReader.BlockData> stack = this.getObjectStack();
        ByteBlockReader.BlockData params = (ByteBlockReader.BlockData)stack.get(stack.size() - 3);
        params.seek();
        this.readPointer();
        return this.readInt() == 0;
    }

    private void readPageHeader() throws IOException {
        this.nextBlock();
    }

    private void readPageHeader2() throws IOException {
        this.nextBlock();
    }

    private void readParams() throws IOException {
        System.out.println("parameters found at " + this.readPosition());
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            this.readParam(i);
        }
        System.out.println(" processed " + n + " parameters");
    }

    private void readParam(int index) throws IOException {
        System.out.println(" param " + (index + 1) + " at " + this.readPosition());
        this.nextBlock();
        int count = this.readInt();
        Param param1 = new Param(this.readPosition(), 1);
        Param param2 = count == 2 ? new Param(this.readPosition(), 2) : null;
        this.readByte();
        String key = this.readUTF16String();
        this.reportParam(key, param1, param2);
    }

    private void reportParam(String key, Param param1, Param param2) {
        if (this.plugin != null) {
            this.plugin.addParam(key, null, param1, param2);
        } else {
            this.report(key, null, param1, param2);
        }
        System.out.println("   " + key + " = " + param1 + (param2 == null ? "" : "," + param2));
    }

    private void report(String key, String val, Param param1, Param param2) {
        if (this.reportData == null) {
            this.reportData = new ArrayList();
        }
        if (key.equals("page")) {
            this.pageData = new TreeMap();
            this.reportData.add(this.pageData);
            if (this.nPagesTotal > 1) {
                this.pageData.put("#page", this.nPages);
            }
        } else {
            if (this.pageData == null) {
                this.pageData = new TreeMap();
                this.reportData.add(this.pageData);
                if (this.nPagesTotal > 1) {
                    this.pageData.put("#page", this.nPages);
                }
            }
            this.pageData.put(key, param1 == null ? val : param1.toMap());
            if (param2 != null) {
                this.pageData.put(key + "2", param2.toMap());
            }
        }
    }

    private void searchForExports(long pos0, int index, long ptNext) throws IOException {
        int nBlocks = 0;
        boolean haveCDX = false;
        boolean haveMOL = false;
        boolean havePNG = false;
        this.seekIn(pos0);
        while (this.readPosition() < ptNext) {
            int len = this.peekInt();
            if (len > 0) {
                ++nBlocks;
                long ptr = this.readPosition();
                if (testing) {
                    System.out.println("additional block " + nBlocks + " len=" + len + " from " + ptr + " to " + (ptr + (long)len) + " ptNext=" + ptNext);
                }
                if (len > 50) {
                    int offset;
                    int n = offset = haveCDX ? -1 : this.findBytes(cdxmlKey, len, false, 112);
                    if (offset >= 0) {
                        haveCDX = true;
                        this.exportCDXML(ptr, offset, nBlocks);
                    }
                    int n2 = offset = haveCDX ? -1 : this.findBytes(cdxKey, len, false, 2);
                    if (offset >= 0) {
                        haveCDX = true;
                        this.exportCDX(ptr, offset, nBlocks);
                    }
                    int n3 = offset = haveMOL ? -1 : this.findBytes(molKey, len, false, 0);
                    if (offset >= 0) {
                        haveMOL = true;
                        this.exportMOL(ptr, offset, nBlocks);
                    }
                    int n4 = offset = havePNG ? -1 : this.findBytes(pngKey, len, false, 0);
                    if (offset >= 0) {
                        havePNG = true;
                        this.exportPNG(ptr, offset, nBlocks);
                    }
                }
            }
            this.nextBlock();
        }
        System.out.println("\n======Page " + (index + 1) + " additional blocks: " + nBlocks);
    }

    private void exportCDXML(long lastPosition, int skip, int nBlock) throws IOException {
        int len;
        long pt0 = lastPosition + (long)skip;
        this.seekIn(pt0);
        byte[] bytes = this.readCDXMLdata(pt0);
        int n = len = bytes == null ? 0 : bytes.length;
        if (len > 0) {
            ++this.nCDX;
            this.handleFileData(nBlock, "_struc.cdxml", bytes, pt0, len, null, null);
        }
        this.seekIn(lastPosition);
    }

    private byte[] readCDXMLdata(long ptr) throws IOException {
        this.seekIn(ptr);
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[1000];
        try {
            int n;
            int n0 = 0;
            int pt = -1;
            for (int ntotal = 0; (pt = sb.indexOf("</CDXML", n0)) < 0 && (n = this.read(buf, 0, 1000)) > 0 && ntotal < 100000; ntotal += n) {
                sb.append(new String(buf, 0, n));
                n0 = Math.max(0, ntotal - 7);
            }
            if (pt < 0) {
                return null;
            }
            sb.setLength(pt);
        }
        catch (Exception e) {
            MNovaMetadataReader.logError(e);
            return null;
        }
        this.seekIn(ptr);
        return (sb + "</CDXML>").getBytes();
    }

    private void exportCDX(long lastPosition, int skip, int nBlock) throws IOException {
        int len;
        long pt0 = lastPosition + (long)skip;
        this.seekIn(pt0);
        byte[] bytes = this.readCDXdata(pt0);
        int n = len = bytes == null ? 0 : bytes.length;
        if (len > 0) {
            ++this.nCDX;
            this.handleFileData(nBlock, "_struc.cdx", bytes, pt0, len, null, null);
        }
        this.seekIn(lastPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readCDXdata(long ptr) throws IOException {
        this.seekIn(ptr);
        ByteOrder bo = this.byteOrder0;
        this.skipIn(22);
        try {
            int type;
            this.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            int nObj = 0;
            while ((type = this.readShort()) != 0 || nObj > 0) {
                if (type == 0) {
                    --nObj;
                    continue;
                }
                if ((type & 0x8000) == 0) {
                    int len = this.readShort();
                    if (len == -1) {
                        len = this.readInt();
                    }
                    this.skipIn(len);
                    continue;
                }
                this.readInt();
                ++nObj;
            }
        }
        catch (Exception e) {
            MNovaMetadataReader.logError(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.setByteOrder(bo);
        }
        long len = this.readPosition() - ptr;
        this.seekIn(ptr);
        return this.readBytes(len);
    }

    private void exportPNG(long lastPosition, int skip, int nBlock) throws IOException {
        byte[] bytes;
        int len;
        this.seekIn(lastPosition);
        try {
            this.readPointer();
            this.readInt();
            this.readFourUnknownInts();
            this.readInt();
            this.nextBlock();
            this.readPointer();
            this.readFourUnknownInts();
            this.readFourUnknownInts();
            this.readDouble();
            this.readDouble();
            this.readByte();
            this.readInts(15);
            this.readLenStringSafely();
            if (this.peekInt() == -1) {
                this.readInt();
            } else {
                this.readUTF16String();
            }
            this.readDouble();
            this.readDouble();
            Math.round(this.readDouble());
            Math.round(this.readDouble());
            this.readByte();
            this.readInt();
            if (this.peekInt() != -1991225785) {
                this.nextSubblock(2);
                this.readInt();
                this.readInt();
            }
        }
        catch (Exception e) {
            MNovaMetadataReader.logError(e);
        }
        if (this.peekInt() != -1991225785) {
            MNovaMetadataReader.logError(new Exception("Could not navigate to start of PNG image - just skipping to tag"));
            this.seekIn(lastPosition + (long)skip);
        }
        int n = len = (bytes = this.readPNGData(this.readPosition())) == null ? 0 : bytes.length;
        if (len > 0) {
            ++this.nPNG;
            this.handleFileData(nBlock, "_struc.png", bytes, this.readPosition() - (long)len, len, null, IFDConst.IFD_REPRESENTATION_FLAG + "png");
        }
        this.seekIn(lastPosition);
    }

    private byte[] readPNGData(long ptr) throws IOException {
        int tag;
        this.seekIn(ptr);
        if (this.readInt() != -1991225785) {
            return null;
        }
        this.readInt();
        do {
            int len = this.readInt();
            tag = this.readInt();
            this.skipIn(len + 4);
        } while (tag != 1229278788);
        long len = this.readPosition() - ptr;
        this.seekIn(ptr);
        return this.readBytes(len);
    }

    private void exportMOL(long lastPosition, int skip, int nBlock) throws IOException {
        int len;
        this.seekIn(lastPosition);
        long ptr = lastPosition + (long)skip;
        this.readPointer();
        this.readInt();
        this.readFourUnknownInts();
        this.readInt();
        this.nextBlock();
        this.nextBlock();
        this.readInt();
        this.nextBlock();
        this.nextBlock();
        this.nextBlock();
        this.nextSubblock(4);
        if (this.peekInt() == -1) {
            this.readByte();
            this.readInts(9);
        }
        if ((len = this.readInt()) > 0 && this.readPosition() + (long)len < ptr + 10L) {
            ++this.nMOL;
            byte[] bytes = this.readBytes(len);
            this.handleFileData(nBlock, "_struc.mol", bytes, this.readPosition(), len, null, null);
        }
        this.seekIn(lastPosition);
    }

    private void handleFileData(int nBlock, String type, byte[] fileData, long ptr, int len, String fname, String cssInfo) {
        if (this.plugin != null) {
            if (cssInfo != null) {
                this.plugin.addParam(type + ":css", cssInfo, null, null);
            }
            this.plugin.addParam(type, fileData, null, null);
        }
        if (fname == null) {
            fname = "file_" + MNovaMetadataReader.zeroFill(nTests, 2) + "_" + MNovaMetadataReader.zeroFill(this.nPages, 2) + type;
        }
        String s = "=====Page " + this.nPages + " block " + nBlock + " byte " + ptr + " " + fname + " [" + len + " bytes] " + (cssInfo != null ? cssInfo : "");
        System.out.println(s);
        if (createStructureFiles) {
            this.writeToFile(fname, fileData);
        }
        if (this.plugin == null) {
            this.report(type, fname, null, null);
        }
    }

    private void writeToFile(String fname, byte[] fileData) {
        if (this.outdir != null) {
            fname = this.outdir + fname;
        }
        File f = new File(fname);
        try (FileOutputStream fis = new FileOutputStream(f);){
            fis.write(fileData);
            System.out.println("File " + f.getAbsolutePath());
        }
        catch (IOException e) {
            MNovaMetadataReader.logError(e);
        }
    }

    private static String zeroFill(int n, int ndig) {
        String s = zeros + n;
        int len = s.length();
        return s.substring(len - Math.max(len - 4, ndig));
    }

    private void readFourUnknownInts() throws IOException {
        if (testing) {
            this.readInts(4);
        } else {
            this.skipIn(16);
        }
    }

    void dumpFileInfo() throws IOException {
        showChars = false;
        showInts = false;
        this.rewindIn();
        this.seekIn(27L);
        this.readPointer();
        long ptr31 = this.readPointer();
        this.seekIn(ptr31);
        this.readVersion();
        this.seekIn(27L);
        this.nextBlock();
        this.nextBlock();
        this.nextBlock();
        System.out.println("\n===Pages start at " + this.readPosition());
        this.readPointer();
        this.nextBlock();
        this.readInt();
        this.readPointer();
        int nPages = this.readInt();
        System.out.println("...Page count = " + nPages);
        this.readPointer();
        for (int i = 0; i < nPages; ++i) {
            long pt = this.readPosition();
            System.out.println("\n======Page " + (i + 1) + " starts at " + pt);
            this.readPageHeader();
            long ptNext = this.readPointer();
            String header = this.readPageTextHeader(this.readPosition(), ptNext);
            if (header != null) {
                System.out.println("page header = " + header);
                if (this.readToParameters(this.readPosition())) {
                    System.out.println(" params at " + this.readPosition());
                    this.readParams();
                    System.out.println("\n======Page " + (i + 1) + " parameters end at " + this.readPosition());
                    this.searchForExports(this.readPosition(), i, ptNext);
                }
            }
            this.seekIn(ptNext);
        }
        System.out.println("\n===Pages end at " + this.readPosition() + " available=" + this.readAvailable());
    }

    public static void main(String[] args) {
        int pt = 0;
        String outdir = null;
        if (args.length >= 2 && args[0].equals("-o")) {
            outdir = args[1];
            pt += 2;
        }
        if (testFile == null && args.length == 1 && "--testall".equals(args[0])) {
            MNovaMetadataReader.testAll(outdir);
        } else if (testFile != null && args.length > pt && "--test".equals(args[pt])) {
            String f = testFile != null ? testFile : testFiles[defaultTest];
            MNovaMetadataReader.runFileTest(f, outdir);
        } else if (args.length != pt) {
            String fname = args[pt];
            MNovaMetadataReader.runFileTest(fname, outdir);
        } else {
            System.out.println("usage: MNovaMetadataReader [-o outputdir] --test");
            System.out.println("usage: MNovaMetadataReader [-o outputdir] --testall");
            System.out.println("usage: MNovaMetadataReader [-o outputdir] mnovaFilename");
            System.out.println("a json file will be created");
        }
    }

    private static boolean runFileTest(String fname, String outdir) {
        try {
            File f = new File(fname);
            String filename = f.getAbsolutePath();
            byte[] bytes = FAIRSpecUtilities.getLimitedStreamBytes(new FileInputStream(filename), -1L, null, true, true);
            System.out.println(bytes.length + " bytes in " + filename);
            MNovaMetadataReader rdr = new MNovaMetadataReader(bytes);
            if (outdir == null) {
                outdir = new File("t").getAbsoluteFile().getParentFile().getAbsolutePath() + "/";
            } else if (!outdir.endsWith("/")) {
                if (outdir.length() == 0) {
                    outdir = f.getAbsoluteFile().getParentFile().getAbsolutePath() + "/";
                }
                outdir = outdir + "/";
            }
            outdir = outdir + f.getName() + ".";
            rdr.outdir = outdir;
            rdr.process();
            System.out.println("MNova file closed for " + filename);
            if (rdr.reportData != null) {
                IFDDefaultJSONSerializer serializer = new IFDDefaultJSONSerializer(false);
                serializer.openObject();
                serializer.addObject("MNova.metadata", rdr.reportData);
                String json = serializer.closeObject();
                rdr.writeToFile("json", json.getBytes());
            }
            return true;
        }
        catch (IOException e) {
            MNovaMetadataReader.logError(e);
            return false;
        }
    }

    private static void logError(Exception e) {
        e.printStackTrace();
    }

    private void test() throws IOException {
        this.rewindIn();
        testing = true;
        showInts = false;
        showChars = true;
        showInts = false;
        showChars = false;
        testing = false;
    }

    static void testStack(Stack<ByteBlockReader.BlockData> objects) throws IOException {
        Enumeration e = objects.elements();
        while (e.hasMoreElements()) {
            ByteBlockReader.BlockData obj = (ByteBlockReader.BlockData)e.nextElement();
            System.out.println("obj " + obj);
        }
    }

    static void testAll(String outdir) {
        testFile = testFiles[18];
        createStructureFiles = testFile != null;
        boolean ok = true;
        for (int i = 0; i < testFiles.length; ++i) {
            nTests = i + 1;
            if (!MNovaMetadataReader.runFileTest(testFiles[i], outdir)) {
                System.err.println("Test " + i + " on " + testFiles[i] + " failed");
                ok = false;
                break;
            }
            System.out.println("Test " + i + " on " + testFiles[i] + " OK");
        }
        if (ok) {
            System.out.println("All tests successful");
        }
    }

    static {
        defaultTest = 2;
        nTests = -1;
        testFiles = new String[]{"test/mnova/cyclohex.mnova", "test/mnova/3a-C.mnova", "test/mnova/1.mnova", "test/mnova/1-deleted.mnova", "test/mnova/1-v14.mnova", "test/mnova/3a-C-taxol.mnova", "test/mnova/1-caff-taxol.mnova", "test/mnova/1-caff-taxol-rev.mnova", "test/mnova/1-caff-taxol-delete.mnova", "test/mnova/1-taxol-drop.mnova", "test/mnova/1-taxol-drop-move.mnova", "test/mnova/3a-c-morphine.mnova", "c:\\temp\\iupac\\zip\\22232721\\metadatanmr\\nmr spectra.mnova", "test/mnova/3aa-C.mnova", "test/mnova/10.mnova", "test/mnova/Substrate_1'h.mnova", "test/mnova/Substrate_1k.mnova", "test/mnova/Products_3a.mnova", "test/mnova/5-H.mnova"};
    }

    class Param {
        String units;
        String source;
        String calc;
        String value;

        Param(String value) {
            this.value = value;
        }

        Param(long ptr, int index) throws IOException {
            boolean isNew;
            MNovaMetadataReader.this.seekIn(ptr);
            long pt1 = MNovaMetadataReader.this.readPosition();
            MNovaMetadataReader.this.readInt();
            int p = MNovaMetadataReader.this.peekInt();
            if (p >= 0) {
                this.units = MNovaMetadataReader.this.readUTF16String();
                if (this.units.equals("acqus")) {
                    this.units = null;
                    MNovaMetadataReader.this.seekIn(pt1);
                }
            } else {
                MNovaMetadataReader.this.readInt();
            }
            boolean bl = isNew = MNovaMetadataReader.this.peekInt() == 0;
            if (isNew) {
                MNovaMetadataReader.this.readInt();
                p = MNovaMetadataReader.this.peekInt();
                if (p >= 0) {
                    this.source = MNovaMetadataReader.this.readUTF16String();
                } else {
                    MNovaMetadataReader.this.readInt();
                }
            }
            if ((p = MNovaMetadataReader.this.peekInt()) >= 0) {
                this.calc = MNovaMetadataReader.this.readUTF16String();
            } else {
                MNovaMetadataReader.this.readInt();
            }
            MNovaMetadataReader.this.readByte();
            p = MNovaMetadataReader.this.peekInt();
            if (p >= 0) {
                this.value = MNovaMetadataReader.this.readUTF16String();
            } else {
                MNovaMetadataReader.this.readInt();
            }
        }

        public String toString() {
            if (this.value == null) {
                return null;
            }
            return this.value.replace('\n', ' ') + (this.units == null ? "" : " " + this.units) + (this.source == null ? "" : " FROM " + this.source);
        }

        public HashMap<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.value != null) {
                map.put("value", this.value);
            }
            if (this.units != null) {
                map.put("units", this.units);
            }
            if (this.source != null) {
                map.put("source", this.source);
            }
            return map;
        }
    }
}

