/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.ifd.vendor.jeol;

import com.integratedgraphics.ifd.vendor.ByteBlockReader;
import com.integratedgraphics.ifd.vendor.nmrml.NmrMLHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.nmrml.parser.Acqu;
import org.nmrml.parser.jeol.JeolParameter;

public class NmrMLJeolAcquStreamReader
extends ByteBlockReader
implements NmrMLHeader {
    private static Map<String, Object> jeolIni;
    public int data_Dimension_Number;
    private String creationTime;
    public String title;
    public String comment;
    public double base_Freq;

    public NmrMLJeolAcquStreamReader(byte[] bytes) throws FileNotFoundException, IOException {
        super(bytes);
        if (jeolIni == null) {
            jeolIni = FAIRSpecUtilities.getJSONResource(Acqu.class, "jeol.ini.json");
        }
    }

    public Acqu read() throws IOException {
        int i;
        int endian;
        boolean fprt = true;
        Locale.setDefault(new Locale("en", "US"));
        Acqu acquisition = new Acqu(Acqu.Spectrometer.JEOL);
        String File_Identifier = this.readSimpleString(8);
        if (fprt) {
            System.out.println("Header: File_Identifier = " + File_Identifier);
        }
        ByteOrder byteOrder = (endian = this.readByte()) == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        acquisition.setByteOrder(byteOrder);
        acquisition.setBiteSyze(8);
        if (fprt) {
            System.out.println("Header: Endian = " + endian);
        }
        int Major_version = this.readByte();
        if (fprt) {
            System.out.println("Header: Major_version = " + Major_version);
        }
        this.skipIn(2);
        this.data_Dimension_Number = this.readByte();
        if (fprt) {
            System.out.println("Header: Data_Dimension_Number = " + this.data_Dimension_Number);
        }
        this.skipIn(1);
        int Data_Type = this.readByte();
        if (fprt) {
            System.out.println("Header: Data_Type = " + Data_Type);
        }
        String Instrument = this.getTerm("INSTRUMENT", this.readByte());
        if (fprt) {
            System.out.println("Header: Instrument = " + Instrument);
        }
        this.skipIn(8);
        byte[] Data_Axis_Type = this.readBytes(8L);
        if (fprt) {
            System.out.println("Header: Data_Axis_Type = " + Data_Axis_Type[0] + ", ... ");
        }
        byte[] Data_Units = this.readBytes(16L);
        if (fprt) {
            System.out.println(String.format("Header: Data_Units = %d, %d, ...", Data_Units[0], Data_Units[1]));
        }
        this.title = this.readSimpleString(124);
        if (fprt) {
            System.out.println("Header: Title = " + this.title);
        }
        this.skipIn(4);
        int Data_Points = this.readInt();
        if (fprt) {
            System.out.println("Header: Data_Points = " + Data_Points);
        }
        this.skipIn(28);
        int Data_Offset_Start = this.readInt();
        if (fprt) {
            System.out.println("Header: Data_Offset_Start = " + Data_Offset_Start);
        }
        this.skipIn(188);
        this.creationTime = NmrMLJeolAcquStreamReader.toDateTime(this.readInt());
        if (fprt) {
            System.out.println("Header: Creation_Time = " + this.creationTime);
        }
        this.readInt();
        String Node_Name = this.readSimpleString(16);
        if (fprt) {
            System.out.println("Header: Node_Name = " + Node_Name);
        }
        String Site = this.readSimpleString(128);
        if (fprt) {
            System.out.println("Header: Site = " + Site);
        }
        String Author2 = this.readSimpleString(128);
        if (fprt) {
            System.out.println("Header: Author = " + Author2);
        }
        this.comment = this.readSimpleString(128);
        if (fprt) {
            System.out.println("Header: Comment = " + this.comment);
        }
        String Data_Axis_Titles = this.readSimpleString(256);
        if (fprt) {
            System.out.println("Header: Data_Axis_Titles = " + Data_Axis_Titles);
        }
        this.base_Freq = this.readDouble();
        if (fprt) {
            System.out.println("Header: Base_Freq = " + this.base_Freq);
        }
        this.skipIn(56);
        double Zero_Freq = this.readDouble();
        if (fprt) {
            System.out.println("Header: Zero_Freq = " + Zero_Freq);
        }
        this.skipIn(76);
        int Param_Start = this.readInt();
        if (fprt) {
            System.out.println("Header: Param_Start = " + Param_Start);
        }
        this.skipIn(68);
        long Data_Start = this.readInt();
        if (fprt) {
            System.out.println("Header: Data_Start = " + Data_Start);
        }
        long Data_Length = this.readLong();
        if (fprt) {
            System.out.println("Header: Data_Length = " + Data_Length);
        }
        if (fprt) {
            System.out.println("------");
        }
        this.skipIn(Param_Start - 1296);
        this.setByteOrder(byteOrder);
        int Parameter_Size = this.readInt();
        int Low_Index = this.readInt();
        int High_Index = this.readInt();
        int Total_Size = this.readInt();
        if (fprt) {
            System.out.println(String.format("Header: Params: Size=%d, Low_Index=%d, High_Index=%d, Total_Size=%d", Parameter_Size, Low_Index, High_Index, Total_Size));
        }
        if (fprt) {
            System.out.println("------");
        }
        int[] factors = null;
        int[] orders = null;
        for (int count = 0; count <= High_Index; ++count) {
            JeolParameter param = this.readParam();
            String param_name = param.name.trim();
            String Unit_label = "";
            boolean flg = false;
            if (param_name.equals("inst_model_number")) {
                acquisition.setInstrumentName(param.valueString);
                flg = true;
            }
            if (param_name.equals("version")) {
                acquisition.setSoftVersion(param.valueString);
                flg = true;
            }
            if (param_name.equals("experiment")) {
                acquisition.setPulseProgram(param.valueString);
                flg = true;
            }
            if (param_name.equals("sample_id")) {
                flg = true;
            }
            if (param_name.equals("probe_id")) {
                flg = true;
            }
            if (param_name.equals("total_scans")) {
                acquisition.setNumberOfScans(BigInteger.valueOf(param.valueInt));
                flg = true;
            }
            if (param_name.equals("acq_delay")) {
                flg = true;
            }
            if (param_name.equals("delay_of_start")) {
                flg = true;
            }
            if (param_name.equals("relaxation_delay")) {
                acquisition.setRelaxationDelay(param.valueDouble);
                flg = true;
            }
            if (param_name.equals("exp_total")) {
                flg = true;
            }
            if (param_name.equals("solvent")) {
                acquisition.setSolvent(param.valueString);
                flg = true;
            }
            if (param_name.equals("temp_set")) {
                Unit_label = this.getTerm("Unit_labels", param.unit);
                if (Unit_label.equals("dC")) {
                    acquisition.setTemperature(param.valueDouble + 273.15);
                } else {
                    acquisition.setTemperature(param.valueDouble);
                }
                flg = true;
            }
            if (param_name.equals("spin_set")) {
                acquisition.setSpiningRate((int)param.valueDouble);
                flg = true;
            }
            if (param_name.equals("irr_mode")) {
                if (param.valueString.toLowerCase().equals("off")) {
                    acquisition.setDecoupledNucleus("off");
                }
                flg = true;
            }
            if (param_name.equals("irr_domain")) {
                if (param.valueString.toLowerCase().equals("proton")) {
                    acquisition.setDecoupledNucleus("1H");
                }
                if (param.valueString.toLowerCase().equals("Carbon13")) {
                    acquisition.setDecoupledNucleus("13C");
                }
                flg = true;
            }
            if (param_name.equals("irr_freq")) {
                flg = true;
            }
            if (param_name.equals("irr_offset")) {
                flg = true;
            }
            if (param_name.equals("x_acq_time")) {
                flg = true;
            }
            if (param_name.equals("x_acq_duration")) {
                flg = true;
            }
            if (param_name.equals("x_probe_map")) {
                acquisition.setProbehead(param.valueString);
                flg = true;
            }
            if (param_name.equals("x_prescans")) {
                acquisition.setNumberOfSteadyStateScans(BigInteger.valueOf(param.valueInt));
                flg = true;
            }
            if (param_name.equals("x_points")) {
                acquisition.setAquiredPoints(param.valueInt);
                flg = true;
            }
            if (param_name.equals("x_domain")) {
                String ObservedNucleus = param.valueString;
                if (param.valueString.toLowerCase().equals("proton")) {
                    ObservedNucleus = "1H";
                }
                acquisition.setObservedNucleus(ObservedNucleus);
                acquisition.setDecoupledNucleus("off");
                flg = true;
            }
            if (param_name.equals("x_freq")) {
                Unit_label = this.getTerm("Unit_labels", param.unit);
                if (Unit_label.equals("Hz")) {
                    acquisition.setTransmiterFreq(param.valueDouble / 1000000.0);
                } else {
                    acquisition.setTransmiterFreq(param.valueDouble);
                }
                flg = true;
            }
            if (param_name.equals("x_sweep")) {
                acquisition.setSpectralWidthHz(param.valueDouble);
                flg = true;
            }
            if (param_name.equals("x_offset")) {
                acquisition.setFreqOffset(param.valueDouble * this.base_Freq);
                flg = true;
            }
            if (param_name.equals("x_pulse")) {
                acquisition.setPulseWidth(param.valueDouble);
                flg = true;
            }
            if (param_name.equals("x_resolution")) {
                flg = true;
            }
            if (param_name.equals("factors")) {
                String[] sfactors = param.valueString.trim().replace("  ", " ").split(" ");
                factors = new int[sfactors.length];
                for (i = 0; i < sfactors.length; ++i) {
                    try {
                        factors[i] = Integer.parseInt(sfactors[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                flg = true;
            }
            if (param_name.equals("orders")) {
                String[] sorders = param.valueString.trim().replace("  ", " ").split(" ");
                orders = new int[sorders.length];
                for (i = 0; i < sorders.length; ++i) {
                    try {
                        orders[i] = Integer.parseInt(sorders[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                flg = true;
            }
            if (!(fprt & flg)) continue;
            System.out.print("Param: %s" + param.name);
            if (param.value_type == 0) {
                System.out.print("\t = \t " + param.valueString + "%s ");
            } else if (param.value_type == 1) {
                System.out.print("\t = \t " + param.valueInt);
            } else if (param.value_type == 2) {
                System.out.print("\t = \t " + param.valueDouble);
            }
            System.out.println(String.format(" %s%s", this.getTerm("Unit_prefix", param.unit_prefix), this.getTerm("Unit_labels", param.unit)));
        }
        acquisition.setSoftware(this.getTerm("SOFTWARE", "SOFTWARE"));
        acquisition.setSpectralWidth(acquisition.getSpectralWidthHz() / acquisition.getTransmiterFreq());
        acquisition.setDspGroupDelay(0.0);
        if (orders.length > 0 && factors.length > 0) {
            double GroupDelay = 0.0;
            int nbo = orders[0];
            for (int k = 0; k < nbo; ++k) {
                double prodfac = 1.0;
                for (i = k; i < nbo; ++i) {
                    prodfac *= (double)factors[i];
                }
                GroupDelay += 0.5 * ((double)(orders[k + 1] - true) / prodfac);
            }
            acquisition.setDspGroupDelay(GroupDelay);
        }
        acquisition.setDataOffset(Data_Start);
        acquisition.setDataLength(Data_Length);
        if (fprt) {
            System.out.println("------");
        }
        this.close();
        return acquisition;
    }

    private static String toDateTime(int cdt) {
        int year = 1990 + (cdt >> 25);
        int month = cdt >> 21 & 0xF;
        int day = cdt >> 16 & 0x1F;
        int seconds = (int)((double)(cdt &= 0xFFFF) / 65535.0 * 86399.99);
        int hour = seconds / 3600;
        int min = (seconds - hour * 3600) / 60;
        int sec = seconds - hour * 3600 - min * 60;
        String iso8601 = year + (month < 10 ? "-0" : "-") + month + (day < 10 ? "-0" : "-") + day + "T" + (hour < 10 ? "0" : "") + hour + (min < 10 ? ":0" : ":") + min + (sec < 10 ? ":0" : ":") + sec;
        System.out.println("JEOLDT " + cdt + " " + iso8601);
        return iso8601;
    }

    private JeolParameter readParam() throws IOException {
        int v2;
        JeolParameter param = new JeolParameter();
        this.setBuf(64);
        byte[] b = new byte[16];
        this.get(b, 0, 4);
        param.unit_scaler = this.getShort();
        int u1 = this.getByte() & 0xFF;
        int v1 = (int)Math.floor(u1 / 16);
        param.unit_prefix = v2 = v1 > 8 ? v1 % 8 : v1 % 8 + 8;
        param.unit = this.getByte();
        this.get(b, 0, 8);
        this.markBuffer();
        this.get(b, 0, b.length);
        int value_type = this.getShort();
        this.resetBuffer();
        param.value_type = value_type;
        switch (value_type) {
            case 0: {
                param.valueString = new String(b).trim();
                break;
            }
            case 1: {
                param.valueInt = this.getInt();
                break;
            }
            case 2: {
                param.valueDouble = this.getDouble();
                break;
            }
        }
        param.name = new String(this.getBuf(), 36, 28).toLowerCase().trim();
        return param;
    }

    private String getTerm(String section, String key) {
        return (String)((Map)jeolIni.get(section)).get(key);
    }

    private String getTerm(String section, int item) {
        return (String)((List)jeolIni.get(section)).get(item);
    }

    @Override
    public int getDimension() {
        return this.data_Dimension_Number;
    }

    public static final void main(String[] args) {
        String testFile = "test/jeol/1d_1d-13C.jdf";
        String fname = args.length == 0 ? testFile : args[0];
        testing = false;
        showInts = false;
        showChars = false;
        try {
            String filename = new File(fname).getAbsolutePath();
            byte[] bytes = FAIRSpecUtilities.getLimitedStreamBytes(new FileInputStream(filename), -1L, null, true, true);
            System.out.println(bytes.length + " bytes in " + filename);
            Acqu acq = new NmrMLJeolAcquStreamReader(bytes).read();
            System.out.println(acq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCreationTime(String creationTime) {
        return creationTime;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getCreationTime() {
        return this.creationTime;
    }
}

