/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.ifd.vendor.bruker;

import com.integratedgraphics.ifd.api.VendorPluginI;
import com.integratedgraphics.ifd.vendor.NMRVendorPlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import jspecview.source.JDXReader;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.extract.MetadataReceiverI;

public class BrukerIFDVendorPlugin
extends NMRVendorPlugin {
    private static final Map<String, String> ifdMap;
    private Globals spec = new Globals();
    private static String IMAGE;
    private static String PDF;

    public BrukerIFDVendorPlugin() {
        this.paramRegex = this.paramRegex + "|procs$|acqu2s$|acqus$|title$|audita.txt$|auditp.txt$";
        this.rezipRegex = "pdata/[^/]+/procs$";
    }

    @Override
    public String getRezipPrefix(String dirName) {
        return BrukerIFDVendorPlugin.isUnsignedInteger(dirName) ? null : "1";
    }

    @Override
    public Object[] getExtractTypeInfo(MetadataReceiverI extractor, String baseName, String entryName) {
        Object[] objectArray;
        String type;
        boolean isImage = entryName.endsWith("thumb.png");
        String string = entryName.endsWith(".pdf") ? PDF : (type = isImage ? IMAGE : null);
        if (type == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = type;
            objectArray = objectArray2;
            objectArray2[1] = isImage ? Boolean.TRUE : null;
        }
        return objectArray;
    }

    @Override
    public boolean doRezipInclude(MetadataReceiverI extractor, String baseName, String entryName) {
        return !entryName.endsWith(".mnova");
    }

    @Override
    public boolean doExtract(String entryName) {
        return false;
    }

    @Override
    public void startRezip(MetadataReceiverI extractor) {
        super.startRezip(extractor);
        this.spec = new Globals();
    }

    @Override
    public void endRezip() {
        if (this.spec.dim == null) {
            this.report("DIM", "1D");
            this.report("##$NUC2", "\u0001");
        }
        this.spec.clear();
        super.endRezip();
    }

    @Override
    public String accept(MetadataReceiverI extractor, String originPath, byte[] bytes) {
        super.accept(extractor, originPath, bytes);
        return this.readJDX(originPath, bytes) ? this.processRepresentation(originPath, null) : null;
    }

    private boolean readJDX(String originPath, byte[] bytes) {
        if (originPath.indexOf("title") >= 0) {
            this.report("TITLE", new String(bytes));
            return true;
        }
        Map<String, String> map = null;
        try {
            map = JDXReader.getHeaderMap(new ByteArrayInputStream(bytes), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (originPath.indexOf("procs") >= 0) {
            Object solvent = this.getSolvent(map);
            if (solvent != null) {
                this.spec.solvent = (String)solvent;
                this.report("SOLVENT", "\u0001");
                this.report("SOLVENT", solvent);
            }
            return true;
        }
        boolean isProc = false;
        if (originPath.indexOf("audita.txt") >= 0 || (isProc = originPath.indexOf("auditp.txt") >= 0)) {
            String timestamp = map.get("##AUDITTRAIL");
            if (timestamp != null) {
                String[] data = timestamp.split("\\(");
                if (data.length > 1) {
                    data = data[data.length - 1].split("<");
                }
                try {
                    if (data.length > 1) {
                        timestamp = data[1];
                        timestamp = timestamp.substring(0, data[1].indexOf(">")).trim();
                        int pt = Math.max(timestamp.indexOf("+"), timestamp.lastIndexOf("-"));
                        String off = "";
                        if (pt > 10) {
                            off = "00000" + timestamp.substring(pt + 1);
                            int len = off.length();
                            off = timestamp.substring(pt, pt + 1) + off.substring(len - 4, len - 2) + ":" + off.substring(len - 2);
                        }
                        timestamp = timestamp.substring(0, 10) + "T" + timestamp.substring(11, 19) + off;
                        ZonedDateTime d = ZonedDateTime.parse(timestamp);
                        this.addProperty(ifdMap.get(isProc ? "PROC_TIMESTAMP" : "TIMESTAMP"), d.toString());
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
            return true;
        }
        if (originPath.indexOf("acqus") >= 0) {
            if (this.spec.solvent == null) {
                this.processString(map, "##$SOLVENT", null);
            }
            int ndim = 0;
            String n1 = BrukerIFDVendorPlugin.getBrukerString(map, "##$NUC1");
            if ((this.spec.nuc1 == null ? (this.spec.nuc1 = this.processString(map, "##$NUC1", "off")) : this.spec.nuc1) != null) {
                ndim = 1;
            }
            if (this.processString(map, "##$NUC2", "off") != null) {
                ndim = 2;
            }
            if (this.processString(map, "##$NUC3", "off") != null) {
                ndim = 3;
            }
            if (this.processString(map, "##$NUC4", "off") != null) {
                ndim = 4;
            }
            if (ndim == 0) {
                return false;
            }
            double freq1 = BrukerIFDVendorPlugin.getDoubleValue(map, "##$BF1");
            this.report("##$BF1", freq1);
            if (ndim >= 2) {
                this.report("##$BF2", BrukerIFDVendorPlugin.getDoubleValue(map, "##$BF2"));
            }
            if (ndim >= 3) {
                this.report("##$BF3", BrukerIFDVendorPlugin.getDoubleValue(map, "##$BF3"));
            }
            this.report("SF", BrukerIFDVendorPlugin.getNominalFrequency(freq1, n1));
        }
        this.report("##$TE", BrukerIFDVendorPlugin.getDoubleValue(map, "##$TE"));
        this.processString(map, "##$PULPROG", null);
        this.processString(map, "##$EXP", null);
        if (originPath.endsWith("acqu2s")) {
            this.spec.dim = "2D";
            this.report("DIM", "2D");
        } else if (originPath.endsWith("acqus") && this.spec.dim == null) {
            this.spec.dim = "1D";
            this.report("DIM", "1D");
        }
        if (this.spec.probeHead == null) {
            this.spec.probeHead = this.processString(map, "##$PROBHD", null);
        }
        return true;
    }

    private Object getSolvent(Map<String, String> map) {
        int pt;
        String nuc_solv = BrukerIFDVendorPlugin.getBrukerString(map, "##$SREGLST");
        return nuc_solv != null && (pt = nuc_solv.indexOf(".")) >= 0 ? nuc_solv.substring(pt + 1) : null;
    }

    private String processString(Map<String, String> map, String key, String ignore) {
        String val = BrukerIFDVendorPlugin.getBrukerString(map, key);
        if (val == null || val.equals(ignore)) {
            return null;
        }
        this.report(key, val);
        return val;
    }

    private static String getBrukerString(Map<String, String> map, String key) {
        return BrukerIFDVendorPlugin.getDelimitedString(map, key, '<', '>');
    }

    private void report(String key, Object val) {
        this.addProperty(ifdMap.get(key), val);
    }

    public static void main(String[] args) {
        BrukerIFDVendorPlugin.test("test/cosy/acqus");
        BrukerIFDVendorPlugin.test("test/cosy/acqu2s");
        BrukerIFDVendorPlugin.test("test/cosy/procs");
        BrukerIFDVendorPlugin.test("test/cosy/proc2s");
        BrukerIFDVendorPlugin.test("test/13c/procs");
        BrukerIFDVendorPlugin.test("test/13c/acqus");
    }

    private static void test(String originPath) {
        VendorPluginI.init();
        System.out.println("====================" + originPath);
        try {
            String filename = new File(originPath).getAbsolutePath();
            byte[] bytes = FAIRSpecUtilities.getLimitedStreamBytes(new FileInputStream(filename), -1L, null, true, true);
            new BrukerIFDVendorPlugin().accept(null, filename, bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getVendorName() {
        return "Bruker";
    }

    @Override
    public String processRepresentation(String ifdPath, byte[] bytes) {
        return IFD_REP_DATAOBJECT_FAIRSPEC_NMR_VENDOR_DATASET;
    }

    static {
        BrukerIFDVendorPlugin.register(BrukerIFDVendorPlugin.class);
        ifdMap = new HashMap<String, String>();
        String[] keys = new String[]{"DIM", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_DIMENSION"), "##$BF1", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_FREQ_1"), "##$BF2", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_FREQ_2"), "##$BF3", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_FREQ_3"), "##$NUC1", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_NUCL_1"), "##$NUC2", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_NUCL_2"), "##$NUC3", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_NUCL_3"), "##$EXP", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_ID"), "##$PULPROG", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_PULSE_PROGRAM"), "##$TE", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_ABSOLUTE_TEMPERATURE"), "##$SOLVENT", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_SOLVENT"), "SOLVENT", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_SOLVENT"), "TITLE", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_TITLE"), "SF", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.INSTR_NOMINAL_FREQ"), "##$PROBHD", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.INSTR_PROBE_TYPE"), "TIMESTAMP", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT.TIMESTAMP"), "PROC_TIMESTAMP", BrukerIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.PROC_TIMESTAMP")};
        int i = 0;
        while (i < keys.length) {
            ifdMap.put(keys[i++], keys[i++]);
        }
        IMAGE = BrukerIFDVendorPlugin.getProp("IFD_REP_DATAOBJECT_FAIRSPEC_NMR.SPECTRUM_IMAGE");
        PDF = BrukerIFDVendorPlugin.getProp("IFD_REP_DATAOBJECT_FAIRSPEC_NMR.SPECTRUM_DOCUMENT");
    }

    private class Globals {
        String dim;
        String nuc1;
        String probeHead;
        String solvent;

        private Globals() {
        }

        public void clear() {
            this.dim = null;
            this.nuc1 = null;
            this.probeHead = null;
        }
    }
}

