/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.util.SortedList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;

public class UniqueList<T>
extends SortedList<T>
implements Serializable {
    static final long serialVersionUID = 538054678L;
    private ArrayList<T> mOriginalOrder = new ArrayList();
    private int[] mOriginalIndex;

    public UniqueList() {
    }

    public UniqueList(Comparator comparator) {
        super(comparator);
    }

    public int getSortedIndex(T t) {
        return super.getIndex(t);
    }

    @Override
    public boolean contains(T t) {
        return super.getIndex(t) != -1;
    }

    @Override
    public int getIndex(T t) {
        int n = super.getIndex(t);
        if (n == -1) {
            return -1;
        }
        if (this.mOriginalIndex == null) {
            this.createOriginalIndex();
        }
        return this.mOriginalIndex[n];
    }

    @Override
    public int add(T t) {
        int n = this.size();
        int n2 = super.add(t);
        if (this.size() != n) {
            this.mOriginalOrder.add(t);
            this.mOriginalIndex = null;
            return n;
        }
        if (this.mOriginalIndex == null) {
            this.createOriginalIndex();
        }
        return this.mOriginalIndex[n2];
    }

    public int add(int n, T t) {
        int n2 = super.add(t);
        if (n2 == -1) {
            return -1;
        }
        this.mOriginalOrder.add(n, t);
        this.mOriginalIndex = null;
        return n;
    }

    @Override
    public T get(int n) {
        return this.mOriginalOrder.get(n);
    }

    public T getSorted(int n) {
        return super.get(n);
    }

    @Override
    public T[] toArray(T[] TArray) {
        return this.mOriginalOrder.toArray(TArray);
    }

    public T[] toSortedArray(T[] TArray) {
        return super.toArray(TArray);
    }

    private void createOriginalIndex() {
        this.mOriginalIndex = new int[this.size()];
        int n = 0;
        for (T t : this.mOriginalOrder) {
            this.mOriginalIndex[super.getIndex(t)] = n++;
        }
    }
}

