/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.util.ArrayList;
import java.util.Comparator;

public class SortedList<T> {
    static final long serialVersionUID = 538314278L;
    private ArrayList<T> mList = new ArrayList();
    private Comparator mComparator;

    public SortedList() {
        this(null);
    }

    public SortedList(Comparator comparator) {
        this.mComparator = comparator;
    }

    public boolean contains(T t) {
        return this.getIndex(t) != -1;
    }

    public boolean equals(SortedList<T> sortedList) {
        if (this.mList.size() != sortedList.mList.size()) {
            return false;
        }
        if (this.mComparator != null) {
            for (int i = 0; i < this.mList.size(); ++i) {
                if (this.mComparator.compare(this.mList.get(i), sortedList.mList.get(i)) == 0) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.mList.size(); ++i) {
                if (this.mList.get(i).equals(sortedList.mList.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int getIndex(T t) {
        int n = this.getIndexOrInsertIndex(t);
        return n < 0 ? -1 : n;
    }

    public int getIndexOrInsertIndex(T t) {
        int n = this.mList.size();
        if (n == 0) {
            return -1;
        }
        int n2 = 1;
        while (2 * n2 <= n) {
            n2 <<= 1;
        }
        int n3 = n2--;
        while (n3 != 0) {
            n3 >>= 1;
            if (n2 >= n) {
                n2 -= n3;
                continue;
            }
            int n4 = this.compare(t, this.mList.get(n2));
            if (n4 == 0) {
                return n2;
            }
            if (n3 == 0) break;
            if (n4 < 0) {
                n2 -= n3;
                continue;
            }
            n2 += n3;
        }
        if (n2 < n && this.compare(t, this.mList.get(n2)) > 0) {
            ++n2;
        }
        return -(n2 + 1);
    }

    private int compare(T t, T t2) {
        return this.mComparator != null ? this.mComparator.compare(t, t2) : ((Comparable)t).compareTo(t2);
    }

    public int getIndexBelowEqual(T t) {
        int n = this.getIndexOrInsertIndex(t);
        return n < 0 ? -(n + 1) : n;
    }

    public int getIndexAboveEqual(T t) {
        int n = this.getIndexOrInsertIndex(t);
        return n < 0 ? -(n + 1) : n + 1;
    }

    public int add(T t) {
        int n = this.getIndexOrInsertIndex(t);
        if (n < 0) {
            n = -(n + 1);
            this.mList.add(n, t);
        }
        return n;
    }

    public boolean addIfNew(T t) {
        int n = this.getIndexOrInsertIndex(t);
        if (n >= 0) {
            return false;
        }
        n = -(n + 1);
        this.mList.add(n, t);
        return true;
    }

    public int size() {
        return this.mList.size();
    }

    public T get(int n) {
        return n < 0 ? null : (T)this.mList.get(n);
    }

    public T[] toArray(T[] TArray) {
        return this.mList.toArray(TArray);
    }

    public void remove(int n) {
        this.mList.remove(n);
    }

    public void removeAll() {
        this.mList.clear();
    }
}

