/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.calc.Matrix;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

public class MatrixSparse {
    private static final int BUFFER_SIZE = 10000;
    private static final int READ_BUFFER_SIZE = 13;
    private LinkedHashMap<Integer, LinkedHashMap<Integer, Integer>> hmIndex_hmIndex;
    private double[] data;
    private int position;
    private int rows;
    private int cols;

    public MatrixSparse(File file) throws Exception {
        this.init();
        this.read(file);
    }

    public MatrixSparse(File file, int n) throws Exception {
        this.init();
        this.read(file, n);
    }

    public MatrixSparse(int n, int n2) {
        this.init();
        this.rows = n;
        this.cols = n2;
    }

    public void init() {
        this.hmIndex_hmIndex = new LinkedHashMap();
        this.data = new double[10000];
        this.position = -1;
    }

    public void set(int n, int n2, double d) {
        if (n >= this.rows) {
            String string = "Row index " + n + " out of bounds " + this.rows + ".";
            throw new IndexOutOfBoundsException(string);
        }
        if (n2 >= this.cols) {
            String string = "Col index " + n2 + " out of bounds " + this.cols + ".";
            throw new IndexOutOfBoundsException(string);
        }
        ++this.position;
        if (this.position == this.data.length) {
            this.resizeArray(this.position + 1);
        }
        this.data[this.position] = d;
        LinkedHashMap<Integer, Integer> linkedHashMap = this.hmIndex_hmIndex.get(n);
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap();
            this.hmIndex_hmIndex.put(n, linkedHashMap);
        }
        linkedHashMap.put(n2, this.position);
    }

    public double get(int n, int n2) {
        if (this.hmIndex_hmIndex.containsKey(n) && this.hmIndex_hmIndex.get(n).containsKey(n2)) {
            int n3 = this.hmIndex_hmIndex.get(n).get(n2);
            return this.data[n3];
        }
        return Double.NaN;
    }

    public double[] getArray() {
        return this.data;
    }

    public Matrix getMatrixK() {
        Matrix matrix = new Matrix(this.rows(), this.cols());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                matrix.set(i, j, this.get(i, j));
            }
        }
        return matrix;
    }

    public int cols() {
        return this.cols;
    }

    public int rows() {
        return this.rows;
    }

    private void read(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(13);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (!bl) {
            byteBuffer.position(0);
            int n = fileChannel.read(byteBuffer);
            if (n == -1) break;
            for (int i = 0; i < n; ++i) {
                byte by = byteBuffer.get(i);
                if (by == -1) {
                    bl = true;
                    continue;
                }
                if (by == 10) {
                    this.read(stringBuilder.toString());
                    stringBuilder.delete(0, stringBuilder.length());
                    continue;
                }
                stringBuilder.append((char)by);
            }
        }
        fileChannel.close();
    }

    private void read(File file, int n) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(13);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n2 = 0;
        block0: while (!bl) {
            byteBuffer.position(0);
            int n3 = fileChannel.read(byteBuffer);
            if (n3 == -1) break;
            for (int i = 0; i < n3; ++i) {
                byte by = byteBuffer.get(i);
                if (by == -1) {
                    bl = true;
                    continue;
                }
                if (by == 10) {
                    this.read(stringBuilder.toString());
                    stringBuilder.delete(0, stringBuilder.length());
                    if (++n2 != n) continue;
                    bl = true;
                    continue block0;
                }
                stringBuilder.append((char)by);
            }
        }
        fileChannel.close();
    }

    private void read(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        double d = Double.parseDouble(stringTokenizer.nextToken());
        if (n >= this.rows) {
            this.rows = n + 1;
        }
        if (n2 >= this.cols) {
            this.cols = n2 + 1;
        }
        this.set(n, n2, d);
    }

    private void resizeArray(int n) {
        if (this.data.length < n) {
            int n2;
            for (n2 = this.data.length; n2 < n; n2 += 10000) {
            }
            double[] dArray = new double[n2];
            int n3 = Math.min(this.position, n);
            System.arraycopy(this.data, 0, dArray, 0, n3);
            this.data = dArray;
        }
    }

    public String toStringRow(int n, NumberFormat numberFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hmIndex_hmIndex.get(n) != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.hmIndex_hmIndex.get(n).keySet());
            for (Integer n2 : arrayList) {
                double d = this.data[this.hmIndex_hmIndex.get(n).get(n2)];
                String string = n + " " + n2 + " " + numberFormat.format(d) + "\n";
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public String toString(NumberFormat numberFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.hmIndex_hmIndex.keySet());
        for (Integer n : arrayList) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.hmIndex_hmIndex.get(n).keySet());
            for (Integer n2 : arrayList2) {
                double d = this.data[this.hmIndex_hmIndex.get(n).get(n2)];
                String string = n + " " + n2 + " " + numberFormat.format(d) + "\n";
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("0.############");
        return this.toString(decimalFormat);
    }
}

