/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianDataOutputStream
implements DataOutput {
    private DataOutputStream delegate;
    private byte[] buffer;

    public LittleEndianDataOutputStream(OutputStream outputStream) {
        this.delegate = new DataOutputStream(outputStream);
        this.buffer = new byte[8];
    }

    @Override
    public final void writeShort(int n) throws IOException {
        this.buffer[0] = (byte)n;
        this.buffer[1] = (byte)(n >> 8);
        this.delegate.write(this.buffer, 0, 2);
    }

    @Override
    public final void writeChar(int n) throws IOException {
        this.buffer[0] = (byte)n;
        this.buffer[1] = (byte)(n >> 8);
        this.delegate.write(this.buffer, 0, 2);
    }

    @Override
    public final void writeInt(int n) throws IOException {
        this.buffer[0] = (byte)n;
        this.buffer[1] = (byte)(n >> 8);
        this.buffer[2] = (byte)(n >> 16);
        this.buffer[3] = (byte)(n >> 24);
        this.delegate.write(this.buffer, 0, 4);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        this.buffer[0] = (byte)l;
        this.buffer[1] = (byte)(l >> 8);
        this.buffer[2] = (byte)(l >> 16);
        this.buffer[3] = (byte)(l >> 24);
        this.buffer[4] = (byte)(l >> 32);
        this.buffer[5] = (byte)(l >> 40);
        this.buffer[6] = (byte)(l >> 48);
        this.buffer[7] = (byte)(l >> 56);
        this.delegate.write(this.buffer, 0, 8);
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    @Override
    public final synchronized void write(int n) throws IOException {
        this.delegate.write(n);
    }

    @Override
    public final synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.delegate.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        this.delegate.writeBoolean(bl);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.delegate.writeByte(n);
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        this.delegate.writeBytes(string);
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        this.delegate.writeUTF(string);
    }

    public final int size() {
        return this.delegate.size();
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        this.delegate.write(byArray, 0, byArray.length);
    }

    public final void close() throws IOException {
        this.delegate.close();
    }
}

