/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class DateAnalysis {
    private int[] max;
    private int[] min;
    private int[] value = new int[3];
    private int day;
    private int month;
    private int year;
    private int currentYear;
    private Calendar calendar;
    private boolean isTwoDigitYear;

    public DateAnalysis() {
        this.max = new int[3];
        this.min = new int[3];
        this.min[0] = Integer.MAX_VALUE;
        this.min[1] = Integer.MAX_VALUE;
        this.min[2] = Integer.MAX_VALUE;
        this.day = -1;
        this.month = -1;
        this.year = -1;
        this.isTwoDigitYear = false;
        this.currentYear = new GregorianCalendar().get(1);
    }

    public boolean analyse(String string) {
        if (!this.interpreteValues(string)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.min[i] > this.value[i]) {
                this.min[i] = this.value[i];
            }
            if (this.max[i] >= this.value[i]) continue;
            this.max[i] = this.value[i];
        }
        return true;
    }

    private boolean interpreteValues(String string) {
        String[] stringArray = string.split("[^\\w]+");
        if (stringArray.length != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            this.value[i] = this.interprete(stringArray[i], i);
            if (this.value[i] >= 0 && this.value[i] <= 3000) continue;
            return false;
        }
        return true;
    }

    public boolean isConclusive() {
        int n;
        for (n = 0; n < 3; ++n) {
            if (this.max[n] <= 31 && this.min[n] != 0) continue;
            if (this.year != -1 && this.year != n) {
                return false;
            }
            this.year = n;
        }
        if (this.year == -1 && this.max[2] < 100 && (this.max[0] <= 12 && this.max[1] <= 31 || this.max[0] <= 31 && this.max[1] <= 12)) {
            this.year = 2;
            this.isTwoDigitYear = true;
        }
        for (n = 0; n < 3; ++n) {
            if (n == this.year || this.max[n] <= 12 && (this.month == -1 || this.month == n)) continue;
            if (this.day != -1 && this.day != n) {
                return false;
            }
            this.day = n;
        }
        for (n = 0; n < 3; ++n) {
            if (n == this.year || n == this.day) continue;
            if (this.month != -1 && this.month != n) {
                return false;
            }
            this.month = n;
        }
        if (this.day == -1 || this.month == -1 || this.year == -1) {
            return false;
        }
        this.calendar = Calendar.getInstance();
        return true;
    }

    public long getDateMillis(String string) {
        if (!this.interpreteValues(string)) {
            return -1L;
        }
        if (this.isTwoDigitYear) {
            int n = this.year;
            this.value[n] = this.value[n] + (this.value[this.year] <= this.currentYear ? 2000 : 1900);
        }
        this.calendar.set(this.value[this.year], this.value[this.month] - 1, this.value[this.day], 12, 0, 0);
        return this.calendar.getTimeInMillis();
    }

    public float getDateFloat(String string) {
        long l = this.getDateMillis(string);
        return l == -1L ? Float.NaN : (float)((l + 43200000L) / 86400000L);
    }

    private int interprete(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            int n2 = DateAnalysis.interpreteMonth(string);
            if (n2 != -1) {
                if (this.month != -1 && this.month != n) {
                    return -1;
                }
                this.month = n;
            }
            return n2;
        }
    }

    public static int interpreteMonth(String string) {
        if ((string = string.toLowerCase()).startsWith("jan")) {
            return 1;
        }
        if (string.startsWith("feb")) {
            return 2;
        }
        if (string.startsWith("mar") || string.startsWith("m\u00c3\u00a4r") || string.startsWith("mae")) {
            return 3;
        }
        if (string.startsWith("apr")) {
            return 4;
        }
        if (string.startsWith("may") || string.startsWith("mai")) {
            return 5;
        }
        if (string.startsWith("jun")) {
            return 6;
        }
        if (string.startsWith("jul")) {
            return 7;
        }
        if (string.startsWith("aug")) {
            return 8;
        }
        if (string.startsWith("sep")) {
            return 9;
        }
        if (string.startsWith("oct") || string.startsWith("okt")) {
            return 10;
        }
        if (string.startsWith("nov")) {
            return 11;
        }
        if (string.startsWith("dec") || string.startsWith("dez")) {
            return 12;
        }
        return -1;
    }
}

