/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Base64 {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int GZIP = 2;
    public static final int DONT_GUNZIP = 4;
    public static final int DO_BREAK_LINES = 8;
    public static final int URL_SAFE = 16;
    public static final int ORDERED = 32;
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final String PREFERRED_ENCODING = "US-ASCII";
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] _STANDARD_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] _STANDARD_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final byte[] _URL_SAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] _URL_SAFE_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final byte[] _ORDERED_ALPHABET = new byte[]{45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte[] _ORDERED_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, -9, -9, -9, -1, -9, -9, -9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, -9, -9, -9, -9, 37, -9, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};

    private static final byte[] getAlphabet(int n) {
        if ((n & 0x10) == 16) {
            return _URL_SAFE_ALPHABET;
        }
        if ((n & 0x20) == 32) {
            return _ORDERED_ALPHABET;
        }
        return _STANDARD_ALPHABET;
    }

    private static final byte[] getDecodabet(int n) {
        if ((n & 0x10) == 16) {
            return _URL_SAFE_DECODABET;
        }
        if ((n & 0x20) == 32) {
            return _ORDERED_DECODABET;
        }
        return _STANDARD_DECODABET;
    }

    private Base64() {
    }

    private static byte[] encode3to4(byte[] byArray, byte[] byArray2, int n, int n2) {
        Base64.encode3to4(byArray2, 0, n, byArray, 0, n2);
        return byArray;
    }

    private static byte[] encode3to4(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = Base64.getAlphabet(n4);
        int n5 = (n2 > 0 ? byArray[n] << 24 >>> 8 : 0) | (n2 > 1 ? byArray[n + 1] << 24 >>> 16 : 0) | (n2 > 2 ? byArray[n + 2] << 24 >>> 24 : 0);
        switch (n2) {
            case 3: {
                byArray2[n3] = byArray3[n5 >>> 18];
                byArray2[n3 + 1] = byArray3[n5 >>> 12 & 0x3F];
                byArray2[n3 + 2] = byArray3[n5 >>> 6 & 0x3F];
                byArray2[n3 + 3] = byArray3[n5 & 0x3F];
                return byArray2;
            }
            case 2: {
                byArray2[n3] = byArray3[n5 >>> 18];
                byArray2[n3 + 1] = byArray3[n5 >>> 12 & 0x3F];
                byArray2[n3 + 2] = byArray3[n5 >>> 6 & 0x3F];
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
            case 1: {
                byArray2[n3] = byArray3[n5 >>> 18];
                byArray2[n3 + 1] = byArray3[n5 >>> 12 & 0x3F];
                byArray2[n3 + 2] = 61;
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
        }
        return byArray2;
    }

    public static void encode(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[4];
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(3, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n);
            Base64.encode3to4(byArray2, byArray, n, 0);
            byteBuffer2.put(byArray2);
        }
    }

    public static void encode(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[4];
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(3, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n);
            Base64.encode3to4(byArray2, byArray, n, 0);
            for (int i = 0; i < 4; ++i) {
                charBuffer.put((char)(byArray2[i] & 0xFF));
            }
        }
    }

    public static String encodeObject(Serializable serializable) throws IOException {
        return Base64.encodeObject(serializable, 0);
    }

    public static String encodeObject(Serializable serializable, int n) throws IOException {
        if (serializable == null) {
            throw new NullPointerException("Cannot serialize a null object.");
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        java.io.OutputStream outputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = new OutputStream(byteArrayOutputStream, 1 | n);
            if ((n & 2) != 0) {
                deflaterOutputStream = new GZIPOutputStream(outputStream);
                objectOutputStream = new ObjectOutputStream(deflaterOutputStream);
            } else {
                objectOutputStream = new ObjectOutputStream(outputStream);
            }
            objectOutputStream.writeObject(serializable);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                objectOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                deflaterOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        try {
            return new String(byteArrayOutputStream.toByteArray(), PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byteArrayOutputStream.toByteArray());
        }
    }

    public static String encodeBytes(byte[] byArray) {
        String string;
        block3: {
            string = null;
            try {
                string = Base64.encodeBytes(byArray, 0, byArray.length, 0);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)iOException.getMessage());
            }
        }
        assert (string != null);
        return string;
    }

    public static String encodeBytes(byte[] byArray, int n) throws IOException {
        return Base64.encodeBytes(byArray, 0, byArray.length, n);
    }

    public static String encodeBytes(byte[] byArray, int n, int n2) {
        String string;
        block3: {
            string = null;
            try {
                string = Base64.encodeBytes(byArray, n, n2, 0);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)iOException.getMessage());
            }
        }
        assert (string != null);
        return string;
    }

    public static String encodeBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        byte[] byArray2 = Base64.encodeBytesToBytes(byArray, n, n2, n3);
        try {
            return new String(byArray2, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray2);
        }
    }

    public static byte[] encodeBytesToBytes(byte[] byArray) {
        byte[] byArray2;
        block2: {
            byArray2 = null;
            try {
                byArray2 = Base64.encodeBytesToBytes(byArray, 0, byArray.length, 0);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("IOExceptions only come from GZipping, which is turned off: " + iOException.getMessage()));
            }
        }
        return byArray2;
    }

    public static byte[] encodeBytesToBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("Cannot serialize a null array.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Cannot have negative offset: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot have length offset: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException(String.format("Cannot have offset of %d and length of %d with array of length %d", n, n2, byArray.length));
        }
        if ((n3 & 2) != 0) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            DeflaterOutputStream deflaterOutputStream = null;
            OutputStream outputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                outputStream = new OutputStream(byteArrayOutputStream, 1 | n3);
                deflaterOutputStream = new GZIPOutputStream(outputStream);
                ((GZIPOutputStream)deflaterOutputStream).write(byArray, n, n2);
                deflaterOutputStream.close();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                try {
                    deflaterOutputStream.close();
                }
                catch (Exception exception) {}
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
            }
            return byteArrayOutputStream.toByteArray();
        }
        boolean bl = (n3 & 8) != 0;
        int n4 = n2 / 3 * 4 + (n2 % 3 > 0 ? 4 : 0);
        if (bl) {
            n4 += n4 / 76;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 - 2;
        int n8 = 0;
        while (n5 < n7) {
            Base64.encode3to4(byArray, n5 + n, 3, byArray2, n6, n3);
            if (bl && (n8 += 4) >= 76) {
                byArray2[n6 + 4] = 10;
                ++n6;
                n8 = 0;
            }
            n5 += 3;
            n6 += 4;
        }
        if (n5 < n2) {
            Base64.encode3to4(byArray, n5 + n, n2 - n5, byArray2, n6, n3);
            n6 += 4;
        }
        if (n6 <= byArray2.length - 1) {
            byte[] byArray3 = new byte[n6];
            System.arraycopy(byArray2, 0, byArray3, 0, n6);
            return byArray3;
        }
        return byArray2;
    }

    private static int decode4to3(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("Source array was null.");
        }
        if (byArray2 == null) {
            throw new NullPointerException("Destination array was null.");
        }
        if (n < 0 || n + 3 >= byArray.length) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d and still process four bytes.", byArray.length, n));
        }
        if (n2 < 0 || n2 + 2 >= byArray2.length) {
            throw new IllegalArgumentException(String.format("Destination array with length %d cannot have offset of %d and still store three bytes.", byArray2.length, n2));
        }
        byte[] byArray3 = Base64.getDecodabet(n3);
        if (byArray[n + 2] == 61) {
            int n4 = (byArray3[byArray[n]] & 0xFF) << 18 | (byArray3[byArray[n + 1]] & 0xFF) << 12;
            byArray2[n2] = (byte)(n4 >>> 16);
            return 1;
        }
        if (byArray[n + 3] == 61) {
            int n5 = (byArray3[byArray[n]] & 0xFF) << 18 | (byArray3[byArray[n + 1]] & 0xFF) << 12 | (byArray3[byArray[n + 2]] & 0xFF) << 6;
            byArray2[n2] = (byte)(n5 >>> 16);
            byArray2[n2 + 1] = (byte)(n5 >>> 8);
            return 2;
        }
        int n6 = (byArray3[byArray[n]] & 0xFF) << 18 | (byArray3[byArray[n + 1]] & 0xFF) << 12 | (byArray3[byArray[n + 2]] & 0xFF) << 6 | byArray3[byArray[n + 3]] & 0xFF;
        byArray2[n2] = (byte)(n6 >> 16);
        byArray2[n2 + 1] = (byte)(n6 >> 8);
        byArray2[n2 + 2] = (byte)n6;
        return 3;
    }

    public static byte[] decode(byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        byArray2 = Base64.decode(byArray, 0, byArray.length, 0);
        return byArray2;
    }

    public static byte[] decode(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("Cannot decode null source array.");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d and process %d bytes.", byArray.length, n, n2));
        }
        if (n2 == 0) {
            return new byte[0];
        }
        if (n2 < 4) {
            throw new IllegalArgumentException("Base64-encoded string must have at least four characters, but length specified was " + n2);
        }
        byte[] byArray2 = Base64.getDecodabet(n3);
        int n4 = n2 * 3 / 4;
        byte[] byArray3 = new byte[n4];
        int n5 = 0;
        byte[] byArray4 = new byte[4];
        int n6 = 0;
        int n7 = 0;
        byte by = 0;
        for (n7 = n; n7 < n + n2; ++n7) {
            by = byArray2[byArray[n7] & 0xFF];
            if (by >= -5) {
                if (by < -1) continue;
                byArray4[n6++] = byArray[n7];
                if (n6 <= 3) continue;
                n5 += Base64.decode4to3(byArray4, 0, byArray3, n5, n3);
                n6 = 0;
                if (byArray[n7] != 61) continue;
                break;
            }
            throw new IOException(String.format("Bad Base64 input character decimal %d in array position %d", byArray[n7] & 0xFF, n7));
        }
        byte[] byArray5 = new byte[n5];
        System.arraycopy(byArray3, 0, byArray5, 0, n5);
        return byArray5;
    }

    public static byte[] decode(String string) throws IOException {
        return Base64.decode(string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decode(String string, int n) throws IOException {
        int n2;
        boolean bl;
        byte[] byArray;
        if (string == null) {
            throw new NullPointerException("Input string was null.");
        }
        try {
            byArray = string.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        byArray = Base64.decode(byArray, 0, byArray.length, n);
        boolean bl2 = bl = (n & 4) != 0;
        if (byArray != null && byArray.length >= 4 && !bl && 35615 == (n2 = byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00)) {
            ByteArrayInputStream byteArrayInputStream = null;
            GZIPInputStream gZIPInputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            byte[] byArray2 = new byte[2048];
            int n3 = 0;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                while ((n3 = gZIPInputStream.read(byArray2)) >= 0) {
                    byteArrayOutputStream.write(byArray2, 0, n3);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
                try {
                    gZIPInputStream.close();
                }
                catch (Exception exception) {}
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byArray;
    }

    public static Object decodeToObject(String string) throws IOException, ClassNotFoundException {
        return Base64.decodeToObject(string, 0, null);
    }

    public static Object decodeToObject(String string, int n, final ClassLoader classLoader) throws IOException, ClassNotFoundException {
        byte[] byArray = Base64.decode(string, n);
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            objectInputStream = classLoader == null ? new ObjectInputStream(byteArrayInputStream) : new ObjectInputStream(byteArrayInputStream){

                @Override
                public Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                    Class<?> clazz = Class.forName(objectStreamClass.getName(), false, classLoader);
                    if (clazz == null) {
                        return super.resolveClass(objectStreamClass);
                    }
                    return clazz;
                }
            };
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (Exception exception) {}
            try {
                objectInputStream.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public static void encodeToFile(byte[] byArray, String string) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("Data to encode was null.");
        }
        OutputStream outputStream = null;
        try {
            outputStream = new OutputStream(new FileOutputStream(string), 1);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void decodeToFile(String string, String string2) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new OutputStream(new FileOutputStream(string2), 0);
            outputStream.write(string.getBytes(PREFERRED_ENCODING));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] decodeFromFile(String string) throws IOException {
        byte[] byArray = null;
        FilterInputStream filterInputStream = null;
        try {
            File file = new File(string);
            byte[] byArray2 = null;
            int n = 0;
            int n2 = 0;
            if (file.length() > Integer.MAX_VALUE) {
                throw new IOException("File is too big for this convenience method (" + file.length() + " bytes).");
            }
            byArray2 = new byte[(int)file.length()];
            filterInputStream = new InputStream(new BufferedInputStream(new FileInputStream(file)), 0);
            while ((n2 = ((InputStream)filterInputStream).read(byArray2, n, 4096)) >= 0) {
                n += n2;
            }
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public static String encodeFromFile(String string) throws IOException {
        String string2 = null;
        FilterInputStream filterInputStream = null;
        try {
            File file = new File(string);
            byte[] byArray = new byte[Math.max((int)((double)file.length() * 1.4 + 1.0), 40)];
            int n = 0;
            int n2 = 0;
            filterInputStream = new InputStream(new BufferedInputStream(new FileInputStream(file)), 1);
            while ((n2 = ((InputStream)filterInputStream).read(byArray, n, 4096)) >= 0) {
                n += n2;
            }
            string2 = new String(byArray, 0, n, PREFERRED_ENCODING);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    public static void encodeFileToFile(String string, String string2) throws IOException {
        String string3 = Base64.encodeFromFile(string);
        java.io.OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(string2));
            outputStream.write(string3.getBytes(PREFERRED_ENCODING));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void decodeFileToFile(String string, String string2) throws IOException {
        byte[] byArray = Base64.decodeFromFile(string);
        java.io.OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(string2));
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static class OutputStream
    extends FilterOutputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int lineLength;
        private boolean breakLines;
        private byte[] b4;
        private boolean suspendEncoding;
        private int options;
        private byte[] decodabet;

        public OutputStream(java.io.OutputStream outputStream) {
            this(outputStream, 1);
        }

        public OutputStream(java.io.OutputStream outputStream, int n) {
            super(outputStream);
            this.breakLines = (n & 8) != 0;
            this.encode = (n & 1) != 0;
            this.bufferLength = this.encode ? 3 : 4;
            this.buffer = new byte[this.bufferLength];
            this.position = 0;
            this.lineLength = 0;
            this.suspendEncoding = false;
            this.b4 = new byte[4];
            this.options = n;
            this.decodabet = Base64.getDecodabet(n);
        }

        @Override
        public void write(int n) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(n);
                return;
            }
            if (this.encode) {
                this.buffer[this.position++] = (byte)n;
                if (this.position >= this.bufferLength) {
                    this.out.write(Base64.encode3to4(this.b4, this.buffer, this.bufferLength, this.options));
                    this.lineLength += 4;
                    if (this.breakLines && this.lineLength >= 76) {
                        this.out.write(10);
                        this.lineLength = 0;
                    }
                    this.position = 0;
                }
            } else if (this.decodabet[n & 0x7F] > -5) {
                this.buffer[this.position++] = (byte)n;
                if (this.position >= this.bufferLength) {
                    int n2 = Base64.decode4to3(this.buffer, 0, this.b4, 0, this.options);
                    this.out.write(this.b4, 0, n2);
                    this.position = 0;
                }
            } else if (this.decodabet[n & 0x7F] != -5) {
                throw new IOException("Invalid character in Base64 data.");
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(byArray, n, n2);
                return;
            }
            for (int i = 0; i < n2; ++i) {
                this.write(byArray[n + i]);
            }
        }

        public void flushBase64() throws IOException {
            if (this.position > 0) {
                if (this.encode) {
                    this.out.write(Base64.encode3to4(this.b4, this.buffer, this.position, this.options));
                    this.position = 0;
                } else {
                    throw new IOException("Base64 input not properly padded.");
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.flushBase64();
            super.close();
            this.buffer = null;
            this.out = null;
        }

        public void suspendEncoding() throws IOException {
            this.flushBase64();
            this.suspendEncoding = true;
        }

        public void resumeEncoding() {
            this.suspendEncoding = false;
        }
    }

    public static class InputStream
    extends FilterInputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int numSigBytes;
        private int lineLength;
        private boolean breakLines;
        private int options;
        private byte[] decodabet;

        public InputStream(java.io.InputStream inputStream) {
            this(inputStream, 0);
        }

        public InputStream(java.io.InputStream inputStream, int n) {
            super(inputStream);
            this.options = n;
            this.breakLines = (n & 8) > 0;
            this.encode = (n & 1) > 0;
            this.bufferLength = this.encode ? 4 : 3;
            this.buffer = new byte[this.bufferLength];
            this.position = -1;
            this.lineLength = 0;
            this.decodabet = Base64.getDecodabet(n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read() throws IOException {
            if (this.position < 0) {
                byte[] byArray;
                if (this.encode) {
                    int n;
                    byArray = new byte[3];
                    int n2 = 0;
                    for (int i = 0; i < 3 && (n = this.in.read()) >= 0; ++i) {
                        byArray[i] = (byte)n;
                        ++n2;
                    }
                    if (n2 <= 0) return -1;
                    Base64.encode3to4(byArray, 0, n2, this.buffer, 0, this.options);
                    this.position = 0;
                    this.numSigBytes = 4;
                } else {
                    byArray = new byte[4];
                    int n = 0;
                    for (n = 0; n < 4; ++n) {
                        int n3 = 0;
                        while ((n3 = this.in.read()) >= 0 && this.decodabet[n3 & 0x7F] <= -5) {
                        }
                        if (n3 < 0) break;
                        byArray[n] = (byte)n3;
                    }
                    if (n == 4) {
                        this.numSigBytes = Base64.decode4to3(byArray, 0, this.buffer, 0, this.options);
                        this.position = 0;
                    } else {
                        if (n != 0) throw new IOException("Improperly padded Base64 input.");
                        return -1;
                    }
                }
            }
            if (this.position < 0) throw new IOException("Error in Base64 code reading stream.");
            if (this.position >= this.numSigBytes) {
                return -1;
            }
            if (this.encode && this.breakLines && this.lineLength >= 76) {
                this.lineLength = 0;
                return 10;
            }
            ++this.lineLength;
            byte by = this.buffer[this.position++];
            if (this.position < this.bufferLength) return by & 0xFF;
            this.position = -1;
            return by & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.read();
                if (n4 < 0) {
                    if (n3 != 0) break;
                    return -1;
                }
                byArray[n + n3] = (byte)n4;
            }
            return n3;
        }
    }
}

