/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

public class Angle {
    public final double TWO_PI = Math.PI * 2;
    private double mValue;

    public Angle() {
    }

    public Angle(Angle angle) {
        this(angle.mValue);
    }

    public Angle(double d) {
        this.mValue = d;
        this.normalize();
    }

    public void normalize() {
        while (this.mValue < -Math.PI) {
            this.mValue += Math.PI * 2;
        }
        while (this.mValue >= Math.PI) {
            this.mValue -= Math.PI * 2;
        }
    }

    public double toDegrees() {
        return 180.0 * this.mValue / Math.PI;
    }

    public double getValue() {
        return this.mValue;
    }

    public void setValue(double d) {
        this.mValue = d;
        this.normalize();
    }

    public double cos() {
        return Math.cos(this.mValue);
    }

    public double sin() {
        return Math.sin(this.mValue);
    }

    public double tan() {
        return Math.tan(this.mValue);
    }

    public static Angle arcsin(double d) {
        return new Angle(Math.asin(d));
    }

    public static Angle arccos(double d) {
        return new Angle(Math.acos(d));
    }

    public static Angle arctan(double d, double d2) {
        return new Angle(Math.atan2(d, d2));
    }

    public static double mean(Angle angle, Angle angle2) {
        double d = (angle.mValue + angle2.mValue) / 2.0;
        double d2 = angle2.mValue - angle.mValue;
        if (Math.abs(d2) > Math.PI) {
            d = d < 0.0 ? (d += Math.PI) : (d -= Math.PI);
        }
        return d;
    }

    public static double difference(double d, double d2) {
        double d3 = d - d2;
        if (d3 >= Math.PI) {
            d3 -= Math.PI * 2;
        } else if (d3 < -Math.PI) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    public static double difference(Angle angle, Angle angle2) {
        return Angle.difference(angle.mValue, angle2.mValue);
    }

    public void add(double d) {
        this.mValue += d;
        this.normalize();
    }

    public void add(Angle angle) {
        this.add(angle.mValue);
    }

    public void subtract(double d) {
        this.mValue -= d;
        this.normalize();
    }

    public void subtract(Angle angle) {
        this.subtract(angle.mValue);
    }

    public boolean isSmallerThan(Angle angle) {
        double d = angle.mValue - this.mValue;
        return d > 0.0 && d < Math.PI || d < 0.0 && d > Math.PI;
    }

    public boolean isGreaterThan(Angle angle) {
        double d = this.mValue - angle.mValue;
        return d > 0.0 && d < Math.PI || d < 0.0 && d > Math.PI;
    }

    public String toString() {
        return this.toDegrees() + " degrees";
    }
}

