/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.geom;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.share.gui.DrawConfig;
import com.actelion.research.share.gui.Polygon;
import com.actelion.research.share.gui.editor.chem.IArrow;
import com.actelion.research.share.gui.editor.dialogs.IAtomPropertiesDialog;
import com.actelion.research.share.gui.editor.dialogs.IAtomQueryFeaturesDialog;
import com.actelion.research.share.gui.editor.dialogs.IBondQueryFeaturesDialog;
import com.actelion.research.share.gui.editor.geom.IPolygon;
import com.actelion.research.share.gui.editor.io.IKeyCode;

public abstract class GeomFactory {
    private DrawConfig drawConfig;

    public GeomFactory(DrawConfig drawConfig) {
        this.drawConfig = drawConfig;
    }

    public final IPolygon createPolygon() {
        return new Polygon();
    }

    public abstract IArrow createArrow(GenericRectangle var1);

    public abstract IAtomQueryFeaturesDialog createAtomQueryFeatureDialog(StereoMolecule var1, int var2, boolean var3);

    public abstract IBondQueryFeaturesDialog createBondFeaturesDialog(StereoMolecule var1, int var2);

    public abstract IAtomPropertiesDialog createAtomPropertiesDialog(StereoMolecule var1, int var2);

    public abstract GenericRectangle getBoundingRect(StereoMolecule var1);

    public abstract IKeyCode getDeleteKey();

    public abstract IKeyCode getEscapeKey();

    public abstract IKeyCode getBackSpaceKey();

    public abstract IKeyCode getEnterKey();

    public DrawConfig getDrawConfig() {
        return this.drawConfig;
    }

    public final long getHighLightColor() {
        return this.drawConfig.getHighLightColor();
    }

    public final long getMapToolColor() {
        return this.drawConfig.getMapToolColor();
    }

    public final long getSelectionColor() {
        return this.drawConfig.getSelectionColor();
    }

    public final long getForegroundColor() {
        return this.drawConfig.getForegroundColor();
    }

    public final long getBackgroundColor() {
        return this.drawConfig.getBackgroundColor();
    }
}

