/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.io;

import com.actelion.research.util.Pipeline;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;

public class StringReadChannel {
    private static final int CAPACITY_LINE_BUFFER = 50000000;
    private static final int CAPACITY_READ_BUFFER = 100000;
    private static final int CAPACITY_PIPE = 1000;
    private ReadableByteChannel byteChannel;
    private ByteBuffer buffer;
    private ByteBuffer byteBufferLine;
    private Pipeline<String> pipeline;

    public StringReadChannel(ReadableByteChannel readableByteChannel) throws IOException {
        this.init(readableByteChannel);
    }

    private void init(ReadableByteChannel readableByteChannel) throws IOException {
        this.byteChannel = readableByteChannel;
        this.byteBufferLine = ByteBuffer.allocate(50000000);
        this.buffer = ByteBuffer.allocate(100000);
        this.pipeline = new Pipeline();
        this.readLine2List();
    }

    public boolean hasMoreLines() throws IOException {
        return !this.pipeline.wereAllDataFetched();
    }

    public String readLine() throws IOException {
        int n = 100;
        String string = null;
        if (!this.pipeline.isEmpty()) {
            string = this.pipeline.pollData();
        } else if (!this.pipeline.isAllDataIn()) {
            int n2 = 0;
            while (this.pipeline.isEmpty()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (++n2 > n) {
                    RuntimeException runtimeException = new RuntimeException("Arbitrary break. Max number of cycles (" + n + ") exceeded.");
                    this.byteChannel.close();
                    throw runtimeException;
                }
                string = this.pipeline.pollData();
            }
        }
        if (!this.pipeline.isAllDataIn() && this.pipeline.sizePipe() < 1000) {
            this.readLine2List();
        }
        return string;
    }

    public void finalize() throws IOException {
        this.close();
    }

    private int readLine2List() throws IOException {
        boolean bl = false;
        int n = 0;
        while (!bl) {
            ((Buffer)this.buffer).clear();
            int n2 = this.byteChannel.read(this.buffer);
            if (n2 == -1) {
                if (this.byteBufferLine.position() > 0) {
                    this.writeBuffer2Pipe();
                    bl = true;
                }
                this.pipeline.setAllDataIn(true);
                return -1;
            }
            for (int i = 0; i < n2; ++i) {
                byte by = this.buffer.get(i);
                if (by == 10) {
                    this.writeBuffer2Pipe();
                    bl = true;
                    continue;
                }
                if (by == 13) continue;
                this.byteBufferLine.put(by);
                ++n;
            }
        }
        return n;
    }

    private void writeBuffer2Pipe() throws UnsupportedEncodingException {
        byte[] byArray = Arrays.copyOf(this.byteBufferLine.array(), this.byteBufferLine.position());
        String string = new String(byArray, "UTF8");
        StringBuilder stringBuilder = new StringBuilder(string);
        this.pipeline.addData(stringBuilder.toString());
        ((Buffer)this.byteBufferLine).clear();
    }

    public static void skipUntilLineMatchesRegEx(StringReadChannel stringReadChannel, String string) throws NoSuchFieldException, IOException {
        int n = 10000;
        StringReadChannel.skipUntilLineMatchesRegEx(stringReadChannel, string, n);
    }

    public static String skipUntilLineMatchesRegEx(StringReadChannel stringReadChannel, String string, int n) throws NoSuchFieldException, IOException {
        String string2 = stringReadChannel.readLine();
        boolean bl = false;
        if (string2.matches(string)) {
            bl = true;
        }
        int n2 = 0;
        while (!bl && stringReadChannel.hasMoreLines()) {
            string2 = stringReadChannel.readLine();
            if (string2.matches(string)) {
                bl = true;
            }
            if (++n2 <= n) continue;
        }
        String string3 = null;
        if (!bl) {
            throw new NoSuchFieldException("Regex " + string + " was not found.");
        }
        string3 = string2;
        return string3;
    }

    public void close() throws IOException {
        this.byteChannel.close();
    }
}

