/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.wmf;

import com.actelion.research.gui.wmf.GraphicsState;
import com.actelion.research.gui.wmf.MetaFile;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.text.AttributedCharacterIterator;

public class WMFGraphics
extends Graphics {
    public static final int MM_ANISOTROPIC = 8;
    private static final int BS_NULL = 1;
    public static final int SRC_AND = 8913094;
    public static final int SRC_PAINT = 15597702;
    public static final int SRC_COPY = 0xCC0020;
    private MetaFile wmf;
    private Color foreground;
    private Color background;
    private Font font = new Font("Helvetica", 0, 12);
    private int penstyle;
    private int penwidth;
    private int brushfillstyle;
    private int brushhatch;
    private int fontescapement;
    private Image brushpattern;
    private int penhandle;
    private int brushhandle;
    private int fonthandle;
    private Rectangle clip;
    private Point origin;
    private GraphicsState state;

    public WMFGraphics(MetaFile metaFile, int n, int n2, Color color, Color color2) {
        this.penstyle = 0;
        this.penwidth = 1;
        this.brushfillstyle = 0;
        this.brushhatch = 0;
        this.fontescapement = 0;
        this.brushpattern = null;
        this.origin = new Point(0, 0);
        this.foreground = color;
        this.background = color2;
        this.state = new GraphicsState();
        this.state.increaseCount();
        this.setWMF(metaFile, n, n2);
        this.reset();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    WMFGraphics(MetaFile metaFile, GraphicsState graphicsState, Color color, Color color2, Font font, int n, int n2, int n3, int n4, int n5, Image image, Point point, Rectangle rectangle) {
        this.wmf = metaFile;
        this.state = graphicsState;
        graphicsState.increaseCount();
        this.foreground = color;
        this.background = color2;
        this.font = font;
        this.penstyle = n;
        this.penwidth = n2;
        this.brushfillstyle = n3;
        this.brushhatch = n4;
        this.fontescapement = n5;
        this.brushpattern = image;
        this.origin = new Point(point.x, point.y);
        if (rectangle != null) {
            this.clip = new Rectangle(rectangle);
        }
        this.createHandles();
        this.setGDIPen();
        this.setGDIHollowBrush();
        this.setGDIFont();
    }

    public void GDIPolyPolygon(Polygon[] polygonArray) {
        this.restore();
        this.setGDIFillBrush();
        this.wmf.polypolygon(polygonArray);
        this.setGDIHollowBrush();
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.restore();
        Color color = this.foreground;
        this.setColor(this.background);
        this.fillRect(n, n2, n3, n4);
        this.setColor(color);
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.restore();
        this.wmf.intersectClipRect(n, n2, n + n3 + 1, n2 + n4 + 1);
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.clip = this.clip != null ? this.clip.intersection(rectangle) : rectangle;
        this.state.setClip(this.clip);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        System.err.println("copyArea not supported");
    }

    @Override
    public Graphics create() {
        WMFGraphics wMFGraphics = new WMFGraphics(this.wmf, this.state, this.foreground, this.background, this.font, this.penstyle, this.penwidth, this.brushfillstyle, this.brushhatch, this.fontescapement, this.brushpattern, this.origin, this.clip);
        return wMFGraphics;
    }

    public void createHandles() {
        this.penhandle = this.wmf.createPenIndirect(this.penstyle, this.penwidth, this.foreground);
        this.wmf.selectObject(this.penhandle);
        this.state.setPen(this.penhandle);
        this.brushhandle = this.wmf.createBrushIndirect(1, this.foreground, this.brushhatch);
        this.wmf.selectObject(this.brushhandle);
        this.state.setPen(this.brushhandle);
        this.fonthandle = this.wmf.createFont(this.font, this.fontescapement, false, false);
        this.wmf.selectObject(this.fonthandle);
        this.state.setPen(this.fonthandle);
    }

    public void deleteHandles() {
        this.wmf.deleteObject(this.penhandle);
        this.wmf.deleteObject(this.brushhandle);
        this.wmf.deleteObject(this.fonthandle);
    }

    @Override
    public void dispose() {
        this.state.decreaseCount();
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.restore();
        int n7 = n + n3 / 2;
        int n8 = n2 + n4 / 2;
        this.wmf.arc(n, n2, n + n3 + 1, n2 + n4 + 1, n7 + (int)Math.round((double)n3 * Math.sin(Math.PI * 2 * (double)(n5 + 90) / 360.0)), n8 + (int)Math.round((double)n4 * Math.cos(Math.PI * 2 * (double)(n5 + 90) / 360.0)), n7 + (int)Math.round((double)n3 * Math.sin(Math.PI * 2 * (double)(n5 + n6 + 90) / 360.0)), n8 + (int)Math.round((double)n4 * Math.cos(Math.PI * 2 * (double)(n5 + n6 + 90) / 360.0)));
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        this.restore();
        int n9 = image.getWidth(imageObserver);
        int n10 = image.getHeight(imageObserver);
        int[] nArray = new int[n9 * n10];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n9, n10, nArray, 0, n9);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            return false;
        }
        int n11 = n3 - n;
        int n12 = n4 - n2;
        int n13 = n7 - n5;
        int n14 = n8 - n6;
        int n15 = n8;
        n8 = n10 - n6;
        n6 = n10 - n15;
        if (n11 < 0 != n13 < 0) {
            this.flipHorizontal(nArray, n9, n10);
            n5 = n13 < 0 ? n9 - n5 : n9 - n7;
        }
        if (n11 < 0) {
            n = n3;
            if (n13 < 0) {
                n5 = n7;
            }
            n11 = -n11;
        }
        if (n13 < 0) {
            n13 = -n13;
        }
        if (n12 < 0 != n14 < 0) {
            this.flipVertical(nArray, n9, n10);
            n6 = n14 < 0 ? n10 - n6 : n10 - n8;
        }
        if (n12 < 0) {
            n2 = n4;
            if (n14 < 0) {
                n6 = n8;
            }
            n12 = -n12;
        }
        if (n14 < 0) {
            n14 = -n14;
        }
        int n16 = color.getRGB();
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & 0xFF000000) != 0) continue;
            nArray[i] = n16;
        }
        this.wmf.stretchBlt(n, n2, n11, n12, n5, n6, n13, n14, 0xCC0020, nArray, n9, n10);
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.restore();
        int n9 = image.getWidth(imageObserver);
        int n10 = image.getHeight(imageObserver);
        int[] nArray = new int[n9 * n10];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n9, n10, nArray, 0, n9);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            return false;
        }
        int n11 = n3 - n;
        int n12 = n4 - n2;
        int n13 = n7 - n5;
        int n14 = n8 - n6;
        n8 = n10 - n6;
        n6 = n10 - n8;
        if (n11 < 0 != n13 < 0) {
            this.flipHorizontal(nArray, n9, n10);
            n5 = n13 < 0 ? n9 - n5 : n9 - n7;
        }
        if (n11 < 0) {
            n = n3;
            if (n13 < 0) {
                n5 = n7;
            }
            n11 = -n11;
        }
        if (n13 < 0) {
            n13 = -n13;
        }
        if (n12 < 0 != n14 < 0) {
            this.flipVertical(nArray, n9, n10);
            n6 = n14 < 0 ? n10 - n6 : n10 - n8;
        }
        if (n12 < 0) {
            n2 = n4;
            if (n14 < 0) {
                n6 = n8;
            }
            n12 = -n12;
        }
        if (n14 < 0) {
            n14 = -n14;
        }
        int[] nArray2 = new int[nArray.length];
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & 0xFF000000) == 0) {
                nArray2[i] = -1;
                nArray[i] = 0;
                bl = true;
                continue;
            }
            nArray2[i] = 0;
        }
        if (bl) {
            this.wmf.stretchBlt(n, n2, n11, n12, n5, n6, n13, n14, 8913094, nArray2, n9, n10);
            this.wmf.stretchBlt(n, n2, n11, n12, n5, n6, n13, n14, 15597702, nArray, n9, n10);
        } else {
            this.wmf.stretchBlt(n, n2, n11, n12, n5, n6, n13, n14, 0xCC0020, nArray, n9, n10);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.restore();
        return this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.restore();
        return this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        this.restore();
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.restore();
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.restore();
        this.wmf.moveTo(n, n2);
        this.wmf.lineTo(n3, n4);
        this.wmf.setPixel(n3, n4, this.getColor());
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.restore();
        this.wmf.ellipse(n, n2, n + n3 + 1, n2 + n4 + 1);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.restore();
        this.wmf.polygon(nArray, nArray2, n);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.restore();
        this.wmf.polyline(nArray, nArray2, n);
        this.wmf.setPixel(nArray[n - 1], nArray2[n - 1], this.getColor());
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.restore();
        this.wmf.rectangle(n, n2, n + n3 + 1, n2 + n4 + 1);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.restore();
        this.wmf.roundRect(n, n2, n + n3 + 1, n2 + n4 + 1, n5, n6);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.restore();
        this.wmf.textOut(n, n2, string);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        System.err.println("drawString(java.text.AttributedCharacterIterator,..) not supported");
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.restore();
        this.setGDIFillBrush();
        int n7 = n + n3 / 2;
        int n8 = n2 + n4 / 2;
        this.wmf.pie(n, n2, n + n3 + 1, n2 + n4 + 1, n7 + (int)Math.round((double)n3 * Math.sin(Math.PI * 2 * (double)(n5 + 90) / 360.0)), n8 + (int)Math.round((double)n4 * Math.cos(Math.PI * 2 * (double)(n5 + 90) / 360.0)), n7 + (int)Math.round((double)n3 * Math.sin(Math.PI * 2 * (double)(n5 + n6 + 90) / 360.0)), n8 + (int)Math.round((double)n4 * Math.cos(Math.PI * 2 * (double)(n5 + n6 + 90) / 360.0)));
        this.setGDIHollowBrush();
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.restore();
        this.setGDIFillBrush();
        this.drawOval(n, n2, n3 - 1, n4 - 1);
        this.setGDIHollowBrush();
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.restore();
        this.setGDIFillBrush();
        this.drawPolygon(nArray, nArray2, n);
        this.setGDIHollowBrush();
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.restore();
        this.setGDIFillBrush();
        this.drawRect(n, n2, n3 - 1, n4 - 1);
        this.setGDIHollowBrush();
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.restore();
        this.setGDIFillBrush();
        this.drawRoundRect(n, n2, n3 - 1, n4 - 1, n5, n6);
        this.setGDIHollowBrush();
    }

    private void flipHorizontal(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = i * n2;
            for (int j = 0; j < n / 2; ++j) {
                int n4 = nArray[n3 + j];
                nArray[n3 + j] = nArray[n3 + n - 1 - j];
                nArray[n3 + n - 1 - j] = n4;
            }
        }
    }

    private void flipVertical(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n];
        for (int i = 0; i < n2 / 2; ++i) {
            System.arraycopy(nArray, i * n, nArray2, 0, n);
            System.arraycopy(nArray, (n2 - i - 1) * n, nArray, i * n, n);
            System.arraycopy(nArray2, 0, nArray, (n2 - i - 1) * n, n);
        }
    }

    public int getBrushFillStyle() {
        return this.brushfillstyle;
    }

    @Override
    public Shape getClip() {
        return this.getClipBounds();
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip != null) {
            return new Rectangle(this.clip);
        }
        return null;
    }

    @Override
    public Color getColor() {
        return this.foreground;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public int getPenStyle() {
        return this.penstyle;
    }

    private void reset() {
        this.setPenStyle(0);
        this.setPenWidth(1);
        this.setBrushFillStyle(0);
        this.setBrushHatch(0);
        this.setFontEscapement(0);
    }

    private void restore() {
        if (this.state.getCount() > 1) {
            if (this.penhandle != this.state.getPen()) {
                this.wmf.selectObject(this.penhandle);
                this.state.setPen(this.penhandle);
            }
            if (this.brushhandle != this.state.getBrush()) {
                this.wmf.selectObject(this.brushhandle);
                this.state.setBrush(this.brushhandle);
            }
            if (this.fonthandle != this.state.getFont()) {
                this.wmf.selectObject(this.fonthandle);
                this.state.setFont(this.fonthandle);
            }
            if (this.clip != this.state.getClip()) {
                this.setClip(this.clip);
                this.state.setClip(this.clip);
            }
            if (!this.origin.equals(this.state.getOrigin())) {
                this.translate(this.origin.x, this.origin.y);
                this.state.setOrigin(this.origin);
            }
        }
    }

    public void setBrushFillStyle(int n) {
        this.brushfillstyle = n;
    }

    public void setBrushHatch(int n) {
        this.brushhatch = n;
    }

    public void setBrushPattern(Image image) {
        this.brushpattern = image;
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void setClip(Shape shape) {
        this.wmf.setClipRgn();
        this.clip = null;
        if (shape != null) {
            Rectangle rectangle = shape.getBounds();
            this.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void setColor(Color color) {
        this.restore();
        this.foreground = color;
        this.setGDIPen();
        this.wmf.setTextColor(this.foreground);
    }

    @Override
    public void setFont(Font font) {
        this.restore();
        this.font = font;
        this.setGDIFont();
    }

    public void setFontEscapement(int n) {
        this.fontescapement = n;
        this.setGDIFont();
    }

    public int setGDIFillBrush() {
        int n;
        block7: {
            n = this.brushhandle;
            if (this.brushfillstyle == 3) {
                if (this.brushpattern != null) {
                    int n2 = this.brushpattern.getWidth(null);
                    int n3 = this.brushpattern.getHeight(null);
                    int[] nArray = new int[n2 * n3];
                    PixelGrabber pixelGrabber = new PixelGrabber(this.brushpattern, 0, 0, n2, n3, nArray, 0, n2);
                    try {
                        pixelGrabber.grabPixels();
                        if ((pixelGrabber.status() & 0x80) != 0) {
                            this.brushhandle = this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                            break block7;
                        }
                        this.brushhandle = this.wmf.createPatternBrush(nArray, n2, n3);
                    }
                    catch (InterruptedException interruptedException) {
                        this.brushhandle = this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                    }
                } else {
                    this.brushhandle = this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                }
            } else {
                this.brushhandle = this.wmf.createBrushIndirect(this.brushfillstyle, this.foreground, this.brushhatch);
            }
        }
        this.wmf.selectObject(this.brushhandle);
        this.wmf.deleteObject(n);
        this.state.setBrush(this.brushhandle);
        return this.brushhandle;
    }

    public int setGDIFont() {
        int n = this.fonthandle;
        this.fonthandle = this.wmf.createFont(this.font, this.fontescapement, false, false);
        this.wmf.selectObject(this.fonthandle);
        this.wmf.deleteObject(n);
        this.state.setFont(this.fonthandle);
        return this.fonthandle;
    }

    public int setGDIHollowBrush() {
        int n = this.brushhandle;
        this.brushhandle = this.wmf.createBrushIndirect(1, this.foreground, this.brushhatch);
        this.wmf.selectObject(this.brushhandle);
        this.wmf.deleteObject(n);
        this.state.setBrush(this.brushhandle);
        return this.brushhandle;
    }

    public int setGDIPen() {
        int n = this.penhandle;
        this.penhandle = this.wmf.createPenIndirect(this.penstyle, this.penwidth, this.foreground);
        this.wmf.selectObject(this.penhandle);
        this.wmf.deleteObject(n);
        this.state.setPen(this.penhandle);
        return this.penhandle;
    }

    @Override
    public void setPaintMode() {
        System.err.println("setPaintMode not supported");
    }

    public void setPenStyle(int n) {
        this.penstyle = n;
        this.setGDIPen();
    }

    public void setPenWidth(int n) {
        this.penwidth = n;
        this.setGDIPen();
    }

    public void setWMF(MetaFile metaFile, int n, int n2) {
        this.wmf = metaFile;
        this.createHandles();
        this.setup(n, n2);
    }

    @Override
    public void setXORMode(Color color) {
        System.err.println("setXORMode not supported");
    }

    public void setSize(int n, int n2) {
        this.wmf.setWindowExt(n, n2);
    }

    private void setup(int n, int n2) {
        this.wmf.setMapMode(8);
        this.wmf.setWindowOrg(0, 0);
        this.wmf.setWindowExt(n, n2);
        this.wmf.setViewportExt(n, n2);
        this.wmf.setTextAlign(24);
        this.wmf.setBKMode(1);
        this.wmf.setBKColor(this.background);
        this.wmf.setTextColor(this.foreground);
        this.wmf.setPolyFillMode(1);
        this.wmf.setStretchBltMode(3);
        this.wmf.setROP2(13);
        this.wmf.setTextCharacterExtra(0);
    }

    @Override
    public void translate(int n, int n2) {
        this.origin.translate(n, n2);
        this.wmf.setWindowOrg(-this.origin.x, -this.origin.y);
        this.state.setOrigin(this.origin);
    }

    public void setPolyFillMode(int n) {
        this.wmf.setPolyFillMode(n);
    }
}

