/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.wmf;

import com.actelion.research.gui.wmf.MetaFile;
import com.actelion.research.gui.wmf.WMFConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.Polygon;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class WMF
extends MetaFile
implements WMFConstants {
    private int maxObjectSize = 0;
    private ByteArrayOutputStream wmf = new ByteArrayOutputStream();
    private Vector<Boolean> handles = new Vector();
    private static boolean loaded = false;
    private static String[][] fontnames = new String[][]{{"helvetica", "Arial"}, {"timesroman", "Times New Roman"}, {"courier", "Courier New"}, {"zapfdingsbat", "Windings"}, {"dialog", "Arial"}, {"dialoginput", "Courier New"}, {"serif", "Times New Roman"}, {"sansserif", "Arial"}, {"monospaced", "Courier New"}};
    public static final int MFCOMMENT = 15;

    public WMF() {
        this.setupFontNames();
    }

    protected int addHandle() {
        for (int i = 0; i < this.handles.size(); ++i) {
            if (this.handles.elementAt(i).booleanValue()) continue;
            this.handles.setElementAt(Boolean.TRUE, i);
            return i;
        }
        this.handles.addElement(Boolean.TRUE);
        return this.handles.size() - 1;
    }

    @Override
    public void arc(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.writeRecordHeader(2071, 8);
        this.writeWord(n8);
        this.writeWord(n7);
        this.writeWord(n6);
        this.writeWord(n5);
        this.writeWord(n4);
        this.writeWord(n3);
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public int createBrushIndirect(int n, Color color, int n2) {
        this.writeRecordHeader(764, 4);
        this.writeWord(n);
        this.writeColor(color);
        this.writeWord(n2);
        return this.addHandle();
    }

    @Override
    public int createFont(Font font, int n, boolean bl, boolean bl2) {
        int n2 = 400;
        if (font.isBold()) {
            n2 = 700;
        }
        return this.createFont(-font.getSize(), 0, n, 0, n2, font.isItalic(), bl, bl2, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, this.translateFontName(font.getName()));
    }

    @Override
    public int createFont(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, byte by, byte by2, byte by3, byte by4, byte by5, String string) {
        this.writeRecordHeader(763, 9 + (string.length() + 2) / 2);
        this.writeWord(n);
        this.writeWord(n2);
        this.writeWord(n3);
        this.writeWord(n4);
        this.writeWord(n5);
        int n6 = 0;
        if (bl) {
            n6 = 1;
        }
        if (bl2) {
            n6 += 256;
        }
        this.writeWord(n6);
        n6 = by << 8 & 0xFF00;
        if (bl3) {
            ++n6;
        }
        this.writeWord(n6);
        this.writeWord(by2 | by3 << 8 & 0xFF00);
        this.writeWord(by4 | by5 << 8 & 0xFF00);
        byte[] byArray = new byte[string.length() + 2];
        string.getBytes(0, string.length(), byArray, 0);
        byArray[byArray.length - 2] = 0;
        byArray[byArray.length - 1] = 0;
        for (int i = 0; i < byArray.length / 2; ++i) {
            this.writeWord(byArray[i * 2] | byArray[i * 2 + 1] << 8 & 0xFF00);
        }
        return this.addHandle();
    }

    @Override
    public int createPatternBrush(int[] nArray, int n, int n2) {
        int n3 = (n * 3 + 3) / 4 * 4;
        this.writeRecordHeader(322, 22 + n3 / 2 * n2);
        this.writeWord(3);
        this.writeWord(0);
        this.writeBitmap(nArray, n, n2);
        return this.addHandle();
    }

    @Override
    public int createPenIndirect(int n, int n2, Color color) {
        this.writeRecordHeader(762, 5);
        this.writeWord(n);
        this.writeInteger(n2);
        this.writeColor(color);
        return this.addHandle();
    }

    @Override
    public void deleteObject(int n) {
        if (n >= this.handles.size() || !this.handles.elementAt(n).booleanValue()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.writeRecordHeader(496, 1);
        this.writeWord(n);
        this.handles.setElementAt(Boolean.FALSE, n);
    }

    @Override
    public void ellipse(int n, int n2, int n3, int n4) {
        this.writeRecordHeader(1048, 4);
        this.writeWord(n4);
        this.writeWord(n3);
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public void escape(int n, byte[] byArray) {
        this.writeRecordHeader(1574, 2 + (byArray.length + 1) / 2);
        this.writeWord(n);
        this.writeWord(byArray.length);
        byte[] byArray2 = new byte[(byArray.length + 1) / 2 * 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (int i = 0; i < byArray2.length; i += 2) {
            int n2 = byArray2[i] & 0xFF | byArray2[i + 1] << 8 & 0xFF00;
            this.writeWord(n2);
        }
    }

    private int getBodySize() {
        return this.wmf.size() / 2;
    }

    private String getFontProperty(Properties properties, String string) throws Exception {
        String string2 = properties.getProperty(string + ".0");
        if (string2 == null) {
            string2 = properties.getProperty(string + ".plain.0");
        }
        if (string2 == null) {
            throw new Exception(string + " not found");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        return stringTokenizer.nextToken().trim();
    }

    private int highWord(int n) {
        return (n & 0xFFFF0000) >> 16;
    }

    @Override
    public void intersectClipRect(int n, int n2, int n3, int n4) {
        this.writeRecordHeader(1046, 4);
        this.writeWord(n4);
        this.writeWord(n3);
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public void lineTo(int n, int n2) {
        this.writeRecordHeader(531, 2);
        this.writeWord(n2);
        this.writeWord(n);
    }

    private void setupFontNames() {
        if (!loaded) {
            try {
                String string = Locale.getDefault().getLanguage();
                String string2 = Locale.getDefault().getCountry();
                String string3 = "lib" + File.separatorChar + "font.properties";
                File file = new File(System.getProperty("java.home"), string3 + '.' + string + '_' + string2);
                if (!file.exists()) {
                    file = new File(System.getProperty("java.home"), string3 + '.' + string);
                }
                if (!file.exists()) {
                    file = new File(System.getProperty("java.home"), string3);
                }
                if (file.exists()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(file));
                    String[][] stringArray = new String[5][2];
                    int n = 0;
                    stringArray[n][0] = "dialog";
                    stringArray[n][1] = this.getFontProperty(properties, stringArray[n][0]);
                    stringArray[++n][0] = "dialoginput";
                    stringArray[n][1] = this.getFontProperty(properties, stringArray[n][0]);
                    stringArray[++n][0] = "serif";
                    stringArray[n][1] = this.getFontProperty(properties, stringArray[n][0]);
                    stringArray[++n][0] = "sansserif";
                    stringArray[n][1] = this.getFontProperty(properties, stringArray[n][0]);
                    stringArray[++n][0] = "monospaced";
                    stringArray[n][1] = this.getFontProperty(properties, stringArray[n][0]);
                    fontnames = stringArray;
                    loaded = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int lowWord(int n) {
        return n & 0xFFFF;
    }

    private void maxObjectSize(int n) {
        if (n > this.maxObjectSize) {
            this.maxObjectSize = n;
        }
    }

    protected void writeRecordHeader(int n, int n2) {
        int n3 = n2 + 3;
        this.writeInteger(n3);
        this.writeWord(n);
        this.maxObjectSize(n3);
    }

    @Override
    public void moveTo(int n, int n2) {
        this.writeRecordHeader(532, 2);
        this.writeWord(n2);
        this.writeWord(n);
    }

    private void outputInteger(OutputStream outputStream, int n) throws IOException {
        this.outputWord(outputStream, this.lowWord(n));
        this.outputWord(outputStream, this.highWord(n));
    }

    private void outputWord(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)((n & 0xFF00) >> 8)};
        outputStream.write(byArray);
    }

    @Override
    public void pie(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.writeRecordHeader(2074, 8);
        this.writeWord(n8);
        this.writeWord(n7);
        this.writeWord(n6);
        this.writeWord(n5);
        this.writeWord(n4);
        this.writeWord(n3);
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public void polygon(int[] nArray, int[] nArray2, int n) {
        this.writeRecordHeader(804, 1 + 2 * n);
        this.writeWord(n);
        for (int i = 0; i < n; ++i) {
            this.writeWord(nArray[i]);
            this.writeWord(nArray2[i]);
        }
    }

    @Override
    public void polyline(int[] nArray, int[] nArray2, int n) {
        this.writeRecordHeader(805, 1 + 2 * n);
        this.writeWord(n);
        for (int i = 0; i < n; ++i) {
            this.writeWord(nArray[i]);
            this.writeWord(nArray2[i]);
        }
    }

    @Override
    public void polypolygon(Polygon[] polygonArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < polygonArray.length; ++n) {
            n2 += polygonArray[n].npoints;
        }
        this.writeRecordHeader(1336, 1 + polygonArray.length + 2 * n2);
        this.writeWord(polygonArray.length);
        for (n = 0; n < polygonArray.length; ++n) {
            this.writeWord(polygonArray[n].npoints);
        }
        for (n = 0; n < polygonArray.length; ++n) {
            for (int i = 0; i < polygonArray[n].npoints; ++i) {
                this.writeWord(polygonArray[n].xpoints[i]);
                this.writeWord(polygonArray[n].ypoints[i]);
            }
        }
    }

    @Override
    public void rectangle(int n, int n2, int n3, int n4) {
        this.writeRecordHeader(1051, 4);
        this.writeWord(n4);
        this.writeWord(n3);
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public void roundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.writeRecordHeader(1564, 6);
        this.writeWord(n6);
        this.writeWord(n5);
        this.writeWord(n4);
        this.writeWord(n3);
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public void selectObject(int n) {
        if (n >= this.handles.size() || !this.handles.elementAt(n).booleanValue()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.writeRecordHeader(301, 1);
        this.writeWord(n);
    }

    @Override
    public void setBKColor(Color color) {
        this.writeRecordHeader(513, 2);
        this.writeColor(color);
    }

    @Override
    public void setBKMode(int n) {
        this.writeRecordHeader(258, 1);
        this.writeWord(n);
    }

    @Override
    public void setClipRgn() {
        this.writeRecordHeader(300, 1);
        this.writeWord(0);
    }

    @Override
    public void setMapMode(int n) {
        this.writeRecordHeader(259, 1);
        this.writeWord(n);
    }

    @Override
    public void setPixel(int n, int n2, Color color) {
        this.writeRecordHeader(1055, 4);
        this.writeColor(color);
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public void setPolyFillMode(int n) {
        this.writeRecordHeader(262, 1);
        this.writeWord(n);
    }

    @Override
    public void setROP2(int n) {
        this.writeRecordHeader(260, 1);
        this.writeWord(n);
    }

    @Override
    public void setStretchBltMode(int n) {
        this.writeRecordHeader(263, 1);
        this.writeWord(n);
    }

    @Override
    public void setTextAlign(int n) {
        this.writeRecordHeader(302, 1);
        this.writeWord(n);
    }

    @Override
    public void setTextCharacterExtra(int n) {
        this.writeRecordHeader(264, 1);
        this.writeWord(n);
    }

    @Override
    public void setTextColor(Color color) {
        this.writeRecordHeader(521, 2);
        this.writeColor(color);
    }

    @Override
    public void setViewportExt(int n, int n2) {
        this.writeRecordHeader(526, 2);
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public void setWindowExt(int n, int n2) {
        this.writeRecordHeader(524, 2);
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public void setWindowOrg(int n, int n2) {
        this.writeRecordHeader(523, 2);
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public void stretchBlt(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray, int n10, int n11) {
        int n12 = (n10 * 3 + 3) / 4 * 4;
        this.writeRecordHeader(2881, 30 + n12 / 2 * n11);
        this.writeInteger(n9);
        this.writeWord(n8);
        this.writeWord(n7);
        this.writeWord(n6);
        this.writeWord(n5);
        this.writeWord(n4);
        this.writeWord(n3);
        this.writeWord(n2);
        this.writeWord(n);
        this.writeBitmap(nArray, n10, n11);
    }

    @Override
    public void textOut(int n, int n2, String string) {
        this.writeRecordHeader(1313, 3 + (string.length() + 1) / 2);
        this.writeWord(string.length());
        byte[] byArray = new byte[string.length() + 1];
        string.getBytes(0, string.length(), byArray, 0);
        byArray[byArray.length - 1] = 0;
        for (int i = 0; i < byArray.length / 2; ++i) {
            int n3 = 0;
            n3 = byArray[i * 2] | byArray[i * 2 + 1] << 8 & 0xFF00;
            this.writeWord(n3);
        }
        this.writeWord(n2);
        this.writeWord(n);
    }

    @Override
    public String translateFontName(String string) {
        String string2 = string;
        String string3 = string.toLowerCase();
        for (int i = 0; i < fontnames.length; ++i) {
            if (!string3.equals(fontnames[i][0])) continue;
            string2 = fontnames[i][1];
            break;
        }
        return string2;
    }

    protected void writeBitmap(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = (n * 3 + 3) / 4 * 4;
        byte[] byArray = new byte[n7 * n2];
        for (n6 = 0; n6 < n2; ++n6) {
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * 3 + n6 * n7;
                n3 = nArray[n5 + n6 * n];
                byArray[n4 + 2] = (byte)(n3 >> 16 & 0xFF);
                byArray[n4 + 1] = (byte)(n3 >> 8 & 0xFF);
                byArray[n4] = (byte)(n3 & 0xFF);
            }
        }
        this.writeInteger(40);
        this.writeInteger(n);
        this.writeInteger(n2);
        this.writeWord(1);
        this.writeWord(24);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        for (n6 = n2 - 1; n6 >= 0; --n6) {
            n5 = n6 * n7;
            for (n4 = 0; n4 < n7; n4 += 2) {
                n3 = n4 + n5;
                this.writeWord(byArray[n3 + 1] << 8 & 0xFF00 | byArray[n3] & 0xFF);
            }
        }
    }

    private void writeBody(OutputStream outputStream) throws IOException {
        this.wmf.writeTo(outputStream);
    }

    protected void writeColor(Color color) {
        this.writeInteger(color.getRed() & 0xFF | color.getGreen() << 8 & 0xFF00 | color.getBlue() << 16 & 0xFF0000);
    }

    private void writeHeader(OutputStream outputStream) throws IOException {
        this.writeRecordHeader(0, 0);
        this.outputWord(outputStream, 1);
        this.outputWord(outputStream, 9);
        this.outputWord(outputStream, 768);
        this.outputInteger(outputStream, this.getBodySize() + 9);
        this.outputWord(outputStream, this.handles.size());
        this.outputInteger(outputStream, this.maxObjectSize);
        this.outputWord(outputStream, 0);
    }

    protected void writeInteger(int n) {
        this.writeWord(this.lowWord(n));
        this.writeWord(this.highWord(n));
    }

    public void writeWMF(OutputStream outputStream) throws IOException {
        this.writeHeader(outputStream);
        this.writeBody(outputStream);
    }

    protected void writeWord(int n) {
        try {
            this.outputWord(this.wmf, n);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

