/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericCheckBox;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericComponent;
import com.actelion.research.gui.generic.GenericDialog;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericLabel;
import com.actelion.research.gui.generic.GenericTextField;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingCheckBox;
import com.actelion.research.gui.swing.SwingComboBox;
import com.actelion.research.gui.swing.SwingComponent;
import com.actelion.research.gui.swing.SwingLabel;
import com.actelion.research.gui.swing.SwingTextField;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SwingDialog
extends JDialog
implements ActionListener,
GenericDialog {
    private Component mParent;
    private JPanel mContent;
    private GenericEventListener<GenericActionEvent> mConsumer;
    private Runnable onOK;
    private Runnable onCancel;

    public SwingDialog(Window window, String string) {
        this(window, string, DEFAULT_MODALITY_TYPE);
    }

    public SwingDialog(Window window, String string, Dialog.ModalityType modalityType) {
        super(window, string, modalityType);
        this.mParent = window;
    }

    @Override
    public void setEventConsumer(GenericEventListener<GenericActionEvent> genericEventListener) {
        this.mConsumer = this.mConsumer == null ? genericEventListener : this.setEventListener(this.mConsumer, genericEventListener);
    }

    private GenericEventListener<GenericActionEvent> setEventListener(final GenericEventListener<GenericActionEvent> genericEventListener, final GenericEventListener<GenericActionEvent> genericEventListener2) {
        return new GenericEventListener<GenericActionEvent>(){

            @Override
            public void eventHappened(GenericActionEvent genericActionEvent) {
                if (genericEventListener != null) {
                    genericEventListener.eventHappened(genericActionEvent);
                }
                if (genericEventListener2 != null) {
                    genericEventListener2.eventHappened(genericActionEvent);
                }
                if (genericActionEvent.getWhat() == 0) {
                    if (SwingDialog.this.onOK != null) {
                        SwingDialog.this.onOK.run();
                    }
                } else if (genericActionEvent.getWhat() == 1 && SwingDialog.this.onCancel != null) {
                    SwingDialog.this.onCancel.run();
                }
            }
        };
    }

    @Override
    public void setLayout(int[] nArray, int[] nArray2) {
        int n;
        double[][] dArrayArray = new double[][]{new double[nArray.length], new double[nArray2.length]};
        for (n = 0; n < nArray.length; ++n) {
            dArrayArray[0][n] = nArray[n] > 0 ? (double)HiDPIHelper.scale(nArray[n]) : (double)nArray[n];
        }
        for (n = 0; n < nArray2.length; ++n) {
            dArrayArray[1][n] = nArray2[n] > 0 ? (double)HiDPIHelper.scale(nArray2[n]) : (double)nArray2[n];
        }
        this.mContent = new JPanel();
        this.mContent.setLayout(new TableLayout(dArrayArray));
    }

    public void add(JPanel jPanel) {
        this.mContent = jPanel;
        super.add(jPanel);
    }

    @Override
    public void add(GenericComponent genericComponent, int n, int n2) {
        this.getContent().add((Component)((SwingComponent)genericComponent).getComponent(), n + "," + n2);
    }

    public JPanel getContent() {
        if (this.mContent == null) {
            this.mContent = (JPanel)this.getContentPane();
        }
        return this.mContent;
    }

    @Override
    public void add(GenericComponent genericComponent, int n, int n2, int n3, int n4) {
        this.getContent().add((Component)((SwingComponent)genericComponent).getComponent(), n + "," + n2 + "," + n3 + "," + n4);
    }

    @Override
    public void showDialog() {
        JPanel jPanel = new JPanel();
        int n = HiDPIHelper.scale(8.0f);
        jPanel.setBorder(BorderFactory.createEmptyBorder(n * 3 / 2, n, n, n));
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, n, 0));
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(this);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "East");
        this.getContentPane().add((Component)this.getContent(), "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.pack();
        this.setLocationRelativeTo(this.mParent);
        this.setVisible(true);
    }

    @Override
    public void showDialog(Runnable runnable, Runnable runnable2) {
        this.onOK = runnable;
        this.onCancel = runnable2;
        this.showDialog();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl && this.onCancel != null && this.getModalityType() != Dialog.ModalityType.MODELESS) {
            this.onCancel.run();
        }
    }

    @Override
    public void disposeDialog() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        switch (actionEvent.getActionCommand()) {
            case "OK": {
                n = 0;
                break;
            }
            case "Cancel": {
                n = 1;
                break;
            }
            default: {
                return;
            }
        }
        this.getEventListener().eventHappened(new GenericActionEvent((Object)this, n, 0));
    }

    private GenericEventListener<GenericActionEvent> getEventListener() {
        if (this.mConsumer == null) {
            this.mConsumer = this.setEventListener(null, null);
        }
        return this.mConsumer;
    }

    @Override
    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this.mParent, string);
    }

    @Override
    public GenericLabel createLabel(String string) {
        return new SwingLabel(string);
    }

    @Override
    public GenericTextField createTextField(int n, int n2) {
        return new SwingTextField(n, n2);
    }

    @Override
    public GenericCheckBox createCheckBox(String string) {
        return new SwingCheckBox(string);
    }

    @Override
    public GenericComboBox createComboBox() {
        return new SwingComboBox();
    }
}

